/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.plan.AbstractJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class DynamicFiltersChecker
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, WarningCollector warningCollector) {
        plan.accept((PlanVisitor)new InternalPlanVisitor<Set<String>, Void>(){

            public Set<String> visitPlan(PlanNode node, Void context) {
                HashSet<String> consumed = new HashSet<String>();
                for (PlanNode source : node.getSources()) {
                    consumed.addAll((Collection)source.accept((PlanVisitor)this, (Object)context));
                }
                return consumed;
            }

            public Set<String> visitOutput(OutputNode node, Void context) {
                Set<String> unmatched = this.visitPlan((PlanNode)node, context);
                Verify.verify((boolean)unmatched.isEmpty(), (String)"All consumed dynamic filters could not be matched with a join.", (Object[])new Object[0]);
                return unmatched;
            }

            @Override
            public Set<String> visitJoin(JoinNode node, Void context) {
                List nonPushedDownFilters = node.getFilter().map(DynamicFilters::extractDynamicFilters).map(DynamicFilters.DynamicFilterExtractResult::getDynamicConjuncts).orElse((List)ImmutableList.of());
                Verify.verify((boolean)nonPushedDownFilters.isEmpty(), (String)"Dynamic filters %s present in join's filter predicate were not pushed down.", (Object)nonPushedDownFilters);
                return this.extractUnmatchedDynamicFilters(node, context);
            }

            @Override
            public Set<String> visitSemiJoin(SemiJoinNode node, Void context) {
                return this.extractUnmatchedDynamicFilters(node, context);
            }

            private Set<String> extractUnmatchedDynamicFilters(AbstractJoinNode node, Void context) {
                Set<String> currentJoinDynamicFilters = node.getDynamicFilters().keySet();
                Set consumedProbeSide = (Set)node.getProbe().accept((PlanVisitor)this, (Object)context);
                Sets.SetView unconsumedByProbeSide = Sets.difference(currentJoinDynamicFilters, (Set)consumedProbeSide);
                Verify.verify((boolean)unconsumedByProbeSide.isEmpty(), (String)"Dynamic filters %s present in join were not fully consumed by its probe side, currentJoinDynamicFilters is: %s, consumedProbeSide is: %s", (Object)unconsumedByProbeSide, currentJoinDynamicFilters, (Object)consumedProbeSide);
                Set consumedBuildSide = (Set)node.getBuild().accept((PlanVisitor)this, (Object)context);
                Sets.SetView unconsumedByBuildSide = Sets.intersection(currentJoinDynamicFilters, (Set)consumedBuildSide);
                Verify.verify((boolean)unconsumedByBuildSide.isEmpty(), (String)String.format("Dynamic filters %s present in join were consumed by its build side. consumedBuildSide %s, currentJoinDynamicFilters %s", Arrays.toString(unconsumedByBuildSide.toArray()), Arrays.toString(consumedBuildSide.toArray()), Arrays.toString(currentJoinDynamicFilters.toArray())), (Object[])new Object[0]);
                HashSet unmatched = new HashSet(consumedBuildSide);
                unmatched.addAll(consumedProbeSide);
                unmatched.removeAll(currentJoinDynamicFilters);
                return ImmutableSet.copyOf(unmatched);
            }

            public Set<String> visitFilter(FilterNode node, Void context) {
                ImmutableSet.Builder consumed = ImmutableSet.builder();
                DynamicFiltersChecker.extractDynamicPredicates(node.getPredicate()).stream().map(DynamicFilters.DynamicFilterPlaceholder::getId).forEach(arg_0 -> ((ImmutableSet.Builder)consumed).add(arg_0));
                consumed.addAll((Iterable)node.getSource().accept((PlanVisitor)this, (Object)context));
                return consumed.build();
            }
        }, null);
    }

    private static List<DynamicFilters.DynamicFilterPlaceholder> extractDynamicPredicates(RowExpression expression) {
        return (List)Expressions.uniqueSubExpressions(expression).stream().map(DynamicFilters::getPlaceholder).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }
}

