/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.spi.plan.PlanCheckerProvider;
import com.facebook.presto.spi.plan.PlanCheckerProviderFactory;
import com.facebook.presto.spi.plan.SimplePlanFragmentSerde;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class PlanCheckerProviderManager {
    private final SimplePlanFragmentSerde simplePlanFragmentSerde;
    private final Map<String, PlanCheckerProviderFactory> providerFactories = new ConcurrentHashMap<String, PlanCheckerProviderFactory>();
    private final CopyOnWriteArrayList<PlanCheckerProvider> providers = new CopyOnWriteArrayList();

    @Inject
    public PlanCheckerProviderManager(SimplePlanFragmentSerde simplePlanFragmentSerde) {
        this.simplePlanFragmentSerde = Objects.requireNonNull(simplePlanFragmentSerde, "planNodeSerde is null");
    }

    public void addPlanCheckerProviderFactory(PlanCheckerProviderFactory planCheckerProviderFactory) {
        Objects.requireNonNull(planCheckerProviderFactory, "planCheckerProviderFactory is null");
        if (this.providerFactories.putIfAbsent(planCheckerProviderFactory.getName(), planCheckerProviderFactory) != null) {
            throw new IllegalArgumentException(String.format("PlanCheckerProviderFactory '%s' is already registered", planCheckerProviderFactory.getName()));
        }
    }

    public void loadPlanCheckerProviders() {
        this.providers.addAllAbsent(this.providerFactories.values().stream().map(pc -> pc.create(this.simplePlanFragmentSerde)).collect(Collectors.toList()));
    }

    public List<PlanCheckerProvider> getPlanCheckerProviders() {
        return this.providers;
    }
}

