/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, WarningCollector warningCollector) {
        plan.accept((PlanVisitor)new Visitor(metadata), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            switch (step) {
                case SINGLE: {
                    this.checkFunctionSignature(node.getAggregations());
                    this.checkAggregation(node.getAggregations());
                    break;
                }
                case PARTIAL: {
                    this.verifyPartialAggregationTypes(node.getAggregations());
                    break;
                }
                case INTERMEDIATE: {
                    this.verifyIntermediateAggregationTypes(node.getAggregations());
                    break;
                }
                case FINAL: {
                    this.checkFunctionSignature(node.getAggregations());
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry entry : node.getAssignments().entrySet()) {
                RowExpression expression = (RowExpression)entry.getValue();
                Type actualType = expression.getType();
                this.verifyTypeSignature((VariableReferenceExpression)entry.getKey(), actualType.getTypeSignature());
            }
            return null;
        }

        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (VariableReferenceExpression keyVariable : node.getOutputVariables()) {
                List valueVariables = (List)node.getVariableMapping().get(keyVariable);
                for (VariableReferenceExpression valueVariable : valueVariables) {
                    this.verifyTypeSignature(keyVariable, valueVariable.getType().getTypeSignature());
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<VariableReferenceExpression, WindowNode.Function> functions) {
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : functions.entrySet()) {
                FunctionHandle functionHandle = entry.getValue().getFunctionHandle();
                CallExpression call = entry.getValue().getFunctionCall();
                this.verifyTypeSignature(entry.getKey(), this.metadata.getFunctionAndTypeManager().getFunctionMetadata(functionHandle).getReturnType());
                this.checkCall(entry.getKey(), call);
            }
        }

        private void checkCall(VariableReferenceExpression variable, CallExpression call) {
            Type actualType = call.getType();
            this.verifyTypeSignature(variable, actualType.getTypeSignature());
        }

        private void checkFunctionSignature(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                this.verifyTypeSignature(entry.getKey(), this.metadata.getFunctionAndTypeManager().getFunctionMetadata(entry.getValue().getFunctionHandle()).getReturnType());
            }
        }

        private void checkAggregation(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                VariableReferenceExpression variable = entry.getKey();
                AggregationNode.Aggregation aggregation = entry.getValue();
                FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(aggregation.getFunctionHandle());
                this.verifyTypeSignature(variable, functionMetadata.getReturnType());
                this.verifyTypeSignature(variable, aggregation.getCall().getType().getTypeSignature());
                int argumentSize = aggregation.getArguments().size();
                int expectedArgumentSize = functionMetadata.getArgumentTypes().size();
                Preconditions.checkArgument((argumentSize == expectedArgumentSize ? 1 : 0) != 0, (String)"Number of arguments is different from function signature: expected %s but got %s", (int)expectedArgumentSize, (int)argumentSize);
                List argumentTypes = (List)aggregation.getArguments().stream().map(argument -> argument.getType().getTypeSignature()).collect(ImmutableList.toImmutableList());
                for (int i = 0; i < functionMetadata.getArgumentTypes().size(); ++i) {
                    TypeSignature expected = (TypeSignature)functionMetadata.getArgumentTypes().get(i);
                    TypeSignature actual = (TypeSignature)argumentTypes.get(i);
                    FunctionAndTypeManager typeManager = this.metadata.getFunctionAndTypeManager();
                    if (actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) || typeManager.isTypeOnlyCoercion(typeManager.getType(actual), typeManager.getType(expected))) continue;
                    Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"Expected input types are %s but getting %s", (Object)functionMetadata.getArgumentTypes(), (Object)argumentTypes);
                }
            }
        }

        private void verifyTypeSignature(VariableReferenceExpression variable, TypeSignature actual) {
            FunctionAndTypeManager functionAndTypeManager = this.metadata.getFunctionAndTypeManager();
            if (!actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) && !functionAndTypeManager.isTypeOnlyCoercion(functionAndTypeManager.getType(actual), variable.getType())) {
                Preconditions.checkArgument((boolean)variable.getType().getTypeSignature().equals((Object)actual), (String)"type of variable '%s' is expected to be %s, but the actual type is %s", (Object)variable.getName(), (Object)variable.getType(), (Object)actual);
            }
        }

        private void verifyPartialAggregationTypes(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                AggregationNode.Aggregation aggregation = entry.getValue();
                TypeSignature actualTypeSig = aggregation.getCall().getType().getTypeSignature();
                this.verifyTypeSignature(entry.getKey(), actualTypeSig);
            }
        }

        private void verifyIntermediateAggregationTypes(Map<VariableReferenceExpression, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                AggregationNode.Aggregation aggregation = entry.getValue();
                int argumentSize = aggregation.getArguments().size();
                Preconditions.checkArgument((argumentSize == 1 ? 1 : 0) != 0, (String)"Number of arguments for intermediate aggregation is expected to be 1, got %s", (int)argumentSize);
                TypeSignature expectedTypeSig = ((RowExpression)aggregation.getArguments().get(0)).getType().getTypeSignature();
                TypeSignature actualTypeSig = aggregation.getCall().getType().getTypeSignature();
                Preconditions.checkArgument((boolean)expectedTypeSig.equals((Object)actualTypeSig), (String)"Return type for intermediate aggregation must be the same as the type of its single argument: expected '%s', got '%s'", (Object)expectedTypeSig, (Object)actualTypeSig);
                this.verifyTypeSignature(entry.getKey(), actualTypeSig);
            }
        }
    }
}

