/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;

public class ValidateStreamingAggregations
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(session, metadata), null);
    }

    private static final class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private final Session session;
        private final Metadata metadata;

        private Visitor(Session session, Metadata metadata) {
            this.session = session;
            this.metadata = metadata;
        }

        public Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> {
                Void cfr_ignored_0 = (Void)source.accept((PlanVisitor)this, (Object)context);
            });
            return null;
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            if (node.getPreGroupedVariables().isEmpty()) {
                return null;
            }
            StreamPropertyDerivations.StreamProperties properties = StreamPropertyDerivations.derivePropertiesRecursively(node.getSource(), this.metadata, this.session);
            ImmutableList desiredProperties = ImmutableList.of((Object)new GroupingProperty((Collection)node.getPreGroupedVariables()));
            Iterator matchIterator = LocalProperties.match(properties.getLocalProperties(), desiredProperties).iterator();
            Optional unsatisfiedRequirement = (Optional)Iterators.getOnlyElement(matchIterator);
            Failures.checkArgument(!unsatisfiedRequirement.isPresent(), "Streaming aggregation with input not grouped on the grouping keys");
            return null;
        }
    }
}

