/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.dispatcher;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.dispatcher.CoordinatorLocation;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchQuery;
import com.facebook.presto.dispatcher.LocalCoordinatorLocation;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.prerequisites.QueryPrerequisites;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.util.Failures;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class LocalDispatchQuery
implements DispatchQuery {
    private static final Logger log = Logger.get(LocalDispatchQuery.class);
    private final QueryStateMachine stateMachine;
    private final QueryMonitor queryMonitor;
    private final ListenableFuture<QueryExecution> queryExecutionFuture;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Executor queryExecutor;
    private final Consumer<DispatchQuery> queryQueuer;
    private final Consumer<QueryExecution> querySubmitter;
    private final SettableFuture<?> submitted = SettableFuture.create();
    private final AtomicReference<Optional<ResourceGroupQueryLimits>> resourceGroupQueryLimits = new AtomicReference(Optional.empty());
    private final boolean retry;
    private final QueryPrerequisites queryPrerequisites;
    private final WarningCollector warningCollector;

    public LocalDispatchQuery(QueryStateMachine stateMachine, QueryMonitor queryMonitor, ListenableFuture<QueryExecution> queryExecutionFuture, ClusterSizeMonitor clusterSizeMonitor, Executor queryExecutor, Consumer<DispatchQuery> queryQueuer, Consumer<QueryExecution> querySubmitter, boolean retry, QueryPrerequisites queryPrerequisites) {
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.queryExecutionFuture = Objects.requireNonNull(queryExecutionFuture, "queryExecutionFuture is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
        this.queryQueuer = Objects.requireNonNull(queryQueuer, "queryQueuer is null");
        this.querySubmitter = Objects.requireNonNull(querySubmitter, "querySubmitter is null");
        this.retry = retry;
        this.queryPrerequisites = Objects.requireNonNull(queryPrerequisites, "queryPrerequisites is null");
        this.warningCollector = Objects.requireNonNull(stateMachine.getWarningCollector(), "warningCollector is null");
        MoreFutures.addExceptionCallback(queryExecutionFuture, throwable -> {
            if (stateMachine.transitionToFailed(throwable)) {
                queryMonitor.queryImmediateFailureEvent(stateMachine.getBasicQueryInfo(Optional.empty()), Failures.toFailure((Throwable)throwable));
            }
        });
        stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                this.submitted.set(null);
            }
        });
    }

    public void startWaitingForPrerequisites() {
        if (this.isDone()) {
            return;
        }
        try {
            Session session = this.stateMachine.getSession();
            CompletableFuture prerequisitesFuture = this.queryPrerequisites.waitForPrerequisites(this.stateMachine.getQueryId(), new QueryPrerequisitesContext(session.getCatalog(), session.getSchema(), this.stateMachine.getBasicQueryInfo(Optional.empty()).getQuery(), session.getSystemProperties(), session.getConnectorProperties()), this.warningCollector);
            this.addStateChangeListener((StateMachine.StateChangeListener<QueryState>)((StateMachine.StateChangeListener)state -> {
                if (state.isDone()) {
                    this.queryPrerequisites.queryFinished(this.stateMachine.getQueryId());
                    if (!prerequisitesFuture.isDone()) {
                        prerequisitesFuture.cancel(true);
                    }
                }
            }));
            prerequisitesFuture.whenCompleteAsync((result, throwable) -> {
                if (throwable != null) {
                    this.fail((Throwable)throwable);
                    return;
                }
                this.queueQuery();
            }, this.queryExecutor);
        }
        catch (Throwable t) {
            this.fail(t);
            throw t;
        }
    }

    private void queueQuery() {
        if (this.stateMachine.transitionToQueued()) {
            try {
                this.queryQueuer.accept(this);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }
    }

    public void startWaitingForResources() {
        if (this.stateMachine.transitionToWaitingForResources()) {
            this.waitForMinimumCoordinatorSidecarsAndWorkers();
        }
    }

    private void waitForMinimumCoordinatorSidecarsAndWorkers() {
        ListenableFuture minimumResourcesFuture = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.clusterSizeMonitor.waitForMinimumCoordinatorSidecars(), this.clusterSizeMonitor.waitForMinimumWorkers()});
        MoreFutures.addSuccessCallback((ListenableFuture)minimumResourcesFuture, () -> {
            boolean isDispatching = this.stateMachine.transitionToDispatching();
            MoreFutures.addSuccessCallback(this.queryExecutionFuture, queryExecution -> this.startExecution((QueryExecution)queryExecution, isDispatching));
        });
        MoreFutures.addExceptionCallback((ListenableFuture)minimumResourcesFuture, throwable -> this.queryExecutor.execute(() -> this.fail((Throwable)throwable)));
    }

    private void startExecution(QueryExecution queryExecution, boolean isDispatching) {
        this.queryExecutor.execute(() -> {
            if (isDispatching) {
                try {
                    this.resourceGroupQueryLimits.get().ifPresent(arg_0 -> ((QueryExecution)queryExecution).setResourceGroupQueryLimits(arg_0));
                    this.querySubmitter.accept(queryExecution);
                }
                catch (Throwable t) {
                    this.fail(t);
                    log.error(t, "query submitter threw exception");
                    throw t;
                }
                finally {
                    this.submitted.set(null);
                }
            }
        });
    }

    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    public long getLastHeartbeatInMillis() {
        return this.stateMachine.getLastHeartbeatInMillis();
    }

    public ListenableFuture<?> getDispatchedFuture() {
        return Futures.nonCancellationPropagating(this.submitted);
    }

    public DispatchInfo getDispatchInfo() {
        boolean dispatched = this.submitted.isDone();
        BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
        if (queryInfo.getState() == QueryState.FAILED) {
            ExecutionFailureInfo failureInfo = this.stateMachine.getFailureInfo().orElseGet(() -> Failures.toFailure((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query failed for an unknown reason")));
            return DispatchInfo.failed((ExecutionFailureInfo)failureInfo, (Duration)queryInfo.getQueryStats().getElapsedTime(), (Duration)queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), (Duration)queryInfo.getQueryStats().getQueuedTime());
        }
        if (dispatched) {
            return DispatchInfo.dispatched((CoordinatorLocation)new LocalCoordinatorLocation(), (Duration)queryInfo.getQueryStats().getElapsedTime(), (Duration)queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), (Duration)queryInfo.getQueryStats().getQueuedTime());
        }
        if (queryInfo.getState() == QueryState.QUEUED) {
            return DispatchInfo.queued((Duration)queryInfo.getQueryStats().getElapsedTime(), (Duration)queryInfo.getQueryStats().getWaitingForPrerequisitesTime(), (Duration)queryInfo.getQueryStats().getQueuedTime());
        }
        return DispatchInfo.waitingForPrerequisites((Duration)queryInfo.getQueryStats().getElapsedTime(), (Duration)queryInfo.getQueryStats().getWaitingForPrerequisitesTime());
    }

    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    public boolean isDone() {
        return this.stateMachine.getQueryState().isDone();
    }

    public long getCreateTimeInMillis() {
        return this.stateMachine.getCreateTimeInMillis();
    }

    public long getExecutionStartTimeInMillis() {
        return this.stateMachine.getExecutionStartTimeInMillis();
    }

    public long getEndTimeInMillis() {
        return this.stateMachine.getEndTimeInMillis();
    }

    public Duration getTotalCpuTime() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalCpuTime).orElseGet(() -> new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    public long getTotalMemoryReservationInBytes() {
        return this.tryGetQueryExecution().map(QueryExecution::getTotalMemoryReservationInBytes).orElse(0L);
    }

    public long getUserMemoryReservationInBytes() {
        return this.tryGetQueryExecution().map(QueryExecution::getUserMemoryReservationInBytes).orElse(0L);
    }

    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    public BasicQueryInfo getBasicQueryInfo() {
        return this.tryGetQueryExecution().map(QueryExecution::getBasicQueryInfo).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    public Session getSession() {
        return this.stateMachine.getSession();
    }

    public void fail(Throwable throwable) {
        if (this.stateMachine.transitionToFailed(throwable)) {
            this.queryMonitor.queryImmediateFailureEvent(this.stateMachine.getBasicQueryInfo(Optional.empty()), Failures.toFailure((Throwable)throwable));
        }
    }

    public void cancel() {
        if (this.stateMachine.transitionToCanceled()) {
            BasicQueryInfo queryInfo = this.stateMachine.getBasicQueryInfo(Optional.empty());
            ExecutionFailureInfo failureInfo = queryInfo.getFailureInfo();
            failureInfo = failureInfo != null ? failureInfo : Failures.toFailure((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled"));
            this.queryMonitor.queryImmediateFailureEvent(queryInfo, failureInfo);
        }
    }

    public void pruneExpiredQueryInfo() {
        this.stateMachine.pruneQueryInfoExpired();
    }

    public void pruneFinishedQueryInfo() {
        this.stateMachine.pruneQueryInfoFinished();
    }

    public Optional<ErrorCode> getErrorCode() {
        return this.stateMachine.getFailureInfo().map(ExecutionFailureInfo::getErrorCode);
    }

    public boolean isRetry() {
        return this.retry;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return this.resourceGroupQueryLimits.get();
    }

    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
        if (!this.resourceGroupQueryLimits.compareAndSet(Optional.empty(), Optional.of(Objects.requireNonNull(resourceGroupQueryLimits, "resourceGroupQueryLimits is null")))) {
            throw new IllegalStateException("Cannot set resourceGroupQueryLimits more than once");
        }
    }

    private Optional<QueryExecution> tryGetQueryExecution() {
        try {
            return MoreFutures.tryGetFutureValue(this.queryExecutionFuture);
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}

