/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.StaticCatalogStore;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.server.NodeResourceStatusProvider;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.NodeState;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/info")
public class ServerInfoResource {
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final boolean resourceManager;
    private final StaticCatalogStore catalogStore;
    private final GracefulShutdownHandler shutdownHandler;
    private final long startTime = System.nanoTime();
    private final NodeResourceStatusProvider nodeResourceStatusProvider;
    private final ResourceGroupManager resourceGroupManager;
    private NodeState nodeState = NodeState.ACTIVE;

    @Inject
    public ServerInfoResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, StaticCatalogStore catalogStore, GracefulShutdownHandler shutdownHandler, NodeResourceStatusProvider nodeResourceStatusProvider, ResourceGroupManager resourceGroupManager) {
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.coordinator = Objects.requireNonNull(serverConfig, "serverConfig is null").isCoordinator();
        this.resourceManager = serverConfig.isResourceManager();
        this.catalogStore = Objects.requireNonNull(catalogStore, "catalogStore is null");
        this.shutdownHandler = Objects.requireNonNull(shutdownHandler, "shutdownHandler is null");
        this.nodeResourceStatusProvider = Objects.requireNonNull(nodeResourceStatusProvider, "nodeResourceStatusProvider is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    @Produces(value={"application/json", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    public ServerInfo getInfo() {
        boolean starting = this.resourceManager ? true : !this.catalogStore.areCatalogsLoaded();
        return new ServerInfo(this.version, this.environment, this.coordinator, starting, Optional.of(Duration.nanosSince((long)this.startTime)));
    }

    @PUT
    @Path(value="state")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    public Response updateState(NodeState state) throws WebApplicationException {
        Objects.requireNonNull(state, "state is null");
        switch (state) {
            case SHUTTING_DOWN: {
                this.shutdownHandler.requestShutdown();
                return Response.ok().build();
            }
            case ACTIVE: 
            case INACTIVE: {
                if (this.shutdownHandler.isShutdownRequested()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Cluster is shutting down").build();
                }
                this.nodeState = state;
                return Response.ok().build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state %s", state)).build();
    }

    @GET
    @Path(value="state")
    @Produces(value={"application/json", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    @RolesAllowed(value={"admin"})
    public NodeState getServerState() {
        if (this.shutdownHandler.isShutdownRequested()) {
            return NodeState.SHUTTING_DOWN;
        }
        if (!this.nodeResourceStatusProvider.hasResources() || !this.resourceGroupManager.isConfigurationManagerLoaded()) {
            return NodeState.INACTIVE;
        }
        return this.nodeState;
    }

    @GET
    @Path(value="coordinator")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"admin"})
    public Response getServerCoordinator() {
        if (this.coordinator) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

