/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.server.protocol.ExecutingQueryResponseProvider;
import com.facebook.presto.server.protocol.LocalQueryProvider;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.spi.QueryId;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public class LocalExecutingQueryResponseProvider
implements ExecutingQueryResponseProvider {
    private final LocalQueryProvider queryProvider;

    @Inject
    public LocalExecutingQueryResponseProvider(LocalQueryProvider queryProvider) {
        this.queryProvider = Objects.requireNonNull(queryProvider, "queryProvider is null");
    }

    public Optional<ListenableFuture<Response>> waitForExecutingResponse(QueryId queryId, String slug, DispatchInfo dispatchInfo, UriInfo uriInfo, String xPrestoPrefixUrl, String scheme, Duration maxWait, DataSize targetResultSize, boolean compressionEnabled, boolean nestedDataSerializationEnabled, boolean binaryResults) {
        Query query;
        try {
            query = this.queryProvider.getQuery(queryId, slug);
        }
        catch (WebApplicationException e) {
            return Optional.empty();
        }
        return Optional.of(Futures.transform((ListenableFuture)query.waitForResults(0L, uriInfo, scheme, maxWait, targetResultSize, binaryResults), results -> QueryResourceUtil.toResponse((Query)query, (QueryResults)results, (String)xPrestoPrefixUrl, (boolean)compressionEnabled, (boolean)nestedDataSerializationEnabled), (Executor)MoreExecutors.directExecutor()));
    }
}

