/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class Match<T> {
    public abstract boolean isPresent();

    public abstract T value();

    public final boolean isEmpty() {
        return !this.isPresent();
    }

    public static <S> Match<S> of(S value, Captures captures) {
        Objects.requireNonNull(captures);
        return new Present(value, captures);
    }

    public static <S> Match<S> empty() {
        return new Empty();
    }

    public abstract Match<T> filter(Predicate<? super T> var1);

    public abstract <U> Match<U> map(Function<? super T, ? extends U> var1);

    public abstract <U> Match<U> flatMap(Function<? super T, Match<U>> var1);

    public T orElse(T fallback) {
        return this.isPresent() ? this.value() : fallback;
    }

    public <S> S capture(Capture<S> capture) {
        return this.captures().get(capture);
    }

    public abstract Captures captures();

    private static class Present<T>
    extends Match<T> {
        private final T value;
        private final Captures captures;

        private Present(T value, Captures captures) {
            this.value = value;
            this.captures = captures;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public Match<T> filter(Predicate<? super T> predicate) {
            return predicate.test(this.value) ? this : Present.empty();
        }

        @Override
        public <U> Match<U> map(Function<? super T, ? extends U> mapper) {
            return Match.of(mapper.apply(this.value), this.captures());
        }

        @Override
        public <U> Match<U> flatMap(Function<? super T, Match<U>> mapper) {
            return mapper.apply(this.value);
        }

        @Override
        public Captures captures() {
            return this.captures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Present present = (Present)o;
            if (this.value != null ? !this.value.equals(present.value) : present.value != null) {
                return false;
            }
            return this.captures.equals(present.captures);
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + this.captures.hashCode();
            return result;
        }

        public String toString() {
            return "Match.Present(value=" + this.value + ", captures=" + this.captures + ')';
        }
    }

    private static class Empty<T>
    extends Match<T> {
        private Empty() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T value() {
            throw new NoSuchElementException("Empty match contains no value");
        }

        @Override
        public Match<T> filter(Predicate<? super T> predicate) {
            return this;
        }

        @Override
        public <U> Match<U> map(Function<? super T, ? extends U> mapper) {
            return Empty.empty();
        }

        @Override
        public <U> Match<U> flatMap(Function<? super T, Match<U>> mapper) {
            return Empty.empty();
        }

        @Override
        public Captures captures() {
            throw new NoSuchElementException("Captures are undefined for an empty Match");
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 42;
        }

        public String toString() {
            return "Match.Empty()";
        }
    }
}

