/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.maven;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

@Mojo(name="check-spi-dependencies", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SpiDependencyChecker
extends AbstractMojo {
    private static final String SPI_GROUP = "com.facebook.presto";
    private static final String SPI_ARTIFACT = "presto-spi";
    private static final String SPI_NAME = "com.facebook.presto:presto-spi";
    @Parameter(defaultValue="false")
    private boolean skipCheckSpiDependencies;
    @Parameter
    private final Set<String> allowedProvidedDependencies = new HashSet<String>();
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySession;
    @Component
    private RepositorySystem repositorySystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipCheckSpiDependencies) {
            this.getLog().info((CharSequence)"Skipping SPI dependency checks");
            return;
        }
        Set<String> spiDependencies = this.getSpiDependencies();
        this.getLog().debug((CharSequence)("SPI dependencies: " + spiDependencies));
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            if (SpiDependencyChecker.isSpiArtifact(artifact)) continue;
            String name = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId();
            if (spiDependencies.contains(name)) {
                if (!"jar".equals(artifact.getType())) {
                    throw new MojoExecutionException(String.format("%n%nPresto plugin dependency %s must have type 'jar'.", name));
                }
                if (artifact.getClassifier() != null) {
                    throw new MojoExecutionException(String.format("%n%nPresto plugin dependency %s must not have a classifier.", name));
                }
                if ("provided".equals(artifact.getScope())) continue;
                throw new MojoExecutionException(String.format("%n%nPresto plugin dependency %s must have scope 'provided'. It is part of the SPI and will be provided at runtime.", name));
            }
            if (!"provided".equals(artifact.getScope()) || this.allowedProvidedDependencies.contains(name)) continue;
            throw new MojoExecutionException(String.format("%n%nPresto plugin dependency %s must not have scope 'provided'. It is not part of the SPI and will not be available at runtime.", name));
        }
    }

    private Set<String> getSpiDependencies() throws MojoExecutionException {
        return this.getArtifactDependencies(this.getSpiDependency()).getRoot().getChildren().stream().filter(node -> !node.getDependency().isOptional()).map(DependencyNode::getArtifact).map(artifact -> String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId()).collect(Collectors.toSet());
    }

    private CollectResult getArtifactDependencies(org.apache.maven.artifact.Artifact artifact) throws MojoExecutionException {
        try {
            Dependency dependency = new Dependency(SpiDependencyChecker.aetherArtifact(artifact), null);
            return this.repositorySystem.collectDependencies(this.repositorySession, new CollectRequest(dependency, null));
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException("Failed to resolve dependencies.", (Exception)((Object)e));
        }
    }

    private org.apache.maven.artifact.Artifact getSpiDependency() throws MojoExecutionException {
        for (org.apache.maven.artifact.Artifact artifact : this.project.getArtifacts()) {
            if (!SpiDependencyChecker.isSpiArtifact(artifact)) continue;
            if (!"provided".equals(artifact.getScope())) {
                throw new MojoExecutionException(String.format("%n%nPresto plugin dependency %s must have scope 'provided'.", SPI_NAME));
            }
            return artifact;
        }
        throw new MojoExecutionException(String.format("%n%nPresto plugin must depend on %s.", SPI_NAME));
    }

    private static boolean isSpiArtifact(org.apache.maven.artifact.Artifact artifact) {
        return SPI_GROUP.equals(artifact.getGroupId()) && SPI_ARTIFACT.equals(artifact.getArtifactId()) && "jar".equals(artifact.getType()) && artifact.getClassifier() == null;
    }

    private static Artifact aetherArtifact(org.apache.maven.artifact.Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }
}

