/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.maven;

import com.facebook.presto.spi.CoordinatorPlugin;
import com.facebook.presto.spi.Plugin;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate-service-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ServiceDescriptorGenerator
extends AbstractMojo {
    private static final String LS = System.getProperty("line.separator");
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/services/com.facebook.presto.spi.Plugin")
    private File servicesFile;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Class<?>> coordinatorPluginClasses;
        List<Class<?>> pluginClasses;
        if (this.servicesFile.exists()) {
            return;
        }
        if (!this.servicesFile.getParentFile().exists()) {
            ServiceDescriptorGenerator.mkdirs(this.servicesFile.getParentFile());
        }
        try {
            URLClassLoader loader = this.createClassloaderFromCompileTimeDependencies();
            pluginClasses = this.findImplementationsOf(Plugin.class, loader);
            coordinatorPluginClasses = this.findImplementationsOf(CoordinatorPlugin.class, loader);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("%n%nError scanning for classes implementing %s and %s.", Plugin.class.getName(), CoordinatorPlugin.class.getName()), e);
        }
        if (pluginClasses.isEmpty() && coordinatorPluginClasses.isEmpty()) {
            throw new MojoExecutionException(String.format("%n%nYou must have at least one class that implements %s or %s.", Plugin.class.getName(), CoordinatorPlugin.class.getName()));
        }
        if (!pluginClasses.isEmpty() && !coordinatorPluginClasses.isEmpty()) {
            throw new MojoExecutionException(String.format("%n%nYou have classes that implement both %s and %s. You can only have one plugin implementation per project.", Plugin.class.getName(), CoordinatorPlugin.class.getName()));
        }
        if (!pluginClasses.isEmpty()) {
            this.ensureSinglePluginImplementation(pluginClasses, Plugin.class);
            this.writeServiceDescriptor(pluginClasses, Plugin.class, this.servicesFile);
        } else {
            this.ensureSinglePluginImplementation(coordinatorPluginClasses, CoordinatorPlugin.class);
            File coordinatorPluginServicesFile = new File(String.valueOf(this.servicesFile.getParent()) + "/" + CoordinatorPlugin.class.getName());
            this.writeServiceDescriptor(coordinatorPluginClasses, CoordinatorPlugin.class, coordinatorPluginServicesFile);
        }
    }

    private void writeServiceDescriptor(List<Class<?>> pluginClasses, Class<?> classImplementationTemplate, File servicesFileToWrite) throws MojoExecutionException {
        try {
            Class<?> pluginClass = pluginClasses.get(0);
            Files.write((byte[])pluginClass.getName().getBytes(Charsets.UTF_8), (File)servicesFileToWrite);
            this.getLog().info((CharSequence)String.format("Wrote META-INF/services/%s with %s", classImplementationTemplate.getName(), pluginClass.getName()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write service descriptor.", (Exception)e);
        }
    }

    private void ensureSinglePluginImplementation(List<Class<?>> pluginClasses, Class<?> classImplementationTemplate) throws MojoExecutionException {
        if (pluginClasses.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> pluginClass : pluginClasses) {
                sb.append(pluginClass.getName()).append(LS);
            }
            throw new MojoExecutionException(String.format("%n%nYou have more than one class that implements %s:%n%n%s%nYou can only have one per plugin project.", classImplementationTemplate.getName(), sb));
        }
    }

    private URLClassLoader createClassloaderFromCompileTimeDependencies() throws Exception {
        ArrayList urls = Lists.newArrayList();
        urls.add(this.classesDirectory.toURI().toURL());
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    private List<Class<?>> findImplementationsOf(Class<?> implementationTemplate, URLClassLoader searchRealm) throws IOException, MojoExecutionException {
        ArrayList implementations = Lists.newArrayList();
        List classes = FileUtils.getFileNames((File)this.classesDirectory, (String)"**/*.class", null, (boolean)false);
        for (String classPath : classes) {
            String className = classPath.substring(0, classPath.length() - 6).replace(File.separatorChar, '.');
            try {
                Class<?> implementation = searchRealm.loadClass(implementationTemplate.getName());
                Class<?> clazz = searchRealm.loadClass(className);
                if (!implementation.isAssignableFrom(clazz)) continue;
                implementations.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Failed to load class.", (Exception)e);
            }
        }
        return implementations;
    }

    private static void mkdirs(File file) throws MojoExecutionException {
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new MojoExecutionException(String.format("%n%nFailed to create directory: %s", file));
        }
    }
}

