/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryReservationHandler;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMemoryContexts {
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private static final long GUARANTEED_MEMORY = new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes();

    @Test
    public void testLocalMemoryContextClose() throws IOException {
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(1000L, 1000L);
        AggregatedMemoryContext aggregateContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        LocalMemoryContext localContext = aggregateContext.newLocalMemoryContext("test");
        localContext.setBytes(100L);
        Assert.assertEquals((long)localContext.getBytes(), (long)100L);
        Assert.assertEquals((long)aggregateContext.getBytes(), (long)100L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)100L);
        localContext.close();
        Assert.assertEquals((long)localContext.getBytes(), (long)0L);
        Assert.assertEquals((long)aggregateContext.getBytes(), (long)0L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)0L);
    }

    @Test
    public void testMemoryContexts() {
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(1000L, 1000L);
        AggregatedMemoryContext aggregateContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        LocalMemoryContext localContext = aggregateContext.newLocalMemoryContext("test");
        Assert.assertEquals((Object)localContext.setBytes(10L), NOT_BLOCKED);
        Assert.assertEquals((long)localContext.getBytes(), (long)10L);
        Assert.assertEquals((long)aggregateContext.getBytes(), (long)10L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)aggregateContext.getBytes());
        LocalMemoryContext secondLocalContext = aggregateContext.newLocalMemoryContext("test");
        Assert.assertEquals((Object)secondLocalContext.setBytes(20L), NOT_BLOCKED);
        Assert.assertEquals((long)secondLocalContext.getBytes(), (long)20L);
        Assert.assertEquals((long)aggregateContext.getBytes(), (long)30L);
        Assert.assertEquals((long)localContext.getBytes(), (long)10L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)aggregateContext.getBytes());
        aggregateContext.close();
        Assert.assertEquals((long)aggregateContext.getBytes(), (long)0L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)0L);
    }

    @Test
    public void testMemoryContextsEnforceBroadcastMemoryLimit() {
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(1000L, 100L);
        AggregatedMemoryContext rootContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        AggregatedMemoryContext firstIntermediateContext = rootContext.newAggregatedMemoryContext();
        AggregatedMemoryContext secondIntermediateContext = rootContext.newAggregatedMemoryContext();
        LocalMemoryContext localContext1 = firstIntermediateContext.newLocalMemoryContext("test1");
        LocalMemoryContext localContext2 = firstIntermediateContext.newLocalMemoryContext("test2");
        LocalMemoryContext localContext3 = secondIntermediateContext.newLocalMemoryContext("test3");
        LocalMemoryContext localContext4 = secondIntermediateContext.newLocalMemoryContext("test4");
        Assert.assertTrue((boolean)localContext1.trySetBytes(30L, true));
        Assert.assertTrue((boolean)localContext2.trySetBytes(30L, true));
        Assert.assertTrue((boolean)localContext3.trySetBytes(30L, true));
        Assert.assertFalse((boolean)localContext4.trySetBytes(30L, true));
        Assert.assertTrue((boolean)localContext1.trySetBytes(5L, true));
        Assert.assertTrue((boolean)localContext4.trySetBytes(30L, true));
    }

    @Test
    public void testTryReserve() {
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(1000L, 1000L);
        AggregatedMemoryContext parentContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        AggregatedMemoryContext aggregateContext1 = parentContext.newAggregatedMemoryContext();
        AggregatedMemoryContext aggregateContext2 = parentContext.newAggregatedMemoryContext();
        LocalMemoryContext childContext1 = aggregateContext1.newLocalMemoryContext("test");
        Assert.assertTrue((boolean)childContext1.trySetBytes(500L));
        Assert.assertTrue((boolean)childContext1.trySetBytes(1000L));
        Assert.assertFalse((boolean)childContext1.trySetBytes(1001L));
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)parentContext.getBytes());
        aggregateContext1.close();
        aggregateContext2.close();
        parentContext.close();
        Assert.assertEquals((long)aggregateContext1.getBytes(), (long)0L);
        Assert.assertEquals((long)aggregateContext2.getBytes(), (long)0L);
        Assert.assertEquals((long)parentContext.getBytes(), (long)0L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)0L);
    }

    @Test
    public void testHierarchicalMemoryContexts() {
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(1000L, 1000L);
        AggregatedMemoryContext parentContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        AggregatedMemoryContext aggregateContext1 = parentContext.newAggregatedMemoryContext();
        AggregatedMemoryContext aggregateContext2 = parentContext.newAggregatedMemoryContext();
        LocalMemoryContext childContext1 = aggregateContext1.newLocalMemoryContext("test");
        LocalMemoryContext childContext2 = aggregateContext2.newLocalMemoryContext("test");
        Assert.assertEquals((Object)childContext1.setBytes(1L), NOT_BLOCKED);
        Assert.assertEquals((Object)childContext2.setBytes(1L), NOT_BLOCKED);
        Assert.assertEquals((long)aggregateContext1.getBytes(), (long)1L);
        Assert.assertEquals((long)aggregateContext2.getBytes(), (long)1L);
        Assert.assertEquals((long)parentContext.getBytes(), (long)(aggregateContext1.getBytes() + aggregateContext2.getBytes()));
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)parentContext.getBytes());
    }

    @Test
    public void testGuaranteedMemoryDoesntBlock() {
        long maxMemory = 2L * GUARANTEED_MEMORY;
        TestMemoryReservationHandler reservationHandler = new TestMemoryReservationHandler(maxMemory, maxMemory);
        AggregatedMemoryContext parentContext = AggregatedMemoryContext.newRootAggregatedMemoryContext((MemoryReservationHandler)reservationHandler, (long)GUARANTEED_MEMORY);
        LocalMemoryContext childContext = parentContext.newLocalMemoryContext("test");
        reservationHandler.exhaustMemory();
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)maxMemory);
        Assert.assertEquals((Object)childContext.setBytes(1000L), NOT_BLOCKED);
        Assert.assertNotEquals((Object)childContext.setBytes(GUARANTEED_MEMORY + 1L), NOT_BLOCKED);
        childContext.close();
        parentContext.close();
        Assert.assertEquals((long)childContext.getBytes(), (long)0L);
        Assert.assertEquals((long)parentContext.getBytes(), (long)0L);
        Assert.assertEquals((long)reservationHandler.getReservation(), (long)maxMemory);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="SimpleLocalMemoryContext is already closed")
    public void testClosedLocalMemoryContext() {
        AggregatedMemoryContext aggregateContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        LocalMemoryContext localContext = aggregateContext.newLocalMemoryContext("test");
        localContext.close();
        localContext.setBytes(100L);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="SimpleAggregatedMemoryContext is already closed")
    public void testClosedAggregateMemoryContext() {
        AggregatedMemoryContext aggregateContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        LocalMemoryContext localContext = aggregateContext.newLocalMemoryContext("test");
        aggregateContext.close();
        localContext.setBytes(100L);
    }

    private static class TestMemoryReservationHandler
    implements MemoryReservationHandler {
        private long reservation;
        private final long maxMemory;
        private final long maxBroadcastMemory;
        private SettableFuture<?> future;

        public TestMemoryReservationHandler(long maxMemory, long maxBroadcastMemory) {
            this.maxMemory = maxMemory;
            this.maxBroadcastMemory = maxBroadcastMemory;
        }

        public long getReservation() {
            return this.reservation;
        }

        public ListenableFuture<?> reserveMemory(String allocationTag, long delta, boolean enforceBroadcastMemoryLimit) {
            this.reservation += delta;
            if (delta >= 0L) {
                if (this.reservation >= this.maxMemory || enforceBroadcastMemoryLimit && this.reservation >= this.maxBroadcastMemory) {
                    this.future = SettableFuture.create();
                    return this.future;
                }
            } else if (this.reservation < this.maxMemory && this.future != null) {
                this.future.set(null);
            }
            return NOT_BLOCKED;
        }

        public boolean tryReserveMemory(String allocationTag, long delta, boolean enforceBroadcastMemoryLimit) {
            if (enforceBroadcastMemoryLimit && this.reservation + delta > this.maxBroadcastMemory) {
                return false;
            }
            if (this.reservation + delta > this.maxMemory) {
                return false;
            }
            this.reservation += delta;
            return true;
        }

        public void exhaustMemory() {
            this.reservation = this.maxMemory;
        }
    }
}

