/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryTableHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class MemorySplit
implements ConnectorSplit {
    private final MemoryTableHandle tableHandle;
    private final int totalPartsPerWorker;
    private final int partNumber;
    private final HostAddress address;
    private final long expectedRows;

    @JsonCreator
    public MemorySplit(@JsonProperty(value="tableHandle") MemoryTableHandle tableHandle, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalPartsPerWorker") int totalPartsPerWorker, @JsonProperty(value="address") HostAddress address, @JsonProperty(value="expectedRows") long expectedRows) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalPartsPerWorker >= 1 ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be >= 1");
        Preconditions.checkState((totalPartsPerWorker > partNumber ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be > partNumber");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.partNumber = partNumber;
        this.totalPartsPerWorker = totalPartsPerWorker;
        this.address = Objects.requireNonNull(address, "address is null");
        this.expectedRows = expectedRows;
    }

    @JsonProperty
    public MemoryTableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public int getTotalPartsPerWorker() {
        return this.totalPartsPerWorker;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.HARD_AFFINITY;
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return ImmutableList.of((Object)this.address);
    }

    @JsonProperty
    public long getExpectedRows() {
        return this.expectedRows;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).add("partNumber", this.partNumber).add("totalPartsPerWorker", this.totalPartsPerWorker).toString();
    }
}

