/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.Model;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public abstract class AbstractSvmModel
implements Model {
    protected svm_model model;
    protected svm_parameter params;

    protected AbstractSvmModel(svm_parameter params) {
        this.params = Objects.requireNonNull(params, "params is null");
    }

    protected AbstractSvmModel(svm_model model) {
        this.model = Objects.requireNonNull(model, "model is null");
    }

    @Override
    public byte[] getSerializedData() {
        File file = null;
        try {
            file = File.createTempFile("svm", null);
            svm.svm_save_model((String)file.getAbsolutePath(), (svm_model)this.model);
            byte[] byArray = Files.readAllBytes(file.toPath());
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public void train(Dataset dataset) {
        this.params.svm_type = this.getLibsvmType();
        svm_problem problem = AbstractSvmModel.toSvmProblem(dataset);
        ExecutorService service = Executors.newCachedThreadPool(Threads.threadsNamed((String)("libsvm-trainer-" + System.identityHashCode(this) + "-%s")));
        try {
            SimpleTimeLimiter limiter = SimpleTimeLimiter.create((ExecutorService)service);
            this.model = (svm_model)limiter.callWithTimeout(AbstractSvmModel.getTrainingFunction(problem, this.params), 1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked((Throwable)cause);
                throw new RuntimeException(cause);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            service.shutdownNow();
        }
    }

    private static Callable<svm_model> getTrainingFunction(svm_problem problem, svm_parameter param) {
        return () -> svm.svm_train((svm_problem)problem, (svm_parameter)param);
    }

    protected abstract int getLibsvmType();

    private static svm_problem toSvmProblem(Dataset dataset) {
        int i;
        svm_problem problem = new svm_problem();
        List<Double> labels = dataset.getLabels();
        problem.l = labels.size();
        problem.y = new double[labels.size()];
        for (i = 0; i < labels.size(); ++i) {
            problem.y[i] = labels.get(i);
        }
        problem.x = new svm_node[labels.size()][];
        for (i = 0; i < dataset.getDatapoints().size(); ++i) {
            problem.x[i] = AbstractSvmModel.toSvmNodes(dataset.getDatapoints().get(i));
        }
        return problem;
    }

    protected static svm_node[] toSvmNodes(FeatureVector features) {
        svm_node[] nodes = new svm_node[features.size()];
        int i = 0;
        for (Map.Entry<Integer, Double> feature : features.getFeatures().entrySet()) {
            nodes[i] = new svm_node();
            nodes[i].index = feature.getKey();
            nodes[i].value = feature.getValue();
            ++i;
        }
        return nodes;
    }
}

