/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.FeatureVector;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Dataset {
    private final List<FeatureVector> datapoints;
    private final List<Double> labels;
    private final Map<Integer, String> labelEnumeration;

    public Dataset(List<Double> labels, List<FeatureVector> datapoints, Map<Integer, String> labelEnumeration) {
        Objects.requireNonNull(datapoints, "datapoints is null");
        Objects.requireNonNull(labels, "labels is null");
        Objects.requireNonNull(labelEnumeration, "labelEnumeration is null");
        Preconditions.checkArgument((datapoints.size() == labels.size() ? 1 : 0) != 0, (Object)"datapoints and labels have different sizes");
        this.labels = ImmutableList.copyOf(labels);
        this.datapoints = ImmutableList.copyOf(datapoints);
        this.labelEnumeration = ImmutableMap.copyOf(labelEnumeration);
    }

    public List<FeatureVector> getDatapoints() {
        return this.datapoints;
    }

    public List<Double> getLabels() {
        return this.labels;
    }

    public Map<Integer, String> getLabelEnumeration() {
        return this.labelEnumeration;
    }
}

