/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.mongodb.ReadPreference;
import com.mongodb.TagSet;
import java.util.List;
import java.util.Objects;

public enum ReadPreferenceType {
    PRIMARY(ReadPreference.primary()),
    PRIMARY_PREFERRED(ReadPreference.primaryPreferred()),
    SECONDARY(ReadPreference.secondary()),
    SECONDARY_PREFERRED(ReadPreference.secondaryPreferred()),
    NEAREST(ReadPreference.nearest());

    private final ReadPreference readPreference;

    private ReadPreferenceType(ReadPreference readPreference) {
        this.readPreference = Objects.requireNonNull(readPreference, "readPreference is null");
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public ReadPreference getReadPreferenceWithTags(List<TagSet> tagSets) {
        if (PRIMARY.equals((Object)this)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Primary read preference can not specify tag sets");
        }
        return ReadPreference.valueOf((String)this.readPreference.getName(), tagSets);
    }
}

