/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import java.util.function.Predicate;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static boolean isArrayType(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    public static boolean isMapType(Type type) {
        return type.getTypeSignature().getBase().equals("map");
    }

    public static boolean isRowType(Type type) {
        return type.getTypeSignature().getBase().equals("row");
    }

    public static boolean isDateType(Type type) {
        return type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
    }

    public static boolean containsType(Type type, Predicate<Type> predicate, Predicate<Type> ... orPredicates) {
        for (Predicate<Type> orPredicate : orPredicates) {
            predicate = predicate.or(orPredicate);
        }
        if (predicate.test(type)) {
            return true;
        }
        return type.getTypeParameters().stream().anyMatch(predicate);
    }
}

