/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.mysql;

import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimeWithTimeZoneType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.plugin.mysql.MySqlConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.mysql.jdbc.Driver;
import com.mysql.jdbc.Statement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;

public class MySqlClient
extends BaseJdbcClient {
    @Inject
    public MySqlClient(JdbcConnectorId connectorId, BaseJdbcConfig config, MySqlConfig mySqlConfig) throws SQLException {
        super(connectorId, config, "`", MySqlClient.connectionFactory(config, mySqlConfig));
    }

    private static ConnectionFactory connectionFactory(BaseJdbcConfig config, MySqlConfig mySqlConfig) throws SQLException {
        Properties connectionProperties = DriverConnectionFactory.basicConnectionProperties((BaseJdbcConfig)config);
        connectionProperties.setProperty("useInformationSchema", "true");
        connectionProperties.setProperty("nullCatalogMeansCurrent", "false");
        connectionProperties.setProperty("useUnicode", "true");
        connectionProperties.setProperty("characterEncoding", "utf8");
        connectionProperties.setProperty("tinyInt1isBit", "false");
        if (mySqlConfig.isAutoReconnect()) {
            connectionProperties.setProperty("autoReconnect", String.valueOf(mySqlConfig.isAutoReconnect()));
            connectionProperties.setProperty("maxReconnects", String.valueOf(mySqlConfig.getMaxReconnects()));
        }
        if (mySqlConfig.getConnectionTimeout() != null) {
            connectionProperties.setProperty("connectTimeout", String.valueOf(mySqlConfig.getConnectionTimeout().toMillis()));
        }
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config.getConnectionUrl(), Optional.ofNullable(config.getUserCredentialName()), Optional.ofNullable(config.getPasswordCredentialName()), connectionProperties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<String> listSchemas(Connection connection) {
        try (ResultSet resultSet = connection.getMetaData().getCatalogs();){
            ImmutableSet.Builder schemaNames = ImmutableSet.builder();
            while (resultSet.next()) {
                String schemaName = resultSet.getString("TABLE_CAT");
                if (schemaName.equalsIgnoreCase("information_schema") || schemaName.equalsIgnoreCase("mysql")) continue;
                schemaNames.add((Object)schemaName);
            }
            ImmutableSet immutableSet = schemaNames.build();
            return immutableSet;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void abortReadConnection(Connection connection) throws SQLException {
        connection.abort(MoreExecutors.directExecutor());
    }

    public PreparedStatement getPreparedStatement(ConnectorSession session, Connection connection, String sql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        if (statement.isWrapperFor(Statement.class)) {
            statement.unwrap(Statement.class).enableStreamingResults();
        }
        return statement;
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        Optional<String> escape = Optional.ofNullable(metadata.getSearchStringEscape());
        return metadata.getTables(schemaName.orElse(null), null, MySqlClient.escapeNamePattern(tableName, escape).orElse(null), new String[]{"TABLE", "VIEW"});
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return resultSet.getString("TABLE_CAT");
    }

    protected String toSqlType(Type type) {
        if (RealType.REAL.equals((Object)type)) {
            return "float";
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return "datetime";
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return "mediumblob";
        }
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.isUnbounded()) {
                return "longtext";
            }
            if (varcharType.getLengthSafe() <= 255) {
                return "tinytext";
            }
            if (varcharType.getLengthSafe() <= 65535) {
                return "text";
            }
            if (varcharType.getLengthSafe() <= 0xFFFFFF) {
                return "mediumtext";
            }
            return "longtext";
        }
        return super.toSqlType(type);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(tableMetadata, session, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            if ("42S01".equals(e.getSQLState())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(ConnectorSession session, JdbcIdentity identity, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            DatabaseMetaData metadata = connection.getMetaData();
            if (metadata.storesUpperCaseIdentifiers()) {
                newColumnName = newColumnName.toUpperCase(Locale.ENGLISH);
            }
            String sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", this.quoted(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName()), this.quoted(jdbcColumn.getColumnName()), this.quoted(newColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            if ("42000".equals(e.getSQLState())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Rename column not supported in catalog: '%s'", handle.getCatalogName()), (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        super.renameTable(identity, null, oldTable, newTable);
    }
}

