/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.oracle;

import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcIdentity;
import com.facebook.presto.plugin.jdbc.JdbcTypeHandle;
import com.facebook.presto.plugin.jdbc.ReadMapping;
import com.facebook.presto.plugin.jdbc.StandardReadMappings;
import com.facebook.presto.plugin.oracle.OracleConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class OracleClient
extends BaseJdbcClient {
    private static final int FETCH_SIZE = 1000;
    private final boolean synonymsEnabled;
    private final int numberDefaultScale;

    @Inject
    public OracleClient(JdbcConnectorId connectorId, BaseJdbcConfig config, OracleConfig oracleConfig, ConnectionFactory connectionFactory) {
        super(connectorId, config, "\"", connectionFactory);
        Objects.requireNonNull(oracleConfig, "oracle config is null");
        this.synonymsEnabled = oracleConfig.isSynonymsEnabled();
        this.numberDefaultScale = oracleConfig.getNumberDefaultScale();
    }

    private String[] getTableTypes() {
        if (this.synonymsEnabled) {
            return new String[]{"TABLE", "VIEW", "SYNONYM"};
        }
        return new String[]{"TABLE", "VIEW"};
    }

    protected ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        String escape = metadata.getSearchStringEscape();
        return metadata.getTables(connection.getCatalog(), OracleClient.escapeNamePattern(schemaName, Optional.of(escape)).orElse(null), OracleClient.escapeNamePattern(tableName, Optional.of(escape)).orElse(null), this.getTableTypes());
    }

    public PreparedStatement getPreparedStatement(ConnectorSession session, Connection connection, String sql) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected String generateTemporaryTableName() {
        return "presto_tmp_" + System.nanoTime();
    }

    protected void renameTable(JdbcIdentity identity, String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        if (!oldTable.getSchemaName().equalsIgnoreCase(newTable.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename across schemas is not supported in Oracle");
        }
        String newTableName = newTable.getTableName().toUpperCase(Locale.ENGLISH);
        String oldTableName = oldTable.getTableName().toUpperCase(Locale.ENGLISH);
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, oldTable.getSchemaName(), oldTableName), this.quoted(newTableName));
        try (Connection connection = this.connectionFactory.openConnection(identity);){
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public Optional<ReadMapping> toPrestoType(ConnectorSession session, JdbcTypeHandle typeHandle) {
        int columnSize = typeHandle.getColumnSize();
        switch (typeHandle.getJdbcType()) {
            case 2005: {
                return Optional.of(StandardReadMappings.varcharReadMapping((VarcharType)VarcharType.createUnboundedVarcharType()));
            }
            case 5: {
                return Optional.of(StandardReadMappings.smallintReadMapping());
            }
            case 6: 
            case 8: {
                return Optional.of(StandardReadMappings.doubleReadMapping());
            }
            case 7: {
                return Optional.of(StandardReadMappings.realReadMapping());
            }
            case 2: {
                int precision = columnSize == 0 ? 38 : columnSize;
                int scale = typeHandle.getDecimalDigits();
                if (scale == 0) {
                    return Optional.of(StandardReadMappings.bigintReadMapping());
                }
                if (scale < 0 || scale > precision) {
                    return Optional.of(StandardReadMappings.decimalReadMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)this.numberDefaultScale)));
                }
                return Optional.of(StandardReadMappings.decimalReadMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)scale)));
            }
            case -1: {
                if (columnSize > 0x7FFFFFFE || columnSize == 0) {
                    return Optional.of(StandardReadMappings.varcharReadMapping((VarcharType)VarcharType.createUnboundedVarcharType()));
                }
                return Optional.of(StandardReadMappings.varcharReadMapping((VarcharType)VarcharType.createVarcharType((int)columnSize)));
            }
            case 12: {
                return Optional.of(StandardReadMappings.varcharReadMapping((VarcharType)VarcharType.createVarcharType((int)columnSize)));
            }
        }
        return super.toPrestoType(session, typeHandle);
    }
}

