/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.array.IntBigArray;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.stream.ByteArrayOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryBuilder;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryColumnWriter
implements ColumnWriter,
DictionaryCompressionOptimizer.DictionaryColumn {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryColumnWriter.class).instanceSize();
    private static final int DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES = Math.toIntExact(new DataSize(32.0, DataSize.Unit.MEGABYTE).toBytes());
    private final int column;
    private final Type type;
    private final CompressionKind compression;
    private final int bufferSize;
    private final OrcEncoding orcEncoding;
    private final int stringStatisticsLimitInBytes;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final ByteArrayOutputStream dictionaryDataStream;
    private final LongOutputStream dictionaryLengthStream;
    private final DictionaryBuilder dictionary = new DictionaryBuilder(10000);
    private final List<DictionaryRowGroup> rowGroups = new ArrayList<DictionaryRowGroup>();
    private long columnStatisticsRetainedSizeInBytes;
    private IntBigArray values;
    private int rowGroupValueCount;
    private StringStatisticsBuilder statisticsBuilder;
    private long rawBytes;
    private long totalValueCount;
    private long totalNonNullValueCount;
    private boolean closed;
    private boolean inRowGroup;
    private ColumnEncoding columnEncoding;
    private boolean directEncoded;
    private SliceDirectColumnWriter directColumnWriter;

    public SliceDictionaryColumnWriter(int column, Type type, CompressionKind compression, int bufferSize, OrcEncoding orcEncoding, DataSize stringStatisticsLimit) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.bufferSize = bufferSize;
        this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        this.stringStatisticsLimitInBytes = Math.toIntExact(Objects.requireNonNull(stringStatisticsLimit, "stringStatisticsLimit is null").toBytes());
        LongOutputStream result = orcEncoding == OrcEncoding.DWRF ? new LongOutputStreamV1(compression, bufferSize, false, Stream.StreamKind.DATA) : new LongOutputStreamV2(compression, bufferSize, false, Stream.StreamKind.DATA);
        this.dataStream = result;
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        this.dictionaryDataStream = new ByteArrayOutputStream(compression, bufferSize, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(compression, bufferSize, orcEncoding);
        this.values = new IntBigArray();
        this.statisticsBuilder = this.newStringStatisticsBuilder();
    }

    @Override
    public long getRawBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.rawBytes;
    }

    @Override
    public int getDictionaryBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact(this.dictionary.getSizeInBytes());
    }

    @Override
    public int getIndexBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact((long)DictionaryCompressionOptimizer.estimateIndexBytesPerValue(this.dictionary.getEntryCount()) * this.getNonNullValueCount());
    }

    @Override
    public long getValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalValueCount;
    }

    @Override
    public long getNonNullValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalNonNullValueCount;
    }

    @Override
    public int getDictionaryEntries() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.dictionary.getEntryCount();
    }

    @Override
    public OptionalInt tryConvertToDirect(int maxDirectBytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new SliceDirectColumnWriter(this.column, this.type, this.compression, this.bufferSize, this.orcEncoding, this::newStringStatisticsBuilder);
        }
        Preconditions.checkState((this.directColumnWriter.getBufferedBytes() == 0L ? 1 : 0) != 0);
        Block dictionaryValues = this.dictionary.getElementBlock();
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            this.directColumnWriter.beginRowGroup();
            boolean success = this.writeDictionaryRowGroup(dictionaryValues, rowGroup.getValueCount(), rowGroup.getDictionaryIndexes(), maxDirectBytes);
            this.directColumnWriter.finishRowGroup();
            if (success) continue;
            this.directColumnWriter.close();
            this.directColumnWriter.reset();
            return OptionalInt.empty();
        }
        if (this.inRowGroup) {
            this.directColumnWriter.beginRowGroup();
            if (!this.writeDictionaryRowGroup(dictionaryValues, this.rowGroupValueCount, this.values, maxDirectBytes)) {
                this.directColumnWriter.close();
                this.directColumnWriter.reset();
                return OptionalInt.empty();
            }
        } else {
            Preconditions.checkState((this.rowGroupValueCount == 0 ? 1 : 0) != 0);
        }
        this.rowGroups.clear();
        this.dictionary.clear();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        this.directEncoded = true;
        return OptionalInt.of(Math.toIntExact(this.directColumnWriter.getBufferedBytes()));
    }

    private boolean writeDictionaryRowGroup(Block dictionary, int valueCount, IntBigArray dictionaryIndexes, int maxDirectBytes) {
        int positionCount;
        int[][] segments = dictionaryIndexes.getSegments();
        for (int i = 0; valueCount > 0 && i < segments.length; valueCount -= positionCount, ++i) {
            int[] segment = segments[i];
            positionCount = Math.min(valueCount, segment.length);
            DictionaryBlock block = new DictionaryBlock(positionCount, dictionary, segment);
            while (block != null) {
                int chunkPositionCount = block.getPositionCount();
                Block chunk = block.getRegion(0, chunkPositionCount);
                while (chunkPositionCount > 1 && chunk.getLogicalSizeInBytes() > (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) {
                    chunk = chunk.getRegion(0, chunkPositionCount /= 2);
                }
                this.directColumnWriter.writeBlock(chunk);
                if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                    return false;
                }
                if (chunkPositionCount < block.getPositionCount()) {
                    block = block.getRegion(chunkPositionCount, block.getPositionCount() - chunkPositionCount);
                    continue;
                }
                block = null;
            }
        }
        Preconditions.checkState((valueCount == 0 ? 1 : 0) != 0);
        return true;
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnEncodings();
        }
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.inRowGroup = true;
        if (this.directEncoded) {
            this.directColumnWriter.beginRowGroup();
        }
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        if (this.directEncoded) {
            this.directColumnWriter.writeBlock(block);
            return;
        }
        this.values.ensureCapacity(this.rowGroupValueCount + block.getPositionCount());
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int index = this.dictionary.putIfAbsent(block, position);
            this.values.set(this.rowGroupValueCount, index);
            ++this.rowGroupValueCount;
            ++this.totalValueCount;
            if (block.isNull(position)) continue;
            this.statisticsBuilder.addValue(this.type.getSlice(block, position));
            this.rawBytes += (long)block.getSliceLength(position);
            ++this.totalNonNullValueCount;
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.inRowGroup);
        this.inRowGroup = false;
        if (this.directEncoded) {
            return this.directColumnWriter.finishRowGroup();
        }
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        DictionaryRowGroup rowGroup = new DictionaryRowGroup(this.values, this.rowGroupValueCount, statistics);
        this.rowGroups.add(rowGroup);
        this.columnStatisticsRetainedSizeInBytes += rowGroup.getColumnStatistics().getRetainedSizeInBytes();
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        this.values = new IntBigArray();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.closed = true;
        if (this.directEncoded) {
            this.directColumnWriter.close();
        } else {
            this.bufferOutputData();
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnStripeStatistics();
        }
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList())));
    }

    private void bufferOutputData() {
        int[] sortedDictionaryIndexes;
        Preconditions.checkState((boolean)this.closed);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        Block dictionaryElements = this.dictionary.getElementBlock();
        for (int sortedDictionaryIndex : sortedDictionaryIndexes = SliceDictionaryColumnWriter.getSortedDictionaryNullsLast(dictionaryElements)) {
            if (dictionaryElements.isNull(sortedDictionaryIndex)) continue;
            int length = dictionaryElements.getSliceLength(sortedDictionaryIndex);
            this.dictionaryLengthStream.writeLong(length);
            Slice value = dictionaryElements.getSlice(sortedDictionaryIndex, 0, length);
            this.dictionaryDataStream.writeSlice(value);
        }
        this.columnEncoding = new ColumnEncoding(this.orcEncoding == OrcEncoding.DWRF ? ColumnEncoding.ColumnEncodingKind.DICTIONARY : ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2, dictionaryElements.getPositionCount() - 1);
        int[] originalDictionaryToSortedIndex = new int[sortedDictionaryIndexes.length];
        int sortOrdinal = 0;
        while (sortOrdinal < sortedDictionaryIndexes.length) {
            int dictionaryIndex = sortedDictionaryIndexes[sortOrdinal];
            originalDictionaryToSortedIndex[dictionaryIndex] = sortOrdinal++;
        }
        if (!this.rowGroups.isEmpty()) {
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            int position;
            IntBigArray dictionaryIndexes = rowGroup.getDictionaryIndexes();
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                this.presentStream.writeBoolean(dictionaryIndexes.get(position) != 0);
            }
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                int originalDictionaryIndex = dictionaryIndexes.get(position);
                if (originalDictionaryIndex == 0) continue;
                int sortedIndex = originalDictionaryToSortedIndex[originalDictionaryIndex];
                if (sortedIndex < 0) {
                    throw new IllegalArgumentException();
                }
                this.dataStream.writeLong(sortedIndex);
            }
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        this.dictionary.clear();
        this.dictionaryDataStream.close();
        this.dictionaryLengthStream.close();
        this.dataStream.close();
        this.presentStream.close();
    }

    private static int[] getSortedDictionaryNullsLast(final Block elementBlock) {
        int[] sortedPositions = new int[elementBlock.getPositionCount()];
        for (int i = 0; i < sortedPositions.length; ++i) {
            sortedPositions[i] = i;
        }
        IntArrays.quickSort((int[])sortedPositions, (int)0, (int)sortedPositions.length, (IntComparator)new AbstractIntComparator(){

            public int compare(int left, int right) {
                boolean nullLeft = elementBlock.isNull(left);
                boolean nullRight = elementBlock.isNull(right);
                if (nullLeft && nullRight) {
                    return 0;
                }
                if (nullLeft) {
                    return 1;
                }
                if (nullRight) {
                    return -1;
                }
                return elementBlock.compareTo(left, 0, elementBlock.getSliceLength(left), elementBlock, right, 0, elementBlock.getSliceLength(right));
            }
        });
        return sortedPositions;
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getIndexStreams(metadataWriter);
        }
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            int groupId = i;
            ColumnStatistics columnStatistics = this.rowGroups.get(groupId).getColumnStatistics();
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = SliceDictionaryColumnWriter.createSliceColumnPositionList(this.compression != CompressionKind.NONE, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createSliceColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getDataStreams();
        }
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column));
        outputDataStreams.add((Object)this.dictionaryLengthStream.getStreamDataOutput(this.column));
        outputDataStreams.add((Object)this.dictionaryDataStream.getStreamDataOutput(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.directEncoded) {
            return this.directColumnWriter.getBufferedBytes();
        }
        return this.getIndexBytes() + this.getDictionaryBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.values.sizeOf() + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.dictionaryDataStream.getRetainedBytes() + this.dictionaryLengthStream.getRetainedBytes() + this.dictionary.getRetainedSizeInBytes() + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes()) + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.dictionaryDataStream.reset();
        this.dictionaryLengthStream.reset();
        this.rowGroups.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.rowGroupValueCount = 0;
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        this.columnEncoding = null;
        this.dictionary.clear();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        if (this.directEncoded) {
            this.directEncoded = false;
            this.directColumnWriter.reset();
        }
    }

    private StringStatisticsBuilder newStringStatisticsBuilder() {
        return new StringStatisticsBuilder(this.stringStatisticsLimitInBytes);
    }

    private static class DictionaryRowGroup {
        private final IntBigArray dictionaryIndexes;
        private final int valueCount;
        private final ColumnStatistics columnStatistics;

        public DictionaryRowGroup(IntBigArray dictionaryIndexes, int valueCount, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(dictionaryIndexes, "dictionaryIndexes is null");
            Preconditions.checkArgument((valueCount >= 0 ? 1 : 0) != 0, (Object)"valueCount is negative");
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            this.dictionaryIndexes = dictionaryIndexes;
            this.valueCount = valueCount;
            this.columnStatistics = columnStatistics;
        }

        public IntBigArray getDictionaryIndexes() {
            return this.dictionaryIndexes;
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public ColumnStatistics getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

