/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDataSourceInput;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class CachingOrcDataSource
implements OrcDataSource {
    private final OrcDataSource dataSource;
    private final RegionFinder regionFinder;
    private final OrcLocalMemoryContext systemMemoryContext;
    private long cachePosition;
    private int cacheLength;
    private byte[] cache;

    public CachingOrcDataSource(OrcDataSource dataSource, RegionFinder regionFinder, OrcLocalMemoryContext systemMemoryContext) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.regionFinder = Objects.requireNonNull(regionFinder, "regionFinder is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.cache = new byte[0];
    }

    @Override
    public OrcDataSourceId getId() {
        return this.dataSource.getId();
    }

    @Override
    public long getReadBytes() {
        return this.dataSource.getReadBytes();
    }

    @Override
    public long getReadTimeNanos() {
        return this.dataSource.getReadTimeNanos();
    }

    @Override
    public long getSize() {
        return this.dataSource.getSize();
    }

    @VisibleForTesting
    void readCacheAt(long offset) throws IOException {
        DiskRange newCacheRange = this.regionFinder.getRangeFor(offset);
        this.cachePosition = newCacheRange.getOffset();
        this.cacheLength = newCacheRange.getLength();
        if (this.cache.length < this.cacheLength) {
            this.cache = new byte[this.cacheLength];
            this.systemMemoryContext.setBytes(this.cacheLength);
        }
        this.dataSource.readFully(newCacheRange.getOffset(), this.cache, 0, this.cacheLength);
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int length) throws IOException {
        if (position < this.cachePosition) {
            throw new IllegalArgumentException(String.format("read request (offset %d length %d) is before cache (offset %d length %d)", position, length, this.cachePosition, this.cacheLength));
        }
        if (position >= this.cachePosition + (long)this.cacheLength) {
            this.readCacheAt(position);
        }
        if (position + (long)length > this.cachePosition + (long)this.cacheLength) {
            throw new IllegalArgumentException(String.format("read request (offset %d length %d) partially overlaps cache (offset %d length %d)", position, length, this.cachePosition, this.cacheLength));
        }
        System.arraycopy(this.cache, Math.toIntExact(position - this.cachePosition), buffer, bufferOffset, length);
    }

    @Override
    public <K> Map<K, OrcDataSourceInput> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            byte[] buffer = new byte[diskRange.getLength()];
            this.readFully(diskRange.getOffset(), buffer);
            builder.put(entry.getKey(), (Object)new OrcDataSourceInput((FixedLengthSliceInput)Slices.wrappedBuffer((byte[])buffer).getInput(), buffer.length));
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    public String toString() {
        return this.dataSource.toString();
    }

    public static interface RegionFinder {
        public DiskRange getRangeFor(long var1);
    }
}

