/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.writer.CompressionBufferPool;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;

public class ColumnWriterOptions {
    private final CompressionKind compressionKind;
    private final OptionalInt compressionLevel;
    private final int compressionMaxBufferSize;
    private final DataSize stringStatisticsLimit;
    private final boolean integerDictionaryEncodingEnabled;
    private final boolean stringDictionarySortingEnabled;
    private final boolean stringDictionaryEncodingEnabled;
    private final boolean ignoreDictionaryRowGroupSizes;
    private final int preserveDirectEncodingStripeCount;
    private final CompressionBufferPool compressionBufferPool;
    private final Set<Integer> flattenedNodes;
    private final boolean mapStatisticsEnabled;
    private final int maxFlattenedMapKeyCount;

    public ColumnWriterOptions(CompressionKind compressionKind, OptionalInt compressionLevel, DataSize compressionMaxBufferSize, DataSize stringStatisticsLimit, boolean integerDictionaryEncodingEnabled, boolean stringDictionarySortingEnabled, boolean stringDictionaryEncodingEnabled, boolean ignoreDictionaryRowGroupSizes, int preserveDirectEncodingStripeCount, CompressionBufferPool compressionBufferPool, Set<Integer> flattenedNodes, boolean mapStatisticsEnabled, int maxFlattenedMapKeyCount) {
        Preconditions.checkArgument((maxFlattenedMapKeyCount > 0 ? 1 : 0) != 0, (String)"maxFlattenedMapKeyCount must be positive: %s", (int)maxFlattenedMapKeyCount);
        Objects.requireNonNull(compressionMaxBufferSize, "compressionMaxBufferSize is null");
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
        this.compressionLevel = Objects.requireNonNull(compressionLevel, "compressionLevel is null");
        this.compressionMaxBufferSize = Math.toIntExact(compressionMaxBufferSize.toBytes());
        this.stringStatisticsLimit = Objects.requireNonNull(stringStatisticsLimit, "stringStatisticsLimit is null");
        this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
        this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
        this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
        this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
        this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
        this.compressionBufferPool = Objects.requireNonNull(compressionBufferPool, "compressionBufferPool is null");
        this.flattenedNodes = Objects.requireNonNull(flattenedNodes, "flattenedNodes is null");
        this.mapStatisticsEnabled = mapStatisticsEnabled;
        this.maxFlattenedMapKeyCount = maxFlattenedMapKeyCount;
    }

    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    public OptionalInt getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getCompressionMaxBufferSize() {
        return this.compressionMaxBufferSize;
    }

    public int getStringStatisticsLimit() {
        return Math.toIntExact(this.stringStatisticsLimit.toBytes());
    }

    public boolean isIntegerDictionaryEncodingEnabled() {
        return this.integerDictionaryEncodingEnabled;
    }

    public boolean isStringDictionarySortingEnabled() {
        return this.stringDictionarySortingEnabled;
    }

    public boolean isStringDictionaryEncodingEnabled() {
        return this.stringDictionaryEncodingEnabled;
    }

    public boolean isIgnoreDictionaryRowGroupSizes() {
        return this.ignoreDictionaryRowGroupSizes;
    }

    public int getPreserveDirectEncodingStripeCount() {
        return this.preserveDirectEncodingStripeCount;
    }

    public CompressionBufferPool getCompressionBufferPool() {
        return this.compressionBufferPool;
    }

    public Set<Integer> getFlattenedNodes() {
        return this.flattenedNodes;
    }

    public boolean isMapStatisticsEnabled() {
        return this.mapStatisticsEnabled;
    }

    public int getMaxFlattenedMapKeyCount() {
        return this.maxFlattenedMapKeyCount;
    }

    public ColumnWriterOptions copyWithDisabledDictionaryEncoding() {
        return this.toBuilder().setStringDictionaryEncodingEnabled(false).setIntegerDictionaryEncodingEnabled(false).build();
    }

    public Builder toBuilder() {
        return new Builder().setCompressionKind(this.getCompressionKind()).setCompressionLevel(this.getCompressionLevel()).setCompressionMaxBufferSize(new DataSize((double)this.getCompressionMaxBufferSize(), DataSize.Unit.BYTE)).setStringStatisticsLimit(new DataSize((double)this.getStringStatisticsLimit(), DataSize.Unit.BYTE)).setIntegerDictionaryEncodingEnabled(this.isIntegerDictionaryEncodingEnabled()).setStringDictionarySortingEnabled(this.isStringDictionarySortingEnabled()).setStringDictionaryEncodingEnabled(this.isStringDictionaryEncodingEnabled()).setIgnoreDictionaryRowGroupSizes(this.isIgnoreDictionaryRowGroupSizes()).setPreserveDirectEncodingStripeCount(this.getPreserveDirectEncodingStripeCount()).setCompressionBufferPool(this.getCompressionBufferPool()).setFlattenedNodes(this.getFlattenedNodes()).setMapStatisticsEnabled(this.isMapStatisticsEnabled()).setMaxFlattenedMapKeyCount(this.getMaxFlattenedMapKeyCount());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CompressionKind compressionKind;
        private OptionalInt compressionLevel = OptionalInt.empty();
        private DataSize compressionMaxBufferSize = OrcWriterOptions.DEFAULT_MAX_COMPRESSION_BUFFER_SIZE;
        private DataSize stringStatisticsLimit = OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT;
        private boolean integerDictionaryEncodingEnabled;
        private boolean stringDictionarySortingEnabled = true;
        private boolean stringDictionaryEncodingEnabled = true;
        private boolean ignoreDictionaryRowGroupSizes;
        private int preserveDirectEncodingStripeCount = 0;
        private CompressionBufferPool compressionBufferPool = new CompressionBufferPool.LastUsedCompressionBufferPool();
        private Set<Integer> flattenedNodes = ImmutableSet.of();
        private boolean mapStatisticsEnabled;
        private int maxFlattenedMapKeyCount = 20000;

        private Builder() {
        }

        public Builder setCompressionKind(CompressionKind compressionKind) {
            this.compressionKind = compressionKind;
            return this;
        }

        public Builder setCompressionLevel(OptionalInt compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder setCompressionMaxBufferSize(DataSize compressionMaxBufferSize) {
            this.compressionMaxBufferSize = compressionMaxBufferSize;
            return this;
        }

        public Builder setStringStatisticsLimit(DataSize stringStatisticsLimit) {
            this.stringStatisticsLimit = stringStatisticsLimit;
            return this;
        }

        public Builder setIntegerDictionaryEncodingEnabled(boolean integerDictionaryEncodingEnabled) {
            this.integerDictionaryEncodingEnabled = integerDictionaryEncodingEnabled;
            return this;
        }

        public Builder setStringDictionarySortingEnabled(boolean stringDictionarySortingEnabled) {
            this.stringDictionarySortingEnabled = stringDictionarySortingEnabled;
            return this;
        }

        public Builder setStringDictionaryEncodingEnabled(boolean stringDictionaryEncodingEnabled) {
            this.stringDictionaryEncodingEnabled = stringDictionaryEncodingEnabled;
            return this;
        }

        public Builder setIgnoreDictionaryRowGroupSizes(boolean ignoreDictionaryRowGroupSizes) {
            this.ignoreDictionaryRowGroupSizes = ignoreDictionaryRowGroupSizes;
            return this;
        }

        public Builder setPreserveDirectEncodingStripeCount(int preserveDirectEncodingStripeCount) {
            this.preserveDirectEncodingStripeCount = preserveDirectEncodingStripeCount;
            return this;
        }

        public Builder setCompressionBufferPool(CompressionBufferPool compressionBufferPool) {
            this.compressionBufferPool = Objects.requireNonNull(compressionBufferPool, "compressionBufferPool is null");
            return this;
        }

        public Builder setFlattenedNodes(Set<Integer> flattenedNodes) {
            this.flattenedNodes = ImmutableSet.copyOf(flattenedNodes);
            return this;
        }

        public Builder setMapStatisticsEnabled(boolean mapStatisticsEnabled) {
            this.mapStatisticsEnabled = mapStatisticsEnabled;
            return this;
        }

        public Builder setMaxFlattenedMapKeyCount(int maxFlattenedMapKeyCount) {
            this.maxFlattenedMapKeyCount = maxFlattenedMapKeyCount;
            return this;
        }

        public ColumnWriterOptions build() {
            return new ColumnWriterOptions(this.compressionKind, this.compressionLevel, this.compressionMaxBufferSize, this.stringStatisticsLimit, this.integerDictionaryEncodingEnabled, this.stringDictionarySortingEnabled, this.stringDictionaryEncodingEnabled, this.ignoreDictionaryRowGroupSizes, this.preserveDirectEncodingStripeCount, this.compressionBufferPool, this.flattenedNodes, this.mapStatisticsEnabled, this.maxFlattenedMapKeyCount);
        }
    }
}

