/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DecodeTimestampOptions {
    private final boolean enableMicroPrecision;
    private final long unitsPerSecond;
    private final long nanosecondsPerUnit;
    private final long baseSeconds;

    public DecodeTimestampOptions(DateTimeZone hiveStorageTimeZone, boolean enableMicroPrecision) {
        this.enableMicroPrecision = enableMicroPrecision;
        TimeUnit timeUnit = enableMicroPrecision ? TimeUnit.MICROSECONDS : TimeUnit.MILLISECONDS;
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.unitsPerSecond = timeUnit.convert(1L, TimeUnit.SECONDS);
        this.nanosecondsPerUnit = TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        this.baseSeconds = TimeUnit.MILLISECONDS.toSeconds(new DateTime(2015, 1, 1, 0, 0, hiveStorageTimeZone).getMillis());
    }

    public boolean enableMicroPrecision() {
        return this.enableMicroPrecision;
    }

    public long getUnitsPerSecond() {
        return this.unitsPerSecond;
    }

    public long getNanosPerUnit() {
        return this.nanosecondsPerUnit;
    }

    public long getBaseSeconds() {
        return this.baseSeconds;
    }
}

