/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.proto.DwrfProto;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DwrfStreamOrderingConfig {
    private final ImmutableMap<Integer, Set<DwrfProto.KeyInfo>> columnToKeySet;

    public DwrfStreamOrderingConfig(Map<Integer, List<DwrfProto.KeyInfo>> columnToKeys) {
        Objects.requireNonNull(columnToKeys, "columnToKeys cannot be null");
        ImmutableMap.Builder columnToKeySetBuilder = new ImmutableMap.Builder();
        for (Map.Entry<Integer, List<DwrfProto.KeyInfo>> entry : columnToKeys.entrySet()) {
            columnToKeySetBuilder.put((Object)entry.getKey(), (Object)ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        this.columnToKeySet = columnToKeySetBuilder.build();
    }

    public Map<Integer, Set<DwrfProto.KeyInfo>> getStreamOrdering() {
        return this.columnToKeySet;
    }
}

