/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.GenericInternalException;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfMetadataWriter;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.CountStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;

public class OrcWriteValidation {
    private final List<Integer> version;
    private final CompressionKind compression;
    private final int rowGroupMaxRowCount;
    private final List<String> columnNames;
    private final Map<String, Slice> metadata;
    private final WriteChecksum checksum;
    private final Map<Long, List<RowGroupStatistics>> rowGroupStatistics;
    private final Map<Long, StripeStatistics> stripeStatistics;
    private final List<ColumnStatistics> fileStatistics;
    private final int stringStatisticsLimitInBytes;
    private final Map<Integer, Integer> flattenedKeyToMapNodes;
    private final Map<Integer, Set<Integer>> flattenedMapToValueNodes;
    private final Set<Integer> flattenedValueNodes;

    private OrcWriteValidation(List<Integer> version, CompressionKind compression, int rowGroupMaxRowCount, List<String> columnNames, Map<String, Slice> metadata, WriteChecksum checksum, Map<Long, List<RowGroupStatistics>> rowGroupStatistics, Map<Long, StripeStatistics> stripeStatistics, List<ColumnStatistics> fileStatistics, int stringStatisticsLimitInBytes, Set<Integer> flattenedNodes, List<OrcType> orcTypes) {
        this.version = version;
        this.compression = compression;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.columnNames = columnNames;
        this.metadata = metadata;
        this.checksum = checksum;
        this.rowGroupStatistics = rowGroupStatistics;
        this.stripeStatistics = stripeStatistics;
        this.fileStatistics = fileStatistics;
        this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
        this.flattenedKeyToMapNodes = this.getFlattenedKeyToMapNodes(flattenedNodes, orcTypes);
        this.flattenedValueNodes = this.getFlattenedValueNodes(flattenedNodes, orcTypes);
        this.flattenedMapToValueNodes = this.getFlattenedMapToValueNodes(flattenedNodes, orcTypes);
    }

    public List<Integer> getVersion() {
        return this.version;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<String, Slice> getMetadata() {
        return this.metadata;
    }

    public void validateMetadata(OrcDataSourceId orcDataSourceId, Map<String, Slice> actualMetadata) throws OrcCorruptionException {
        Map filteredMetadata = (Map)actualMetadata.entrySet().stream().filter(entry -> !DwrfMetadataWriter.STATIC_METADATA.containsKey(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!this.metadata.equals(filteredMetadata)) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected metadata");
        }
    }

    public WriteChecksum getChecksum() {
        return this.checksum;
    }

    public void validateFileStatistics(OrcDataSourceId orcDataSourceId, List<ColumnStatistics> actualFileStatistics) throws OrcCorruptionException {
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "file", actualFileStatistics, this.fileStatistics);
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, List<StripeInformation> actualStripes, List<StripeStatistics> actualStripeStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualStripes, "actualStripes is null");
        Objects.requireNonNull(actualStripeStatistics, "actualStripeStatistics is null");
        if (actualStripeStatistics.isEmpty()) {
            return;
        }
        if (actualStripeStatistics.size() != this.stripeStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in stripe statistics");
        }
        for (int stripeIndex = 0; stripeIndex < actualStripes.size(); ++stripeIndex) {
            long stripeOffset = actualStripes.get(stripeIndex).getOffset();
            StripeStatistics actual = actualStripeStatistics.get(stripeIndex);
            this.validateStripeStatistics(orcDataSourceId, stripeOffset, actual.getColumnStatistics());
        }
    }

    public void validateStripeStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, List<ColumnStatistics> actual) throws OrcCorruptionException {
        StripeStatistics expected = this.stripeStatistics.get(stripeOffset);
        if (expected == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Stripe at " + stripeOffset, actual, expected.getColumnStatistics());
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, Map<StreamId, List<RowGroupIndex>> actualRowGroupStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(actualRowGroupStatistics, "actualRowGroupStatistics is null");
        List<RowGroupStatistics> expectedRowGroupStatistics = this.rowGroupStatistics.get(stripeOffset);
        if (expectedRowGroupStatistics == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Missing row group column statistics for stripe at offset %s", stripeOffset);
        }
        int rowGroupCount = expectedRowGroupStatistics.size();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry : actualRowGroupStatistics.entrySet()) {
            if (entry.getValue().size() == rowGroupCount) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group count stripe in at offset %s", stripeOffset);
        }
        for (int rowGroupIndex = 0; rowGroupIndex < expectedRowGroupStatistics.size(); ++rowGroupIndex) {
            RowGroupStatistics expectedRowGroup = expectedRowGroupStatistics.get(rowGroupIndex);
            if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.HASHED) {
                Map<Integer, ColumnStatistics> expectedStatistics = expectedRowGroup.getColumnStatistics();
                Map<Integer, ColumnStatistics> actualStatistics = this.aggregateRowGroupStatisticsFromRowIndex(orcDataSourceId, actualRowGroupStatistics, stripeOffset, rowGroupIndex);
                expectedStatistics = this.adjustRowGroupStatisticsForFlatMaps(orcDataSourceId, stripeOffset, expectedStatistics);
                actualStatistics = this.adjustRowGroupStatisticsForFlatMaps(orcDataSourceId, stripeOffset, actualStatistics);
                Set<Integer> actualColumns = actualStatistics.keySet();
                Set<Integer> expectedColumns = expectedStatistics.keySet();
                if (!expectedColumns.equals(actualColumns)) {
                    throw new OrcCorruptionException(orcDataSourceId, "Unexpected column in row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
                }
                for (Map.Entry<StreamId, List<RowGroupIndex>> entry : actualRowGroupStatistics.entrySet()) {
                    int column = entry.getKey().getColumn();
                    ColumnStatistics actual = actualStatistics.get(column);
                    ColumnStatistics expected = expectedStatistics.get(column);
                    OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, actual, expected);
                }
            }
            if (expectedRowGroup.getValidationMode() == OrcWriteValidationMode.DETAILED) continue;
            Map<Integer, ColumnStatistics> actualStatistics = this.aggregateRowGroupStatisticsFromRowIndex(orcDataSourceId, actualRowGroupStatistics, stripeOffset, rowGroupIndex);
            actualStatistics = this.adjustRowGroupStatisticsForFlatMaps(orcDataSourceId, stripeOffset, actualStatistics);
            RowGroupStatistics actualRowGroup = new RowGroupStatistics(OrcWriteValidationMode.BOTH, actualStatistics);
            RowGroupStatistics adjustedExpectedRowGroup = new RowGroupStatistics(OrcWriteValidationMode.BOTH, this.adjustRowGroupStatisticsForFlatMaps(orcDataSourceId, stripeOffset, expectedRowGroup.getColumnStatistics()));
            if (adjustedExpectedRowGroup.getHash() == actualRowGroup.getHash()) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Checksum mismatch for row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
    }

    private Map<Integer, ColumnStatistics> adjustRowGroupStatisticsForFlatMaps(OrcDataSourceId orcDataSourceId, long stripeOffset, Map<Integer, ColumnStatistics> stats) {
        if (this.flattenedKeyToMapNodes.isEmpty()) {
            return stats;
        }
        StripeStatistics stripeStats = this.stripeStatistics.get(stripeOffset);
        if (stripeStats == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Could not find stripe statistics for a stripe at offset %s", stripeOffset);
        }
        List<ColumnStatistics> allStripeColumnStatistics = stripeStats.getColumnStatistics();
        HashSet<Integer> excludedNodes = new HashSet<Integer>();
        for (Map.Entry<Integer, Integer> keyToMapNodeEntry : this.flattenedKeyToMapNodes.entrySet()) {
            int keyNode = keyToMapNodeEntry.getKey();
            ColumnStatistics stripeColumnStat = allStripeColumnStatistics.get(keyNode);
            if (stripeColumnStat.getNumberOfValues() != 0L) continue;
            Integer mapNode = keyToMapNodeEntry.getValue();
            Set<Integer> valueNodes = this.flattenedMapToValueNodes.get(mapNode);
            for (int valueNode : valueNodes) {
                ColumnStatistics valueColumnStat = allStripeColumnStatistics.get(valueNode);
                if (valueColumnStat.getNumberOfValues() != 0L) {
                    throw new OrcCorruptionException(orcDataSourceId, "Stripe at offset %s has unexpected flat map value node column stats with non-zero number of values", stripeOffset);
                }
                excludedNodes.add(valueNode);
            }
        }
        return (Map)stats.entrySet().stream().filter(e -> !excludedNodes.contains(e.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Integer, ColumnStatistics> aggregateRowGroupStatisticsFromRowIndex(OrcDataSourceId orcDataSourceId, Map<StreamId, List<RowGroupIndex>> actualRowGroupStatistics, long stripeOffset, int rowGroupIndex) {
        HashMap<Integer, List> actualColumnStatisticsByColumn = new HashMap<Integer, List>();
        for (Map.Entry<StreamId, List<RowGroupIndex>> entry2 : actualRowGroupStatistics.entrySet()) {
            int column = entry2.getKey().getColumn();
            ColumnStatistics actual = entry2.getValue().get(rowGroupIndex).getColumnStatistics();
            List aggregateStats = actualColumnStatisticsByColumn.computeIfAbsent(column, key -> new ArrayList());
            aggregateStats.add(actual);
            if (aggregateStats.size() == 1 || this.flattenedValueNodes.contains(column)) continue;
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected multiple column statistics for node %s in row group %s in stripe at offset %s", column, rowGroupIndex, stripeOffset);
        }
        return actualColumnStatisticsByColumn.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ColumnStatistics.mergeColumnStatistics((List)entry.getValue())));
    }

    private Map<Integer, Integer> getFlattenedKeyToMapNodes(Set<Integer> flattenedNodes, List<OrcType> orcTypes) {
        ImmutableMap.Builder keyNodeToMapNode = ImmutableMap.builder();
        flattenedNodes.forEach(mapNodeIndex -> keyNodeToMapNode.put((Object)((OrcType)orcTypes.get((int)mapNodeIndex)).getFieldTypeIndex(0), mapNodeIndex));
        return keyNodeToMapNode.build();
    }

    private Map<Integer, Set<Integer>> getFlattenedMapToValueNodes(Set<Integer> flattenedNodes, List<OrcType> orcTypes) {
        ImmutableMap.Builder keyNodeToMapNode = ImmutableMap.builder();
        flattenedNodes.forEach(mapNodeIndex -> keyNodeToMapNode.put(mapNodeIndex, this.getFlattenedValueNodes((Set<Integer>)ImmutableSet.of((Object)mapNodeIndex), orcTypes)));
        return keyNodeToMapNode.build();
    }

    private Set<Integer> getFlattenedValueNodes(Set<Integer> flattenedNodes, List<OrcType> orcTypes) {
        ImmutableSet.Builder valueNodes = ImmutableSet.builder();
        ArrayList<Integer> stack = new ArrayList<Integer>();
        for (Integer mapNodeIndex : flattenedNodes) {
            int valueNodeIndex = orcTypes.get(mapNodeIndex).getFieldTypeIndex(1);
            stack.add(valueNodeIndex);
            while (!stack.isEmpty()) {
                int nodeIndex = (Integer)stack.remove(stack.size() - 1);
                valueNodes.add((Object)nodeIndex);
                OrcType orcType = orcTypes.get(nodeIndex);
                stack.addAll(orcType.getFieldTypeIndexes());
            }
        }
        return valueNodes.build();
    }

    public void validateRowGroupStatistics(OrcDataSourceId orcDataSourceId, long stripeOffset, int rowGroupIndex, List<ColumnStatistics> actual) throws OrcCorruptionException {
        List<RowGroupStatistics> rowGroups = this.rowGroupStatistics.get(stripeOffset);
        if (rowGroups == null) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected stripe at offset %s", stripeOffset);
        }
        if (rowGroups.size() <= rowGroupIndex) {
            throw new OrcCorruptionException(orcDataSourceId, "Unexpected row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
        ImmutableList.Builder actualAdjusted = ImmutableList.builder();
        ImmutableMap.Builder actualAdjustedByNode = ImmutableMap.builder();
        for (int i = 1; i < actual.size(); ++i) {
            if (this.flattenedKeyToMapNodes.containsKey(i)) continue;
            actualAdjusted.add((Object)actual.get(i));
            actualAdjustedByNode.put((Object)i, (Object)actual.get(i));
        }
        RowGroupStatistics expectedRowGroup = rowGroups.get(rowGroupIndex);
        RowGroupStatistics actualRowGroup = new RowGroupStatistics(OrcWriteValidationMode.BOTH, (Map<Integer, ColumnStatistics>)actualAdjustedByNode.build());
        if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.HASHED) {
            Map<Integer, ColumnStatistics> expectedByColumnIndex = expectedRowGroup.getColumnStatistics();
            List expected = (List)IntStream.range(1, actual.size()).filter(column -> !this.flattenedKeyToMapNodes.containsKey(column)).mapToObj(expectedByColumnIndex::get).collect(ImmutableList.toImmutableList());
            OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, "Row group " + rowGroupIndex + " in stripe at offset " + stripeOffset, (List<ColumnStatistics>)actualAdjusted.build(), expected);
        }
        if (expectedRowGroup.getValidationMode() != OrcWriteValidationMode.DETAILED && expectedRowGroup.getHash() != actualRowGroup.getHash()) {
            throw new OrcCorruptionException(orcDataSourceId, "Checksum mismatch for row group %s in stripe at offset %s", rowGroupIndex, stripeOffset);
        }
    }

    public StatisticsValidation createWriteStatisticsBuilder(Map<Integer, Type> readColumns) {
        Objects.requireNonNull(readColumns, "readColumns is null");
        Preconditions.checkArgument((!readColumns.isEmpty() ? 1 : 0) != 0, (Object)"readColumns is empty");
        int columnCount = readColumns.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
        Preconditions.checkArgument((readColumns.size() == columnCount ? 1 : 0) != 0, (Object)"statistics validation requires all columns to be read");
        ImmutableList.Builder types = ImmutableList.builder();
        for (int column = 0; column < columnCount; ++column) {
            Type type = readColumns.get(column);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"statistics validation requires all columns to be read");
            types.add((Object)type);
        }
        return new StatisticsValidation((List)types.build());
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, List<ColumnStatistics> actualColumnStatistics, List<ColumnStatistics> expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.size() != expectedColumnStatistics.size()) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected number of columns in %s statistics", name);
        }
        for (int i = 0; i < actualColumnStatistics.size(); ++i) {
            ColumnStatistics actual = actualColumnStatistics.get(i);
            ColumnStatistics expected = expectedColumnStatistics.get(i);
            OrcWriteValidation.validateColumnStatisticsEquivalent(orcDataSourceId, name + " column " + i, actual, expected);
        }
    }

    private static void validateColumnStatisticsEquivalent(OrcDataSourceId orcDataSourceId, String name, ColumnStatistics actualColumnStatistics, ColumnStatistics expectedColumnStatistics) throws OrcCorruptionException {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(actualColumnStatistics, "actualColumnStatistics is null");
        Objects.requireNonNull(expectedColumnStatistics, "expectedColumnStatistics is null");
        if (actualColumnStatistics.getNumberOfValues() != expectedColumnStatistics.getNumberOfValues()) {
            String failureMessage = String.format("Actual Values %s does not match expected values %s", actualColumnStatistics, expectedColumnStatistics);
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: %s in %s statistics", failureMessage, name);
        }
        if (!Objects.equals(actualColumnStatistics.getBooleanStatistics(), expectedColumnStatistics.getBooleanStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected boolean counts in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getIntegerStatistics(), expectedColumnStatistics.getIntegerStatistics())) {
            IntegerStatistics actualIntegerStatistics = actualColumnStatistics.getIntegerStatistics();
            IntegerStatistics expectedIntegerStatistics = expectedColumnStatistics.getIntegerStatistics();
            if (actualIntegerStatistics == null || expectedIntegerStatistics == null || !Objects.equals(actualIntegerStatistics.getMin(), expectedIntegerStatistics.getMin()) || !Objects.equals(actualIntegerStatistics.getMax(), expectedIntegerStatistics.getMax()) || actualIntegerStatistics.getSum() != null && expectedIntegerStatistics.getSum() != null && !Objects.equals(actualIntegerStatistics.getSum(), expectedIntegerStatistics.getSum())) {
                throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected integer range in %s statistics", name);
            }
        }
        if (!Objects.equals(actualColumnStatistics.getDoubleStatistics(), expectedColumnStatistics.getDoubleStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected double range in %s statistics", name);
        }
        StringStatistics expectedStringStatistics = expectedColumnStatistics.getStringStatistics();
        if (expectedStringStatistics != null) {
            expectedStringStatistics = new StringStatistics(OrcMetadataReader.minStringTruncateToValidRange(expectedStringStatistics.getMin(), PostScript.HiveWriterVersion.ORC_HIVE_8732), OrcMetadataReader.maxStringTruncateToValidRange(expectedStringStatistics.getMax(), PostScript.HiveWriterVersion.ORC_HIVE_8732), expectedStringStatistics.getSum());
        }
        StringStatistics actualStringStatistics = actualColumnStatistics.getStringStatistics();
        if (!Objects.equals(actualColumnStatistics.getStringStatistics(), expectedStringStatistics) && expectedStringStatistics != null && (actualStringStatistics == null || actualStringStatistics.getSum() != expectedStringStatistics.getSum() || expectedStringStatistics.getMax() != null && !Objects.equals(actualStringStatistics.getMax(), expectedStringStatistics.getMax()) || expectedStringStatistics.getMin() != null && !Objects.equals(actualStringStatistics.getMin(), expectedStringStatistics.getMin()))) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected string range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDateStatistics(), expectedColumnStatistics.getDateStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected date range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getDecimalStatistics(), expectedColumnStatistics.getDecimalStatistics())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected decimal range in %s statistics", name);
        }
        if (!Objects.equals(actualColumnStatistics.getBloomFilter(), expectedColumnStatistics.getBloomFilter())) {
            throw new OrcCorruptionException(orcDataSourceId, "Write validation failed: unexpected bloom filter in %s statistics", name);
        }
    }

    public static class OrcWriteValidationBuilder {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcWriteValidationBuilder.class).instanceSize();
        private final OrcWriteValidationMode validationMode;
        private List<Integer> version;
        private CompressionKind compression;
        private int rowGroupMaxRowCount;
        private int stringStatisticsLimitInBytes;
        private List<String> columnNames;
        private final Map<String, Slice> metadata = new HashMap<String, Slice>();
        private final WriteChecksumBuilder checksum;
        private List<RowGroupStatistics> currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        private final Map<Long, List<RowGroupStatistics>> rowGroupStatisticsByStripe = new HashMap<Long, List<RowGroupStatistics>>();
        private final Map<Long, StripeStatistics> stripeStatistics = new HashMap<Long, StripeStatistics>();
        private List<ColumnStatistics> fileStatistics;
        private long retainedSize = INSTANCE_SIZE;
        private Set<Integer> flattenedNodes;
        private List<OrcType> orcTypes;

        public OrcWriteValidationBuilder(OrcWriteValidationMode validationMode, List<Type> types) {
            this.validationMode = validationMode;
            this.checksum = new WriteChecksumBuilder(types);
        }

        public long getRetainedSize() {
            return this.retainedSize;
        }

        public OrcWriteValidationBuilder setVersion(List<Integer> version) {
            this.version = ImmutableList.copyOf(version);
            return this;
        }

        public void setCompression(CompressionKind compression) {
            this.compression = compression;
        }

        public void setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        }

        public OrcWriteValidationBuilder setStringStatisticsLimitInBytes(int stringStatisticsLimitInBytes) {
            this.stringStatisticsLimitInBytes = stringStatisticsLimitInBytes;
            return this;
        }

        public OrcWriteValidationBuilder setColumnNames(List<String> columnNames) {
            this.columnNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnNames, "columnNames is null"));
            return this;
        }

        public OrcWriteValidationBuilder addMetadataProperty(String key, Slice value) {
            this.metadata.put(key, value);
            return this;
        }

        public OrcWriteValidationBuilder addStripe(long rowCount) {
            this.checksum.addStripe(rowCount);
            return this;
        }

        public OrcWriteValidationBuilder addPage(Page page) {
            this.checksum.addPage(page);
            return this;
        }

        public void addRowGroupStatistics(Map<Integer, ColumnStatistics> columnStatistics) {
            RowGroupStatistics rowGroupStatistics = new RowGroupStatistics(this.validationMode, columnStatistics);
            this.currentRowGroupStatistics.add(rowGroupStatistics);
            this.retainedSize += (long)RowGroupStatistics.INSTANCE_SIZE;
            if (this.validationMode != OrcWriteValidationMode.HASHED) {
                for (ColumnStatistics statistics : rowGroupStatistics.getColumnStatistics().values()) {
                    this.retainedSize += 4L + statistics.getRetainedSizeInBytes();
                }
            }
        }

        public void addStripeStatistics(long stripStartOffset, StripeStatistics columnStatistics) {
            this.stripeStatistics.put(stripStartOffset, columnStatistics);
            this.rowGroupStatisticsByStripe.put(stripStartOffset, this.currentRowGroupStatistics);
            this.currentRowGroupStatistics = new ArrayList<RowGroupStatistics>();
        }

        public void setFileStatistics(List<ColumnStatistics> fileStatistics) {
            this.fileStatistics = fileStatistics;
        }

        public void setFlattenedNodes(Set<Integer> flattenedNodes) {
            this.flattenedNodes = flattenedNodes;
        }

        public void setOrcTypes(List<OrcType> orcTypes) {
            this.orcTypes = orcTypes;
        }

        public OrcWriteValidation build() {
            return new OrcWriteValidation(this.version, this.compression, this.rowGroupMaxRowCount, this.columnNames, this.metadata, this.checksum.build(), this.rowGroupStatisticsByStripe, this.stripeStatistics, this.fileStatistics, this.stringStatisticsLimitInBytes, this.flattenedNodes, this.orcTypes);
        }
    }

    private static class RowGroupStatistics {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowGroupStatistics.class).instanceSize();
        private final OrcWriteValidationMode validationMode;
        private final SortedMap<Integer, ColumnStatistics> columnStatistics;
        private final long hash;

        public RowGroupStatistics(OrcWriteValidationMode validationMode, Map<Integer, ColumnStatistics> columnStatistics) {
            this.validationMode = validationMode;
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            if (validationMode == OrcWriteValidationMode.HASHED) {
                this.columnStatistics = ImmutableSortedMap.of();
                this.hash = RowGroupStatistics.hashColumnStatistics((SortedMap<Integer, ColumnStatistics>)ImmutableSortedMap.copyOf(columnStatistics));
            } else if (validationMode == OrcWriteValidationMode.DETAILED) {
                this.columnStatistics = ImmutableSortedMap.copyOf(columnStatistics);
                this.hash = 0L;
            } else if (validationMode == OrcWriteValidationMode.BOTH) {
                this.columnStatistics = ImmutableSortedMap.copyOf(columnStatistics);
                this.hash = RowGroupStatistics.hashColumnStatistics(this.columnStatistics);
            } else {
                throw new IllegalArgumentException("Unsupported validation mode");
            }
        }

        private static long hashColumnStatistics(SortedMap<Integer, ColumnStatistics> columnStatistics) {
            StatisticsHasher statisticsHasher = new StatisticsHasher();
            statisticsHasher.putInt(columnStatistics.size());
            for (Map.Entry<Integer, ColumnStatistics> entry : columnStatistics.entrySet()) {
                statisticsHasher.putInt(entry.getKey()).putOptionalHashable(entry.getValue());
            }
            return statisticsHasher.hash();
        }

        public OrcWriteValidationMode getValidationMode() {
            return this.validationMode;
        }

        public Map<Integer, ColumnStatistics> getColumnStatistics() {
            Verify.verify((this.validationMode != OrcWriteValidationMode.HASHED ? 1 : 0) != 0, (String)"columnStatistics are not available in HASHED mode", (Object[])new Object[0]);
            return this.columnStatistics;
        }

        public long getHash() {
            return this.hash;
        }
    }

    private class ColumnStatisticsValidation {
        private final Type type;
        private final StatisticsBuilder statisticsBuilder;
        private final Function<Block, List<Block>> fieldExtractor;
        private final List<ColumnStatisticsValidation> fieldBuilders;

        private ColumnStatisticsValidation(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.statisticsBuilder = new BooleanStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TinyintType.TINYINT.equals((Object)type)) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (SmallintType.SMALLINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (IntegerType.INTEGER.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (BigintType.BIGINT.equals((Object)type)) {
                this.statisticsBuilder = new IntegerStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DoubleType.DOUBLE.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (RealType.REAL.equals((Object)type)) {
                this.statisticsBuilder = new DoubleStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof VarcharType) {
                this.statisticsBuilder = new StringStatisticsBuilder(OrcWriteValidation.this.stringStatisticsLimitInBytes);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof CharType) {
                this.statisticsBuilder = new StringStatisticsBuilder(OrcWriteValidation.this.stringStatisticsLimitInBytes);
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
                this.statisticsBuilder = new BinaryStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (DateType.DATE.equals((Object)type)) {
                this.statisticsBuilder = new DateStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (TimestampType.TIMESTAMP.equals((Object)type) || TimestampType.TIMESTAMP_MICROSECONDS.equals((Object)type)) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)type;
                this.statisticsBuilder = decimalType.isShort() ? new ShortDecimalStatisticsBuilder(decimalType.getScale()) : new LongDecimalStatisticsBuilder();
                this.fieldExtractor = ignored -> ImmutableList.of();
                this.fieldBuilders = ImmutableList.of();
            } else if (type.getTypeSignature().getBase().equals("array")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> ImmutableList.of((Object)ColumnarArray.toColumnarArray((Block)block).getElementsBlock());
                this.fieldBuilders = ImmutableList.of((Object)new ColumnStatisticsValidation((Type)Iterables.getOnlyElement((Iterable)type.getTypeParameters())));
            } else if (type.getTypeSignature().getBase().equals("map")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
                    return ImmutableList.of((Object)columnarMap.getKeysBlock(), (Object)columnarMap.getValuesBlock());
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
            } else if (type.getTypeSignature().getBase().equals("row")) {
                this.statisticsBuilder = new CountStatisticsBuilder();
                this.fieldExtractor = block -> {
                    ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
                    ImmutableList.Builder fields = ImmutableList.builder();
                    for (int index = 0; index < columnarRow.getFieldCount(); ++index) {
                        fields.add((Object)columnarRow.getField(index));
                    }
                    return fields.build();
                };
                this.fieldBuilders = (List)type.getTypeParameters().stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
            } else {
                throw new GenericInternalException(String.format("Unsupported Hive type: %s", type));
            }
        }

        private void addBlock(Block block) {
            this.statisticsBuilder.addBlock(this.type, block);
            List<Block> fields = this.fieldExtractor.apply(block);
            for (int i = 0; i < this.fieldBuilders.size(); ++i) {
                this.fieldBuilders.get(i).addBlock(fields.get(i));
            }
        }

        private void build(ImmutableList.Builder<ColumnStatistics> output) {
            output.add((Object)this.statisticsBuilder.buildColumnStatistics());
            this.fieldBuilders.forEach(fieldBuilders -> fieldBuilders.build(output));
        }
    }

    public class StatisticsValidation {
        private final List<Type> types;
        private List<ColumnStatisticsValidation> columnStatisticsValidations;
        private long rowCount;

        private StatisticsValidation(List<Type> types) {
            this.types = Objects.requireNonNull(types, "types is null");
            this.columnStatisticsValidations = (List)types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public void reset() {
            this.rowCount = 0L;
            this.columnStatisticsValidations = (List)this.types.stream().map(x$0 -> new ColumnStatisticsValidation((Type)x$0)).collect(ImmutableList.toImmutableList());
        }

        public void addPage(Page page) {
            this.rowCount += (long)page.getPositionCount();
            for (int channel = 0; channel < this.columnStatisticsValidations.size(); ++channel) {
                this.columnStatisticsValidations.get(channel).addBlock(page.getBlock(channel));
            }
        }

        public List<ColumnStatistics> build() {
            ImmutableList.Builder statisticsBuilders = ImmutableList.builder();
            if (this.rowCount > 0L) {
                statisticsBuilders.add((Object)new ColumnStatistics(this.rowCount, null));
                this.columnStatisticsValidations.forEach(validation -> ((ColumnStatisticsValidation)validation).build((ImmutableList.Builder<ColumnStatistics>)statisticsBuilders));
            }
            return statisticsBuilders.build();
        }
    }

    public static class WriteChecksumBuilder {
        private static final long NULL_HASH_CODE = 7944063686788161739L;
        private final List<Type> types;
        private long totalRowCount;
        private final List<XxHash64> columnHashes;
        private final XxHash64 stripeHash = new XxHash64();
        private final byte[] longBuffer = new byte[8];
        private final Slice longSlice = Slices.wrappedBuffer((byte[])this.longBuffer);

        private WriteChecksumBuilder(List<Type> types) {
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            ImmutableList.Builder columnHashes = ImmutableList.builder();
            for (Type ignored : types) {
                columnHashes.add((Object)new XxHash64());
            }
            this.columnHashes = columnHashes.build();
        }

        public static WriteChecksumBuilder createWriteChecksumBuilder(Map<Integer, Type> readColumns) {
            Objects.requireNonNull(readColumns, "readColumns is null");
            Preconditions.checkArgument((!readColumns.isEmpty() ? 1 : 0) != 0, (Object)"readColumns is empty");
            int columnCount = readColumns.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1;
            Preconditions.checkArgument((readColumns.size() == columnCount ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
            ImmutableList.Builder types = ImmutableList.builder();
            for (int column = 0; column < columnCount; ++column) {
                Type type = readColumns.get(column);
                Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"checksum requires all columns to be read");
                types.add((Object)type);
            }
            return new WriteChecksumBuilder((List<Type>)types.build());
        }

        public void addStripe(long rowCount) {
            this.longSlice.setLong(0, rowCount);
            this.stripeHash.update(this.longBuffer, 0, 8);
        }

        public void addPage(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() >= this.columnHashes.size() ? 1 : 0) != 0, (Object)"invalid page");
            for (int channel = 0; channel < this.columnHashes.size(); ++channel) {
                Type type = this.types.get(channel);
                Block block = page.getBlock(channel);
                XxHash64 xxHash64 = this.columnHashes.get(channel);
                for (int position = 0; position < block.getPositionCount(); ++position) {
                    long hash = WriteChecksumBuilder.hashPositionSkipNullMapKeys(type, block, position);
                    this.longSlice.setLong(0, hash);
                    xxHash64.update(this.longBuffer);
                }
            }
            this.totalRowCount += (long)page.getPositionCount();
        }

        private static long hashPositionSkipNullMapKeys(Type type, Block block, int position) {
            long micros;
            long mills;
            if (block.isNull(position)) {
                return 7944063686788161739L;
            }
            if (type.getTypeSignature().getBase().equals("map")) {
                Type keyType = (Type)type.getTypeParameters().get(0);
                Type valueType = (Type)type.getTypeParameters().get(1);
                Block mapBlock = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                    if (mapBlock.isNull(i)) continue;
                    hash += WriteChecksumBuilder.hashPositionSkipNullMapKeys(keyType, mapBlock, i);
                    hash += WriteChecksumBuilder.hashPositionSkipNullMapKeys(valueType, mapBlock, i + 1);
                }
                return hash;
            }
            if (type.getTypeSignature().getBase().equals("array")) {
                Type elementType = (Type)type.getTypeParameters().get(0);
                Block array = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < array.getPositionCount(); ++i) {
                    hash = 31L * hash + WriteChecksumBuilder.hashPositionSkipNullMapKeys(elementType, array, i);
                }
                return hash;
            }
            if (type.getTypeSignature().getBase().equals("row")) {
                Block row = (Block)type.getObject(block, position);
                long hash = 0L;
                for (int i = 0; i < row.getPositionCount(); ++i) {
                    Type elementType = (Type)type.getTypeParameters().get(i);
                    hash = 31L * hash + WriteChecksumBuilder.hashPositionSkipNullMapKeys(elementType, row, i);
                }
                return hash;
            }
            if (type.getTypeSignature().getBase().equals("timestamp") && (mills = TimestampType.TIMESTAMP.getLong(block, position)) > -1000L && mills < 0L) {
                return AbstractLongType.hash((long)(mills + 1000L));
            }
            if (type.getTypeSignature().getBase().equals("timestamp microseconds") && (micros = TimestampType.TIMESTAMP_MICROSECONDS.getLong(block, position)) > -1000000L && micros < 0L) {
                return AbstractLongType.hash((long)(micros + 1000000L));
            }
            return type.hash(block, position);
        }

        public WriteChecksum build() {
            return new WriteChecksum(this.totalRowCount, this.stripeHash.hash(), (List)this.columnHashes.stream().map(XxHash64::hash).collect(ImmutableList.toImmutableList()));
        }
    }

    public static class WriteChecksum {
        private final long totalRowCount;
        private final long stripeHash;
        private final List<Long> columnHashes;

        public WriteChecksum(long totalRowCount, long stripeHash, List<Long> columnHashes) {
            this.totalRowCount = totalRowCount;
            this.stripeHash = stripeHash;
            this.columnHashes = columnHashes;
        }

        public long getTotalRowCount() {
            return this.totalRowCount;
        }

        public long getStripeHash() {
            return this.stripeHash;
        }

        public List<Long> getColumnHashes() {
            return this.columnHashes;
        }
    }

    public static enum OrcWriteValidationMode {
        HASHED,
        DETAILED,
        BOTH;

    }
}

