/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatistics;
import com.facebook.presto.orc.metadata.statistics.MapStatisticsEntry;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import com.facebook.presto.orc.proto.DwrfProto;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MapColumnStatisticsBuilder
implements StatisticsBuilder {
    private final ImmutableList.Builder<MapStatisticsEntry> entries = new ImmutableList.Builder();
    private final boolean collectKeyStats;
    private long nonNullValueCount;
    private boolean hasEntries;

    public MapColumnStatisticsBuilder(boolean collectKeyStats) {
        this.collectKeyStats = collectKeyStats;
    }

    @Override
    public void addBlock(Type type, Block block) {
        throw new UnsupportedOperationException();
    }

    public void addMapStatistics(DwrfProto.KeyInfo key, ColumnStatistics columnStatistics) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(columnStatistics, "columnStatistics is null");
        this.hasEntries = true;
        if (this.collectKeyStats) {
            this.entries.add((Object)new MapStatisticsEntry(key, columnStatistics));
        }
    }

    public void increaseValueCount(long count) {
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        this.nonNullValueCount += count;
    }

    private Optional<MapStatistics> buildMapStatistics() {
        if (this.hasEntries && this.collectKeyStats) {
            MapStatistics mapStatistics = new MapStatistics((List<MapStatisticsEntry>)this.entries.build());
            return Optional.of(mapStatistics);
        }
        return Optional.empty();
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        if (this.hasEntries && this.collectKeyStats) {
            MapStatistics mapStatistics = new MapStatistics((List<MapStatisticsEntry>)this.entries.build());
            return new MapColumnStatistics(this.nonNullValueCount, null, mapStatistics);
        }
        return new ColumnStatistics(this.nonNullValueCount, null);
    }

    public static Optional<MapStatistics> mergeMapStatistics(List<ColumnStatistics> stats) {
        LinkedHashMap<DwrfProto.KeyInfo, List> columnStatisticsByKey = new LinkedHashMap<DwrfProto.KeyInfo, List>();
        long nonNullValueCount = 0L;
        for (ColumnStatistics columnStatistics : stats) {
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            MapStatistics partialStatistics = columnStatistics.getMapStatistics();
            if (partialStatistics == null) {
                return Optional.empty();
            }
            for (MapStatisticsEntry entry : partialStatistics.getEntries()) {
                List allKeyStats = columnStatisticsByKey.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                allKeyStats.add(entry.getColumnStatistics());
            }
            nonNullValueCount += columnStatistics.getNumberOfValues();
        }
        MapColumnStatisticsBuilder mapStatisticsBuilder = new MapColumnStatisticsBuilder(true);
        for (Map.Entry entry : columnStatisticsByKey.entrySet()) {
            ColumnStatistics mergedColumnStatistics = ColumnStatistics.mergeColumnStatistics((List)entry.getValue());
            DwrfProto.KeyInfo key = (DwrfProto.KeyInfo)entry.getKey();
            mapStatisticsBuilder.addMapStatistics(key, mergedColumnStatistics);
        }
        mapStatisticsBuilder.increaseValueCount(nonNullValueCount);
        return mapStatisticsBuilder.buildMapStatistics();
    }
}

