/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.NoopOrcLocalMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfStripeCacheMode;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.CodedInputStream;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;

public abstract class AbstractTestDwrfStripeCaching {
    private static final DataSize CACHE_MAX_SIZE = DataSize.valueOf((String)"8MB");
    private final TempFile bothAllStripesFile = AbstractTestDwrfStripeCaching.writeOrcFile(true, DwrfStripeCacheMode.INDEX_AND_FOOTER, CACHE_MAX_SIZE);
    private final TempFile bothHalfStripesFile = AbstractTestDwrfStripeCaching.rewriteFile(this.bothAllStripesFile, DwrfStripeCacheMode.INDEX_AND_FOOTER);
    private final TempFile indexAllStripesFile = AbstractTestDwrfStripeCaching.writeOrcFile(true, DwrfStripeCacheMode.INDEX, CACHE_MAX_SIZE);
    private final TempFile indexHalfStripesFile = AbstractTestDwrfStripeCaching.rewriteFile(this.indexAllStripesFile, DwrfStripeCacheMode.INDEX);
    private final TempFile footerAllStripesFile = AbstractTestDwrfStripeCaching.writeOrcFile(true, DwrfStripeCacheMode.FOOTER, CACHE_MAX_SIZE);
    private final TempFile footerHalfStripesFile = AbstractTestDwrfStripeCaching.rewriteFile(this.footerAllStripesFile, DwrfStripeCacheMode.FOOTER);
    private final TempFile noneAllStripesFile = AbstractTestDwrfStripeCaching.writeOrcFile(true, DwrfStripeCacheMode.NONE, CACHE_MAX_SIZE);
    private final TempFile stripeCacheDisabledFile = AbstractTestDwrfStripeCaching.writeOrcFile(false, DwrfStripeCacheMode.INDEX_AND_FOOTER, CACHE_MAX_SIZE);

    @AfterClass
    public void tearDown() throws IOException {
        ImmutableList files = ImmutableList.of((Object)this.bothAllStripesFile, (Object)this.bothHalfStripesFile, (Object)this.indexAllStripesFile, (Object)this.indexHalfStripesFile, (Object)this.footerAllStripesFile, (Object)this.footerHalfStripesFile, (Object)this.noneAllStripesFile, (Object)this.stripeCacheDisabledFile);
        for (TempFile tempFile : files) {
            tempFile.close();
        }
    }

    @DataProvider(name="Stripe cache for ALL stripes with mode BOTH")
    public Object[][] bothAllStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_BOTH_AllStripes.orc"), this.bothAllStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache for HALF stripes with mode BOTH")
    public Object[][] bothHalfStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_BOTH_HalfStripes.orc"), this.bothHalfStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache for ALL stripes with mode INDEX")
    public Object[][] indexAllStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_INDEX_AllStripes.orc"), this.indexAllStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache for HALF stripes with mode INDEX")
    public Object[][] indexHalfStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_INDEX_HalfStripes.orc"), this.indexHalfStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache for ALL stripes with mode FOOTER")
    public Object[][] footerAllStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_FOOTER_AllStripes.orc"), this.footerAllStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache for HALF stripes with mode FOOTER")
    public Object[][] footerHalfStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_FOOTER_HalfStripes.orc"), this.footerHalfStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache with mode NONE")
    public Object[][] noneAllStripesFilesProvider() {
        return AbstractTestDwrfStripeCaching.toArray(AbstractTestDwrfStripeCaching.getResourceFile("DwrfStripeCache_NONE.orc"), this.noneAllStripesFile.getFile());
    }

    @DataProvider(name="Stripe cache disabled")
    public Object[][] stripeCacheDisabledFilesProvider() {
        return new Object[][]{{this.stripeCacheDisabledFile.getFile()}};
    }

    static File getResourceFile(String fileName) {
        String resourceName = "dwrf_stripe_cache/" + fileName;
        return new File(Resources.getResource((String)resourceName).getFile());
    }

    private static Object[][] toArray(File file1, File file2) {
        return new Object[][]{{file1}, {file2}};
    }

    private static TempFile rewriteFile(TempFile srcFile, DwrfStripeCacheMode mode) {
        DwrfProto.Footer footer = AbstractTestDwrfStripeCaching.readFileFooter(srcFile.getFile());
        Assert.assertEquals((int)footer.getStripesCount(), (int)4);
        long size = 0L;
        for (int i = 0; i < 2; ++i) {
            DwrfProto.StripeInformation stripe = footer.getStripes(i);
            if (mode.hasFooter()) {
                size += stripe.getFooterLength();
            }
            if (!mode.hasIndex()) continue;
            size += stripe.getIndexLength();
        }
        return AbstractTestDwrfStripeCaching.writeOrcFile(true, mode, new DataSize((double)size, DataSize.Unit.BYTE));
    }

    private static TempFile writeOrcFile(boolean cacheEnabled, DwrfStripeCacheMode cacheMode, DataSize cacheMaxSize) {
        TempFile outputFile = new TempFile();
        try {
            IntegerType type = IntegerType.INTEGER;
            ImmutableList types = ImmutableList.of((Object)type, (Object)type, (Object)type);
            OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(100).build()).withDwrfStripeCacheEnabled(cacheEnabled).withDwrfStripeCacheMode(cacheMode).withDwrfStripeCacheMaxSize(cacheMaxSize).build();
            OrcWriter writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(outputFile.getFile())), (List)ImmutableList.of((Object)"Int1", (Object)"Int2", (Object)"Int3"), (List)types, OrcEncoding.DWRF, CompressionKind.ZLIB, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, writerOptions, (Map)ImmutableMap.of(), OrcTester.HIVE_STORAGE_TIME_ZONE, true, OrcWriteValidation.OrcWriteValidationMode.BOTH, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
            int count = 0;
            for (int stripe = 0; stripe < 4; ++stripe) {
                BlockBuilder[] blockBuilders = new BlockBuilder[3];
                for (int i = 0; i < blockBuilders.length; ++i) {
                    blockBuilders[i] = type.createBlockBuilder(null, 100);
                }
                for (int row = 0; row < 100; ++row) {
                    blockBuilders[0].writeInt(count);
                    blockBuilders[1].writeInt(Integer.MAX_VALUE);
                    blockBuilders[2].writeInt(count * 10);
                    ++count;
                }
                Block[] blocks = new Block[blockBuilders.length];
                for (int i = 0; i < blocks.length; ++i) {
                    blocks[i] = blockBuilders[i].build();
                }
                writer.write(new Page(blocks));
            }
            writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return outputFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DwrfProto.Footer readFileFooter(File orcFile) {
        try (RandomAccessFile file = new RandomAccessFile(orcFile, "r");){
            file.seek(file.length() - 1L);
            int postScriptSize = file.read() & 0xFF;
            long postScriptPosition = file.length() - (long)postScriptSize - 1L;
            byte[] postScriptBytes = AbstractTestDwrfStripeCaching.readBytes(file, postScriptPosition, postScriptSize);
            CodedInputStream postScriptInput = CodedInputStream.newInstance((byte[])postScriptBytes, (int)0, (int)postScriptSize);
            DwrfProto.PostScript postScript = DwrfProto.PostScript.parseFrom((CodedInputStream)postScriptInput);
            long footerPosition = postScriptPosition - postScript.getFooterLength();
            int footerLength = Math.toIntExact(postScript.getFooterLength());
            byte[] footerBytes = AbstractTestDwrfStripeCaching.readBytes(file, footerPosition, postScript.getFooterLength());
            int compressionBufferSize = Math.toIntExact(postScript.getCompressionBlockSize());
            OrcDataSourceId dataSourceId = new OrcDataSourceId(orcFile.getName());
            Optional decompressor = OrcDecompressor.createOrcDecompressor((OrcDataSourceId)dataSourceId, (CompressionKind)CompressionKind.ZLIB, (int)compressionBufferSize);
            OrcInputStream footerInputStream = new OrcInputStream(dataSourceId, new SharedBuffer((OrcLocalMemoryContext)NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT), (FixedLengthSliceInput)Slices.wrappedBuffer((byte[])footerBytes).slice(0, footerLength).getInput(), decompressor, Optional.empty(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, (long)footerLength);
            DwrfProto.Footer footer = DwrfProto.Footer.parseFrom((InputStream)footerInputStream);
            return footer;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static byte[] readBytes(RandomAccessFile file, long offset, long length) throws IOException {
        byte[] buf = new byte[Math.toIntExact(length)];
        file.seek(offset);
        file.readFully(buf, 0, buf.length);
        return buf;
    }
}

