/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.CachingStripeMetadataSource;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.cache.CachingOrcFileTailSource;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestOrcReader {
    private static final int CHAR_LENGTH = 10;
    private static final DecimalType DECIMAL_TYPE_PRECISION_2 = DecimalType.createDecimalType((int)2, (int)1);
    private static final DecimalType DECIMAL_TYPE_PRECISION_4 = DecimalType.createDecimalType((int)4, (int)2);
    private static final DecimalType DECIMAL_TYPE_PRECISION_8 = DecimalType.createDecimalType((int)8, (int)4);
    private static final DecimalType DECIMAL_TYPE_PRECISION_17 = DecimalType.createDecimalType((int)17, (int)8);
    private static final DecimalType DECIMAL_TYPE_PRECISION_18 = DecimalType.createDecimalType((int)18, (int)8);
    private static final DecimalType DECIMAL_TYPE_PRECISION_38 = DecimalType.createDecimalType((int)38, (int)16);
    private static final CharType CHAR = CharType.createCharType((long)10L);
    private final OrcTester tester;

    public AbstractTestOrcReader(OrcTester tester) {
        this.tester = tester;
    }

    @BeforeClass
    public void setUp() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)OrcTester.HIVE_STORAGE_TIME_ZONE);
    }

    @Test
    public void testBooleanSequence() throws Exception {
        this.tester.testRoundTrip((Type)BooleanType.BOOLEAN, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)30000)));
    }

    @Test
    public void testLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<? extends Number>)AbstractTestOrcReader.intsBetween(0, 31234));
    }

    @Test
    public void testNegativeLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<? extends Number>)AbstractTestOrcReader.intsBetween(-31234, -999));
    }

    @Test
    public void testLongSequenceWithHoles() throws Exception {
        this.testRoundTripNumeric(AbstractTestOrcReader.skipEvery(5, AbstractTestOrcReader.intsBetween(0, 31234)));
    }

    @Test
    public void testLongDirect() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000));
    }

    @Test
    public void testLongDirect2() throws Exception {
        ArrayList<Integer> values = new ArrayList<Integer>(31234);
        for (int i = 0; i < 31234; ++i) {
            values.add(i);
        }
        Collections.shuffle(values, new Random(0L));
        this.testRoundTripNumeric(values);
    }

    @Test
    public void testLongShortRepeat() throws Exception {
        this.testRoundTripNumeric(Iterables.limit(AbstractTestOrcReader.repeatEach(4, Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17))), (int)30000));
    }

    @Test
    public void testLongPatchedBase() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat(AbstractTestOrcReader.intsBetween(0, 18), AbstractTestOrcReader.intsBetween(0, 18), (Iterable)ImmutableList.of((Object)30000, (Object)20000, (Object)400000, (Object)30000, (Object)20000))), (int)30000));
    }

    @Test
    public void testLongStrideDictionary() throws Exception {
        this.testRoundTripNumeric(Iterables.concat((Iterable)ImmutableList.of((Object)1), Collections.nCopies(9999, 123), (Iterable)ImmutableList.of((Object)2), Collections.nCopies(9999, 123)));
    }

    @Test
    public void testCaching() throws Exception {
        Cache orcFileTailCache = CacheBuilder.newBuilder().maximumWeight(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes()).weigher((id, tail) -> ((OrcFileTail)tail).getFooterSize() + ((OrcFileTail)tail).getMetadataSize()).expireAfterAccess(new Duration(10.0, TimeUnit.MINUTES).toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        CachingOrcFileTailSource orcFileTailSource = new CachingOrcFileTailSource((OrcFileTailSource)new StorageOrcFileTailSource(), orcFileTailCache);
        Cache stripeFootercache = CacheBuilder.newBuilder().maximumWeight(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes()).weigher((id, footer) -> ((Slice)footer).length()).expireAfterAccess(new Duration(10.0, TimeUnit.MINUTES).toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        Cache stripeStreamCache = CacheBuilder.newBuilder().maximumWeight(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes()).weigher((id, stream) -> ((Slice)stream).length()).expireAfterAccess(new Duration(10.0, TimeUnit.MINUTES).toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        Optional<Cache> rowGroupIndexCache = Optional.of(CacheBuilder.newBuilder().maximumWeight(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes()).weigher((id, rowGroupIndices) -> Math.toIntExact(((List)rowGroupIndices).stream().mapToLong(RowGroupIndex::getRetainedSizeInBytes).sum())).expireAfterAccess(new Duration(10.0, TimeUnit.MINUTES).toMillis(), TimeUnit.MILLISECONDS).recordStats().build());
        CachingStripeMetadataSource stripeMetadataSource = new CachingStripeMetadataSource((StripeMetadataSource)new StorageStripeMetadataSource(), stripeFootercache, stripeStreamCache, rowGroupIndexCache);
        try (TempFile tempFile = AbstractTestOrcReader.createTempFile(10001);){
            OrcBatchRecordReader storageReader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 1, (OrcFileTailSource)orcFileTailSource, (StripeMetadataSource)stripeMetadataSource, true, (Map<Integer, Slice>)ImmutableMap.of(), false);
            Assert.assertEquals((long)orcFileTailCache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)orcFileTailCache.stats().hitCount(), (long)0L);
            OrcBatchRecordReader cacheReader = OrcTester.createCustomOrcRecordReader(tempFile, OrcEncoding.ORC, OrcPredicate.TRUE, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), 1, (OrcFileTailSource)orcFileTailSource, (StripeMetadataSource)stripeMetadataSource, true, (Map<Integer, Slice>)ImmutableMap.of(), false);
            Assert.assertEquals((long)orcFileTailCache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)orcFileTailCache.stats().hitCount(), (long)1L);
            Assert.assertEquals((long)storageReader.getRetainedSizeInBytes(), (long)cacheReader.getRetainedSizeInBytes());
            Assert.assertEquals((long)storageReader.getFileRowCount(), (long)cacheReader.getFileRowCount());
            Assert.assertEquals((long)storageReader.getSplitLength(), (long)cacheReader.getSplitLength());
            storageReader.nextBatch();
            Assert.assertEquals((long)stripeFootercache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)stripeFootercache.stats().hitCount(), (long)0L);
            Assert.assertEquals((long)stripeStreamCache.stats().missCount(), (long)2L);
            Assert.assertEquals((long)stripeStreamCache.stats().hitCount(), (long)0L);
            Assert.assertEquals((long)rowGroupIndexCache.get().stats().missCount(), (long)1L);
            Assert.assertEquals((long)rowGroupIndexCache.get().stats().hitCount(), (long)0L);
            cacheReader.nextBatch();
            Assert.assertEquals((long)stripeFootercache.stats().missCount(), (long)1L);
            Assert.assertEquals((long)stripeFootercache.stats().hitCount(), (long)1L);
            Assert.assertEquals((long)stripeStreamCache.stats().missCount(), (long)2L);
            Assert.assertEquals((long)stripeStreamCache.stats().hitCount(), (long)2L);
            Assert.assertEquals((long)rowGroupIndexCache.get().stats().missCount(), (long)1L);
            Assert.assertEquals((long)rowGroupIndexCache.get().stats().hitCount(), (long)1L);
            Assert.assertEquals((int)storageReader.readBlock(0).getInt(0), (int)cacheReader.readBlock(0).getInt(0));
        }
    }

    private static TempFile createTempFile(int nRecords) throws IOException, SerDeException {
        TempFile file = new TempFile();
        FileSinkOperator.RecordWriter writer = OrcTester.createOrcRecordWriter(file.getFile(), OrcTester.Format.ORC_12, CompressionKind.NONE, (Type)BigintType.BIGINT);
        OrcSerde serde = new OrcSerde();
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector("test", (Type)BigintType.BIGINT);
        Object row = objectInspector.create();
        StructField field = (StructField)objectInspector.getAllStructFieldRefs().get(0);
        objectInspector.setStructFieldData(row, field, (Object)1L);
        Writable record = serde.serialize(row, (ObjectInspector)objectInspector);
        for (int i = 0; i < nRecords; ++i) {
            writer.write(record);
        }
        writer.close(false);
        return file;
    }

    private void testRoundTripNumeric(Iterable<? extends Number> values) throws Exception {
        List writeValues = ImmutableList.copyOf(values).stream().map(Number::longValue).collect(Collectors.toList());
        this.tester.testRoundTrip((Type)TinyintType.TINYINT, writeValues.stream().map(Long::byteValue).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)SmallintType.SMALLINT, writeValues.stream().map(Long::shortValue).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)IntegerType.INTEGER, writeValues.stream().map(Long::intValue).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)BigintType.BIGINT, writeValues);
        this.tester.testRoundTrip((Type)DateType.DATE, writeValues.stream().map(Long::intValue).map(SqlDate::new).collect(Collectors.toList()));
        this.tester.testRoundTrip((Type)TimestampType.TIMESTAMP, writeValues.stream().map(timestamp -> DateTimeTestingUtils.sqlTimestampOf((long)timestamp, (ConnectorSession)TestingConnectorSession.SESSION)).collect(Collectors.toList()));
    }

    @Test
    public void testFloatSequence() throws Exception {
        this.tester.testRoundTrip((Type)RealType.REAL, AbstractTestOrcReader.floatSequence(0.0f, 0.1f, 30000));
    }

    @Test
    public void testFloatNaNInfinity() throws Exception {
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(-1.23f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(-1000.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.23f)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-0.0f), (Object)Float.valueOf(1.0f)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.0f)));
        this.tester.testRoundTrip((Type)RealType.REAL, (List<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)));
    }

    @Test
    public void testDoubleSequence() throws Exception {
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, AbstractTestOrcReader.doubleSequence(0.0, 0.1, 30000));
    }

    @Test
    public void testDecimalSequence() throws Exception {
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_2, AbstractTestOrcReader.decimalSequence("-30", "1", 60, 2, 1));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_4, AbstractTestOrcReader.decimalSequence("-3000", "1", 6000, 4, 2));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_8, AbstractTestOrcReader.decimalSequence("-3000000", "100", 60000, 8, 4));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_17, AbstractTestOrcReader.decimalSequence("-30000000000", "1000000", 60000, 17, 8));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_18, AbstractTestOrcReader.decimalSequence("-30000000000", "1000000", 60000, 18, 8));
        this.tester.testRoundTrip((Type)DECIMAL_TYPE_PRECISION_38, AbstractTestOrcReader.decimalSequence("-3000000000000000000", "100000000000000", 60000, 38, 16));
    }

    @Test
    public void testDoubleNaNInfinity() throws Exception {
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)1000.0, (Object)-1.0, (Object)Double.POSITIVE_INFINITY));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)-1000.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)0.0, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)1.0));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)Double.POSITIVE_INFINITY));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)1.0));
        this.tester.testRoundTrip((Type)DoubleType.DOUBLE, (List<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY));
    }

    @Test
    public void testStringUnicode() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"apple", (Object)"apple pie", (Object)"apple\ud835\udc03", (Object)"apple\ufffd")), (int)30000)));
    }

    @Test
    public void testStringDirectSequence() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, AbstractTestOrcReader.intsBetween(0, 30000).stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Test
    public void testStringDictionarySequence() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)).stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Test
    public void testStringStrideDictionary() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.concat((Iterable)ImmutableList.of((Object)"a"), Collections.nCopies(9999, "123"), (Iterable)ImmutableList.of((Object)"b"), Collections.nCopies(9999, "123"))));
    }

    @Test
    public void testEmptyStringSequence() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{""}), (int)30000)));
    }

    @Test
    public void testCharDirectSequence() throws Exception {
        this.tester.testRoundTrip((Type)CHAR, AbstractTestOrcReader.intsBetween(0, 30000).stream().map(this::toCharValue).collect(Collectors.toList()));
    }

    @Test
    public void testCharDictionarySequence() throws Exception {
        this.tester.testRoundTrip((Type)CHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)).stream().map(this::toCharValue).collect(Collectors.toList()));
    }

    @Test
    public void testEmptyCharSequence() throws Exception {
        this.tester.testRoundTrip((Type)CHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{"          "}), (int)30000)));
    }

    private String toCharValue(Object value) {
        return Strings.padEnd((String)value.toString(), (int)10, (char)' ');
    }

    @Test
    public void testBinaryDirectSequence() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, AbstractTestOrcReader.intsBetween(0, 30000).stream().map(Object::toString).map(string -> string.getBytes(StandardCharsets.UTF_8)).map(SqlVarbinary::new).collect(Collectors.toList()));
    }

    @Test
    public void testBinaryDictionarySequence() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)).stream().map(Object::toString).map(string -> string.getBytes(StandardCharsets.UTF_8)).map(SqlVarbinary::new).collect(Collectors.toList()));
    }

    @Test
    public void testEmptyBinarySequence() throws Exception {
        this.tester.testRoundTrip((Type)VarbinaryType.VARBINARY, Collections.nCopies(30000, new SqlVarbinary(new byte[0])));
    }

    @Test
    public void testDwrfInvalidCheckpointsForRowGroupDictionary() throws Exception {
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat((Iterable[])new Iterable[]{ImmutableList.of((Object)1), Collections.nCopies(9999, 123), ImmutableList.of((Object)2), Collections.nCopies(9999, 123), ImmutableList.of((Object)3), Collections.nCopies(9999, 123), Collections.nCopies(1000000, null)})), (int)200000));
        this.tester.assertRoundTrip((Type)IntegerType.INTEGER, values, false);
        this.tester.assertRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)values).stream().map(value -> value == null ? null : String.valueOf(value)).collect(Collectors.toList()));
    }

    @Test
    public void testDwrfInvalidCheckpointsForStripeDictionary() throws Exception {
        this.tester.testRoundTrip((Type)VarcharType.VARCHAR, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)200000)).stream().map(Object::toString).collect(Collectors.toList()));
    }

    @Test
    public void testExtraLargeColumnValue() throws Exception {
        Random rnd = new Random(0L);
        String val = rnd.doubles(50000L).mapToObj(Double::toString).collect(Collectors.joining(","));
        this.tester.assertRoundTrip((Type)VarcharType.VARCHAR, (List<?>)ImmutableList.of((Object)val));
    }

    private static <T> Iterable<T> skipEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                while (this.delegate.hasNext()) {
                    Object next = this.delegate.next();
                    ++this.position;
                    if (this.position <= n) {
                        return next;
                    }
                    this.position = 0;
                }
                return this.endOfData();
            }
        };
    }

    private static <T> Iterable<T> repeatEach(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private int position;
            private final Iterator delegate;
            private Object value;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                if (this.position == 0) {
                    if (!this.delegate.hasNext()) {
                        return this.endOfData();
                    }
                    this.value = this.delegate.next();
                }
                ++this.position;
                if (this.position >= n) {
                    this.position = 0;
                }
                return this.value;
            }
        };
    }

    private static List<Double> doubleSequence(double start, double step, int items) {
        ArrayList<Double> values = new ArrayList<Double>();
        double nextValue = start;
        for (int i = 0; i < items; ++i) {
            values.add(nextValue);
            nextValue += step;
        }
        return values;
    }

    private static List<Float> floatSequence(float start, float step, int items) {
        ImmutableList.Builder values = ImmutableList.builder();
        float nextValue = start;
        for (int i = 0; i < items; ++i) {
            values.add((Object)Float.valueOf(nextValue));
            nextValue += step;
        }
        return values.build();
    }

    private static List<SqlDecimal> decimalSequence(String start, String step, int items, int precision, int scale) {
        BigInteger decimalStep = new BigInteger(step);
        ArrayList<SqlDecimal> values = new ArrayList<SqlDecimal>();
        BigInteger nextValue = new BigInteger(start);
        for (int i = 0; i < items; ++i) {
            values.add(new SqlDecimal(nextValue, precision, scale));
            nextValue = nextValue.add(decimalStep);
        }
        return values;
    }

    public static ContiguousSet<Integer> intsBetween(int lowerInclusive, int upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(lowerInclusive), (Comparable)Integer.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.integers());
    }
}

