/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.DateTimeZone;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBatchStreamReaders {
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)10, (int)5);
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)30, (int)10);
    private static final int ROWS = 10000000;
    private static final int MAX_STRING = 10;
    private static final List<?> NULL_VALUES = Collections.nCopies(10000000, null);

    @Benchmark
    public Object readBlocks(BenchmarkData data) throws Throwable {
        OrcBatchRecordReader recordReader = data.createRecordReader();
        ImmutableList.Builder blocks = new ImmutableList.Builder();
        while (recordReader.nextBatch() > 0) {
            Block block = recordReader.readBlock(0);
            blocks.add((Object)block);
        }
        return blocks.build();
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBatchStreamReaders.class.getSimpleName() + ".*").warmupMode(WarmupMode.BULK).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final Random random = new Random(0L);
        private Type type;
        private File temporaryDirectory;
        private File orcFile;
        @Param(value={"boolean", "tinyint", "smallint", "integer", "bigint", "decimal(10,5)", "decimal(30,10)", "timestamp", "real", "double", "varchar_direct", "varchar_dictionary"})
        private String typeSignature;
        @Param(value={"PARTIAL", "NONE", "ALL"})
        private Nulls withNulls;

        @Setup
        public void setup() throws Exception {
            this.type = this.typeSignature.startsWith("varchar") ? FunctionAndTypeManager.createTestFunctionAndTypeManager().getType(TypeSignature.parseTypeSignature((String)"varchar")) : FunctionAndTypeManager.createTestFunctionAndTypeManager().getType(TypeSignature.parseTypeSignature((String)this.typeSignature));
            this.temporaryDirectory = Files.createTempDir();
            this.orcFile = new File(this.temporaryDirectory, UUID.randomUUID().toString());
            OrcTester.writeOrcColumnHive(this.orcFile, OrcTester.Format.ORC_12, CompressionKind.NONE, this.type, this.createValues());
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }

        protected List<?> createValues() {
            switch (this.withNulls) {
                case ALL: {
                    return NULL_VALUES;
                }
                case PARTIAL: {
                    return IntStream.range(0, 10000000).mapToObj(i -> i % 2 == 0 ? this.createValue() : null).collect(Collectors.toList());
                }
            }
            return IntStream.range(0, 10000000).mapToObj(i -> this.createValue()).collect(Collectors.toList());
        }

        private Object createValue() {
            switch (this.typeSignature) {
                case "boolean": {
                    return this.random.nextBoolean();
                }
                case "tinyint": {
                    return Long.valueOf(this.random.nextLong()).byteValue();
                }
                case "smallint": {
                    return (short)this.random.nextInt();
                }
                case "integer": {
                    return this.random.nextInt();
                }
                case "bigint": {
                    return this.random.nextLong();
                }
                case "decimal(10,5)": {
                    return new SqlDecimal(BigInteger.valueOf(this.random.nextLong() % 10000000000L), SHORT_DECIMAL_TYPE.getPrecision(), SHORT_DECIMAL_TYPE.getScale());
                }
                case "decimal(30,10)": {
                    return new SqlDecimal(BigInteger.valueOf(this.random.nextLong() % 10000000000L), LONG_DECIMAL_TYPE.getPrecision(), LONG_DECIMAL_TYPE.getScale());
                }
                case "timestamp": {
                    return new SqlTimestamp(this.random.nextLong(), TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS);
                }
                case "real": {
                    return Float.valueOf(this.random.nextFloat());
                }
                case "double": {
                    return this.random.nextDouble();
                }
                case "varchar_dictionary": {
                    return Strings.repeat((String)"0", (int)10);
                }
                case "varchar_direct": {
                    return BenchmarkData.randomAsciiString(this.random);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + this.typeSignature);
        }

        private OrcBatchRecordReader createRecordReader() throws IOException {
            FileOrcDataSource dataSource = new FileOrcDataSource(this.orcFile, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
            OrcReader orcReader = new OrcReader((OrcDataSource)dataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            return orcReader.createBatchRecordReader((Map)ImmutableMap.of((Object)0, (Object)this.type), OrcPredicate.TRUE, DateTimeZone.UTC, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1);
        }

        private static String randomAsciiString(Random random) {
            char[] value = new char[random.nextInt(10)];
            for (int i = 0; i < value.length; ++i) {
                value[i] = (char)random.nextInt(127);
            }
            return new String(value);
        }

        public static enum Nulls {
            PARTIAL,
            NONE,
            ALL;

        }
    }
}

