/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBigintValues {
    @Benchmark
    public int lookupInHashTable(BenchmarkData data) {
        int hits = 0;
        for (int i = 0; i < 10000; ++i) {
            if (!data.hashtableFilter.testLong((long)i)) continue;
            ++hits;
        }
        return hits;
    }

    @Benchmark
    public int lookupInBitmask(BenchmarkData data) {
        int hits = 0;
        for (int i = 0; i < 10000; ++i) {
            if (!data.bitmaskFilter.testLong((long)i)) continue;
            ++hits;
        }
        return hits;
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBigintValues.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private long[] values;
        private TupleDomainFilter hashtableFilter;
        private TupleDomainFilter bitmaskFilter;
        @Param(value={"5000", "1000", "100", "10"})
        private int numValues;

        @Setup
        public void setup() throws Exception {
            this.values = new long[this.numValues];
            Random random = new Random(0L);
            for (int i = 0; i < this.numValues; ++i) {
                this.values[i] = random.nextInt(10000);
            }
            this.hashtableFilter = TupleDomainFilter.BigintValuesUsingHashTable.of((long)0L, (long)10000L, (long[])this.values, (boolean)false);
            this.bitmaskFilter = TupleDomainFilter.BigintValuesUsingBitmask.of((long)0L, (long)10000L, (long[])this.values, (boolean)false);
        }
    }
}

