/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBytesValues {
    private final byte[][] testWords = new byte[][]{"abc".getBytes(), "apple".getBytes(), "banana".getBytes(), "grape".getBytes(), "orange".getBytes(), "peach".getBytes()};

    @Benchmark
    public int lookupInExclusive(BenchmarkData data) {
        int hits = 0;
        for (int i = 0; i < this.testWords.length; ++i) {
            if (!data.exclusiveFilter.testBytes(this.testWords[i], 0, this.testWords[i].length)) continue;
            ++hits;
        }
        return hits;
    }

    @Benchmark
    public int lookupInMultiRange(BenchmarkData data) {
        int hits = 0;
        for (int i = 0; i < this.testWords.length; ++i) {
            if (!data.multiRangeFilter.testBytes(this.testWords[i], 0, this.testWords[i].length)) continue;
            ++hits;
        }
        return hits;
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBytesValues.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private TupleDomainFilter exclusiveFilter;
        private TupleDomainFilter multiRangeFilter;

        @Setup
        public void setup() throws Exception {
            this.exclusiveFilter = TupleDomainFilter.BytesValuesExclusive.of((byte[][])new byte[][]{"apple".getBytes(), "grape".getBytes(), "orange".getBytes()}, (boolean)false);
            this.multiRangeFilter = TupleDomainFilter.MultiRange.of((List)ImmutableList.of((Object)TupleDomainFilter.BytesRange.of(null, (boolean)true, (byte[])"apple".getBytes(), (boolean)true, (boolean)false), (Object)TupleDomainFilter.BytesRange.of((byte[])"apple".getBytes(), (boolean)true, (byte[])"grape".getBytes(), (boolean)true, (boolean)false), (Object)TupleDomainFilter.BytesRange.of((byte[])"grape".getBytes(), (boolean)true, (byte[])"orange".getBytes(), (boolean)true, (boolean)false), (Object)TupleDomainFilter.BytesRange.of((byte[])"orange".getBytes(), (boolean)true, null, (boolean)true, (boolean)false)), (boolean)false, (boolean)false);
        }
    }
}

