/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.facebook.presto.orc.writer.LongDictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=3, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkDictionaryWriter {
    private static final int COLUMN_INDEX = 0;
    private static final int STRING_LIMIT_BYTES = Math.toIntExact(OrcWriterOptions.DEFAULT_MAX_STRING_STATISTICS_LIMIT.toBytes());

    private ColumnWriterOptions getColumnWriterOptions() {
        return this.getColumnWriterOptions(true);
    }

    private ColumnWriterOptions getColumnWriterOptions(boolean sortStringDictionaryKeys) {
        return ColumnWriterOptions.builder().setCompressionKind(CompressionKind.NONE).setStringDictionarySortingEnabled(sortStringDictionaryKeys).build();
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDictionaryWriter.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private StringStatisticsBuilder newStringStatisticsBuilder() {
        return new StringStatisticsBuilder(STRING_LIMIT_BYTES);
    }

    @Benchmark
    public void writeDirect(BenchmarkData data) {
        Type type = data.getType();
        Object columnWriter = type.equals(VarcharType.VARCHAR) ? new SliceDirectColumnWriter(0, 0, type, this.getColumnWriterOptions(), Optional.empty(), OrcEncoding.DWRF, this::newStringStatisticsBuilder, OrcEncoding.DWRF.createMetadataWriter()) : new LongColumnWriter(0, 0, type, this.getColumnWriterOptions(), Optional.empty(), OrcEncoding.DWRF, IntegerStatisticsBuilder::new, OrcEncoding.DWRF.createMetadataWriter());
        for (Block block : data.getBlocks()) {
            columnWriter.beginRowGroup();
            columnWriter.writeBlock(block);
            columnWriter.finishRowGroup();
        }
        columnWriter.close();
        columnWriter.reset();
    }

    private void writeDictionary(BenchmarkData data, boolean sortStringDictionaryKeys) {
        DictionaryColumnWriter columnWriter = this.getDictionaryColumnWriter(data, sortStringDictionaryKeys);
        for (Block block : data.getBlocks()) {
            columnWriter.beginRowGroup();
            columnWriter.writeBlock(block);
            columnWriter.finishRowGroup();
        }
        columnWriter.close();
        columnWriter.reset();
    }

    @Benchmark
    public void writeDictionary(BenchmarkData data) {
        this.writeDictionary(data, true);
    }

    @Benchmark
    public void writeDictionaryAndConvert(BenchmarkData data) {
        DictionaryColumnWriter columnWriter = this.getDictionaryColumnWriter(data, true);
        for (Block block : data.getBlocks()) {
            columnWriter.beginRowGroup();
            columnWriter.writeBlock(block);
            columnWriter.finishRowGroup();
        }
        int maxDirectBytes = Math.toIntExact(new DataSize(512.0, DataSize.Unit.MEGABYTE).toBytes());
        OptionalInt optionalInt = columnWriter.tryConvertToDirect(maxDirectBytes);
        Preconditions.checkState((boolean)optionalInt.isPresent(), (Object)"Column did not covert to direct");
        columnWriter.close();
        columnWriter.reset();
    }

    @Benchmark
    public void writeDictionaryNoSorting(BenchmarkData data) {
        this.writeDictionary(data, false);
    }

    private DictionaryColumnWriter getDictionaryColumnWriter(BenchmarkData data, boolean sortStringDictionaryKeys) {
        Type type = data.getType();
        ColumnWriterOptions columnWriterOptions = this.getColumnWriterOptions(sortStringDictionaryKeys);
        Object columnWriter = type.equals(VarcharType.VARCHAR) ? new SliceDictionaryColumnWriter(0, 0, type, columnWriterOptions, Optional.empty(), OrcEncoding.DWRF, OrcEncoding.DWRF.createMetadataWriter()) : new LongDictionaryColumnWriter(0, 0, type, columnWriterOptions, Optional.empty(), OrcEncoding.DWRF, OrcEncoding.DWRF.createMetadataWriter());
        return columnWriter;
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int NUM_BLOCKS = 1000;
        private static final int ROWS_PER_BLOCK = 10000;
        private static final String INTEGER_TYPE = "integer";
        private static final String BIGINT_TYPE = "bigint";
        private static final String VARCHAR_TYPE = "varchar";
        private static final String POSSIBLE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 +-_*#";
        private static final int MAX_STRING_LENGTH = 30;
        private static final int MIN_STRING_LENGTH = 10;
        private final Random random = new Random(0L);
        private final List<Block> blocks = new ArrayList<Block>();
        @Param(value={"integer", "bigint", "varchar"})
        private String typeSignature = "integer";
        @Param(value={"1", "5", "10", "100"})
        private String uniqueValuesPercentage = "100";
        private Type type;

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public Type getType() {
            return this.type;
        }

        @Setup
        public void setUp() {
            this.type = this.getType(this.typeSignature);
            for (int i = 0; i < 1000; ++i) {
                this.blocks.add(this.getBlock(10000));
            }
        }

        private Type getType(String typeSignature) {
            switch (typeSignature) {
                case "varchar": {
                    return VarcharType.VARCHAR;
                }
                case "bigint": {
                    return BigintType.BIGINT;
                }
                case "integer": {
                    return IntegerType.INTEGER;
                }
            }
            throw new UnsupportedOperationException("Unsupported type " + typeSignature);
        }

        private int getUniqueValues(int numRows) {
            int value = Integer.parseInt(this.uniqueValuesPercentage);
            Preconditions.checkState((value <= 100 ? 1 : 0) != 0);
            int uniqueValues = (int)((double)(value * numRows) / 100.0);
            return Math.max(uniqueValues, 1);
        }

        private String getNextString(char[] chars, int length) {
            for (int i = 0; i < length; ++i) {
                chars[i] = POSSIBLE_CHARS.charAt(this.random.nextInt(POSSIBLE_CHARS.length()));
            }
            return String.valueOf(chars);
        }

        private List<String> generateStrings(int numRows) {
            int i;
            int valuesToGenerate = this.getUniqueValues(numRows);
            ArrayList<String> strings = new ArrayList<String>(numRows);
            char[] chars = new char[30];
            for (i = 0; i < valuesToGenerate; ++i) {
                int length = 10 + this.random.nextInt(20);
                strings.add(this.getNextString(chars, length));
            }
            for (i = valuesToGenerate; i < numRows; ++i) {
                int randomIndex = this.random.nextInt(valuesToGenerate);
                strings.add((String)strings.get(randomIndex));
            }
            return strings;
        }

        private List<Integer> generateIntegers(int numRows) {
            int i;
            int valuesToGenerate = this.getUniqueValues(numRows);
            ArrayList<Integer> integers = new ArrayList<Integer>(numRows);
            for (i = 0; i < valuesToGenerate; ++i) {
                integers.add(this.random.nextInt());
            }
            for (i = valuesToGenerate; i < numRows; ++i) {
                int randomIndex = this.random.nextInt(valuesToGenerate);
                integers.add((Integer)integers.get(randomIndex));
            }
            return integers;
        }

        private List<Long> generateLongs(int numRows) {
            int i;
            int valuesToGenerate = this.getUniqueValues(numRows);
            ArrayList<Long> longs = new ArrayList<Long>(numRows);
            for (i = 0; i < valuesToGenerate; ++i) {
                longs.add(this.random.nextLong());
            }
            for (i = valuesToGenerate; i < numRows; ++i) {
                int randomIndex = this.random.nextInt(valuesToGenerate);
                longs.add((Long)longs.get(randomIndex));
            }
            return longs;
        }

        private Block getBlock(int numRows) {
            BlockBuilder blockBuilder;
            if (this.type.equals(VarcharType.VARCHAR)) {
                blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, numRows);
                for (String string : this.generateStrings(numRows)) {
                    VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)string));
                }
            } else if (this.type.equals(BigintType.BIGINT)) {
                blockBuilder = BigintType.BIGINT.createBlockBuilder(null, numRows);
                for (Long value : this.generateLongs(numRows)) {
                    BigintType.BIGINT.writeLong(blockBuilder, value.longValue());
                }
            } else if (this.type.equals(IntegerType.INTEGER)) {
                blockBuilder = IntegerType.INTEGER.createBlockBuilder(null, numRows);
                for (Integer value : this.generateIntegers(numRows)) {
                    IntegerType.INTEGER.writeLong(blockBuilder, value.longValue());
                }
            } else {
                throw new UnsupportedOperationException("Unsupported type " + this.typeSignature);
            }
            return blockBuilder.build();
        }
    }
}

