/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.SingleMapBlockWriter;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.testing.TestingEnvironment;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=2, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapBlockBuilder {
    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkMapBlockBuilder.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Benchmark
    public void blockBuilder(BenchmarkData data) {
        MapBlockBuilder mapBlockBuilder = data.getMapBlockBuilder();
        int positionCount = data.getPositionCount();
        int outerElementCount = data.getOuterElementCount();
        int innerElementCount = data.getInnerElementCount();
        for (int position = 0; position < positionCount; ++position) {
            SingleMapBlockWriter outerBlockBuilder = mapBlockBuilder.beginBlockEntry();
            for (int outer = 0; outer < outerElementCount; ++outer) {
                BigintType.BIGINT.writeLong((BlockBuilder)outerBlockBuilder, (long)outer);
                BlockBuilder innerBlockBuilder = outerBlockBuilder.beginBlockEntry();
                for (int inner = 0; inner < innerElementCount; ++inner) {
                    BigintType.BIGINT.writeLong(innerBlockBuilder, (long)inner * 2L);
                    BigintType.BIGINT.writeLong(innerBlockBuilder, (long)inner * 2L + 1L);
                }
                outerBlockBuilder.closeEntry();
            }
            mapBlockBuilder.closeEntry();
        }
    }

    @Benchmark
    public void directBuilder(BenchmarkData data) {
        MapBlockBuilder mapBlockBuilder = data.getMapBlockBuilder();
        int positionCount = data.getPositionCount();
        int outerElementCount = data.getOuterElementCount();
        int innerElementCount = data.getInnerElementCount();
        for (int position = 0; position < positionCount; ++position) {
            mapBlockBuilder.beginDirectEntry();
            BlockBuilder outerKeyBuilder = mapBlockBuilder.getKeyBlockBuilder();
            for (int outer = 0; outer < outerElementCount; ++outer) {
                BigintType.BIGINT.writeLong(outerKeyBuilder, (long)outer);
            }
            MapBlockBuilder outerValueBuilder = (MapBlockBuilder)mapBlockBuilder.getValueBlockBuilder();
            for (int outer = 0; outer < outerElementCount; ++outer) {
                outerValueBuilder.beginDirectEntry();
                BlockBuilder innerKeyBuilder = outerValueBuilder.getKeyBlockBuilder();
                for (int inner = 0; inner < innerElementCount; ++inner) {
                    BigintType.BIGINT.writeLong(innerKeyBuilder, (long)inner * 2L);
                }
                BlockBuilder innerValueBuilder = outerValueBuilder.getValueBlockBuilder();
                for (int inner = 0; inner < innerElementCount; ++inner) {
                    BigintType.BIGINT.writeLong(innerValueBuilder, (long)inner * 2L + 1L);
                }
                outerValueBuilder.closeEntry();
            }
            mapBlockBuilder.closeEntry();
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final MethodHandle KEY_NATIVE_EQUALS = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        private static final MethodHandle KEY_BLOCK_EQUALS = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_EQUALS, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
        private static final MethodHandle KEY_NATIVE_HASH_CODE = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{BigintType.BIGINT});
        private static final MethodHandle KEY_BLOCK_HASH_CODE = MethodHandleUtil.compose((MethodHandle)KEY_NATIVE_HASH_CODE, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)BigintType.BIGINT));
        @Param(value={"100"})
        private String positionCount = "100";
        @Param(value={"10", "100"})
        private String numberOfOuterElements = "100";
        @Param(value={"10", "100"})
        private String numberOfInnerElements = "100";

        int getPositionCount() {
            return Integer.parseInt(this.positionCount);
        }

        int getOuterElementCount() {
            return Integer.parseInt(this.numberOfOuterElements);
        }

        int getInnerElementCount() {
            return Integer.parseInt(this.numberOfInnerElements);
        }

        MapBlockBuilder getMapBlockBuilder() {
            MapType innerMapType = new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
            MapType mapType = new MapType((Type)BigintType.BIGINT, (Type)innerMapType, KEY_BLOCK_EQUALS, KEY_BLOCK_HASH_CODE);
            return (MapBlockBuilder)mapType.createBlockBuilder(null, 1024);
        }
    }
}

