/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.ArrayBlockBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapFlatWriter {
    private static final int SEED = 0;

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(BenchmarkMapFlatWriter.class.getName() + ".*").build();
        new Runner(options).run();
    }

    @Benchmark
    public void baseline(BenchmarkData data) throws IOException {
        this.doWrite(data);
    }

    private void doWrite(BenchmarkData data) throws IOException {
        OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlattenedColumns((Set)ImmutableSet.of((Object)0)).build();
        OrcWriter writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(data.orcFile)), (List)ImmutableList.of((Object)"col1"), (List)ImmutableList.of((Object)data.type), OrcEncoding.DWRF, CompressionKind.ZSTD, Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, orcWriterOptions, (Map)ImmutableMap.of(), OrcTester.HIVE_STORAGE_TIME_ZONE, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        for (Block block : data.blocks) {
            writer.write(new Page(new Block[]{block}));
        }
        writer.close();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private MapType type;
        private File temporaryDirectory;
        private File orcFile;
        @Param(value={"map<bigint,bigint>", "map<bigint,array<bigint>>"})
        private String typeSignature = "map<bigint,bigint>";
        @Param(value={"500"})
        private int distinctKeyCount = 500;
        @Param(value={"50000"})
        private int positionsPerBlock = 50000;
        @Param(value={"5"})
        private int blockCount = 5;
        @Param(value={"10"})
        private int childElementValueCount = 10;
        @Param(value={"12, 2, 5, 3, 4, 5, 2, 10, 7, 45, 0"})
        private String frequencyHistogram = "12, 2, 5, 3, 4, 5, 2, 10, 7, 45, 0";
        private List<Block> blocks;

        @Setup
        public void setup() throws Exception {
            int i;
            Random random = new Random(0L);
            FunctionAndTypeManager typeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            this.type = (MapType)typeManager.getType(TypeSignature.parseTypeSignature((String)this.typeSignature));
            Type keyType = this.type.getKeyType();
            Type valueType = this.type.getValueType();
            this.temporaryDirectory = Files.createTempDir();
            this.orcFile = new File(this.temporaryDirectory, UUID.randomUUID().toString());
            this.orcFile.deleteOnExit();
            ImmutableList.Builder blocks = ImmutableList.builder();
            ArrayList<Long> keys = new ArrayList<Long>(this.distinctKeyCount);
            for (int i2 = 0; i2 < this.distinctKeyCount; ++i2) {
                keys.add(Long.valueOf(i2));
            }
            Collections.shuffle(keys, random);
            List weights = Arrays.stream(this.frequencyHistogram.split(",")).map(String::trim).map(Integer::valueOf).collect(Collectors.toList());
            Assert.assertEquals((int)weights.size(), (int)11, (String)"Number of weights is expected to be 11");
            double weightSum = weights.stream().mapToInt(Integer::intValue).sum();
            double[] keyFrequencies = new double[this.distinctKeyCount];
            int offset = 0;
            for (i = 0; i < weights.size(); ++i) {
                double frequency = 0.1 * (double)(i + 1);
                int weight = (Integer)weights.get(i);
                int keyCount = (int)((double)(this.distinctKeyCount * weight) / weightSum);
                if (weight > 0) {
                    keyCount = Math.max(keyCount, 1);
                }
                if (offset + keyCount >= this.distinctKeyCount) {
                    keyCount = this.distinctKeyCount - offset;
                }
                for (int j = 0; j < keyCount; ++j) {
                    keyFrequencies[offset++] = frequency;
                }
            }
            for (i = 0; i < this.blockCount; ++i) {
                MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)this.type.createBlockBuilder(null, this.positionsPerBlock);
                BlockBuilder mapKeyBuilder = mapBlockBuilder.getKeyBlockBuilder();
                BlockBuilder mapValueBuilder = mapBlockBuilder.getValueBlockBuilder();
                for (int j = 0; j < this.positionsPerBlock; ++j) {
                    int k;
                    mapBlockBuilder.beginDirectEntry();
                    int entryKeyCount = 0;
                    for (k = 0; k < this.distinctKeyCount; ++k) {
                        if (!(random.nextDouble() < keyFrequencies[k])) continue;
                        keyType.writeLong(mapKeyBuilder, ((Long)keys.get(k)).longValue());
                        ++entryKeyCount;
                    }
                    if (valueType == BigintType.BIGINT) {
                        for (k = 0; k < entryKeyCount; ++k) {
                            valueType.writeLong(mapValueBuilder, random.nextLong());
                        }
                    } else if (valueType instanceof ArrayType) {
                        ArrayType arrayValueType = (ArrayType)valueType;
                        Type elementType = arrayValueType.getElementType();
                        ArrayBlockBuilder arrayBlockBuilder = (ArrayBlockBuilder)mapValueBuilder;
                        BlockBuilder arrayElementValueBuilder = arrayBlockBuilder.getElementBlockBuilder();
                        for (int k2 = 0; k2 < entryKeyCount; ++k2) {
                            arrayBlockBuilder.beginDirectEntry();
                            for (int c = 0; c < this.childElementValueCount; ++c) {
                                elementType.writeLong(arrayElementValueBuilder, random.nextLong());
                            }
                            arrayBlockBuilder.closeEntry();
                        }
                    } else {
                        throw new UnsupportedOperationException("Unsupported type: " + this.type);
                    }
                    mapBlockBuilder.closeEntry();
                }
                Block block = mapBlockBuilder.build();
                blocks.add((Object)block);
            }
            this.blocks = blocks.build();
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

