/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTimeZone;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSelectiveStreamReaders {
    private static final int ROWS = 10000000;
    private static final List<?> NULL_VALUES = Collections.nCopies(10000000, null);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)10, (int)5);
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)30, (int)10);

    @Benchmark
    public List<Block> readAllBlocks(BenchmarkData data) throws IOException {
        Page page;
        OrcSelectiveRecordReader recordReader = data.createRecordReader();
        ArrayList<Block> blocks = new ArrayList<Block>();
        while ((page = recordReader.getNextPage()) != null) {
            if (page.getPositionCount() <= 0) continue;
            for (int i = 0; i < page.getChannelCount(); ++i) {
                blocks.add(page.getBlock(i).getLoadedBlock());
            }
        }
        return blocks;
    }

    @Test
    public void verifyReadAllBlocks() throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkSelectiveStreamReaders benchmarkSelectiveStreamReaders = new BenchmarkSelectiveStreamReaders();
        benchmarkSelectiveStreamReaders.readAllBlocks(data);
    }

    private static String randomAsciiString(Random random) {
        return String.format("%09d", random.nextInt(999999999));
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSelectiveStreamReaders.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @Immutable
    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int NO_FILTER = -1;
        private final Random random = new Random(0L);
        private File temporaryDirectory;
        private File orcFile;
        private Type type;
        private int channelCount;
        private int nonEmptyFilterCount;
        private List<Optional<TupleDomainFilter>> filters = new ArrayList<Optional<TupleDomainFilter>>();
        private List<Float> filterRates = new ArrayList<Float>();
        @Param(value={"boolean", "integer", "bigint", "smallint", "tinyint", "date", "timestamp", "real", "double", "decimal(10,5)", "decimal(30,10)", "varchar_unbounded_direct", "varchar_bounded_direct", "varchar_dictionary"})
        private String typeSignature = "boolean";
        @Param(value={"PARTIAL", "NONE", "ALL"})
        private Nulls withNulls = Nulls.PARTIAL;
        @Param(value={"-1", "0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1", "0.0|-1", "0.1|-1", "0.2|-1", "0.3|-1", "0.4|-1", "0.5|-1", "0.6|-1", "0.7|-1", "0.8|-1", "0.9|-1", "1|-1", "0|0.5", "0.1|0.5", "0.2|0.5", "0.3|0.5", "0.4|0.5", "0.5|0.5", "0.6|0.5", "0.7|0.5", "0.8|0.5", "0.9|0.5", "1|0.5", "-1|-1", "1|1"})
        private String filterRateSignature = "0.1|-1";

        @Setup
        public void setup() throws Exception {
            this.type = this.typeSignature.startsWith("varchar_bounded") ? VarcharType.createVarcharType((int)9) : (this.typeSignature.startsWith("varchar") ? FunctionAndTypeManager.createTestFunctionAndTypeManager().getType(TypeSignature.parseTypeSignature((String)"varchar")) : FunctionAndTypeManager.createTestFunctionAndTypeManager().getType(TypeSignature.parseTypeSignature((String)this.typeSignature)));
            this.temporaryDirectory = Files.createTempDir();
            this.orcFile = new File(this.temporaryDirectory, UUID.randomUUID().toString());
            this.filterRates = (List)Arrays.stream(this.filterRateSignature.split("\\|")).map(r -> Float.valueOf(Float.parseFloat(r))).collect(ImmutableList.toImmutableList());
            this.channelCount = this.filterRates.size();
            ArrayList values = new ArrayList();
            for (int i = 0; i < this.channelCount; ++i) {
                float filterRate = this.filterRates.get(i).floatValue();
                Pair<Boolean, Float> filterInfoForNonNull = this.getFilterInfoForNonNull(filterRate);
                values.add(this.createValues(this.type, filterRate));
                Optional<TupleDomainFilter> filter = this.getFilter(this.type, filterRate, filterInfoForNonNull.getKey(), filterInfoForNonNull.getValue().floatValue());
                this.filters.add(filter);
                if (!filter.isPresent()) continue;
                ++this.nonEmptyFilterCount;
            }
            OrcTester.writeOrcColumnsPresto(this.orcFile, OrcTester.Format.ORC_12, CompressionKind.NONE, Optional.empty(), Collections.nCopies(this.channelCount, this.type), values, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }

        public OrcSelectiveRecordReader createRecordReader() throws IOException {
            FileOrcDataSource dataSource = new FileOrcDataSource(this.orcFile, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
            OrcReader orcReader = new OrcReader((OrcDataSource)dataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            return orcReader.createSelectiveRecordReader(IntStream.range(0, this.channelCount).boxed().collect(Collectors.toMap(Function.identity(), i -> this.type)), IntStream.range(0, this.channelCount).boxed().collect(Collectors.toList()), this.nonEmptyFilterCount > 0 ? IntStream.range(0, this.channelCount).filter(i -> this.filters.get(i).isPresent()).boxed().collect(Collectors.toMap(Function.identity(), i -> ImmutableMap.of((Object)new Subfield("c"), this.filters.get((int)i).orElse(null)))) : ImmutableMap.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), OrcPredicate.TRUE, 0L, dataSource.getSize(), DateTimeZone.UTC, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), Optional.empty(), 1);
        }

        private Optional<TupleDomainFilter> getFilter(Type type, float filterRate, boolean filterAllowNull, float selectionRateForNonNull) {
            if (filterRate == -1.0f) {
                return Optional.empty();
            }
            if (type == BooleanType.BOOLEAN) {
                return Optional.of(TupleDomainFilter.BooleanValue.of((boolean)true, (boolean)filterAllowNull));
            }
            if (type == BigintType.BIGINT) {
                return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-9.223372E18f * selectionRateForNonNull)), (long)((long)(9.223372E18f * selectionRateForNonNull)), (boolean)filterAllowNull));
            }
            if (type == IntegerType.INTEGER || type == DateType.DATE || type == TimestampType.TIMESTAMP) {
                return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-2.1474836E9f * selectionRateForNonNull)), (long)((long)(2.1474836E9f * selectionRateForNonNull)), (boolean)filterAllowNull));
            }
            if (type == IntegerType.INTEGER) {
                return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-2.1474836E9f * selectionRateForNonNull)), (long)((long)(2.1474836E9f * selectionRateForNonNull)), (boolean)filterAllowNull));
            }
            if (type == SmallintType.SMALLINT) {
                return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-32768.0f * selectionRateForNonNull)), (long)((long)(32767.0f * selectionRateForNonNull)), (boolean)filterAllowNull));
            }
            if (type == TinyintType.TINYINT) {
                return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-128.0f * selectionRateForNonNull)), (long)((long)(127.0f * selectionRateForNonNull)), (boolean)filterAllowNull));
            }
            if (type == RealType.REAL) {
                return Optional.of(TupleDomainFilter.FloatRange.of((float)0.0f, (boolean)false, (boolean)false, (float)selectionRateForNonNull, (boolean)false, (boolean)true, (boolean)filterAllowNull));
            }
            if (type == DoubleType.DOUBLE) {
                return Optional.of(TupleDomainFilter.DoubleRange.of((double)0.0, (boolean)false, (boolean)false, (double)selectionRateForNonNull, (boolean)false, (boolean)true, (boolean)filterAllowNull));
            }
            if (type instanceof DecimalType) {
                if (((DecimalType)type).isShort()) {
                    return Optional.of(TupleDomainFilter.BigintRange.of((long)((long)(-1.0E10f * selectionRateForNonNull)), (long)((long)(1.0E10f * selectionRateForNonNull)), (boolean)filterAllowNull));
                }
                return Optional.of(TupleDomainFilter.LongDecimalRange.of((long)((long)(-1.0E10f * selectionRateForNonNull)), (long)((long)(-1.0E10f * selectionRateForNonNull)), (boolean)false, (boolean)true, (long)((long)(1.0E10f * selectionRateForNonNull)), (long)((long)(1.0E10f * selectionRateForNonNull)), (boolean)false, (boolean)true, (boolean)filterAllowNull));
            }
            if (type instanceof VarcharType) {
                if (this.typeSignature.equals("varchar_dictionary")) {
                    return Optional.of(TupleDomainFilter.BytesRange.of((byte[])"000000000".getBytes(), (boolean)false, (byte[])"000000000".getBytes(), (filterRate == 1.0f ? 1 : 0) != 0, (boolean)filterAllowNull));
                }
                return Optional.of(TupleDomainFilter.BytesRange.of((byte[])"000000000".getBytes(), (boolean)false, (byte[])String.format("%09d", (int)(1.0E9f * selectionRateForNonNull) - 1).getBytes(), (filterRate == 1.0f ? 1 : 0) != 0, (boolean)filterAllowNull));
            }
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }

        private List<?> createValues(Type type, float filterRate) {
            switch (this.withNulls) {
                case ALL: {
                    return NULL_VALUES;
                }
                case PARTIAL: {
                    return IntStream.range(0, 10000000).mapToObj(j -> (double)this.random.nextFloat() > 0.5 * (double)(filterRate == -1.0f ? 1.0f : 1.0f - filterRate) ? this.createValue(type, filterRate) : null).collect(Collectors.toList());
                }
            }
            return IntStream.range(0, 10000000).mapToObj(j -> this.createValue(type, filterRate)).collect(Collectors.toList());
        }

        private final Object createValue(Type type, float filterRate) {
            if (type == BooleanType.BOOLEAN) {
                return this.random.nextFloat() <= (1.0f - filterRate) / (1.0f + filterRate);
            }
            if (type == BigintType.BIGINT) {
                return this.random.nextLong();
            }
            if (type == IntegerType.INTEGER) {
                return this.random.nextInt();
            }
            if (type == SmallintType.SMALLINT) {
                return (short)this.random.nextInt();
            }
            if (type == TinyintType.TINYINT) {
                return (byte)this.random.nextInt();
            }
            if (type == DateType.DATE) {
                return new SqlDate(this.random.nextInt());
            }
            if (type == TimestampType.TIMESTAMP) {
                long value = this.random.nextInt();
                return new SqlTimestamp(value, TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS);
            }
            if (type == RealType.REAL) {
                return Float.valueOf(this.random.nextFloat());
            }
            if (type == DoubleType.DOUBLE) {
                return this.random.nextDouble();
            }
            if (type instanceof DecimalType) {
                if (Decimals.isShortDecimal((Type)type)) {
                    return new SqlDecimal(BigInteger.valueOf(this.random.nextLong() % 10000000000L), SHORT_DECIMAL_TYPE.getPrecision(), SHORT_DECIMAL_TYPE.getScale());
                }
                return new SqlDecimal(BigInteger.valueOf(this.random.nextLong() % 10000000000L), LONG_DECIMAL_TYPE.getPrecision(), LONG_DECIMAL_TYPE.getScale());
            }
            if (type instanceof VarcharType) {
                if (this.typeSignature.equals("varchar_dictionary")) {
                    return Strings.repeat((String)"0", (int)9);
                }
                return BenchmarkSelectiveStreamReaders.randomAsciiString(this.random);
            }
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }

        private Pair<Boolean, Float> getFilterInfoForNonNull(float filterRate) {
            switch (this.withNulls) {
                case NONE: {
                    return new Pair<Boolean, Float>(false, Float.valueOf(1.0f - filterRate));
                }
                case PARTIAL: {
                    return new Pair<Boolean, Float>(true, Float.valueOf((1.0f - filterRate) / (1.0f + filterRate)));
                }
                case ALL: {
                    return new Pair<Boolean, Float>(filterRate == 0.0f, Float.valueOf(1.0f));
                }
            }
            throw new UnsupportedOperationException("Unsupported withNulls: " + (Object)((Object)this.withNulls));
        }

        public static enum Nulls {
            PARTIAL,
            NONE,
            ALL;

        }
    }
}

