/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcZstdDecompressor;
import com.facebook.presto.orc.zstd.ZstdJniCompressor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.Assert;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkZstdJniDecompression {
    private static final ZstdJniCompressor compressor = new ZstdJniCompressor(OptionalInt.empty());
    private static final List<Unit> list = BenchmarkZstdJniDecompression.generateWorkload();
    private static final int sourceLength = 262144;
    private static byte[] decompressedBytes = new byte[262144];

    @Benchmark
    public void decompressJni() throws OrcCorruptionException {
        this.decompressList(this.createOrcDecompressor(true));
    }

    @Benchmark
    public void decompressJava() throws OrcCorruptionException {
        this.decompressList(this.createOrcDecompressor(false));
    }

    private void decompressList(OrcDecompressor decompressor) throws OrcCorruptionException {
        for (Unit unit : list) {
            int outputSize = decompressor.decompress(unit.compressedBytes, 0, unit.compressedLength, new OrcDecompressor.OutputBuffer(){

                public byte[] initialize(int size) {
                    return decompressedBytes;
                }

                public byte[] grow(int size) {
                    throw new RuntimeException();
                }
            });
            Assert.assertEquals((int)outputSize, (int)unit.sourceLength);
        }
    }

    private static List<Unit> generateWorkload() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < 10; ++i) {
            byte[] sourceBytes = BenchmarkZstdJniDecompression.getAlphaNumericString(262144).getBytes();
            byte[] compressedBytes = new byte[0x800000];
            int size = compressor.compress(sourceBytes, 0, sourceBytes.length, compressedBytes, 0, compressedBytes.length);
            builder.add((Object)new Unit(sourceBytes, 262144, compressedBytes, size));
        }
        return builder.build();
    }

    private OrcDecompressor createOrcDecompressor(boolean zstdJniDecompressionEnabled) {
        return new OrcZstdDecompressor(new OrcDataSourceId("orc"), 262144, zstdJniDecompressionEnabled);
    }

    private static String getAlphaNumericString(int length) {
        String alphaNumericString = "USINDIA";
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int index = 0; index < length; ++index) {
            int arrayIndex = (int)((double)alphaNumericString.length() * Math.random());
            stringBuilder.append(alphaNumericString.charAt(arrayIndex));
        }
        return stringBuilder.toString();
    }

    static class Unit {
        final byte[] sourceBytes;
        final int sourceLength;
        final byte[] compressedBytes;
        final int compressedLength;

        public Unit(byte[] sourceBytes, int sourceLength, byte[] compressedBytes, int compressedLength) {
            this.sourceBytes = sourceBytes;
            this.sourceLength = sourceLength;
            this.compressedBytes = compressedBytes;
            this.compressedLength = compressedLength;
        }
    }
}

