/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.OrcFileIntrospector;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;

public class CapturingOrcFileIntrospector
implements OrcFileIntrospector {
    private final List<StripeInformation> stripeInformations = new ArrayList<StripeInformation>();
    private final List<Stripe> stripes = new ArrayList<Stripe>();
    private final Map<Long, Map<StreamId, List<RowGroupIndex>>> rowGroupIndexesByStripeOffset = new HashMap<Long, Map<StreamId, List<RowGroupIndex>>>();
    private final Map<Long, StripeFooter> stripeFooterByStripeOffset = new HashMap<Long, StripeFooter>();
    private Footer fileFooter;
    private OrcFileTail fileTail;

    public void onFileFooter(Footer fileFooter) {
        Assert.assertNull((Object)this.fileFooter);
        this.fileFooter = fileFooter;
    }

    public void onFileTail(OrcFileTail fileTail) {
        Assert.assertNull((Object)this.fileTail);
        this.fileTail = fileTail;
    }

    public void onStripe(StripeInformation stripeInformation, Stripe stripe) {
        this.stripeInformations.add(stripeInformation);
        this.stripes.add(stripe);
    }

    public void onStripeFooter(StripeInformation stripeInformation, StripeFooter stripeFooter) {
        Long stripeOffset = stripeInformation.getOffset();
        Assert.assertNull((Object)this.stripeFooterByStripeOffset.put(stripeOffset, stripeFooter));
    }

    public void onRowGroupIndexes(StripeInformation stripe, Map<StreamId, List<RowGroupIndex>> columnIndexes) {
        Long stripeOffset = stripe.getOffset();
        Assert.assertNull(this.rowGroupIndexesByStripeOffset.put(stripeOffset, columnIndexes));
    }

    public List<StripeInformation> getStripeInformations() {
        return this.stripeInformations;
    }

    public List<Stripe> getStripes() {
        return this.stripes;
    }

    public Map<Long, Map<StreamId, List<RowGroupIndex>>> getRowGroupIndexesByStripeOffset() {
        return this.rowGroupIndexesByStripeOffset;
    }

    public Map<Long, StripeFooter> getStripeFooterByStripeOffset() {
        return this.stripeFooterByStripeOffset;
    }

    public Footer getFileFooter() {
        return this.fileFooter;
    }

    public OrcFileTail getFileTail() {
        return this.fileTail;
    }
}

