/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.hive.orc.OrcConf;
import com.facebook.hive.orc.OrcOutputFormat;
import com.facebook.hive.orc.OrcSerde;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.Reader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.AbstractTestOrcReader;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.NoopOrcLocalMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingEncryptionLibrary;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcPredicate;
import com.facebook.presto.orc.TrackingTupleDomainFilter;
import com.facebook.presto.orc.TupleDomainFilterOrderChecker;
import com.facebook.presto.orc.UnsupportedEncryptionLibrary;
import com.facebook.presto.orc.WriterEncryptionGroup;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.KeyProvider;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.testing.DateTimeTestingUtils;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcUtil;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public class OrcTester {
    public static final DataSize MAX_BLOCK_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    public static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final List<Integer> PRIME_NUMBERS = ImmutableList.of((Object)5, (Object)7, (Object)11, (Object)13, (Object)17, (Object)19, (Object)23, (Object)29, (Object)31, (Object)37, (Object)41, (Object)43, (Object[])new Integer[]{47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97});
    private boolean structTestsEnabled;
    private boolean mapTestsEnabled;
    private boolean listTestsEnabled;
    private boolean complexStructuralTestsEnabled;
    private boolean structuralNullTestsEnabled;
    private boolean reverseTestsEnabled;
    private boolean nullTestsEnabled;
    private boolean missingStructFieldsTestsEnabled;
    private boolean skipBatchTestsEnabled;
    private boolean skipStripeTestsEnabled;
    private boolean dwrfEncryptionEnabled;
    private Set<Format> formats = ImmutableSet.of();
    private Set<CompressionKind> compressions = ImmutableSet.of();
    private boolean useSelectiveOrcReader;
    private boolean flattenAllColumns;

    public static OrcTester quickDwrfFlatMapTester() {
        OrcTester orcTester = new OrcTester();
        orcTester.nullTestsEnabled = true;
        orcTester.skipBatchTestsEnabled = true;
        orcTester.skipStripeTestsEnabled = true;
        orcTester.formats = ImmutableSet.of((Object)((Object)Format.DWRF));
        orcTester.compressions = ImmutableSet.of((Object)CompressionKind.ZLIB);
        orcTester.dwrfEncryptionEnabled = true;
        orcTester.flattenAllColumns = true;
        orcTester.useSelectiveOrcReader = true;
        return orcTester;
    }

    public static OrcTester quickOrcTester() {
        OrcTester orcTester = new OrcTester();
        orcTester.structTestsEnabled = true;
        orcTester.mapTestsEnabled = true;
        orcTester.listTestsEnabled = true;
        orcTester.nullTestsEnabled = true;
        orcTester.missingStructFieldsTestsEnabled = true;
        orcTester.skipBatchTestsEnabled = true;
        orcTester.formats = ImmutableSet.of((Object)((Object)Format.ORC_12), (Object)((Object)Format.ORC_11), (Object)((Object)Format.DWRF));
        orcTester.compressions = ImmutableSet.of((Object)CompressionKind.ZLIB);
        orcTester.dwrfEncryptionEnabled = true;
        return orcTester;
    }

    public static OrcTester fullOrcTester() {
        OrcTester orcTester = new OrcTester();
        orcTester.structTestsEnabled = true;
        orcTester.mapTestsEnabled = true;
        orcTester.listTestsEnabled = true;
        orcTester.complexStructuralTestsEnabled = true;
        orcTester.structuralNullTestsEnabled = true;
        orcTester.reverseTestsEnabled = true;
        orcTester.nullTestsEnabled = true;
        orcTester.missingStructFieldsTestsEnabled = true;
        orcTester.skipBatchTestsEnabled = true;
        orcTester.skipStripeTestsEnabled = true;
        orcTester.formats = ImmutableSet.copyOf((Object[])Format.values());
        orcTester.compressions = ImmutableSet.of((Object)CompressionKind.NONE, (Object)CompressionKind.SNAPPY, (Object)CompressionKind.ZLIB, (Object)CompressionKind.LZ4, (Object)CompressionKind.ZSTD);
        orcTester.dwrfEncryptionEnabled = true;
        return orcTester;
    }

    public static OrcTester quickSelectiveOrcTester() {
        OrcTester orcTester = new OrcTester();
        orcTester.listTestsEnabled = true;
        orcTester.structTestsEnabled = true;
        orcTester.nullTestsEnabled = true;
        orcTester.skipBatchTestsEnabled = true;
        orcTester.formats = ImmutableSet.of((Object)((Object)Format.ORC_12), (Object)((Object)Format.ORC_11), (Object)((Object)Format.DWRF));
        orcTester.compressions = ImmutableSet.of((Object)CompressionKind.ZLIB, (Object)CompressionKind.ZSTD);
        orcTester.useSelectiveOrcReader = true;
        return orcTester;
    }

    public void testRoundTrip(Type type, List<?> readValues) throws Exception {
        this.testRoundTrip(type, readValues, (List<Map<Subfield, TupleDomainFilter>>)ImmutableList.of());
    }

    public void testRoundTrip(Type type, List<?> readValues, TupleDomainFilter ... filters) throws Exception {
        this.testRoundTrip(type, readValues, (List)Arrays.stream(filters).map(filter -> ImmutableMap.of((Object)new Subfield("c"), (Object)filter)).collect(ImmutableList.toImmutableList()));
    }

    public void testRoundTrip(Type type, List<?> readValues, List<Map<Subfield, TupleDomainFilter>> filters) throws Exception {
        List columnFilters = (List)filters.stream().map(filter -> ImmutableMap.of((Object)0, (Object)filter)).collect(ImmutableList.toImmutableList());
        this.testRoundTripTypes((List<Type>)ImmutableList.of((Object)type), (List<List<?>>)ImmutableList.of(readValues), columnFilters);
        if (this.nullTestsEnabled) {
            this.assertRoundTrip(type, readValues.stream().map(value -> null).collect(Collectors.toList()), columnFilters);
        }
        if (this.structTestsEnabled) {
            this.testStructRoundTrip(type, readValues);
        }
        if (this.complexStructuralTestsEnabled) {
            this.testStructRoundTrip(OrcTester.rowType(type, type, type), readValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
        }
        if (this.mapTestsEnabled && type.isComparable()) {
            this.testMapRoundTrip(type, readValues);
        }
        if (this.listTestsEnabled) {
            this.testListRoundTrip(type, readValues);
        }
        if (this.complexStructuralTestsEnabled) {
            this.testListRoundTrip(OrcTester.arrayType(type), readValues.stream().map(OrcTester::toHiveList).collect(Collectors.toList()));
        }
    }

    private void testStructRoundTrip(Type type, List<?> values) throws Exception {
        Type rowType = OrcTester.rowType(type, type, type);
        this.testRoundTripType(rowType, values.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
        if (this.structuralNullTestsEnabled) {
            this.testRoundTripType(rowType, OrcTester.insertNullEvery(5, values).stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
            this.testRoundTripType(rowType, values.stream().map(value -> OrcTester.toHiveStruct(null)).collect(Collectors.toList()));
        }
        if (this.missingStructFieldsTestsEnabled) {
            Type readType = OrcTester.rowType(type, type, type, type, type, type);
            Type writeType = OrcTester.rowType(type, type, type);
            List writeValues = values.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList());
            List readValues = values.stream().map(OrcTester::toHiveStructWithNull).collect(Collectors.toList());
            this.assertRoundTrip(writeType, readType, writeValues, readValues, true, (List<OrcReaderSettings>)ImmutableList.of());
        }
    }

    private void testMapRoundTrip(Type type, List<?> readValues) throws Exception {
        Type mapType = OrcTester.mapType(type, type);
        Object readNullKeyValue = Iterables.getLast(readValues);
        this.testRoundTripType(mapType, readValues.stream().map(value -> OrcTester.toHiveMap(value, readNullKeyValue)).collect(Collectors.toList()));
        if (this.structuralNullTestsEnabled) {
            this.testRoundTripType(mapType, OrcTester.insertNullEvery(5, readValues).stream().map(value -> OrcTester.toHiveMap(value, readNullKeyValue)).collect(Collectors.toList()));
            this.testRoundTripType(mapType, readValues.stream().map(value -> OrcTester.toHiveMap(null, readNullKeyValue)).collect(Collectors.toList()));
        }
    }

    private void testListRoundTrip(Type type, List<?> readValues) throws Exception {
        Type arrayType = OrcTester.arrayType(type);
        this.testRoundTripType(arrayType, readValues.stream().map(OrcTester::toHiveList).collect(Collectors.toList()));
        if (this.structuralNullTestsEnabled) {
            this.testRoundTripType(arrayType, OrcTester.insertNullEvery(5, readValues).stream().map(OrcTester::toHiveList).collect(Collectors.toList()));
            this.testRoundTripType(arrayType, readValues.stream().map(value -> OrcTester.toHiveList(null)).collect(Collectors.toList()));
        }
    }

    private void testRoundTripType(Type type, List<?> readValues) throws Exception {
        this.testRoundTripTypes((List<Type>)ImmutableList.of((Object)type), (List<List<?>>)ImmutableList.of(readValues), (List<Map<Integer, Map<Subfield, TupleDomainFilter>>>)ImmutableList.of());
    }

    public void testRoundTripTypes(List<Type> types, List<List<?>> readValues, List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters) throws Exception {
        this.testRoundTripTypes(types, readValues, filters, (List<List<Integer>>)ImmutableList.of());
    }

    public void testRoundTripTypes(List<Type> types, List<List<?>> readValues, List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters, List<List<Integer>> expectedFilterOrder) throws Exception {
        Assert.assertEquals((int)types.size(), (int)readValues.size());
        if (!expectedFilterOrder.isEmpty()) {
            Assert.assertEquals((int)filters.size(), (int)expectedFilterOrder.size());
        }
        this.assertRoundTrip(types, readValues, filters, expectedFilterOrder);
        if (this.reverseTestsEnabled) {
            this.assertRoundTrip(types, Lists.transform(readValues, OrcTester::reverse), filters, expectedFilterOrder);
        }
        if (this.nullTestsEnabled) {
            this.assertRoundTrip(types, this.insertNulls(types, readValues), filters, expectedFilterOrder);
            if (this.reverseTestsEnabled) {
                this.assertRoundTrip(types, this.insertNulls(types, Lists.transform(readValues, OrcTester::reverse)), filters, expectedFilterOrder);
            }
        }
    }

    public void testRoundTripTypesWithOrder(List<Type> types, List<List<?>> readValues, List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters, List<List<Integer>> expectedFilterOrder) throws Exception {
        Assert.assertNotNull(expectedFilterOrder);
        Assert.assertEquals((int)filters.size(), (int)expectedFilterOrder.size());
        this.testRoundTripTypes(types, readValues, filters, expectedFilterOrder);
        int columnCount = types.size();
        List reverseFilters = (List)filters.stream().map(filtersEntry -> (ImmutableMap)filtersEntry.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> columnCount - 1 - (Integer)entry.getKey(), Map.Entry::getValue))).collect(ImmutableList.toImmutableList());
        List reverseFilterOrder = (List)expectedFilterOrder.stream().map(columns -> (ImmutableList)columns.stream().map(column -> columnCount - 1 - column).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        this.testRoundTripTypes(Lists.reverse(types), Lists.reverse(readValues), reverseFilters, reverseFilterOrder);
    }

    private List<List<?>> insertNulls(List<Type> types, List<List<?>> values) {
        Assert.assertTrue((types.size() <= PRIME_NUMBERS.size() ? 1 : 0) != 0);
        return IntStream.range(0, types.size()).mapToObj(i -> OrcTester.insertNullEvery(PRIME_NUMBERS.get(i), (List)values.get(i))).collect(Collectors.toList());
    }

    public void assertRoundTrip(Type type, List<?> readValues) throws Exception {
        this.assertRoundTrip(type, type, readValues, readValues, true, (List<OrcReaderSettings>)ImmutableList.of());
    }

    public void assertRoundTripWithSettings(Type type, List<?> readValues, List<OrcReaderSettings> settings) throws Exception {
        this.assertRoundTrip(type, type, readValues, readValues, true, settings);
    }

    public void assertRoundTrip(Type type, List<?> readValues, List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters) throws Exception {
        List settings = (List)filters.stream().map(entry -> OrcReaderSettings.builder().setColumnFilters((Map<Integer, Map<Subfield, TupleDomainFilter>>)entry).build()).collect(ImmutableList.toImmutableList());
        this.assertRoundTrip(type, type, readValues, readValues, true, (List<OrcReaderSettings>)settings);
    }

    public void assertRoundTrip(Type type, List<?> readValues, boolean verifyWithHiveReader) throws Exception {
        this.assertRoundTrip(type, type, readValues, readValues, verifyWithHiveReader, (List<OrcReaderSettings>)ImmutableList.of());
    }

    public void assertRoundTrip(List<Type> types, List<List<?>> readValues, List<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters, List<List<Integer>> expectedFilterOrder) throws Exception {
        List settings = (List)IntStream.range(0, filters.size()).mapToObj(i -> OrcReaderSettings.builder().setColumnFilters((Map)filters.get(i)).setExpectedFilterOrder((List<Integer>)(expectedFilterOrder.isEmpty() ? ImmutableList.of() : (List)expectedFilterOrder.get(i))).build()).collect(ImmutableList.toImmutableList());
        this.assertRoundTrip(types, types, readValues, readValues, true, (List<OrcReaderSettings>)settings);
    }

    private void assertRoundTrip(Type writeType, Type readType, List<?> writeValues, List<?> readValues, boolean verifyWithHiveReader, List<OrcReaderSettings> settings) throws Exception {
        this.assertRoundTrip((List<Type>)ImmutableList.of((Object)writeType), (List<Type>)ImmutableList.of((Object)readType), (List<List<?>>)ImmutableList.of(writeValues), (List<List<?>>)ImmutableList.of(readValues), verifyWithHiveReader, settings);
    }

    private void assertRoundTrip(List<Type> writeTypes, List<Type> readTypes, List<List<?>> writeValues, List<List<?>> readValues, boolean verifyWithHiveReader, List<OrcReaderSettings> settings) throws Exception {
        Assert.assertEquals((int)writeTypes.size(), (int)readTypes.size());
        Assert.assertEquals((int)writeTypes.size(), (int)writeValues.size());
        Assert.assertEquals((int)writeTypes.size(), (int)readValues.size());
        AtomicLong totalSize = new AtomicLong(0L);
        NoOpOrcWriterStats stats = NoOpOrcWriterStats.NOOP_WRITER_STATS;
        Object flattenedColumns = ImmutableSet.of();
        if (this.flattenAllColumns) {
            flattenedColumns = (Set)AbstractTestOrcReader.intsBetween(0, writeTypes.size()).stream().collect(ImmutableSet.toImmutableSet());
        }
        for (Format format : this.formats) {
            if (!readTypes.stream().allMatch(readType -> format.supportsType((Type)readType))) {
                return;
            }
            OrcEncoding orcEncoding = format.getOrcEncoding();
            for (CompressionKind compression : this.compressions) {
                Throwable throwable;
                TempFile tempFile;
                boolean hiveSupported;
                boolean bl = hiveSupported = compression != CompressionKind.LZ4 && compression != CompressionKind.ZSTD && flattenedColumns.isEmpty();
                if (hiveSupported) {
                    tempFile = new TempFile();
                    throwable = null;
                    try {
                        OrcTester.writeOrcColumnsHive(tempFile.getFile(), format, compression, writeTypes, writeValues);
                        OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, false, false, orcEncoding, format, true, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)ImmutableMap.of());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tempFile != null) {
                            if (throwable != null) {
                                try {
                                    tempFile.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                tempFile.close();
                            }
                        }
                    }
                }
                tempFile = new TempFile();
                throwable = null;
                try {
                    OrcTester.writeOrcColumnsPresto(tempFile.getFile(), format, compression, Optional.empty(), writeTypes, writeValues, (WriterStats)stats, (Set<Integer>)flattenedColumns);
                    if (verifyWithHiveReader && hiveSupported) {
                        OrcTester.assertFileContentsHive(readTypes, tempFile, format, readValues);
                    }
                    OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, false, false, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)ImmutableMap.of());
                    if (this.skipBatchTestsEnabled) {
                        OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, true, false, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)ImmutableMap.of());
                    }
                    if (this.skipStripeTestsEnabled) {
                        OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, false, true, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)ImmutableMap.of());
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tempFile != null) {
                        if (throwable != null) {
                            try {
                                tempFile.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tempFile.close();
                        }
                    }
                }
                if (!this.dwrfEncryptionEnabled || format != Format.DWRF) continue;
                tempFile = new TempFile();
                throwable = null;
                try {
                    DwrfWriterEncryption dwrfWriterEncryption = OrcTester.generateWriterEncryption();
                    OrcTester.writeOrcColumnsPresto(tempFile.getFile(), format, compression, Optional.of(dwrfWriterEncryption), writeTypes, writeValues, (WriterStats)stats, (Set<Integer>)flattenedColumns);
                    ImmutableMap.Builder intermediateKeysBuilder = ImmutableMap.builder();
                    for (int i = 0; i < dwrfWriterEncryption.getWriterEncryptionGroups().size(); ++i) {
                        for (Integer node : ((WriterEncryptionGroup)dwrfWriterEncryption.getWriterEncryptionGroups().get(i)).getNodes()) {
                            intermediateKeysBuilder.put((Object)node, (Object)((WriterEncryptionGroup)dwrfWriterEncryption.getWriterEncryptionGroups().get(i)).getIntermediateKeyMetadata());
                        }
                    }
                    ImmutableMap intermediateKeysMap = intermediateKeysBuilder.build();
                    OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, false, false, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)intermediateKeysMap);
                    if (this.skipBatchTestsEnabled) {
                        OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, true, false, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)intermediateKeysMap);
                    }
                    if (!this.skipStripeTestsEnabled) continue;
                    OrcTester.assertFileContentsPresto(readTypes, tempFile, readValues, false, true, orcEncoding, format, false, this.useSelectiveOrcReader, settings, (Map<Integer, Slice>)intermediateKeysMap);
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (tempFile == null) continue;
                    if (throwable != null) {
                        try {
                            tempFile.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    tempFile.close();
                }
            }
        }
        Assert.assertEquals((long)totalSize.get(), (long)0L);
    }

    public static void assertFileContentsPresto(List<Type> types, File file, List<List<?>> expectedValues, OrcEncoding orcEncoding, OrcPredicate orcPredicate, Optional<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields) throws IOException {
        Map includedColumns = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), types::get));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        OrcTester.assertFileContentsPresto(types, file, expectedValues, orcEncoding, orcPredicate, filters, filterFunctions, filterFunctionInputMapping, requiredSubfields, (Map<Integer, Slice>)ImmutableMap.of(), includedColumns, outputColumns);
    }

    public static void assertFileContentsPresto(List<Type> types, File file, List<List<?>> expectedValues, OrcEncoding orcEncoding, OrcPredicate orcPredicate, Optional<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Slice> intermediateEncryptionKeys, Map<Integer, Type> includedColumns, List<Integer> outputColumns) throws IOException {
        try (OrcSelectiveRecordReader recordReader = OrcTester.createCustomOrcSelectiveRecordReader(file, orcEncoding, orcPredicate, types, 1024, filters.orElse((Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of()), filterFunctions, filterFunctionInputMapping, requiredSubfields, (Map<Integer, Object>)ImmutableMap.of(), intermediateEncryptionKeys, includedColumns, outputColumns, false, new TestingHiveOrcAggregatedMemoryContext(), false);){
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
            OrcTester.assertFileContentsPresto(types, recordReader, expectedValues, outputColumns);
        }
    }

    public static void assertFileContentsPresto(List<Type> types, OrcSelectiveRecordReader recordReader, List<List<?>> expectedValues, List<Integer> outputColumns) throws IOException {
        Page page;
        int rowsProcessed = 0;
        while ((page = recordReader.getNextPage()) != null) {
            int positionCount = page.getPositionCount();
            if (positionCount == 0) continue;
            Assert.assertTrue((expectedValues.get(0).size() >= rowsProcessed + positionCount ? 1 : 0) != 0);
            for (int i = 0; i < outputColumns.size(); ++i) {
                Type type = types.get(outputColumns.get(i));
                Block block = page.getBlock(i);
                Assert.assertEquals((int)block.getPositionCount(), (int)positionCount);
                OrcTester.checkNullValues(type, block);
                OrcTester.assertBlockEquals(type, block, expectedValues.get(i), rowsProcessed);
            }
            rowsProcessed += positionCount;
        }
        Assert.assertEquals((int)rowsProcessed, (int)expectedValues.get(0).size());
    }

    static void assertBlockEquals(Type type, Block block, List<?> expectedValues, int offset) {
        int positionCount = block.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            OrcTester.assertColumnValueEquals(type, type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position), expectedValues.get(offset + position));
        }
    }

    private static Map<Integer, Map<Subfield, TupleDomainFilter>> addOrderTracking(Map<Integer, Map<Subfield, TupleDomainFilter>> filters, TupleDomainFilterOrderChecker orderChecker) {
        return Maps.transformEntries(filters, (column, columnFilters) -> Maps.transformValues((Map)columnFilters, filter -> OrcTester.addOrderTracking(filter, orderChecker, column)));
    }

    private static TupleDomainFilter addOrderTracking(TupleDomainFilter filter, TupleDomainFilterOrderChecker orderChecker, int column) {
        if (filter instanceof TupleDomainFilter.BigintRange) {
            return TrackingTupleDomainFilter.TestBigintRange.of((TupleDomainFilter.BigintRange)filter, unused -> orderChecker.call(column));
        }
        if (filter instanceof TupleDomainFilter.DoubleRange) {
            return TrackingTupleDomainFilter.TestDoubleRange.of((TupleDomainFilter.DoubleRange)filter, unused -> orderChecker.call(column));
        }
        throw new UnsupportedOperationException("Unsupported filter type: " + filter.getClass().getSimpleName());
    }

    public static void assertFileContentsPresto(List<Type> types, TempFile tempFile, List<List<?>> expectedValues, boolean skipFirstBatch, boolean skipStripe, OrcEncoding orcEncoding, Format format, boolean isHiveWriter, boolean useSelectiveOrcReader, List<OrcReaderSettings> settings, Map<Integer, Slice> intermediateEncryptionKeys) throws IOException {
        OrcPredicate orcPredicate = TestingOrcPredicate.createOrcPredicate(types, expectedValues, format, isHiveWriter);
        Map includedColumns = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), types::get));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        if (useSelectiveOrcReader) {
            OrcTester.assertFileContentsPresto(types, tempFile.getFile(), expectedValues, orcEncoding, orcPredicate, Optional.empty(), (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), (Map<Integer, List<Subfield>>)ImmutableMap.of(), intermediateEncryptionKeys, includedColumns, outputColumns);
            for (OrcReaderSettings entry : settings) {
                Assert.assertTrue((boolean)entry.getFilterFunctions().isEmpty(), (String)"Filter functions are not supported yet");
                Assert.assertTrue((boolean)entry.getFilterFunctionInputMapping().isEmpty(), (String)"Filter functions are not supported yet");
                Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters = entry.getColumnFilters();
                List<List<?>> prunedAndFilteredRows = OrcTester.pruneValues(types, OrcTester.filterRows(types, expectedValues, columnFilters), entry.getRequiredSubfields());
                Optional<Object> orderChecker = Optional.empty();
                List<Integer> expectedFilterOrder = entry.getExpectedFilterOrder();
                if (!expectedFilterOrder.isEmpty()) {
                    orderChecker = Optional.of(new TupleDomainFilterOrderChecker(expectedFilterOrder));
                }
                Optional<Map<Integer, Map<Subfield, TupleDomainFilter>>> transformedFilters = Optional.of(orderChecker.map(checker -> OrcTester.addOrderTracking(columnFilters, checker)).orElse(columnFilters));
                OrcTester.assertFileContentsPresto(types, tempFile.getFile(), prunedAndFilteredRows, orcEncoding, orcPredicate, transformedFilters, entry.getFilterFunctions(), entry.getFilterFunctionInputMapping(), entry.getRequiredSubfields());
                orderChecker.ifPresent(TupleDomainFilterOrderChecker::assertOrder);
            }
            return;
        }
        try (OrcBatchRecordReader recordReader = OrcTester.createCustomOrcRecordReader(tempFile, orcEncoding, orcPredicate, types, 1024, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), false, intermediateEncryptionKeys, false);){
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)0L);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)0L);
            boolean isFirst = true;
            int rowsProcessed = 0;
            int batchSize = Math.toIntExact(recordReader.nextBatch());
            while (batchSize >= 0) {
                if (!skipStripe || rowsProcessed >= 10000) {
                    if (skipFirstBatch && isFirst) {
                        isFirst = false;
                    } else {
                        for (int i = 0; i < types.size(); ++i) {
                            Type type = types.get(i);
                            Block block = recordReader.readBlock(i);
                            Assert.assertEquals((int)block.getPositionCount(), (int)batchSize);
                            OrcTester.checkNullValues(type, block);
                            OrcTester.assertBlockEquals(type, block, expectedValues.get(i), rowsProcessed);
                        }
                    }
                }
                Assert.assertEquals((long)recordReader.getReaderPosition(), (long)rowsProcessed);
                Assert.assertEquals((long)recordReader.getFilePosition(), (long)rowsProcessed);
                rowsProcessed += batchSize;
                batchSize = Math.toIntExact(recordReader.nextBatch());
            }
            Assert.assertEquals((int)rowsProcessed, (int)expectedValues.get(0).size());
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)rowsProcessed);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)rowsProcessed);
        }
    }

    public static List<List<?>> filterRows(List<Type> types, List<List<?>> values, Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters) {
        if (columnFilters.isEmpty()) {
            return values;
        }
        List passingRows = IntStream.range(0, values.get(0).size()).filter(row -> OrcTester.testRow(types, values, row, columnFilters)).boxed().collect(Collectors.toList());
        return IntStream.range(0, values.size()).mapToObj(column -> passingRows.stream().map(((List)values.get(column))::get).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private static boolean testRow(List<Type> types, List<List<?>> values, int row, Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters) {
        for (int column = 0; column < types.size(); ++column) {
            Map<Subfield, TupleDomainFilter> filters = columnFilters.get(column);
            if (filters == null) continue;
            Type type = types.get(column);
            Object value = values.get(column).get(row);
            for (Map.Entry<Subfield, TupleDomainFilter> entry : filters.entrySet()) {
                if (OrcTester.testSubfieldValue(type, value, entry.getKey(), entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean testSubfieldValue(Type type, Object value, Subfield subfield, TupleDomainFilter filter) {
        Type nestedType = type;
        Object nestedValue = value;
        for (Subfield.PathElement pathElement : subfield.getPath()) {
            if (nestedType instanceof ArrayType) {
                Assert.assertTrue((boolean)(pathElement instanceof Subfield.LongSubscript));
                if (nestedValue == null) {
                    return filter.testNull();
                }
                int index = Math.toIntExact(((Subfield.LongSubscript)pathElement).getIndex()) - 1;
                nestedType = ((ArrayType)nestedType).getElementType();
                if (index >= ((List)nestedValue).size()) {
                    return true;
                }
                nestedValue = ((List)nestedValue).get(index);
                continue;
            }
            if (nestedType instanceof RowType) {
                Assert.assertTrue((boolean)(pathElement instanceof Subfield.NestedField));
                if (nestedValue == null) {
                    return filter.testNull();
                }
                String fieldName = ((Subfield.NestedField)pathElement).getName();
                int index = -1;
                List fields = ((RowType)nestedType).getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    if (!fieldName.equalsIgnoreCase((String)((RowType.Field)fields.get(i)).getName().get())) continue;
                    index = i;
                    nestedType = ((RowType.Field)fields.get(i)).getType();
                    break;
                }
                Assert.assertTrue((index >= 0 ? 1 : 0) != 0, (String)("Struct field not found: " + fieldName));
                nestedValue = ((List)nestedValue).get(index);
                continue;
            }
            Assert.fail((String)("Unsupported type: " + type));
        }
        return OrcTester.testValue(nestedType, nestedValue, filter);
    }

    private static boolean testValue(Type type, Object value, TupleDomainFilter filter) {
        if (value == null) {
            return filter.testNull();
        }
        if (filter == TupleDomainFilter.IS_NULL) {
            return false;
        }
        if (filter == TupleDomainFilter.IS_NOT_NULL) {
            return true;
        }
        if (type == BooleanType.BOOLEAN) {
            return filter.testBoolean(((Boolean)value).booleanValue());
        }
        if (type == TinyintType.TINYINT || type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT) {
            return filter.testLong(((Number)value).longValue());
        }
        if (type == RealType.REAL) {
            return filter.testFloat(((Number)value).floatValue());
        }
        if (type == DoubleType.DOUBLE) {
            return filter.testDouble(((Double)value).doubleValue());
        }
        if (type == DateType.DATE) {
            return filter.testLong((long)((SqlDate)value).getDays());
        }
        if (type == TimestampType.TIMESTAMP) {
            return filter.testLong(((SqlTimestamp)value).getMillisUtc());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigDecimal bigDecimal = ((SqlDecimal)value).toBigDecimal();
            if (decimalType.isShort()) {
                return filter.testLong(bigDecimal.unscaledValue().longValue());
            }
            Slice encodedDecimal = Decimals.encodeScaledValue((BigDecimal)bigDecimal);
            return filter.testDecimal(encodedDecimal.getLong(0), encodedDecimal.getLong(8));
        }
        if (type == VarcharType.VARCHAR) {
            return filter.testBytes(((String)value).getBytes(), 0, ((String)value).length());
        }
        if (type instanceof CharType) {
            String charString = String.valueOf(value);
            return filter.testBytes(charString.getBytes(), 0, charString.length());
        }
        if (type == VarbinaryType.VARBINARY) {
            byte[] binary = ((SqlVarbinary)value).getBytes();
            return filter.testBytes(binary, 0, binary.length);
        }
        Assert.fail((String)("Unsupported type: " + type));
        return false;
    }

    private static SubfieldPruner createSubfieldPruner(Type type, List<Subfield> requiredSubfields) {
        if (type instanceof ArrayType) {
            return new ListSubfieldPruner(type, requiredSubfields);
        }
        if (type instanceof MapType) {
            return new MapSubfieldPruner(type, requiredSubfields);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static List<List<?>> pruneValues(List<Type> types, List<List<?>> values, Map<Integer, List<Subfield>> requiredSubfields) {
        if (requiredSubfields.isEmpty()) {
            return values;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            List<Subfield> subfields = requiredSubfields.get(i);
            if (subfields.isEmpty()) {
                builder.add(values.get(i));
                continue;
            }
            SubfieldPruner subfieldPruner = OrcTester.createSubfieldPruner(types.get(i), subfields);
            builder.add(values.get(i).stream().map(subfieldPruner::prune).collect(Collectors.toList()));
        }
        return builder.build();
    }

    public static void assertColumnValueEquals(Type type, Object actual, Object expected) {
        if (actual == null) {
            Assert.assertEquals((Object)actual, (Object)expected);
            return;
        }
        String baseType = type.getTypeSignature().getBase();
        if ("array".equals(baseType)) {
            List actualArray = (List)actual;
            List expectedArray = (List)expected;
            Assert.assertEquals((actualArray == null ? 1 : 0) != 0, (expectedArray == null ? 1 : 0) != 0);
            Assert.assertEquals((int)actualArray.size(), (int)expectedArray.size());
            Type elementType = (Type)type.getTypeParameters().get(0);
            for (int i = 0; i < actualArray.size(); ++i) {
                Object actualElement = actualArray.get(i);
                Object expectedElement = expectedArray.get(i);
                OrcTester.assertColumnValueEquals(elementType, actualElement, expectedElement);
            }
        } else if ("map".equals(baseType)) {
            Map actualMap = (Map)actual;
            Map expectedMap = (Map)expected;
            Assert.assertEquals((int)actualMap.size(), (int)expectedMap.size());
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            ArrayList expectedEntries = new ArrayList(expectedMap.entrySet());
            for (Map.Entry actualEntry : actualMap.entrySet()) {
                boolean matchFound = false;
                Iterator iterator = expectedEntries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry expectedEntry = (Map.Entry)iterator.next();
                    try {
                        OrcTester.assertColumnValueEquals(keyType, actualEntry.getKey(), expectedEntry.getKey());
                        OrcTester.assertColumnValueEquals(valueType, actualEntry.getValue(), expectedEntry.getValue());
                        iterator.remove();
                        matchFound = true;
                        break;
                    }
                    catch (AssertionError assertionError) {
                    }
                }
                Assert.assertTrue((boolean)matchFound);
            }
            Assert.assertTrue((boolean)expectedEntries.isEmpty());
        } else if ("row".equals(baseType)) {
            List fieldTypes = type.getTypeParameters();
            List actualRow = (List)actual;
            List expectedRow = (List)expected;
            Assert.assertEquals((int)actualRow.size(), (int)fieldTypes.size());
            Assert.assertEquals((int)actualRow.size(), (int)expectedRow.size());
            for (int fieldId = 0; fieldId < actualRow.size(); ++fieldId) {
                Type fieldType = (Type)fieldTypes.get(fieldId);
                Object actualElement = actualRow.get(fieldId);
                Object expectedElement = expectedRow.get(fieldId);
                OrcTester.assertColumnValueEquals(fieldType, actualElement, expectedElement);
            }
        } else if (type.equals(DoubleType.DOUBLE)) {
            Double actualDouble = (Double)actual;
            Double expectedDouble = (Double)expected;
            if (actualDouble.isNaN()) {
                Assert.assertTrue((boolean)expectedDouble.isNaN(), (String)"expected double to be NaN");
            } else {
                Assert.assertEquals((double)actualDouble, (double)expectedDouble, (double)0.001);
            }
        } else if (!Objects.equals(actual, expected)) {
            Assert.assertEquals((Object)actual, (Object)expected);
        }
    }

    static OrcBatchRecordReader createCustomOrcRecordReader(TempFile tempFile, OrcEncoding orcEncoding, OrcPredicate predicate, Type type, int initialBatchSize, boolean cacheable, boolean mapNullKeysEnabled) throws IOException {
        return OrcTester.createCustomOrcRecordReader(tempFile, orcEncoding, predicate, (List<Type>)ImmutableList.of((Object)type), initialBatchSize, cacheable, mapNullKeysEnabled);
    }

    static OrcBatchRecordReader createCustomOrcRecordReader(TempFile tempFile, OrcEncoding orcEncoding, OrcPredicate predicate, List<Type> types, int initialBatchSize, boolean cacheable, boolean mapNullKeysEnabled) throws IOException {
        return OrcTester.createCustomOrcRecordReader(tempFile, orcEncoding, predicate, types, initialBatchSize, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), cacheable, (Map<Integer, Slice>)ImmutableMap.of(), mapNullKeysEnabled);
    }

    static OrcBatchRecordReader createCustomOrcRecordReader(TempFile tempFile, OrcEncoding orcEncoding, OrcPredicate predicate, List<Type> types, int initialBatchSize, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource, boolean cacheable, Map<Integer, Slice> intermediateEncryptionKeys, boolean mapNullKeysEnabled) throws IOException {
        FileOrcDataSource orcDataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSource, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(MAX_BLOCK_SIZE).withMapNullKeysEnabled(mapNullKeysEnabled).build(), cacheable, new DwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new TestingEncryptionLibrary()), DwrfKeyProvider.of(intermediateEncryptionKeys), new RuntimeStats());
        Assert.assertEquals((int)orcReader.getFooter().getRowsInRowGroup(), (int)10000);
        Map columnTypes = (Map)IntStream.range(0, types.size()).boxed().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), types::get));
        return orcReader.createBatchRecordReader(columnTypes, predicate, HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), initialBatchSize);
    }

    static OrcReader createCustomOrcReader(TempFile tempFile, OrcEncoding orcEncoding, boolean mapNullKeysEnabled, Map<Integer, Slice> intermediateEncryptionKeys) throws IOException {
        FileOrcDataSource orcDataSource = new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(MAX_BLOCK_SIZE).withMapNullKeysEnabled(mapNullKeysEnabled).build(), false, new DwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new TestingEncryptionLibrary()), DwrfKeyProvider.of(intermediateEncryptionKeys), new RuntimeStats());
        return orcReader;
    }

    public static void writeOrcColumnPresto(File outputFile, Format format, CompressionKind compression, Type type, List<?> values) throws Exception {
        OrcTester.writeOrcColumnsPresto(outputFile, format, compression, Optional.empty(), (List<Type>)ImmutableList.of((Object)type), ImmutableList.of(values), (WriterStats)new NoOpOrcWriterStats());
    }

    public static void writeOrcColumnsPresto(File outputFile, Format format, CompressionKind compression, Optional<DwrfWriterEncryption> dwrfWriterEncryption, List<Type> types, List<List<?>> values, WriterStats stats) throws Exception {
        OrcTester.writeOrcColumnsPresto(outputFile, format, compression, dwrfWriterEncryption, types, values, stats, (Set<Integer>)ImmutableSet.of());
    }

    public static void writeOrcColumnsPresto(File outputFile, Format format, CompressionKind compression, Optional<DwrfWriterEncryption> dwrfWriterEncryption, List<Type> types, List<List<?>> values, WriterStats stats, Set<Integer> flattenedColumns) throws Exception {
        OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlattenedColumns(flattenedColumns).build();
        OrcWriter writer = OrcTester.createOrcWriter(outputFile, format.orcEncoding, compression, dwrfWriterEncryption, types, orcWriterOptions, stats);
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            BlockBuilder blockBuilder = type.createBlockBuilder(null, values.size());
            for (Object value : values.get(i)) {
                OrcTester.writeValue(type, blockBuilder, value);
            }
            blocks[i] = blockBuilder.build();
        }
        writer.write(new Page(blocks));
        writer.close();
        writer.validate((OrcDataSource)new FileOrcDataSource(outputFile, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true));
    }

    public static List<StripeFooter> getStripes(File inputFile, OrcEncoding encoding) throws IOException {
        return OrcTester.getFileMetadata(inputFile, encoding).getStripeFooters();
    }

    public static FileMetadata getFileMetadata(File inputFile, OrcEncoding encoding) throws IOException {
        boolean zstdJniDecompressionEnabled = true;
        DataSize dataSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        FileOrcDataSource orcDataSource = new FileOrcDataSource(inputFile, dataSize, dataSize, dataSize, true);
        RuntimeStats runtimeStats = new RuntimeStats();
        OrcReaderOptions orcReaderOptions = OrcReaderOptions.builder().withMaxMergeDistance(dataSize).withTinyStripeThreshold(dataSize).withMaxBlockSize(dataSize).withZstdJniDecompressionEnabled(zstdJniDecompressionEnabled).build();
        OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, encoding, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, orcReaderOptions, false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, runtimeStats);
        Footer footer = reader.getFooter();
        Optional decompressor = OrcDecompressor.createOrcDecompressor((OrcDataSourceId)orcDataSource.getId(), (CompressionKind)reader.getCompressionKind(), (int)reader.getBufferSize(), (boolean)zstdJniDecompressionEnabled);
        ImmutableList.Builder stripes = new ImmutableList.Builder();
        for (StripeInformation stripe : footer.getStripes()) {
            byte[] tailBuffer = new byte[Math.toIntExact(stripe.getFooterLength())];
            orcDataSource.readFully(stripe.getOffset() + stripe.getIndexLength() + stripe.getDataLength(), tailBuffer);
            OrcInputStream inputStream = new OrcInputStream(orcDataSource.getId(), new SharedBuffer((OrcLocalMemoryContext)NoopOrcLocalMemoryContext.NOOP_ORC_LOCAL_MEMORY_CONTEXT), (FixedLengthSliceInput)Slices.wrappedBuffer((byte[])tailBuffer).getInput(), decompressor, Optional.empty(), (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), (long)tailBuffer.length);
            Throwable throwable = null;
            try {
                StripeFooter stripeFooter = encoding.createMetadataReader(runtimeStats, orcReaderOptions).readStripeFooter(orcDataSource.getId(), footer.getTypes(), (InputStream)inputStream);
                stripes.add((Object)stripeFooter);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return new FileMetadata(footer, (List<StripeFooter>)stripes.build());
    }

    public static OrcWriter createOrcWriter(File outputFile, OrcEncoding encoding, CompressionKind compression, Optional<DwrfWriterEncryption> dwrfWriterEncryption, List<Type> types, OrcWriterOptions writerOptions, WriterStats stats) throws FileNotFoundException {
        List<String> columnNames = OrcTester.makeColumnNames(types.size());
        ImmutableMap.Builder metadata = ImmutableMap.builder();
        metadata.put((Object)"columns", (Object)String.join((CharSequence)", ", columnNames));
        metadata.put((Object)"columns.types", (Object)OrcTester.createSettableStructObjectInspector(types).getTypeName());
        OrcWriter writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(outputFile)), columnNames, types, encoding, compression, dwrfWriterEncryption, new DwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new TestingEncryptionLibrary()), writerOptions, (Map)ImmutableMap.of(), HIVE_STORAGE_TIME_ZONE, true, OrcWriteValidation.OrcWriteValidationMode.BOTH, stats);
        return writer;
    }

    private static DwrfWriterEncryption generateWriterEncryption() {
        return new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)1), Slices.utf8Slice((String)"encryptionKey"))));
    }

    static OrcSelectiveRecordReader createCustomOrcSelectiveRecordReader(TempFile tempFile, OrcEncoding orcEncoding, OrcPredicate predicate, Type type, int initialBatchSize, boolean mapNullKeysEnabled, boolean appendRowNumber) throws IOException {
        return OrcTester.createCustomOrcSelectiveRecordReader(tempFile.getFile(), orcEncoding, predicate, (List<Type>)ImmutableList.of((Object)type), initialBatchSize, (Map<Integer, Map<Subfield, TupleDomainFilter>>)ImmutableMap.of(), (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), (Map<Integer, List<Subfield>>)ImmutableMap.of(), (Map<Integer, Object>)ImmutableMap.of(), (Map<Integer, Slice>)ImmutableMap.of(), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)type), (List<Integer>)ImmutableList.of((Object)0), mapNullKeysEnabled, new TestingHiveOrcAggregatedMemoryContext(), appendRowNumber);
    }

    public static OrcSelectiveRecordReader createCustomOrcSelectiveRecordReader(File file, OrcEncoding orcEncoding, OrcPredicate predicate, List<Type> types, int initialBatchSize, Map<Integer, Map<Subfield, TupleDomainFilter>> filters, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, Map<Integer, Object> constantValues, Map<Integer, Slice> intermediateEncryptionKeys, Map<Integer, Type> includedColumns, List<Integer> outputColumns, boolean mapNullKeysEnabled, OrcAggregatedMemoryContext systemMemoryUsage, boolean appendRowNumber) throws IOException {
        FileOrcDataSource orcDataSource = new FileOrcDataSource(file, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(MAX_BLOCK_SIZE).withMapNullKeysEnabled(mapNullKeysEnabled).withAppendRowNumber(appendRowNumber).build(), false, new DwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new TestingEncryptionLibrary()), DwrfKeyProvider.of(intermediateEncryptionKeys), new RuntimeStats());
        Assert.assertEquals(orcReader.getColumnNames().subList(0, types.size()), OrcTester.makeColumnNames(types.size()));
        return orcReader.createSelectiveRecordReader(includedColumns, outputColumns, filters, filterFunctions, filterFunctionInputMapping, requiredSubfields, constantValues, (Map)ImmutableMap.of(), predicate, 0L, orcDataSource.getSize(), HIVE_STORAGE_TIME_ZONE, systemMemoryUsage, Optional.empty(), initialBatchSize);
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (TinyintType.TINYINT.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (Decimals.isShortDecimal((Type)type)) {
            type.writeLong(blockBuilder, ((SqlDecimal)value).toBigDecimal().unscaledValue().longValue());
        } else if (Decimals.isLongDecimal((Type)type)) {
            type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)value).toBigDecimal().unscaledValue()));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (RealType.REAL.equals((Object)type)) {
            float floatValue = ((Number)value).floatValue();
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(floatValue));
        } else if (type instanceof VarcharType) {
            Slice slice = Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (type instanceof CharType) {
            Slice slice = Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (Type)type);
            type.writeSlice(blockBuilder, slice);
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((SqlVarbinary)value).getBytes()));
        } else if (DateType.DATE.equals((Object)type)) {
            long days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, days);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            long millis = ((SqlTimestamp)value).getMillisUtc();
            type.writeLong(blockBuilder, millis);
        } else if (TimestampType.TIMESTAMP_MICROSECONDS.equals((Object)type)) {
            long micros = ((SqlTimestamp)value).getMicrosUtc();
            type.writeLong(blockBuilder, micros);
        } else {
            String baseType = type.getTypeSignature().getBase();
            if ("array".equals(baseType)) {
                List array = (List)value;
                Type elementType = (Type)type.getTypeParameters().get(0);
                BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
                for (Object elementValue : array) {
                    OrcTester.writeValue(elementType, arrayBlockBuilder, elementValue);
                }
                blockBuilder.closeEntry();
            } else if ("map".equals(baseType)) {
                Map map = (Map)value;
                Type keyType = (Type)type.getTypeParameters().get(0);
                Type valueType = (Type)type.getTypeParameters().get(1);
                BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
                for (Map.Entry entry : map.entrySet()) {
                    OrcTester.writeValue(keyType, mapBlockBuilder, entry.getKey());
                    OrcTester.writeValue(valueType, mapBlockBuilder, entry.getValue());
                }
                blockBuilder.closeEntry();
            } else if ("row".equals(baseType)) {
                List array = (List)value;
                List fieldTypes = type.getTypeParameters();
                BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
                for (int fieldId = 0; fieldId < fieldTypes.size(); ++fieldId) {
                    Type fieldType = (Type)fieldTypes.get(fieldId);
                    OrcTester.writeValue(fieldType, rowBlockBuilder, array.get(fieldId));
                }
                blockBuilder.closeEntry();
            } else {
                throw new IllegalArgumentException("Unsupported type " + type);
            }
        }
    }

    private static void assertFileContentsHive(List<Type> types, TempFile tempFile, Format format, List<List<?>> expectedValues) throws Exception {
        if (format == Format.DWRF) {
            OrcTester.assertFileContentsDwrfHive(types, tempFile, expectedValues);
        } else {
            OrcTester.assertFileContentsOrcHive(types, tempFile, expectedValues);
        }
    }

    private static void assertFileContentsOrcHive(List<Type> types, TempFile tempFile, List<List<?>> expectedValues) throws Exception {
        JobConf configuration = new JobConf(new Configuration(false));
        configuration.set("hive.io.file.readcolumn.ids", "0");
        configuration.setBoolean("hive.io.file.read.all.columns", false);
        org.apache.hadoop.hive.ql.io.orc.Reader reader = OrcFile.createReader((Path)new Path(tempFile.getFile().getAbsolutePath()), (OrcFile.ReaderOptions)new OrcFile.ReaderOptions((Configuration)configuration));
        RecordReader recordReader = reader.rows();
        StructObjectInspector rowInspector = (StructObjectInspector)reader.getObjectInspector();
        List fields = OrcTester.makeColumnNames(types.size()).stream().map(arg_0 -> ((StructObjectInspector)rowInspector).getStructFieldRef(arg_0)).collect(Collectors.toList());
        Object rowData = null;
        int rowCount = 0;
        while (recordReader.hasNext()) {
            rowData = recordReader.next(rowData);
            for (int i = 0; i < fields.size(); ++i) {
                Object actualValue = rowInspector.getStructFieldData(rowData, (StructField)fields.get(i));
                actualValue = OrcTester.decodeRecordReaderValue(types.get(i), actualValue);
                OrcTester.assertColumnValueEquals(types.get(i), actualValue, expectedValues.get(i).get(rowCount));
            }
            ++rowCount;
        }
        Assert.assertEquals((int)rowCount, (int)expectedValues.get(0).size());
    }

    private static void assertFileContentsDwrfHive(List<Type> types, TempFile tempFile, List<List<?>> expectedValues) throws Exception {
        JobConf configuration = new JobConf(new Configuration(false));
        configuration.set("hive.io.file.readcolumn.ids", "0");
        configuration.setBoolean("hive.io.file.read.all.columns", false);
        Path path = new Path(tempFile.getFile().getAbsolutePath());
        Reader reader = com.facebook.hive.orc.OrcFile.createReader((FileSystem)path.getFileSystem((Configuration)configuration), (Path)path, (Configuration)configuration);
        boolean[] include = new boolean[reader.getTypes().size() + 100000];
        Arrays.fill(include, true);
        com.facebook.hive.orc.RecordReader recordReader = reader.rows(include);
        StructObjectInspector rowInspector = (StructObjectInspector)reader.getObjectInspector();
        List fields = OrcTester.makeColumnNames(types.size()).stream().map(arg_0 -> ((StructObjectInspector)rowInspector).getStructFieldRef(arg_0)).collect(Collectors.toList());
        Object rowData = null;
        int rowCount = 0;
        while (recordReader.hasNext()) {
            rowData = recordReader.next(rowData);
            for (int i = 0; i < fields.size(); ++i) {
                Object actualValue = rowInspector.getStructFieldData(rowData, (StructField)fields.get(i));
                actualValue = OrcTester.decodeRecordReaderValue(types.get(i), actualValue);
                OrcTester.assertColumnValueEquals(types.get(i), actualValue, expectedValues.get(i).get(rowCount));
            }
            ++rowCount;
        }
        Assert.assertEquals((int)rowCount, (int)expectedValues.get(0).size());
    }

    private static List<String> makeColumnNames(int columns) {
        return IntStream.range(0, columns).mapToObj(i -> i == 0 ? "test" : "test" + (i + 1)).collect(Collectors.toList());
    }

    private static Object decodeRecordReaderValue(Type type, Object actualValue) {
        if (actualValue instanceof OrcLazyObject) {
            try {
                actualValue = ((OrcLazyObject)actualValue).materialize();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (actualValue instanceof BooleanWritable) {
            actualValue = ((BooleanWritable)actualValue).get();
        } else if (actualValue instanceof ByteWritable) {
            actualValue = ((ByteWritable)actualValue).get();
        } else if (actualValue instanceof BytesWritable) {
            actualValue = new SqlVarbinary(((BytesWritable)actualValue).copyBytes());
        } else if (actualValue instanceof DateWritable) {
            actualValue = new SqlDate(((DateWritable)actualValue).getDays());
        } else if (actualValue instanceof DoubleWritable) {
            actualValue = ((DoubleWritable)actualValue).get();
        } else if (actualValue instanceof FloatWritable) {
            actualValue = Float.valueOf(((FloatWritable)actualValue).get());
        } else if (actualValue instanceof IntWritable) {
            actualValue = ((IntWritable)actualValue).get();
        } else if (actualValue instanceof HiveCharWritable) {
            actualValue = ((HiveCharWritable)actualValue).getPaddedValue().toString();
        } else if (actualValue instanceof LongWritable) {
            actualValue = ((LongWritable)actualValue).get();
        } else if (actualValue instanceof ShortWritable) {
            actualValue = ((ShortWritable)actualValue).get();
        } else if (actualValue instanceof HiveDecimalWritable) {
            DecimalType decimalType = (DecimalType)type;
            HiveDecimalWritable writable = (HiveDecimalWritable)actualValue;
            BigInteger rescaledValue = Decimals.rescale((BigInteger)writable.getHiveDecimal().unscaledValue(), (int)writable.getScale(), (int)decimalType.getScale());
            actualValue = new SqlDecimal(rescaledValue, decimalType.getPrecision(), decimalType.getScale());
        } else if (actualValue instanceof Text) {
            actualValue = actualValue.toString();
        } else if (actualValue instanceof TimestampWritable) {
            TimestampWritable timestamp = (TimestampWritable)actualValue;
            actualValue = DateTimeTestingUtils.sqlTimestampOf((long)(timestamp.getSeconds() * 1000L + (long)timestamp.getNanos() / 1000000L), (ConnectorSession)TestingConnectorSession.SESSION);
        } else if (actualValue instanceof org.apache.hadoop.hive.ql.io.orc.OrcStruct) {
            ArrayList<Object> fields = new ArrayList<Object>();
            org.apache.hadoop.hive.ql.io.orc.OrcStruct structObject = (org.apache.hadoop.hive.ql.io.orc.OrcStruct)actualValue;
            for (int fieldId = 0; fieldId < structObject.getNumFields(); ++fieldId) {
                fields.add(OrcUtil.getFieldValue((org.apache.hadoop.hive.ql.io.orc.OrcStruct)structObject, (int)fieldId));
            }
            actualValue = OrcTester.decodeRecordReaderStruct(type, fields);
        } else if (actualValue instanceof OrcStruct) {
            ArrayList<Object> fields = new ArrayList<Object>();
            OrcStruct structObject = (OrcStruct)actualValue;
            for (int fieldId = 0; fieldId < structObject.getNumFields(); ++fieldId) {
                fields.add(structObject.getFieldValue(fieldId));
            }
            actualValue = OrcTester.decodeRecordReaderStruct(type, fields);
        } else if (actualValue instanceof List) {
            actualValue = OrcTester.decodeRecordReaderList(type, (List)actualValue);
        } else if (actualValue instanceof Map) {
            actualValue = OrcTester.decodeRecordReaderMap(type, (Map)actualValue);
        }
        return actualValue;
    }

    private static List<Object> decodeRecordReaderList(Type type, List<?> list) {
        Type elementType = (Type)type.getTypeParameters().get(0);
        return list.stream().map(element -> OrcTester.decodeRecordReaderValue(elementType, element)).collect(Collectors.toList());
    }

    private static Object decodeRecordReaderMap(Type type, Map<?, ?> map) {
        Type keyType = (Type)type.getTypeParameters().get(0);
        Type valueType = (Type)type.getTypeParameters().get(1);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            newMap.put(OrcTester.decodeRecordReaderValue(keyType, entry.getKey()), OrcTester.decodeRecordReaderValue(valueType, entry.getValue()));
        }
        return newMap;
    }

    private static List<Object> decodeRecordReaderStruct(Type type, List<?> fields) {
        List fieldTypes = type.getTypeParameters();
        ArrayList<Object> newFields = new ArrayList<Object>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = (Type)fieldTypes.get(i);
            Object field = fields.get(i);
            newFields.add(OrcTester.decodeRecordReaderValue(fieldType, field));
        }
        for (int j = fields.size(); j < fieldTypes.size(); ++j) {
            newFields.add(null);
        }
        return newFields;
    }

    public static DataSize writeOrcColumnHive(File outputFile, Format format, CompressionKind compression, Type type, List<?> values) throws Exception {
        return OrcTester.writeOrcColumnsHive(outputFile, format, compression, (List<Type>)ImmutableList.of((Object)type), ImmutableList.of(values));
    }

    public static DataSize writeOrcColumnsHive(File outputFile, Format format, CompressionKind compression, List<Type> types, List<List<?>> values) throws Exception {
        FileSinkOperator.RecordWriter recordWriter = Format.DWRF == format ? OrcTester.createDwrfRecordWriter(outputFile, compression, types) : OrcTester.createOrcRecordWriter(outputFile, format, compression, types);
        return OrcTester.writeOrcFileColumnHive(outputFile, format, recordWriter, types, values);
    }

    private static DataSize writeOrcFileColumnHive(File outputFile, Format format, FileSinkOperator.RecordWriter recordWriter, List<Type> types, List<List<?>> values) throws Exception {
        SettableStructObjectInspector objectInspector = OrcTester.createSettableStructObjectInspector(types);
        Object row = objectInspector.create();
        ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
        Serializer serializer = format.createSerializer();
        for (int i = 0; i < values.get(0).size(); ++i) {
            for (int j = 0; j < types.size(); ++j) {
                Object value = OrcTester.preprocessWriteValueHive(types.get(j), values.get(j).get(i));
                objectInspector.setStructFieldData(row, (StructField)fields.get(j), value);
            }
            if (Format.DWRF == format && i == 142345) {
                OrcTester.setDwrfLowMemoryFlag(recordWriter);
            }
            Writable record = serializer.serialize(row, (ObjectInspector)objectInspector);
            recordWriter.write(record);
        }
        recordWriter.close(false);
        return DataSize.succinctBytes((long)outputFile.length());
    }

    public static DataSize writeOrcFileColumnHive(File outputFile, Format format, FileSinkOperator.RecordWriter recordWriter, Type type, List<?> values) throws Exception {
        return OrcTester.writeOrcFileColumnHive(outputFile, format, recordWriter, (List<Type>)ImmutableList.of((Object)type), ImmutableList.of(values));
    }

    private static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        }
        if (type instanceof CharType) {
            int charLength = ((CharType)type).getLength();
            return new JavaHiveCharObjectInspector(TypeInfoFactory.getCharTypeInfo((int)charLength));
        }
        if (type instanceof VarbinaryType) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampType.TIMESTAMP_MICROSECONDS)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)OrcTester.getJavaObjectInspector((Type)type.getTypeParameters().get(0)));
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            ObjectInspector keyObjectInspector = OrcTester.getJavaObjectInspector((Type)type.getTypeParameters().get(0));
            ObjectInspector valueObjectInspector = OrcTester.getJavaObjectInspector((Type)type.getTypeParameters().get(1));
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            return ObjectInspectorFactory.getStandardStructObjectInspector(type.getTypeSignature().getParameters().stream().map(parameter -> (String)parameter.getNamedTypeSignature().getName().get()).collect(Collectors.toList()), type.getTypeParameters().stream().map(OrcTester::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Object preprocessWriteValueHive(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return value;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return ((Number)value).byteValue();
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return ((Number)value).shortValue();
        }
        if (type.equals(IntegerType.INTEGER)) {
            return ((Number)value).intValue();
        }
        if (type.equals(BigintType.BIGINT)) {
            return ((Number)value).longValue();
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        if (type instanceof VarcharType) {
            return value;
        }
        if (type instanceof CharType) {
            return new HiveChar((String)value, ((CharType)type).getLength());
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ((SqlVarbinary)value).getBytes();
        }
        if (type.equals(DateType.DATE)) {
            int days = ((SqlDate)value).getDays();
            LocalDate localDate = LocalDate.ofEpochDay(days);
            ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
            long millis = TimeUnit.SECONDS.toMillis(zonedDateTime.toEpochSecond());
            Date date = new Date(0L);
            date.setTime(millis);
            return date;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            long millisUtc = (int)((SqlTimestamp)value).getMillisUtc();
            return new Timestamp(millisUtc);
        }
        if (type instanceof DecimalType) {
            return HiveDecimal.create((BigDecimal)((SqlDecimal)value).toBigDecimal());
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            return ((List)value).stream().map(element -> OrcTester.preprocessWriteValueHive(elementType, element)).collect(Collectors.toList());
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            HashMap<Object, Object> newMap = new HashMap<Object, Object>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                newMap.put(OrcTester.preprocessWriteValueHive(keyType, entry.getKey()), OrcTester.preprocessWriteValueHive(valueType, entry.getValue()));
            }
            return newMap;
        }
        if (type.getTypeSignature().getBase().equals("row")) {
            List fieldValues = (List)value;
            List fieldTypes = type.getTypeParameters();
            ArrayList<Object> newStruct = new ArrayList<Object>();
            for (int fieldId = 0; fieldId < fieldValues.size(); ++fieldId) {
                newStruct.add(OrcTester.preprocessWriteValueHive((Type)fieldTypes.get(fieldId), fieldValues.get(fieldId)));
            }
            return newStruct;
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static void checkNullValues(Type type, Block block) {
        if (!block.mayHaveNull()) {
            return;
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) continue;
            if (type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP)) {
                Assert.assertEquals((long)type.getLong(block, position), (long)0L);
            }
            if (type.equals(BooleanType.BOOLEAN)) {
                Assert.assertFalse((boolean)type.getBoolean(block, position));
            }
            if (type.equals(DoubleType.DOUBLE)) {
                Assert.assertEquals((double)type.getDouble(block, position), (double)0.0);
            }
            if (!(type instanceof VarcharType) && !(type instanceof CharType) && !type.equals(VarbinaryType.VARBINARY)) continue;
            Assert.assertEquals((int)type.getSlice(block, position).length(), (int)0);
        }
    }

    private static void setDwrfLowMemoryFlag(FileSinkOperator.RecordWriter recordWriter) {
        Object writer = OrcTester.getFieldValue(recordWriter, "writer");
        Object memoryManager = OrcTester.getFieldValue(writer, "memoryManager");
        OrcTester.setFieldValue(memoryManager, "lowMemoryMode", true);
        try {
            writer.getClass().getMethod("enterLowMemoryMode", new Class[0]).invoke(writer, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getFieldValue(Object instance, String name) {
        try {
            Field writerField = instance.getClass().getDeclaredField(name);
            writerField.setAccessible(true);
            return writerField.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setFieldValue(Object instance, String name, Object value) {
        try {
            Field writerField = instance.getClass().getDeclaredField(name);
            writerField.setAccessible(true);
            writerField.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static FileSinkOperator.RecordWriter createOrcRecordWriter(File outputFile, Format format, CompressionKind compression, Type type) throws IOException {
        return OrcTester.createOrcRecordWriter(outputFile, format, compression, (List<Type>)ImmutableList.of((Object)type));
    }

    static FileSinkOperator.RecordWriter createOrcRecordWriter(File outputFile, Format format, CompressionKind compression, List<Type> types) throws IOException {
        JobConf jobConf = new JobConf();
        org.apache.orc.OrcConf.WRITE_FORMAT.setString((Configuration)jobConf, format == Format.ORC_12 ? "0.12" : "0.11");
        org.apache.orc.OrcConf.COMPRESS.setString((Configuration)jobConf, compression.name());
        return new org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat().getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compression != CompressionKind.NONE, OrcTester.createTableProperties(types), () -> {});
    }

    private static FileSinkOperator.RecordWriter createDwrfRecordWriter(File outputFile, CompressionKind compressionCodec, List<Type> types) throws IOException {
        JobConf jobConf = new JobConf();
        OrcConf.setVar((Configuration)jobConf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_COMPRESSION, (String)compressionCodec.name());
        OrcConf.setIntVar((Configuration)jobConf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_ENTROPY_STRING_THRESHOLD, (int)1);
        OrcConf.setIntVar((Configuration)jobConf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_DICTIONARY_ENCODING_INTERVAL, (int)2);
        OrcConf.setBoolVar((Configuration)jobConf, (OrcConf.ConfVars)OrcConf.ConfVars.HIVE_ORC_BUILD_STRIDE_DICTIONARY, (boolean)true);
        return new OrcOutputFormat().getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compressionCodec != CompressionKind.NONE, OrcTester.createTableProperties(types), () -> {});
    }

    static SettableStructObjectInspector createSettableStructObjectInspector(String name, Type type) {
        return ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)name), (List)ImmutableList.of((Object)OrcTester.getJavaObjectInspector(type)));
    }

    static SettableStructObjectInspector createSettableStructObjectInspector(List<Type> types) {
        List columnTypes = types.stream().map(OrcTester::getJavaObjectInspector).collect(Collectors.toList());
        return ObjectInspectorFactory.getStandardStructObjectInspector(OrcTester.makeColumnNames(types.size()), columnTypes);
    }

    private static Properties createTableProperties(List<Type> types) {
        String columnTypes = types.stream().map(OrcTester::getJavaObjectInspector).map(ObjectInspector::getTypeName).collect(Collectors.joining(","));
        Properties orderTableProperties = new Properties();
        orderTableProperties.setProperty("columns", String.join((CharSequence)",", OrcTester.makeColumnNames(types.size())));
        orderTableProperties.setProperty("columns.types", columnTypes);
        orderTableProperties.setProperty("orc.bloom.filter.columns", String.join((CharSequence)",", OrcTester.makeColumnNames(types.size())));
        orderTableProperties.setProperty("orc.bloom.filter.fpp", "0.50");
        orderTableProperties.setProperty("orc.bloom.filter.write.version", "original");
        return orderTableProperties;
    }

    private static <T> List<T> reverse(List<T> iterable) {
        return Lists.reverse((List)ImmutableList.copyOf(iterable));
    }

    private static <T> List<T> insertNullEvery(final int n, final List<T> iterable) {
        return Lists.newArrayList(() -> new AbstractIterator<T>(){
            private int position;
            private int totalCount;
            private final Iterator delegate;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                if (this.totalCount >= iterable.size()) {
                    return this.endOfData();
                }
                ++this.totalCount;
                ++this.position;
                if (this.position > n) {
                    this.position = 0;
                    return null;
                }
                if (!this.delegate.hasNext()) {
                    return this.endOfData();
                }
                return this.delegate.next();
            }
        });
    }

    public static List<Object> toHiveStruct(Object input) {
        return Arrays.asList(input, input, input);
    }

    private static List<Object> toHiveStructWithNull(Object input) {
        return Arrays.asList(input, input, input, null, null, null);
    }

    private static Map<Object, Object> toHiveMap(Object input, Object nullKeyValue) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(input != null ? input : nullKeyValue, input);
        return map;
    }

    private static List<Object> toHiveList(Object input) {
        return Arrays.asList(input, input, input, input);
    }

    private static boolean hasType(Type testType, Set<String> baseTypes) {
        String testBaseType = testType.getTypeSignature().getBase();
        if ("array".equals(testBaseType)) {
            Type elementType = (Type)testType.getTypeParameters().get(0);
            return OrcTester.hasType(elementType, baseTypes);
        }
        if ("map".equals(testBaseType)) {
            Type keyType = (Type)testType.getTypeParameters().get(0);
            Type valueType = (Type)testType.getTypeParameters().get(1);
            return OrcTester.hasType(keyType, baseTypes) || OrcTester.hasType(valueType, baseTypes);
        }
        if ("row".equals(testBaseType)) {
            return testType.getTypeParameters().stream().anyMatch(fieldType -> OrcTester.hasType(fieldType, baseTypes));
        }
        return baseTypes.contains(testBaseType);
    }

    public static Type arrayType(Type elementType) {
        return FUNCTION_AND_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType.getTypeSignature())));
    }

    public static Type mapType(Type keyType, Type valueType) {
        return FUNCTION_AND_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
    }

    public static Type rowType(Type ... fieldTypes) {
        ImmutableList.Builder typeSignatureParameters = ImmutableList.builder();
        for (int i = 0; i < fieldTypes.length; ++i) {
            String filedName = "field_" + i;
            Type fieldType = fieldTypes[i];
            typeSignatureParameters.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(filedName, false)), fieldType.getTypeSignature())));
        }
        return FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)typeSignatureParameters.build());
    }

    public static class FileMetadata {
        Footer footer;
        List<StripeFooter> stripeFooters;

        public FileMetadata(Footer footer, List<StripeFooter> stripeFooters) {
            this.footer = Objects.requireNonNull(footer, "footer is null");
            this.stripeFooters = Objects.requireNonNull(stripeFooters, "stripeFooters is null");
        }

        public Footer getFooter() {
            return this.footer;
        }

        public List<StripeFooter> getStripeFooters() {
            return this.stripeFooters;
        }
    }

    private static class MapSubfieldPruner
    implements SubfieldPruner {
        private final Set<Long> keys;
        private final Optional<SubfieldPruner> nestedSubfieldPruner;

        public MapSubfieldPruner(Type type, List<Subfield> requiredSubfields) {
            Preconditions.checkArgument((boolean)(type instanceof MapType), (Object)("type is not a map type: " + type));
            this.keys = (Set)requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).map(Subfield.LongSubscript::getIndex).collect(ImmutableSet.toImmutableSet());
            List elementSubfields = (List)requiredSubfields.stream().filter(subfield -> subfield.getPath().size() > 1).map(subfield -> subfield.tail(subfield.getRootName())).distinct().collect(ImmutableList.toImmutableList());
            this.nestedSubfieldPruner = elementSubfields.isEmpty() ? Optional.empty() : Optional.of(OrcTester.createSubfieldPruner(((MapType)type).getValueType(), elementSubfields));
        }

        @Override
        public Object prune(Object value) {
            if (value == null) {
                return null;
            }
            Map map = (Map)value;
            Map prunedMap = this.keys.isEmpty() ? map : Maps.filterKeys((Map)((Map)value), key -> this.keys.contains(((Number)key).longValue()));
            return this.nestedSubfieldPruner.map(pruner -> Maps.transformValues((Map)prunedMap, pruner::prune)).orElse(prunedMap);
        }
    }

    private static class ListSubfieldPruner
    implements SubfieldPruner {
        private final int maxIndex;
        private final Optional<SubfieldPruner> nestedSubfieldPruner;

        public ListSubfieldPruner(Type type, List<Subfield> requiredSubfields) {
            Preconditions.checkArgument((boolean)(type instanceof ArrayType), (Object)("type is not an array type: " + type));
            this.maxIndex = requiredSubfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).map(Subfield.LongSubscript::getIndex).mapToInt(Long::intValue).max().orElse(-1);
            List elementSubfields = (List)requiredSubfields.stream().filter(subfield -> subfield.getPath().size() > 1).map(subfield -> subfield.tail(subfield.getRootName())).distinct().collect(ImmutableList.toImmutableList());
            this.nestedSubfieldPruner = elementSubfields.isEmpty() ? Optional.empty() : Optional.of(OrcTester.createSubfieldPruner(((ArrayType)type).getElementType(), elementSubfields));
        }

        @Override
        public Object prune(Object value) {
            if (value == null) {
                return null;
            }
            List list = (List)value;
            List prunedList = this.maxIndex == -1 ? list : (list.size() < this.maxIndex ? list : list.subList(0, this.maxIndex));
            return this.nestedSubfieldPruner.map(pruner -> prunedList.stream().map(pruner::prune).collect(Collectors.toList())).orElse(prunedList);
        }
    }

    private static interface SubfieldPruner {
        public Object prune(Object var1);
    }

    public static class OrcReaderSettings {
        private final Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters;
        private final List<Integer> expectedFilterOrder;
        private final List<FilterFunction> filterFunctions;
        private final Map<Integer, Integer> filterFunctionInputMapping;
        private final Map<Integer, List<Subfield>> requiredSubfields;
        private final OrcFileTailSource orcFileTailSource;

        private OrcReaderSettings(Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters, List<Integer> expectedFilterOrder, List<FilterFunction> filterFunctions, Map<Integer, Integer> filterFunctionInputMapping, Map<Integer, List<Subfield>> requiredSubfields, OrcFileTailSource orcFileTailSource) {
            this.columnFilters = Objects.requireNonNull(columnFilters, "columnFilters is null");
            this.expectedFilterOrder = Objects.requireNonNull(expectedFilterOrder, "expectedFilterOrder is null");
            this.filterFunctions = Objects.requireNonNull(filterFunctions, "filterFunctions is null");
            this.filterFunctionInputMapping = Objects.requireNonNull(filterFunctionInputMapping, "filterFunctionInputMapping is null");
            this.requiredSubfields = Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
            this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        }

        public Map<Integer, Map<Subfield, TupleDomainFilter>> getColumnFilters() {
            return this.columnFilters;
        }

        public List<Integer> getExpectedFilterOrder() {
            return this.expectedFilterOrder;
        }

        public List<FilterFunction> getFilterFunctions() {
            return this.filterFunctions;
        }

        public Map<Integer, Integer> getFilterFunctionInputMapping() {
            return this.filterFunctionInputMapping;
        }

        public Map<Integer, List<Subfield>> getRequiredSubfields() {
            return this.requiredSubfields;
        }

        public OrcFileTailSource getOrcFileTailSource() {
            return this.orcFileTailSource;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters = ImmutableMap.of();
            private List<Integer> expectedFilterOrder = ImmutableList.of();
            private List<FilterFunction> filterFunctions = ImmutableList.of();
            private Map<Integer, Integer> filterFunctionInputMapping = ImmutableMap.of();
            private Map<Integer, List<Subfield>> requiredSubfields = new HashMap<Integer, List<Subfield>>();
            private OrcFileTailSource orcFileTailSource = new StorageOrcFileTailSource();

            public Builder setColumnFilters(Map<Integer, Map<Subfield, TupleDomainFilter>> columnFilters) {
                this.columnFilters = Objects.requireNonNull(columnFilters, "columnFilters is null");
                return this;
            }

            public Builder setExpectedFilterOrder(List<Integer> expectedFilterOrder) {
                this.expectedFilterOrder = Objects.requireNonNull(expectedFilterOrder, "expectedFilterOrder is null");
                return this;
            }

            public Builder setFilterFunctions(List<FilterFunction> filterFunctions) {
                this.filterFunctions = Objects.requireNonNull(filterFunctions, "filterFunctions is null");
                return this;
            }

            public Builder setFilterFunctionMapping(Map<Integer, Integer> filterFunctionInputMapping) {
                this.filterFunctionInputMapping = Objects.requireNonNull(filterFunctionInputMapping, "filterFunctionInputMapping is null");
                return this;
            }

            public Builder setRequiredSubfields(Map<Integer, List<Subfield>> requiredSubfields) {
                Objects.requireNonNull(requiredSubfields, "requiredSubfields is null");
                this.requiredSubfields.clear();
                this.requiredSubfields.putAll(requiredSubfields);
                return this;
            }

            public Builder addRequiredSubfields(int column, String ... subfields) {
                this.requiredSubfields.put(column, (List<Subfield>)Arrays.stream(subfields).map(subfield -> new Subfield(subfield)).collect(ImmutableList.toImmutableList()));
                return this;
            }

            public Builder setOrcFileTailSource(OrcFileTailSource orcFileTailSource) {
                this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
                return this;
            }

            public OrcReaderSettings build() {
                return new OrcReaderSettings(this.columnFilters, this.expectedFilterOrder, this.filterFunctions, this.filterFunctionInputMapping, this.requiredSubfields, this.orcFileTailSource);
            }
        }
    }

    public static enum Format {
        ORC_12(OrcEncoding.ORC){

            @Override
            public Serializer createSerializer() {
                return new org.apache.hadoop.hive.ql.io.orc.OrcSerde();
            }
        }
        ,
        ORC_11(OrcEncoding.ORC){

            @Override
            public Serializer createSerializer() {
                return new org.apache.hadoop.hive.ql.io.orc.OrcSerde();
            }
        }
        ,
        DWRF(OrcEncoding.DWRF){

            @Override
            public boolean supportsType(Type type) {
                return !OrcTester.hasType(type, (Set)ImmutableSet.of((Object)"date", (Object)"decimal", (Object)"char"));
            }

            @Override
            public Serializer createSerializer() {
                return new OrcSerde();
            }
        };

        private final OrcEncoding orcEncoding;

        private Format(OrcEncoding orcEncoding) {
            this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        }

        public OrcEncoding getOrcEncoding() {
            return this.orcEncoding;
        }

        public boolean supportsType(Type type) {
            return true;
        }

        public abstract Serializer createSerializer();
    }
}

