/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.CachingOrcDataSource;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.NoopOrcDataSource;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcDataSource;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.orc.OrcConf;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCachingOrcDataSource {
    private static final int POSITION_COUNT = 50000;
    private TempFile tempFile;

    @BeforeClass
    public void setUp() throws Exception {
        this.tempFile = new TempFile();
        Random random = new Random();
        List values = (List)Stream.generate(() -> Long.toHexString(random.nextLong())).limit(50000L).collect(ImmutableList.toImmutableList());
        OrcTester.writeOrcFileColumnHive(this.tempFile.getFile(), OrcTester.Format.ORC_12, TestCachingOrcDataSource.createOrcRecordWriter(this.tempFile.getFile(), OrcTester.Format.ORC_12, CompressionKind.ZLIB, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), (Type)VarcharType.VARCHAR, values);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.tempFile.close();
    }

    @Test
    public void testWrapWithCacheIfTinyStripes() {
        DataSize maxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        DataSize tinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
        TestingHiveOrcAggregatedMemoryContext systemMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        OrcDataSource actual = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)NoopOrcDataSource.INSTANCE, (List)ImmutableList.of(), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext);
        Assertions.assertInstanceOf((Object)actual, CachingOrcDataSource.class);
        actual = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)NoopOrcDataSource.INSTANCE, (List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext);
        Assertions.assertInstanceOf((Object)actual, CachingOrcDataSource.class);
        actual = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)NoopOrcDataSource.INSTANCE, (List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 33L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 63L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext);
        Assertions.assertInstanceOf((Object)actual, CachingOrcDataSource.class);
        actual = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)NoopOrcDataSource.INSTANCE, (List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 33L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 63L, 8388588L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext);
        Assertions.assertInstanceOf((Object)actual, CachingOrcDataSource.class);
        actual = AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)NoopOrcDataSource.INSTANCE, (List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 33L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 63L, 8388589L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext);
        TestCachingOrcDataSource.assertNotInstanceOf(actual, CachingOrcDataSource.class);
    }

    @Test
    public void testTinyStripesReadCacheAt() throws IOException {
        DataSize maxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        DataSize tinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
        TestingHiveOrcAggregatedMemoryContext systemMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        TestingOrcDataSource testingOrcDataSource = new TestingOrcDataSource(NoopOrcDataSource.INSTANCE);
        CachingOrcDataSource cachingOrcDataSource = new CachingOrcDataSource((OrcDataSource)testingOrcDataSource, (CachingOrcDataSource.RegionFinder)AbstractOrcRecordReader.LinearProbeRangeFinder.createTinyStripesRangeFinder((List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 33L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 63L, 8388588L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold), systemMemoryContext.newOrcLocalMemoryContext(CachingOrcDataSource.class.getSimpleName()));
        cachingOrcDataSource.readCacheAt(3L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(3L, 60)));
        cachingOrcDataSource.readCacheAt(63L);
        Assert.assertEquals((long)systemMemoryContext.getBytes(), (long)0x800000L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(63L, 0x800000)));
        testingOrcDataSource = new TestingOrcDataSource(NoopOrcDataSource.INSTANCE);
        cachingOrcDataSource = new CachingOrcDataSource((OrcDataSource)testingOrcDataSource, (CachingOrcDataSource.RegionFinder)AbstractOrcRecordReader.LinearProbeRangeFinder.createTinyStripesRangeFinder((List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 33L, 10L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 63L, 8388588L, 10L, 10L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold), systemMemoryContext.newOrcLocalMemoryContext(CachingOrcDataSource.class.getSimpleName()));
        cachingOrcDataSource.readCacheAt(62L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(3L, 60)));
        cachingOrcDataSource.readCacheAt(63L);
        Assert.assertEquals((long)systemMemoryContext.getBytes(), (long)0x1000000L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(63L, 0x800000)));
        testingOrcDataSource = new TestingOrcDataSource(NoopOrcDataSource.INSTANCE);
        cachingOrcDataSource = new CachingOrcDataSource((OrcDataSource)testingOrcDataSource, (CachingOrcDataSource.RegionFinder)AbstractOrcRecordReader.LinearProbeRangeFinder.createTinyStripesRangeFinder((List)ImmutableList.of((Object)new StripeInformation(123L, 3L, 1L, 1L, 1L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 4L, 0x100000L, 0x100000L, 0x300000L, OptionalLong.empty(), (List)ImmutableList.of()), (Object)new StripeInformation(123L, 0x500004L, 0x100000L, 0x100000L, 0x100000L, OptionalLong.empty(), (List)ImmutableList.of())), (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold), systemMemoryContext.newOrcLocalMemoryContext(CachingOrcDataSource.class.getSimpleName()));
        cachingOrcDataSource.readCacheAt(3L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(3L, 0x500001)));
        cachingOrcDataSource.readCacheAt(0x500004L);
        Assert.assertEquals((long)systemMemoryContext.getBytes(), (long)0x1500001L);
        Assert.assertEquals(testingOrcDataSource.getLastReadRanges(), (Collection)ImmutableList.of((Object)new DiskRange(0x500004L, 0x300000)));
    }

    @Test
    public void testIntegration() throws IOException {
        TestingOrcDataSource orcDataSource = new TestingOrcDataSource((OrcDataSource)new FileOrcDataSource(this.tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true));
        this.doIntegration(orcDataSource, new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE));
        Assert.assertEquals((int)orcDataSource.getReadCount(), (int)1);
        orcDataSource = new TestingOrcDataSource((OrcDataSource)new FileOrcDataSource(this.tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true));
        this.doIntegration(orcDataSource, new DataSize(400.0, DataSize.Unit.KILOBYTE), new DataSize(400.0, DataSize.Unit.KILOBYTE), new DataSize(400.0, DataSize.Unit.KILOBYTE));
        Assert.assertEquals((int)orcDataSource.getReadCount(), (int)3);
    }

    public void doIntegration(TestingOrcDataSource orcDataSource, DataSize maxMergeDistance, DataSize maxReadSize, DataSize tinyStripeThreshold) throws IOException {
        int batchSize;
        TestingHiveOrcAggregatedMemoryContext systemMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(maxMergeDistance).withTinyStripeThreshold(tinyStripeThreshold).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).build(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        Assert.assertEquals((int)orcDataSource.getReadCount(), (int)1);
        List stripes = orcReader.getFooter().getStripes();
        Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(stripes.size()), (Comparable)Integer.valueOf(3));
        Assertions.assertInstanceOf((Object)AbstractOrcRecordReader.wrapWithCacheIfTinyStripes((OrcDataSource)orcDataSource, (List)stripes, (DataSize)maxMergeDistance, (DataSize)tinyStripeThreshold, (OrcAggregatedMemoryContext)systemMemoryContext), CachingOrcDataSource.class);
        OrcBatchRecordReader orcRecordReader = orcReader.createBatchRecordReader((Map)ImmutableMap.of((Object)0, (Object)VarcharType.VARCHAR), (numberOfRows, statisticsByColumnIndex) -> true, OrcTester.HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1);
        int positionCount = 0;
        while ((batchSize = orcRecordReader.nextBatch()) > 0) {
            Block block = orcRecordReader.readBlock(0);
            positionCount += block.getPositionCount();
        }
        Assert.assertEquals((int)positionCount, (int)50000);
    }

    public static <T, U extends T> void assertNotInstanceOf(T actual, Class<U> expectedType) {
        Assert.assertNotNull(actual, (String)"actual is null");
        Assert.assertNotNull(expectedType, (String)"expectedType is null");
        if (expectedType.isInstance(actual)) {
            Assert.fail((String)String.format("expected:<%s> to not be an instance of <%s>", actual, expectedType.getName()));
        }
    }

    private static FileSinkOperator.RecordWriter createOrcRecordWriter(File outputFile, OrcTester.Format format, CompressionKind compression, ObjectInspector columnObjectInspector) throws IOException {
        JobConf jobConf = new JobConf();
        OrcConf.WRITE_FORMAT.setString((Configuration)jobConf, format == OrcTester.Format.ORC_12 ? "0.12" : "0.11");
        OrcConf.COMPRESS.setString((Configuration)jobConf, compression.name());
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", "test");
        tableProperties.setProperty("columns.types", columnObjectInspector.getTypeName());
        tableProperties.setProperty(OrcConf.STRIPE_SIZE.getAttribute(), "120000");
        return new OrcOutputFormat().getHiveRecordWriter(jobConf, new Path(outputFile.toURI()), Text.class, compression != CompressionKind.NONE, tableProperties, () -> {});
    }
}

