/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.CapturingOrcFileIntrospector;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.MapColumnStatisticsBuilder;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.ByteString;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestColumnStatistics {
    private static final int MAP_STATS_TEST_STRIPE_MAX_ROW_COUNT = 4;
    private static final int MAP_STATS_TEST_ROW_GROUP_MAX_ROW_COUNT = 2;
    public static final int COLUMN = 1;

    @DataProvider
    public static Object[][] mapKeyTypeProvider() {
        return new Object[][]{{BigintType.BIGINT}, {VarcharType.VARCHAR}};
    }

    @Test(dataProvider="mapKeyTypeProvider")
    public void testEmptyMapStatistics(Type mapKeyType) throws Exception {
        MapType mapType = (MapType)OrcTester.mapType(mapKeyType, (Type)BigintType.BIGINT);
        Page emptyMaps = TestColumnStatistics.createMapPage(mapType, Arrays.asList(TestColumnStatistics.mapOf(new Object[0]), TestColumnStatistics.mapOf(new Object[0]), TestColumnStatistics.mapOf(new Object[0]), TestColumnStatistics.mapOf(new Object[0]), TestColumnStatistics.mapOf(new Object[0]), TestColumnStatistics.mapOf(new Object[0])));
        Page emptyMapsWithNulls = TestColumnStatistics.createMapPage(mapType, Arrays.asList(null, TestColumnStatistics.mapOf(new Object[0]), null, null, null, TestColumnStatistics.mapOf(new Object[0])));
        Page emptyMapsWithAllNulls = TestColumnStatistics.createMapPage(mapType, Arrays.asList(null, null, null, null, null, null));
        this.doTestFlatMapStatistics((Type)mapType, emptyMaps, new ColumnStatistics(Long.valueOf(6L)), new ColumnStatistics(Long.valueOf(2L)), new ColumnStatistics(Long.valueOf(2L)), new ColumnStatistics(Long.valueOf(2L)));
        this.doTestFlatMapStatistics((Type)mapType, emptyMapsWithNulls, new ColumnStatistics(Long.valueOf(2L)), new ColumnStatistics(Long.valueOf(1L)), new ColumnStatistics(Long.valueOf(0L)), new ColumnStatistics(Long.valueOf(1L)));
        this.doTestFlatMapStatistics((Type)mapType, emptyMapsWithAllNulls, new ColumnStatistics(Long.valueOf(0L)), new ColumnStatistics(Long.valueOf(0L)), new ColumnStatistics(Long.valueOf(0L)), new ColumnStatistics(Long.valueOf(0L)));
    }

    @Test(dataProvider="mapKeyTypeProvider")
    public void testMapStatistics(Type mapKeyType) throws Exception {
        Object[] objectArray;
        MapType mapType = (MapType)OrcTester.mapType(mapKeyType, (Type)BigintType.BIGINT);
        if (mapKeyType == BigintType.BIGINT) {
            Object[] objectArray2 = new Object[6];
            objectArray2[0] = 0L;
            objectArray2[1] = 1L;
            objectArray2[2] = 2L;
            objectArray2[3] = 3L;
            objectArray2[4] = 4L;
            objectArray = objectArray2;
            objectArray2[5] = 5L;
        } else {
            Object[] objectArray3 = new Object[6];
            objectArray3[0] = "k0";
            objectArray3[1] = "k1";
            objectArray3[2] = "k2";
            objectArray3[3] = "k3";
            objectArray3[4] = "k4";
            objectArray = objectArray3;
            objectArray3[5] = "k5";
        }
        Object[] keys = objectArray;
        Object everyRowKey = keys[0];
        Object firstRowGroupKey = keys[1];
        Object secondRowGroupKey = keys[2];
        Object thirdRowGroupKey = keys[3];
        Object firstStripeKey = keys[4];
        Object secondStripeKey = keys[5];
        Page maps = TestColumnStatistics.createMapPage(mapType, Arrays.asList(TestColumnStatistics.mapOf(everyRowKey, 1L, firstRowGroupKey, 11L), TestColumnStatistics.mapOf(everyRowKey, 2L, firstStripeKey, 100L), TestColumnStatistics.mapOf(everyRowKey, 3L, firstStripeKey, 100L), TestColumnStatistics.mapOf(everyRowKey, 4L, secondRowGroupKey, 22L), TestColumnStatistics.mapOf(everyRowKey, 5L, thirdRowGroupKey, 33L, secondStripeKey, 1000L), TestColumnStatistics.mapOf(everyRowKey, 6L)));
        MapColumnStatisticsBuilder fileStatistics = new MapColumnStatisticsBuilder(true);
        fileStatistics.increaseValueCount(6L);
        TestColumnStatistics.addIntStats(fileStatistics, everyRowKey, 6L, 1L, 6L, 21L);
        TestColumnStatistics.addIntStats(fileStatistics, firstRowGroupKey, 1L, 11L, 11L, 11L);
        TestColumnStatistics.addIntStats(fileStatistics, firstStripeKey, 2L, 100L, 100L, 200L);
        TestColumnStatistics.addIntStats(fileStatistics, secondRowGroupKey, 1L, 22L, 22L, 22L);
        TestColumnStatistics.addIntStats(fileStatistics, thirdRowGroupKey, 1L, 33L, 33L, 33L);
        TestColumnStatistics.addIntStats(fileStatistics, secondStripeKey, 1L, 1000L, 1000L, 1000L);
        MapColumnStatisticsBuilder rowGroupStats1 = new MapColumnStatisticsBuilder(true);
        rowGroupStats1.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats1, everyRowKey, 2L, 1L, 2L, 3L);
        TestColumnStatistics.addIntStats(rowGroupStats1, firstRowGroupKey, 1L, 11L, 11L, 11L);
        TestColumnStatistics.addIntStats(rowGroupStats1, firstStripeKey, 1L, 100L, 100L, 100L);
        MapColumnStatisticsBuilder rowGroupStats2 = new MapColumnStatisticsBuilder(true);
        rowGroupStats2.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats2, everyRowKey, 2L, 3L, 4L, 7L);
        rowGroupStats2.addMapStatistics(TestColumnStatistics.keyInfo(firstRowGroupKey), new ColumnStatistics(Long.valueOf(0L)));
        TestColumnStatistics.addIntStats(rowGroupStats2, firstStripeKey, 1L, 100L, 100L, 100L);
        TestColumnStatistics.addIntStats(rowGroupStats2, secondRowGroupKey, 1L, 22L, 22L, 22L);
        MapColumnStatisticsBuilder rowGroupStats3 = new MapColumnStatisticsBuilder(true);
        rowGroupStats3.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats3, everyRowKey, 2L, 5L, 6L, 11L);
        TestColumnStatistics.addIntStats(rowGroupStats3, thirdRowGroupKey, 1L, 33L, 33L, 33L);
        TestColumnStatistics.addIntStats(rowGroupStats3, secondStripeKey, 1L, 1000L, 1000L, 1000L);
        this.doTestFlatMapStatistics((Type)mapType, maps, fileStatistics.buildColumnStatistics(), rowGroupStats1.buildColumnStatistics(), rowGroupStats2.buildColumnStatistics(), rowGroupStats3.buildColumnStatistics());
    }

    @Test(dataProvider="mapKeyTypeProvider")
    public void testMapStatisticsWithNulls(Type mapKeyType) throws Exception {
        MapType mapType = (MapType)OrcTester.mapType(mapKeyType, (Type)BigintType.BIGINT);
        Object key = mapKeyType == BigintType.BIGINT ? Long.valueOf(0L) : "k0";
        Page maps = TestColumnStatistics.createMapPage(mapType, Arrays.asList(TestColumnStatistics.mapOf(key, 1L), TestColumnStatistics.mapOf(new Object[0]), null, TestColumnStatistics.mapOf(key, null), TestColumnStatistics.mapOf(key, null), TestColumnStatistics.mapOf(key, 2L)));
        MapColumnStatisticsBuilder fileStatistics = new MapColumnStatisticsBuilder(true);
        fileStatistics.increaseValueCount(5L);
        TestColumnStatistics.addIntStats(fileStatistics, key, 2L, 1L, 2L, 3L);
        MapColumnStatisticsBuilder rowGroupStats1 = new MapColumnStatisticsBuilder(true);
        rowGroupStats1.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats1, key, 1L, 1L, 1L, 1L);
        MapColumnStatisticsBuilder rowGroupStats2 = new MapColumnStatisticsBuilder(true);
        rowGroupStats2.increaseValueCount(1L);
        rowGroupStats2.addMapStatistics(TestColumnStatistics.keyInfo(key), new ColumnStatistics(Long.valueOf(0L)));
        MapColumnStatisticsBuilder rowGroupStats3 = new MapColumnStatisticsBuilder(true);
        rowGroupStats3.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats3, key, 1L, 2L, 2L, 2L);
        this.doTestFlatMapStatistics((Type)mapType, maps, fileStatistics.buildColumnStatistics(), rowGroupStats1.buildColumnStatistics(), rowGroupStats2.buildColumnStatistics(), rowGroupStats3.buildColumnStatistics());
    }

    @Test(dataProvider="mapKeyTypeProvider")
    public void testMapStatisticsWithNullsFullRowGroup(Type mapKeyType) throws Exception {
        MapType mapType = (MapType)OrcTester.mapType(mapKeyType, (Type)BigintType.BIGINT);
        Object key = mapKeyType == BigintType.BIGINT ? Long.valueOf(0L) : "k0";
        Page maps = TestColumnStatistics.createMapPage(mapType, Arrays.asList(TestColumnStatistics.mapOf(key, 1L), TestColumnStatistics.mapOf(new Object[0]), null, null, TestColumnStatistics.mapOf(key, null), TestColumnStatistics.mapOf(key, 2L)));
        MapColumnStatisticsBuilder fileStatistics = new MapColumnStatisticsBuilder(true);
        fileStatistics.increaseValueCount(4L);
        TestColumnStatistics.addIntStats(fileStatistics, key, 2L, 1L, 2L, 3L);
        MapColumnStatisticsBuilder rowGroupStats1 = new MapColumnStatisticsBuilder(true);
        rowGroupStats1.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats1, key, 1L, 1L, 1L, 1L);
        MapColumnStatisticsBuilder rowGroupStats2 = new MapColumnStatisticsBuilder(true);
        rowGroupStats2.increaseValueCount(0L);
        rowGroupStats2.addMapStatistics(TestColumnStatistics.keyInfo(key), new ColumnStatistics(Long.valueOf(0L)));
        MapColumnStatisticsBuilder rowGroupStats3 = new MapColumnStatisticsBuilder(true);
        rowGroupStats3.increaseValueCount(2L);
        TestColumnStatistics.addIntStats(rowGroupStats3, key, 1L, 2L, 2L, 2L);
        this.doTestFlatMapStatistics((Type)mapType, maps, fileStatistics.buildColumnStatistics(), rowGroupStats1.buildColumnStatistics(), rowGroupStats2.buildColumnStatistics(), rowGroupStats3.buildColumnStatistics());
    }

    private void doTestFlatMapStatistics(Type type, Page page, ColumnStatistics expectedFileStats, ColumnStatistics expectedRowGroupStats1, ColumnStatistics expectedRowGroupStats2, ColumnStatistics expectedRowGroupStats3) throws Exception {
        CapturingOrcFileIntrospector introspector;
        Assert.assertEquals((int)page.getPositionCount(), (int)6);
        try (TempFile tempFile = new TempFile();){
            this.writeFileForMapStatistics(type, page, tempFile);
            introspector = TestColumnStatistics.introspectOrcFile(type, tempFile);
        }
        List allFileStatistics = introspector.getFileFooter().getFileStats();
        ColumnStatistics actualFileStatistics = (ColumnStatistics)allFileStatistics.get(1);
        Assert.assertEquals((Object)actualFileStatistics, (Object)expectedFileStats);
        Assert.assertEquals((int)introspector.getStripes().size(), (int)2);
        Assert.assertEquals((int)introspector.getStripeInformations().size(), (int)2);
        Assert.assertEquals((int)introspector.getRowGroupIndexesByStripeOffset().size(), (int)2);
        Stripe stripe1 = introspector.getStripes().get(0);
        Stripe stripe2 = introspector.getStripes().get(1);
        Assert.assertEquals((long)stripe1.getRowCount(), (long)4L);
        Assert.assertEquals((long)stripe2.getRowCount(), (long)2L);
        long stripeOffset1 = introspector.getStripeInformations().get(0).getOffset();
        long stripeOffset2 = introspector.getStripeInformations().get(1).getOffset();
        Map<StreamId, List<RowGroupIndex>> stripeRowGroupIndexes1 = introspector.getRowGroupIndexesByStripeOffset().get(stripeOffset1);
        Map<StreamId, List<RowGroupIndex>> stripeRowGroupIndexes2 = introspector.getRowGroupIndexesByStripeOffset().get(stripeOffset2);
        this.assertNumberOfRowGroupStatistics(stripeRowGroupIndexes1, 2);
        this.assertNumberOfRowGroupStatistics(stripeRowGroupIndexes2, 1);
        ColumnStatistics actualRowGroupStats1 = this.getColumnRowGroupStats(stripeRowGroupIndexes1, 0);
        ColumnStatistics actualRowGroupStats2 = this.getColumnRowGroupStats(stripeRowGroupIndexes1, 1);
        ColumnStatistics actualRowGroupStats3 = this.getColumnRowGroupStats(stripeRowGroupIndexes2, 0);
        Assert.assertEquals((Object)actualRowGroupStats1, (Object)expectedRowGroupStats1);
        Assert.assertEquals((Object)actualRowGroupStats2, (Object)expectedRowGroupStats2);
        Assert.assertEquals((Object)actualRowGroupStats3, (Object)expectedRowGroupStats3);
    }

    private void assertNumberOfRowGroupStatistics(Map<StreamId, List<RowGroupIndex>> rowGroupIndexes, int size) {
        for (Map.Entry<StreamId, List<RowGroupIndex>> e : rowGroupIndexes.entrySet()) {
            Assert.assertEquals((int)e.getValue().size(), (int)size);
        }
    }

    private ColumnStatistics getColumnRowGroupStats(Map<StreamId, List<RowGroupIndex>> rowGroupIndexes, int rowGroupIndex) {
        ColumnStatistics columnStatistics = null;
        for (Map.Entry<StreamId, List<RowGroupIndex>> e : rowGroupIndexes.entrySet()) {
            if (e.getKey().getColumn() != 1) continue;
            Assert.assertNull(columnStatistics);
            columnStatistics = e.getValue().get(rowGroupIndex).getColumnStatistics();
        }
        Assert.assertNotNull(columnStatistics);
        return columnStatistics;
    }

    private static Page createMapPage(MapType type, List<Map<Object, Object>> maps) {
        Type keyType = type.getKeyType();
        Type valueType = type.getValueType();
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)type.createBlockBuilder(null, maps.size());
        BlockBuilder mapKeyBuilder = mapBlockBuilder.getKeyBlockBuilder();
        BlockBuilder mapValueBuilder = mapBlockBuilder.getValueBlockBuilder();
        for (Map<Object, Object> map : maps) {
            if (map == null) {
                mapBlockBuilder.appendNull();
                continue;
            }
            mapBlockBuilder.beginDirectEntry();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                TypeUtils.writeNativeValue((Type)keyType, (BlockBuilder)mapKeyBuilder, (Object)entry.getKey());
                TypeUtils.writeNativeValue((Type)valueType, (BlockBuilder)mapValueBuilder, (Object)entry.getValue());
            }
            mapBlockBuilder.closeEntry();
        }
        return new Page(new Block[]{mapBlockBuilder.build()});
    }

    private void writeFileForMapStatistics(Type type, Page page, TempFile file) throws IOException {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(4).build();
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)flushPolicy).withRowGroupMaxRowCount(2).withFlattenedColumns((Set)ImmutableSet.of((Object)0)).withMapStatisticsEnabled(true).build();
        try (OrcWriter orcWriter = OrcTester.createOrcWriter(file.getFile(), OrcEncoding.DWRF, CompressionKind.ZLIB, Optional.empty(), (List<Type>)ImmutableList.of((Object)type), writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);){
            orcWriter.write(page);
        }
    }

    private static CapturingOrcFileIntrospector introspectOrcFile(Type type, TempFile file) throws IOException {
        FileOrcDataSource dataSource = new FileOrcDataSource(file.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReaderOptions readerOptions = OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withReadMapStatistics(true).build();
        CapturingOrcFileIntrospector introspector = new CapturingOrcFileIntrospector();
        OrcReader reader = new OrcReader((OrcDataSource)dataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), Optional.empty(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, readerOptions, false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats(), Optional.of(introspector));
        OrcSelectiveRecordReader recordReader = reader.createSelectiveRecordReader((Map)ImmutableMap.of((Object)0, (Object)type), (List)ImmutableList.of((Object)0), Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), OrcPredicate.TRUE, 0L, dataSource.getSize(), DateTimeZone.UTC, (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, Optional.empty(), 1000);
        while (recordReader.getNextPage() != null) {
        }
        recordReader.close();
        dataSource.close();
        return introspector;
    }

    private static DwrfProto.KeyInfo keyInfo(Object key) {
        if (key instanceof Long) {
            return DwrfProto.KeyInfo.newBuilder().setIntKey(((Long)key).longValue()).build();
        }
        return DwrfProto.KeyInfo.newBuilder().setBytesKey(ByteString.copyFromUtf8((String)((String)key))).build();
    }

    private static void addIntStats(MapColumnStatisticsBuilder stats, Object key, long numberOfValues, long min, long max, long sum) {
        stats.addMapStatistics(TestColumnStatistics.keyInfo(key), (ColumnStatistics)new IntegerColumnStatistics(Long.valueOf(numberOfValues), null, new IntegerStatistics(Long.valueOf(min), Long.valueOf(max), Long.valueOf(sum))));
    }

    private static Map<Object, Object> mapOf(Object ... values) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }
}

