/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.writer.CompressionBufferPool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.OptionalInt;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnWriterOptions {
    @Test
    public void testProperties() {
        CompressionKind compressionKind = CompressionKind.ZSTD;
        OptionalInt compressionLevel = OptionalInt.of(3);
        DataSize compressionMaxBufferSize = DataSize.valueOf((String)"56kB");
        DataSize stringStatisticsLimit = DataSize.valueOf((String)"17MB");
        boolean integerDictionaryEncodingEnabled = true;
        boolean stringDictionarySortingEnabled = true;
        boolean stringDictionaryEncodingEnabled = true;
        boolean ignoreDictionaryRowGroupSizes = true;
        int preserveDirectEncodingStripeCount = 27;
        CompressionBufferPool.LastUsedCompressionBufferPool compressionBufferPool = new CompressionBufferPool.LastUsedCompressionBufferPool();
        ImmutableSet flattenedNodes = ImmutableSet.of((Object)1, (Object)5);
        boolean mapStatisticsEnabled = true;
        int maxFlattenedMapKeyCount = 27;
        ColumnWriterOptions options = ColumnWriterOptions.builder().setCompressionKind(compressionKind).setCompressionLevel(compressionLevel).setCompressionMaxBufferSize(compressionMaxBufferSize).setStringStatisticsLimit(stringStatisticsLimit).setIntegerDictionaryEncodingEnabled(integerDictionaryEncodingEnabled).setStringDictionarySortingEnabled(stringDictionarySortingEnabled).setStringDictionaryEncodingEnabled(stringDictionaryEncodingEnabled).setIgnoreDictionaryRowGroupSizes(ignoreDictionaryRowGroupSizes).setPreserveDirectEncodingStripeCount(preserveDirectEncodingStripeCount).setCompressionBufferPool((CompressionBufferPool)compressionBufferPool).setFlattenedNodes((Set)flattenedNodes).setMapStatisticsEnabled(mapStatisticsEnabled).setMaxFlattenedMapKeyCount(maxFlattenedMapKeyCount).build();
        boolean checkDisabledDictionaryEncoding = false;
        for (ColumnWriterOptions actual : ImmutableList.of((Object)options, (Object)options.copyWithDisabledDictionaryEncoding())) {
            Assert.assertEquals((Object)actual.getCompressionKind(), (Object)compressionKind);
            Assert.assertEquals((Object)actual.getCompressionLevel(), (Object)compressionLevel);
            Assert.assertEquals((int)actual.getCompressionMaxBufferSize(), (int)Math.toIntExact(compressionMaxBufferSize.toBytes()));
            Assert.assertEquals((int)actual.getStringStatisticsLimit(), (int)Math.toIntExact(stringStatisticsLimit.toBytes()));
            Assert.assertEquals((boolean)actual.isStringDictionarySortingEnabled(), (boolean)stringDictionarySortingEnabled);
            Assert.assertEquals((boolean)actual.isIgnoreDictionaryRowGroupSizes(), (boolean)ignoreDictionaryRowGroupSizes);
            Assert.assertEquals((int)actual.getPreserveDirectEncodingStripeCount(), (int)preserveDirectEncodingStripeCount);
            Assert.assertEquals((Object)actual.getCompressionBufferPool(), (Object)compressionBufferPool);
            Assert.assertEquals((Set)actual.getFlattenedNodes(), (Set)flattenedNodes);
            Assert.assertEquals((boolean)actual.isMapStatisticsEnabled(), (boolean)mapStatisticsEnabled);
            Assert.assertEquals((int)actual.getMaxFlattenedMapKeyCount(), (int)maxFlattenedMapKeyCount);
            if (checkDisabledDictionaryEncoding) {
                Assert.assertFalse((boolean)actual.isStringDictionaryEncodingEnabled());
                Assert.assertFalse((boolean)actual.isIntegerDictionaryEncodingEnabled());
            } else {
                Assert.assertEquals((boolean)actual.isStringDictionaryEncodingEnabled(), (boolean)stringDictionaryEncodingEnabled);
                Assert.assertEquals((boolean)actual.isIntegerDictionaryEncodingEnabled(), (boolean)integerDictionaryEncodingEnabled);
            }
            checkDisabledDictionaryEncoding = true;
        }
    }
}

