/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.AbstractOrcRecordReader;
import com.facebook.presto.orc.AbstractTestOrcReader;
import com.facebook.presto.orc.DiskRange;
import com.facebook.presto.orc.DwrfEncryptionInfo;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.DwrfWriterEncryption;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPermissionsException;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeReader;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingPlainKeyEncryptionLibrary;
import com.facebook.presto.orc.UnsupportedEncryptionLibrary;
import com.facebook.presto.orc.WriterEncryptionGroup;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.DwrfEncryption;
import com.facebook.presto.orc.metadata.EncryptionGroup;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.KeyProvider;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDecryption {
    private static final List<byte[]> A_KEYS = ImmutableList.of((Object)"key1a".getBytes(), (Object)"key2a".getBytes());
    private static final List<byte[]> B_KEYS = ImmutableList.of((Object)"key1b".getBytes(), (Object)"key2b".getBytes());
    private static final StripeInformation A_STRIPE = new StripeInformation(1L, 2L, 3L, 4L, 5L, OptionalLong.empty(), A_KEYS);
    private static final StripeInformation NO_KEYS_STRIPE = new StripeInformation(1L, 2L, 3L, 4L, 5L, OptionalLong.empty(), (List)ImmutableList.of());
    private static final StripeInformation B_STRIPE = new StripeInformation(1L, 2L, 3L, 4L, 5L, OptionalLong.empty(), B_KEYS);
    private static final OrcType ROW_TYPE = new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)7), (List)ImmutableList.of((Object)"col_int", (Object)"col_list", (Object)"col_map", (Object)"col_row"), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcType ROW_TYPE2 = new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)"sub_row1"), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcType ROW_TYPE3 = new OrcType(OrcType.OrcTypeKind.STRUCT, (List)ImmutableList.of((Object)9, (Object)10), (List)ImmutableList.of((Object)"sub_int1", (Object)"sub_int2"), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcType INT_TYPE = new OrcType(OrcType.OrcTypeKind.INT, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcType LIST_TYPE = new OrcType(OrcType.OrcTypeKind.LIST, (List)ImmutableList.of((Object)3), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcType MAP_TYPE = new OrcType(OrcType.OrcTypeKind.MAP, (List)ImmutableList.of((Object)5, (Object)6), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());

    @Test
    public void testValidateEncrypted() {
        ImmutableList encryptionGroups = ImmutableList.of((Object)new EncryptionGroup((List)ImmutableList.of((Object)1, (Object)3), Optional.empty(), (List)ImmutableList.of((Object)Slices.EMPTY_SLICE, (Object)Slices.EMPTY_SLICE)), (Object)new EncryptionGroup((List)ImmutableList.of((Object)4), Optional.empty(), (List)ImmutableList.of((Object)Slices.EMPTY_SLICE)));
        Optional<DwrfEncryption> encryption = Optional.of(new DwrfEncryption(KeyProvider.UNKNOWN, (List)encryptionGroups));
        Footer footer = this.createFooterWithEncryption((List<StripeInformation>)ImmutableList.of((Object)A_STRIPE, (Object)NO_KEYS_STRIPE), encryption);
        OrcReader.validateEncryption((Footer)footer, (OrcDataSourceId)new OrcDataSourceId("1"));
    }

    @Test
    public void testValidateUnencrypted() {
        Footer footer = this.createFooterWithEncryption((List<StripeInformation>)ImmutableList.of((Object)NO_KEYS_STRIPE), Optional.empty());
        OrcReader.validateEncryption((Footer)footer, (OrcDataSourceId)new OrcDataSourceId("1"));
    }

    @Test(expectedExceptions={OrcCorruptionException.class})
    public void testValidateMissingStripeKeys() {
        ImmutableList encryptionGroups = ImmutableList.of((Object)new EncryptionGroup((List)ImmutableList.of((Object)1, (Object)3), Optional.empty(), (List)ImmutableList.of((Object)Slices.EMPTY_SLICE, (Object)Slices.EMPTY_SLICE)), (Object)new EncryptionGroup((List)ImmutableList.of((Object)4), Optional.empty(), (List)ImmutableList.of((Object)Slices.EMPTY_SLICE)));
        Optional<DwrfEncryption> encryption = Optional.of(new DwrfEncryption(KeyProvider.UNKNOWN, (List)encryptionGroups));
        Footer footer = this.createFooterWithEncryption((List<StripeInformation>)ImmutableList.of((Object)NO_KEYS_STRIPE), encryption);
        OrcReader.validateEncryption((Footer)footer, (OrcDataSourceId)new OrcDataSourceId("1"));
    }

    @Test(expectedExceptions={OrcCorruptionException.class})
    public void testValidateMismatchedGroups() {
        ImmutableList encryptionGroups = ImmutableList.of((Object)new EncryptionGroup((List)ImmutableList.of((Object)1, (Object)3), Optional.empty(), (List)ImmutableList.of((Object)Slices.EMPTY_SLICE, (Object)Slices.EMPTY_SLICE)));
        Optional<DwrfEncryption> encryption = Optional.of(new DwrfEncryption(KeyProvider.UNKNOWN, (List)encryptionGroups));
        Footer footer = this.createFooterWithEncryption((List<StripeInformation>)ImmutableList.of((Object)A_STRIPE), encryption);
        OrcReader.validateEncryption((Footer)footer, (OrcDataSourceId)new OrcDataSourceId("1"));
    }

    private Footer createFooterWithEncryption(List<StripeInformation> stripes, Optional<DwrfEncryption> encryption) {
        ImmutableList types = ImmutableList.of((Object)ROW_TYPE, (Object)INT_TYPE, (Object)LIST_TYPE, (Object)INT_TYPE, (Object)MAP_TYPE, (Object)INT_TYPE, (Object)INT_TYPE);
        return new Footer(1L, 2, OptionalLong.empty(), stripes, (List)types, (List)ImmutableList.of(), (Map)ImmutableMap.of(), encryption, Optional.empty());
    }

    @Test
    public void testCreateNodeToGroupMap() {
        ImmutableList encryptionGroups = ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)3), (Object)ImmutableList.of((Object)4), (Object)ImmutableList.of((Object)7));
        ImmutableList types = ImmutableList.of((Object)ROW_TYPE, (Object)INT_TYPE, (Object)LIST_TYPE, (Object)INT_TYPE, (Object)MAP_TYPE, (Object)INT_TYPE, (Object)INT_TYPE, (Object)ROW_TYPE2, (Object)ROW_TYPE3, (Object)INT_TYPE, (Object)INT_TYPE);
        Map actual = DwrfEncryptionInfo.createNodeToGroupMap((List)encryptionGroups, (List)types);
        ImmutableMap expected = ImmutableMap.builder().put((Object)1, (Object)0).put((Object)3, (Object)0).put((Object)4, (Object)1).put((Object)5, (Object)1).put((Object)6, (Object)1).put((Object)7, (Object)2).put((Object)8, (Object)2).put((Object)9, (Object)2).put((Object)10, (Object)2).build();
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testGetStripeDecryptionKeys() {
        ImmutableList encryptedStripes = ImmutableList.of((Object)A_STRIPE, (Object)NO_KEYS_STRIPE, (Object)B_STRIPE, (Object)NO_KEYS_STRIPE);
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)0, (List)encryptedStripes), A_KEYS);
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)1, (List)encryptedStripes), A_KEYS);
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)2, (List)encryptedStripes), B_KEYS);
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)3, (List)encryptedStripes), B_KEYS);
    }

    @Test
    public void testGetStripeDecryptionKeysUnencrypted() {
        ImmutableList unencryptedStripes = ImmutableList.of((Object)NO_KEYS_STRIPE, (Object)NO_KEYS_STRIPE);
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)0, (List)unencryptedStripes), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)AbstractOrcRecordReader.getDecryptionKeyMetadata((int)1, (List)unencryptedStripes), (Collection)ImmutableList.of());
    }

    @Test
    public void testGetDiskRanges() {
        ImmutableList unencryptedStreams = ImmutableList.of((Object)new Stream(3, Stream.StreamKind.ROW_INDEX, 5, true, 0, Optional.of(15L)), (Object)new Stream(4, 0, Stream.StreamKind.ROW_INDEX, 5, true), (Object)new Stream(3, Stream.StreamKind.DATA, 5, true, 0, Optional.of(45L)), (Object)new Stream(4, 0, Stream.StreamKind.DATA, 5, true));
        ImmutableList group1Streams = ImmutableList.of((Object)new Stream(0, 0, Stream.StreamKind.ROW_INDEX, 5, true), (Object)new Stream(5, Stream.StreamKind.ROW_INDEX, 5, true, 0, Optional.of(25L)), (Object)new Stream(0, Stream.StreamKind.DATA, 5, true, 0, Optional.of(30L)), (Object)new Stream(5, Stream.StreamKind.DATA, 5, true, 0, Optional.of(55L)));
        ImmutableList group2Streams = ImmutableList.of((Object)new Stream(1, Stream.StreamKind.ROW_INDEX, 5, true, 0, Optional.of(5L)), (Object)new Stream(2, 0, Stream.StreamKind.ROW_INDEX, 5, true), (Object)new Stream(1, Stream.StreamKind.DATA, 5, true, 0, Optional.of(35L)), (Object)new Stream(2, 0, Stream.StreamKind.DATA, 5, true));
        Map actual = StripeReader.getDiskRanges((List)ImmutableList.of((Object)unencryptedStreams, (Object)group1Streams, (Object)group2Streams));
        ImmutableMap expected = ImmutableMap.builder().put((Object)new StreamId(0, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(0L, 5)).put((Object)new StreamId(1, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(5L, 5)).put((Object)new StreamId(2, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(10L, 5)).put((Object)new StreamId(3, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(15L, 5)).put((Object)new StreamId(4, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(20L, 5)).put((Object)new StreamId(5, 0, Stream.StreamKind.ROW_INDEX), (Object)new DiskRange(25L, 5)).put((Object)new StreamId(0, 0, Stream.StreamKind.DATA), (Object)new DiskRange(30L, 5)).put((Object)new StreamId(1, 0, Stream.StreamKind.DATA), (Object)new DiskRange(35L, 5)).put((Object)new StreamId(2, 0, Stream.StreamKind.DATA), (Object)new DiskRange(40L, 5)).put((Object)new StreamId(3, 0, Stream.StreamKind.DATA), (Object)new DiskRange(45L, 5)).put((Object)new StreamId(4, 0, Stream.StreamKind.DATA), (Object)new DiskRange(50L, 5)).put((Object)new StreamId(5, 0, Stream.StreamKind.DATA), (Object)new DiskRange(55L, 5)).build();
        Assert.assertEquals((Map)actual, (Map)expected);
    }

    @Test
    public void testMultipleEncryptionGroupsRowType() throws Exception {
        Type rowType = OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        Slice iek2 = Slices.utf8Slice((String)"iek2");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)2), iek1), (Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)3), iek2)));
        ImmutableList types = ImmutableList.of((Object)rowType);
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        ImmutableList values = ImmutableList.of(columnValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)2, (Object)iek1, (Object)3, (Object)iek2), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)rowType), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testSingleEncryptionGroupRowType() throws Exception {
        Type rowType = OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)1), iek1)));
        ImmutableList types = ImmutableList.of((Object)rowType);
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        ImmutableList values = ImmutableList.of(columnValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)rowType), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testEncryptionGroupWithMultipleTypes() throws Exception {
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)1, (Object)2), iek1)));
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        List intValues = (List)ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(ImmutableList.toImmutableList());
        List varcharValues = (List)ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(String::valueOf).collect(ImmutableList.toImmutableList());
        ImmutableList values = ImmutableList.of((Object)intValues, (Object)varcharValues);
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1, (Object)2, (Object)iek1), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT, (Object)1, (Object)VarcharType.VARCHAR), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testEncryptionGroupWithReversedOrderNodes() throws Exception {
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)2, (Object)1), iek1)));
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR);
        List intValues = (List)ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(ImmutableList.toImmutableList());
        List varcharValues = (List)ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(String::valueOf).collect(ImmutableList.toImmutableList());
        ImmutableList values = ImmutableList.of((Object)intValues, (Object)varcharValues);
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1, (Object)2, (Object)iek1), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT, (Object)1, (Object)VarcharType.VARCHAR), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testMultipleEncryptionGroupsMultipleColumns() throws Exception {
        Type rowType = OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        Slice iek2 = Slices.utf8Slice((String)"iek2");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)1, (Object)8), iek1), (Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)5, (Object)9, (Object)10), iek2)));
        ImmutableList types = ImmutableList.of((Object)rowType, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        List varcharValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(String::valueOf).collect(Collectors.toList());
        List rowValues = columnValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList());
        ImmutableList values = ImmutableList.of(rowValues, columnValues, varcharValues, varcharValues, columnValues, varcharValues, columnValues, columnValues);
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1, (Object)5, (Object)iek2, (Object)8, (Object)iek1, (Object)9, (Object)iek2, (Object)10, (Object)iek2), (Map<Integer, Type>)ImmutableMap.builder().put((Object)0, (Object)rowType).put((Object)1, (Object)BigintType.BIGINT).put((Object)2, (Object)VarcharType.VARCHAR).put((Object)3, (Object)VarcharType.VARCHAR).put((Object)4, (Object)BigintType.BIGINT).put((Object)5, (Object)VarcharType.VARCHAR).put((Object)6, (Object)BigintType.BIGINT).put((Object)7, (Object)BigintType.BIGINT).build(), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testEncryptionMultipleColumns() throws Exception {
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ImmutableList values = ImmutableList.of(columnValues, columnValues);
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        Slice iek2 = Slices.utf8Slice((String)"iek2");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)1), iek1), (Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)2), iek2)));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1, (Object)2, (Object)iek2), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT, (Object)1, (Object)BigintType.BIGINT), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testSkipFirstStripe() throws Exception {
        FileOrcDataSource orcDataSource = new FileOrcDataSource(new File(Resources.getResource((String)"encrypted_2splits.dwrf").getFile()), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderOptions.builder().withMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withTinyStripeThreshold(new DataSize(1.0, DataSize.Unit.MEGABYTE)).withMaxBlockSize(OrcTester.MAX_BLOCK_SIZE).build(), false, new DwrfEncryptionProvider((EncryptionLibrary)new UnsupportedEncryptionLibrary(), (EncryptionLibrary)new TestingPlainKeyEncryptionLibrary()), DwrfKeyProvider.of((Map)ImmutableMap.of((Object)0, (Object)Slices.utf8Slice((String)"key"))), new RuntimeStats());
        int offset = 10;
        try (OrcSelectiveRecordReader recordReader = TestDecryption.getSelectiveRecordReader((OrcDataSource)orcDataSource, orcReader, offset);){
            OrcTester.assertFileContentsPresto((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), recordReader, ImmutableList.of((Object)ImmutableList.of((Object)1L)), (List<Integer>)ImmutableList.of((Object)0));
        }
    }

    @Test(expectedExceptions={OrcPermissionsException.class})
    public void testPermissionErrorForEncryptedWithoutKeys() throws Exception {
        ImmutableList types = ImmutableList.of((Object)OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}));
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        ImmutableList values = ImmutableList.of(columnValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()));
        Slice iek = Slices.utf8Slice((String)"iek");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)0), iek)));
        List outputColumns = (List)IntStream.range(0, types.size()).boxed().collect(ImmutableList.toImmutableList());
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of(), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT})), (Map<Integer, List<Subfield>>)ImmutableMap.of(), outputColumns);
    }

    @Test
    public void testReadPermittedColumnsWithoutAllKeys() throws Exception {
        Subfield subfield1 = new Subfield("c.field_0");
        Subfield subfield3 = new Subfield("c.field_2");
        Type rowType = OrcTester.rowType(new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT});
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        Slice iek2 = Slices.utf8Slice((String)"iek2");
        Slice iek3 = Slices.utf8Slice((String)"iek3");
        DwrfWriterEncryption dwrfWriterEncryption = new DwrfWriterEncryption(KeyProvider.UNKNOWN, (List)ImmutableList.of((Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)2), iek1), (Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)3, (Object)6), iek2), (Object)new WriterEncryptionGroup((List)ImmutableList.of((Object)5), iek3)));
        ImmutableList types = ImmutableList.of((Object)rowType, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        List columnValues = ImmutableList.copyOf(AbstractTestOrcReader.intsBetween(0, 31234)).stream().map(Number::longValue).collect(Collectors.toList());
        ImmutableList writtenValues = ImmutableList.of(columnValues.stream().map(OrcTester::toHiveStruct).collect(Collectors.toList()), columnValues, columnValues, columnValues);
        ImmutableList readValues = ImmutableList.of(columnValues.stream().map(value -> Arrays.asList(value, null, value)).collect(Collectors.toList()), columnValues, columnValues);
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, writtenValues, readValues, Optional.of(dwrfWriterEncryption), (Map<Integer, Slice>)ImmutableMap.of((Object)2, (Object)iek1, (Object)5, (Object)iek3), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)rowType, (Object)1, (Object)BigintType.BIGINT, (Object)3, (Object)BigintType.BIGINT), (Map<Integer, List<Subfield>>)ImmutableMap.of((Object)0, (Object)ImmutableList.of((Object)subfield1, (Object)subfield3)), (List<Integer>)ImmutableList.of((Object)0, (Object)1, (Object)3));
    }

    @Test
    public void testReadsEmptyFile() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        ImmutableList values = ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of());
        Slice iek1 = Slices.utf8Slice((String)"iek1");
        Slice iek2 = Slices.utf8Slice((String)"iek2");
        ImmutableList outputColumns = ImmutableList.of((Object)0, (Object)1);
        TestDecryption.testDecryptionRoundTrip((List<Type>)types, values, values, Optional.empty(), (Map<Integer, Slice>)ImmutableMap.of((Object)1, (Object)iek1, (Object)2, (Object)iek2), (Map<Integer, Type>)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT, (Object)1, (Object)BigintType.BIGINT), (Map<Integer, List<Subfield>>)ImmutableMap.of(), (List<Integer>)outputColumns);
    }

    private static void testDecryptionRoundTrip(List<Type> types, List<List<?>> writtenValues, List<List<?>> readValues, Optional<DwrfWriterEncryption> dwrfWriterEncryption, Map<Integer, Slice> readerIntermediateKeys, Map<Integer, Type> includedColumns, Map<Integer, List<Subfield>> requiredSubfields, List<Integer> outputColumns) throws Exception {
        try (TempFile tempFile = new TempFile();){
            OrcTester.writeOrcColumnsPresto(tempFile.getFile(), OrcTester.Format.DWRF, CompressionKind.ZSTD, dwrfWriterEncryption, types, writtenValues, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
            OrcTester.assertFileContentsPresto(types, tempFile.getFile(), readValues, OrcEncoding.DWRF, OrcPredicate.TRUE, Optional.empty(), (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), requiredSubfields, readerIntermediateKeys, includedColumns, outputColumns);
            TestDecryption.validateFileStatistics(tempFile, dwrfWriterEncryption, readerIntermediateKeys);
        }
    }

    private static void validateFileStatistics(TempFile tempFile, Optional<DwrfWriterEncryption> dwrfWriterEncryption, Map<Integer, Slice> readerIntermediateKeys) throws IOException {
        OrcReader readerNoKeys = OrcTester.createCustomOrcReader(tempFile, OrcEncoding.DWRF, false, (Map<Integer, Slice>)ImmutableMap.of());
        if (readerNoKeys.getFooter().getStripes().isEmpty()) {
            Assert.assertEquals((int)readerNoKeys.getFooter().getFileStats().size(), (int)0);
            return;
        }
        if (dwrfWriterEncryption.isPresent()) {
            List types = readerNoKeys.getTypes();
            List fileStatsNoKey = readerNoKeys.getFooter().getFileStats();
            Assert.assertEquals((int)fileStatsNoKey.size(), (int)types.size());
            Set allEncryptedNodes = dwrfWriterEncryption.get().getWriterEncryptionGroups().stream().flatMap(group -> group.getNodes().stream()).flatMap(node -> TestDecryption.collectNodeTree(types, node).stream()).collect(Collectors.toSet());
            for (Set readerKeyNodes : Sets.powerSet(readerIntermediateKeys.keySet())) {
                HashMap readerKeys = new HashMap();
                readerKeyNodes.forEach(node -> {
                    Slice cfr_ignored_0 = (Slice)readerKeys.put(node, readerIntermediateKeys.get(node));
                });
                Set decryptedNodes = readerKeys.keySet().stream().flatMap(node -> TestDecryption.collectNodeTree(types, node).stream()).collect(Collectors.toSet());
                Assert.assertTrue((boolean)allEncryptedNodes.containsAll(decryptedNodes));
                OrcReader readerWithKeys = OrcTester.createCustomOrcReader(tempFile, OrcEncoding.DWRF, false, readerIntermediateKeys);
                List fileStatsWithKey = readerWithKeys.getFooter().getFileStats();
                Assert.assertEquals((int)fileStatsWithKey.size(), (int)types.size());
                for (int node2 = 0; node2 < types.size(); ++node2) {
                    ColumnStatistics statsWithKey = (ColumnStatistics)fileStatsWithKey.get(node2);
                    ColumnStatistics statsNoKey = (ColumnStatistics)fileStatsNoKey.get(node2);
                    OrcType type = (OrcType)types.get(node2);
                    if (allEncryptedNodes.contains(node2)) {
                        Assert.assertTrue((boolean)TestDecryption.hasNoTypeStats(statsNoKey));
                    } else {
                        TestDecryption.assertStatsTypeMatch(statsNoKey, type);
                        TestDecryption.assertStatsTypeMatch(statsWithKey, type);
                        Assert.assertEquals((Object)statsNoKey, (Object)statsWithKey);
                    }
                    if (!decryptedNodes.contains(node2)) continue;
                    TestDecryption.assertStatsTypeMatch(statsWithKey, type);
                }
            }
        }
    }

    private static void assertStatsTypeMatch(ColumnStatistics stats, OrcType type) {
        OrcType.OrcTypeKind kind = type.getOrcTypeKind();
        if (kind == OrcType.OrcTypeKind.BINARY) {
            Assert.assertNotNull((Object)stats.getBinaryStatistics());
        } else if (kind == OrcType.OrcTypeKind.BOOLEAN) {
            Assert.assertNotNull((Object)stats.getBooleanStatistics());
        } else if (kind == OrcType.OrcTypeKind.BYTE || kind == OrcType.OrcTypeKind.SHORT || kind == OrcType.OrcTypeKind.INT || kind == OrcType.OrcTypeKind.LONG) {
            Assert.assertNotNull((Object)stats.getIntegerStatistics());
        } else if (kind == OrcType.OrcTypeKind.FLOAT || kind == OrcType.OrcTypeKind.DOUBLE) {
            Assert.assertNotNull((Object)stats.getDoubleStatistics());
        } else if (kind == OrcType.OrcTypeKind.STRING) {
            Assert.assertNotNull((Object)stats.getStringStatistics());
        } else {
            Assert.assertTrue((boolean)TestDecryption.hasNoTypeStats(stats));
        }
    }

    private static boolean hasNoTypeStats(ColumnStatistics columnStatistics) {
        return columnStatistics.getBooleanStatistics() == null && columnStatistics.getIntegerStatistics() == null && columnStatistics.getDoubleStatistics() == null && columnStatistics.getStringStatistics() == null && columnStatistics.getDateStatistics() == null && columnStatistics.getDecimalStatistics() == null && columnStatistics.getBinaryStatistics() == null;
    }

    private static Set<Integer> collectNodeTree(List<OrcType> types, int node) {
        HashSet<Integer> nodes = new HashSet<Integer>();
        TestDecryption.collectNodeTree(nodes, types, node);
        return nodes;
    }

    private static void collectNodeTree(Set<Integer> nodes, List<OrcType> types, int node) {
        nodes.add(node);
        for (Integer subNode : types.get(node).getFieldTypeIndexes()) {
            TestDecryption.collectNodeTree(nodes, types, subNode);
        }
    }

    private static OrcSelectiveRecordReader getSelectiveRecordReader(OrcDataSource orcDataSource, OrcReader orcReader, int offset) {
        return orcReader.createSelectiveRecordReader((Map)ImmutableMap.of((Object)0, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), OrcPredicate.TRUE, (long)offset, orcDataSource.getSize(), OrcTester.HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), Optional.empty(), 1024);
    }
}

