/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.FlushReason;
import io.airlift.units.DataSize;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultOrcWriterFlushPolicy {
    @Test
    public void testFlushMaxStripeRowCount() {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(10).build();
        Assert.assertEquals((int)flushPolicy.getStripeMaxRowCount(), (int)10);
        Optional actual = flushPolicy.shouldFlushStripe(5, 0, false);
        Assert.assertFalse((boolean)actual.isPresent());
        actual = flushPolicy.shouldFlushStripe(10, 0, false);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals(actual.get(), (Object)FlushReason.MAX_ROWS);
        actual = flushPolicy.shouldFlushStripe(20, 0, false);
        Assert.assertFalse((boolean)actual.isPresent());
    }

    @Test
    public void testFlushMaxStripeSize() {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().withStripeMinSize(new DataSize(50.0, DataSize.Unit.BYTE)).withStripeMaxSize(new DataSize(100.0, DataSize.Unit.BYTE)).build();
        Assert.assertEquals((int)flushPolicy.getStripeMinBytes(), (int)50);
        Assert.assertEquals((int)flushPolicy.getStripeMaxBytes(), (int)100);
        Optional actual = flushPolicy.shouldFlushStripe(1, 90, false);
        Assert.assertFalse((boolean)actual.isPresent());
        actual = flushPolicy.shouldFlushStripe(1, 100, false);
        Assert.assertFalse((boolean)actual.isPresent());
        actual = flushPolicy.shouldFlushStripe(1, 200, false);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals(actual.get(), (Object)FlushReason.MAX_BYTES);
    }

    @Test
    public void testFlushDictionaryFull() {
        DefaultOrcWriterFlushPolicy flushPolicy = DefaultOrcWriterFlushPolicy.builder().build();
        Optional actual = flushPolicy.shouldFlushStripe(1, 1, false);
        Assert.assertFalse((boolean)actual.isPresent());
        actual = flushPolicy.shouldFlushStripe(1, 1, true);
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals(actual.get(), (Object)FlushReason.DICTIONARY_FULL);
    }
}

