/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DefaultOrcWriterFlushPolicy;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcSelectiveRecordReader;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterFlushPolicy;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryColumnWriter {
    private static final int COLUMN_ID = 1;
    private static final int BATCH_ROWS = 1000;
    private static final int STRIPE_MAX_ROWS = 15000;
    private static final int INTEGER_VALUES_DICTIONARY_BASE = 1000000000;
    private static final Random RANDOM = new Random();

    private static int megabytes(int size) {
        return Math.toIntExact(new DataSize((double)size, DataSize.Unit.MEGABYTE).toBytes());
    }

    private static int getStripeSize(int size) {
        if (size == 0) {
            return 0;
        }
        return (size - 1) / 15000 + 1;
    }

    @Test
    public void testStringNoRows() throws Exception {
        ImmutableList values = ImmutableList.of();
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, (List<String>)values);
            Assert.assertEquals((int)stripeFooters.size(), (int)TestDictionaryColumnWriter.getStripeSize(values.size()));
        }
    }

    @Test
    public void testStringAllNullsWithDirectConversion() throws Exception {
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{null}), (int)90000));
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            directConversionTester.add(7, TestDictionaryColumnWriter.megabytes(1), true);
            directConversionTester.add(14, TestDictionaryColumnWriter.megabytes(1), true);
            directConversionTester.add(32, TestDictionaryColumnWriter.megabytes(1), true);
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, values);
            this.verifyDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), input.getEncoding(), stripeFooters);
        }
    }

    @Test
    public void testStringRandomValuesWithNull() throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < 60000; ++i) {
            values.add(RANDOM.nextBoolean() ? null : UUID.randomUUID().toString());
        }
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, values);
            this.verifyDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), input.getEncoding(), stripeFooters);
        }
    }

    @Test
    public void testStringRandomRepeatingValues() throws Exception {
        int i;
        ArrayList<String> stripeValues = new ArrayList<String>();
        int dictionarySize = 1000;
        for (i = 0; i < dictionarySize; ++i) {
            stripeValues.add(UUID.randomUUID().toString());
        }
        for (i = dictionarySize; i < 15000; ++i) {
            stripeValues.add((String)stripeValues.get(RANDOM.nextInt(dictionarySize)));
        }
        Collections.shuffle(stripeValues);
        ArrayList<String> values = new ArrayList<String>(stripeValues);
        Collections.shuffle(stripeValues);
        values.addAll(stripeValues);
        Collections.shuffle(stripeValues);
        values.addAll(stripeValues);
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, values);
            this.verifyDictionaryEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), input.getEncoding(), stripeFooters, (List<Integer>)ImmutableList.of((Object)dictionarySize, (Object)dictionarySize, (Object)dictionarySize));
        }
    }

    @Test
    public void testStringNonRepeatingValues() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 60000; ++i) {
            builder.add((Object)Integer.toString(i));
        }
        ImmutableList values = builder.build();
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, (List<String>)values);
            this.verifyDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), input.getEncoding(), stripeFooters);
        }
    }

    @Test
    public void testStringIncreasedStrideSize() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 60000; ++i) {
            builder.add((Object)Integer.toString(i));
        }
        ImmutableList values = builder.build();
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            OrcWriterOptions writerOptions = OrcWriterOptions.builder().withRowGroupMaxRowCount(14876).withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).build();
            this.testDictionary((Type)VarcharType.VARCHAR, input.getEncoding(), writerOptions, directConversionTester, (List<?>)values);
        }
    }

    @Test
    public void testStringRepeatingValues() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 60000; ++i) {
            builder.add((Object)Integer.toString(i % 1000 + 1000000000));
        }
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            ImmutableList values = builder.build();
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, (List<String>)values);
            this.verifyDictionaryEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), input.getEncoding(), stripeFooters, (List<Integer>)ImmutableList.of((Object)1000, (Object)1000, (Object)1000, (Object)1000));
        }
    }

    @Test
    public void testStringRepeatingValuesWithDirectConversion() throws Exception {
        ArrayList<String> values = new ArrayList<String>(60000);
        for (int i = 0; i < 60000; ++i) {
            int offset = i % 2001;
            if (offset > 0) {
                values.add(Integer.toString(offset + 1000000000));
                continue;
            }
            values.add(null);
        }
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            DirectConversionTester directConversionTester = new DirectConversionTester();
            directConversionTester.add(0, TestDictionaryColumnWriter.megabytes(1), true);
            directConversionTester.add(16, 5000, false);
            directConversionTester.add(16, TestDictionaryColumnWriter.megabytes(1), true);
            List<StripeFooter> stripeFooters = this.testStringDictionary(directConversionTester, input, values);
            Assert.assertEquals((int)TestDictionaryColumnWriter.getStripeSize(values.size()), (int)stripeFooters.size());
            this.verifyDirectEncoding(stripeFooters, input.getEncoding(), 0);
            this.verifyDirectEncoding(stripeFooters, input.getEncoding(), 1);
            this.verifyDictionaryEncoding(stripeFooters, input.getEncoding(), 2, 2000);
            this.verifyDictionaryEncoding(stripeFooters, input.getEncoding(), 3, 2000);
        }
    }

    @Test
    public void testStringPreserveDirectEncoding() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i = 0L; i < 15000L; ++i) {
            builder.add((Object)Long.toString(Integer.MAX_VALUE + i));
        }
        int repeatInterval = 1500;
        for (long i = 0L; i < 100000L; ++i) {
            builder.add((Object)Long.toString(Integer.MAX_VALUE + i % (long)repeatInterval));
        }
        int preserveDirectEncodingStripeCount = 2;
        OrcWriterOptions.Builder orcWriterOptionsBuilder = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withIntegerDictionaryEncodingEnabled(true).withPreserveDirectEncodingStripeCount(preserveDirectEncodingStripeCount);
        ImmutableList values = builder.build();
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            int i;
            DirectConversionTester tester = new DirectConversionTester();
            OrcWriterOptions orcWriterOptions = orcWriterOptionsBuilder.withStringDictionarySortingEnabled(input.isSortStringDictionaryKeys()).build();
            List<StripeFooter> stripeFooters = this.testDictionary((Type)VarcharType.VARCHAR, input.getEncoding(), orcWriterOptions, tester, (List<?>)values);
            Assert.assertEquals((int)TestDictionaryColumnWriter.getStripeSize(values.size()), (int)stripeFooters.size());
            for (i = 0; i <= preserveDirectEncodingStripeCount; ++i) {
                this.verifyDirectEncoding(stripeFooters, input.getEncoding(), i);
            }
            for (i = preserveDirectEncodingStripeCount + 1; i < stripeFooters.size(); ++i) {
                this.verifyDictionaryEncoding(stripeFooters, input.getEncoding(), i, repeatInterval);
            }
        }
    }

    @Test
    public void testDisableStringDictionaryEncoding() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i = 0L; i < 45000L; ++i) {
            builder.add((Object)Long.toString(0L));
        }
        ImmutableList values = builder.build();
        this.testStringDirectColumn((List<String>)values);
    }

    @Test
    public void testDisableStringOnlyNulls() throws IOException {
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{null}), (int)45000));
        this.testStringDirectColumn(values);
    }

    @Test
    public void testDisableStringMixedNulls() throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < 50000; ++i) {
            int childSize = i % 5;
            if (childSize == 4) {
                values.add(null);
            }
            values.add(Integer.toString(i));
        }
        this.testStringDirectColumn(values);
    }

    private void testStringDirectColumn(List<String> values) throws IOException {
        long totalRows = values.size();
        for (StringDictionaryInput input : StringDictionaryInput.values()) {
            OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withStringDictionaryEncodingEnabled(false).withStringDictionarySortingEnabled(input.isSortStringDictionaryKeys()).build();
            DirectConversionTester tester = new DirectConversionTester();
            List<StripeFooter> stripeFooters = this.testDictionary((Type)VarcharType.VARCHAR, input.getEncoding(), orcWriterOptions, tester, values);
            int index = 0;
            for (long rows = 0L; rows < totalRows; rows += 15000L) {
                this.verifyDirectEncoding(stripeFooters, input.getEncoding(), index++);
            }
            Assert.assertEquals((int)stripeFooters.size(), (int)index);
        }
    }

    @Test
    public void testIntegerNoRows() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ImmutableList values = ImmutableList.of();
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, (List<?>)values);
        Assert.assertEquals((int)stripeFooters.size(), (int)TestDictionaryColumnWriter.getStripeSize(values.size()));
    }

    @Test
    public void testIntegerDictionaryAllNulls() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        directConversionTester.add(7, TestDictionaryColumnWriter.megabytes(1), true);
        directConversionTester.add(14, TestDictionaryColumnWriter.megabytes(1), true);
        directConversionTester.add(32, TestDictionaryColumnWriter.megabytes(1), true);
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Integer[]{null}), (int)60000));
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, values);
        this.verifyDwrfDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), stripeFooters);
    }

    @Test
    public void testIntegerDictionaryAlternatingNulls() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ArrayList values = Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Integer[]{Integer.MAX_VALUE, null, Integer.MIN_VALUE}), (int)60000));
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, values);
        this.verifyDictionaryEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), OrcEncoding.DWRF, stripeFooters, (List<Integer>)ImmutableList.of((Object)2, (Object)2, (Object)2, (Object)2));
    }

    @Test
    public void testIntegerRandomValues() throws IOException {
        List<Integer> values = this.generateRandomIntegers(70000);
        DirectConversionTester directConversionTester = new DirectConversionTester();
        this.testIntegerDictionary(directConversionTester, values);
    }

    @Test
    public void testIntegerIncreasedStrideSize() throws IOException {
        List<Integer> values = this.generateRandomIntegers(90000);
        DirectConversionTester directConversionTester = new DirectConversionTester();
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withIntegerDictionaryEncodingEnabled(true).withRowGroupMaxRowCount(14998).build();
        this.testDictionary((Type)IntegerType.INTEGER, OrcEncoding.DWRF, writerOptions, directConversionTester, values);
    }

    private List<Integer> generateRandomIntegers(int maxSize) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < maxSize; ++i) {
            values.add(RANDOM.nextBoolean() ? null : Integer.valueOf(RANDOM.nextInt()));
        }
        return values;
    }

    @Test
    public void testDictionaryRetainedSizeWithDifferentSettings() {
        DictionaryColumnWriter ignoredRowGroupWriter = TestDictionaryColumnWriter.getStringDictionaryColumnWriter(true);
        DictionaryColumnWriter withRowGroupWriter = TestDictionaryColumnWriter.getStringDictionaryColumnWriter(false);
        int numEntries = 10000;
        int numBlocks = 10;
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, numEntries);
        Slice slice = Slices.utf8Slice((String)"SomeString");
        for (int i = 0; i < numEntries; ++i) {
            VarcharType.VARCHAR.writeSlice(blockBuilder, slice);
        }
        Block block = blockBuilder.build();
        for (int i = 0; i < numBlocks; ++i) {
            this.writeBlock(ignoredRowGroupWriter, block);
            this.writeBlock(withRowGroupWriter, block);
        }
        long ignoredRowGroupBytes = ignoredRowGroupWriter.getRowGroupRetainedSizeInBytes();
        long withRowGroupBytes = withRowGroupWriter.getRowGroupRetainedSizeInBytes();
        long expectedDictionaryIndexSize = numBlocks * numEntries * 1;
        String message = String.format("Ignored bytes %s With bytes %s", ignoredRowGroupBytes, withRowGroupBytes);
        Assert.assertTrue((ignoredRowGroupBytes + expectedDictionaryIndexSize <= withRowGroupBytes ? 1 : 0) != 0, (String)message);
    }

    private void writeBlock(DictionaryColumnWriter writer, Block block) {
        writer.beginRowGroup();
        writer.writeBlock(block);
        writer.finishRowGroup();
    }

    @Test
    public void testLongRandomValues() throws IOException {
        List<Long> values = this.generateRandomLongs(70000);
        DirectConversionTester directConversionTester = new DirectConversionTester();
        this.testLongDictionary(directConversionTester, values);
    }

    @Test
    public void testLongIncreasedStrideSize() throws IOException {
        List<Long> values = this.generateRandomLongs(80000);
        DirectConversionTester directConversionTester = new DirectConversionTester();
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withIntegerDictionaryEncodingEnabled(true).withRowGroupMaxRowCount(14998).build();
        this.testDictionary((Type)BigintType.BIGINT, OrcEncoding.DWRF, writerOptions, directConversionTester, values);
    }

    private static DictionaryColumnWriter getStringDictionaryColumnWriter(boolean ignoreRowGroupSizes) {
        OrcEncoding orcEncoding = OrcEncoding.DWRF;
        ColumnWriterOptions columnWriterOptions = ColumnWriterOptions.builder().setCompressionKind(CompressionKind.SNAPPY).setIgnoreDictionaryRowGroupSizes(ignoreRowGroupSizes).build();
        return new SliceDictionaryColumnWriter(1, 0, (Type)VarcharType.VARCHAR, columnWriterOptions, Optional.empty(), orcEncoding, orcEncoding.createMetadataWriter());
    }

    private List<Long> generateRandomLongs(int maxSize) {
        ArrayList<Long> values = new ArrayList<Long>();
        for (int i = 0; i < maxSize; ++i) {
            values.add(RANDOM.nextBoolean() ? null : Long.valueOf(RANDOM.nextLong()));
        }
        return values;
    }

    @Test
    public void testIntegerDictionaryRepeatingValues() throws IOException {
        ImmutableList baseList = ImmutableList.of((Object)Integer.MAX_VALUE, (Object)Integer.MIN_VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)baseList);
        int repeatInterval = 1500;
        for (int i = baseList.size(); i < 45000; ++i) {
            builder.add((Object)(1000000000 + i % repeatInterval));
        }
        ImmutableList values = builder.build();
        DirectConversionTester directConversionTester = new DirectConversionTester();
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, (List<?>)values);
        this.verifyDictionaryEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), OrcEncoding.DWRF, stripeFooters, (List<Integer>)ImmutableList.of((Object)(repeatInterval + baseList.size()), (Object)repeatInterval, (Object)repeatInterval));
        stripeFooters = this.testDictionary((Type)IntegerType.INTEGER, OrcEncoding.DWRF, false, true, new DirectConversionTester(), (List<?>)values);
        this.verifyDwrfDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), stripeFooters);
    }

    @Test
    public void testIntegerDictionaryNonRepeating() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ImmutableList baseList = ImmutableList.of((Object)Integer.MAX_VALUE, (Object)Integer.MIN_VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)baseList);
        for (int i = baseList.size(); i < 60000; ++i) {
            builder.add((Object)i);
        }
        ImmutableList values = builder.build();
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, (List<?>)values);
        this.verifyDwrfDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), stripeFooters);
    }

    @Test
    public void testIntegerDictionaryRepeatingValuesDirect() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        directConversionTester.add(0, 1000, false);
        directConversionTester.add(0, 4000, true);
        directConversionTester.add(16, 10000, true);
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.addAll(Arrays.asList(Integer.MAX_VALUE, Integer.MIN_VALUE));
        values.add(null);
        int repeatInterval = 1500;
        for (int i = values.size(); i < 60000; ++i) {
            values.add(1000000000 + i % repeatInterval);
        }
        List<StripeFooter> stripeFooters = this.testIntegerDictionary(directConversionTester, values);
        Assert.assertEquals((int)TestDictionaryColumnWriter.getStripeSize(values.size()), (int)stripeFooters.size());
        this.verifyDwrfDirectEncoding(stripeFooters, 0);
        this.verifyDwrfDirectEncoding(stripeFooters, 1);
        this.verifyDictionaryEncoding(stripeFooters, OrcEncoding.DWRF, 2, repeatInterval);
        this.verifyDictionaryEncoding(stripeFooters, OrcEncoding.DWRF, 3, repeatInterval);
    }

    @Test
    public void testLongDictionaryNonRepeating() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ImmutableList baseList = ImmutableList.of((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)baseList);
        for (long i = (long)baseList.size(); i < 100000L; ++i) {
            builder.add((Object)i);
        }
        ImmutableList values = builder.build();
        List<StripeFooter> stripeFooters = this.testLongDictionary(directConversionTester, (List<?>)values);
        this.verifyDwrfDirectEncoding(TestDictionaryColumnWriter.getStripeSize(values.size()), stripeFooters);
    }

    @Test
    public void testLongDictionaryRepeatingValuesDirect() throws IOException {
        DirectConversionTester directConversionTester = new DirectConversionTester();
        directConversionTester.add(0, 1000, false);
        directConversionTester.add(0, 4000, true);
        directConversionTester.add(16, 10000, true);
        ImmutableList baseList = ImmutableList.of((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)baseList);
        int repeatInterval = 1500;
        for (long i = (long)baseList.size(); i < 50000L; ++i) {
            builder.add((Object)(1000000000L + i % (long)repeatInterval));
        }
        ImmutableList values = builder.build();
        List<StripeFooter> stripeFooters = this.testLongDictionary(directConversionTester, (List<?>)values);
        Assert.assertEquals((int)TestDictionaryColumnWriter.getStripeSize(values.size()), (int)stripeFooters.size());
        this.verifyDwrfDirectEncoding(stripeFooters, 0);
        this.verifyDwrfDirectEncoding(stripeFooters, 1);
        this.verifyDictionaryEncoding(stripeFooters, OrcEncoding.DWRF, 2, repeatInterval);
        this.verifyDwrfDirectEncoding(stripeFooters, 3);
    }

    @Test
    public void testLongPreserveDirectEncoding() throws IOException {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long i2 = 0L; i2 < 15000L; ++i2) {
            builder.add((Object)i2);
        }
        int repeatInterval = 1500;
        for (long i3 = 0L; i3 < 100000L; ++i3) {
            builder.add((Object)(1000000000L + i3 % (long)repeatInterval));
        }
        DirectConversionTester tester = new DirectConversionTester();
        int preserveDirectEncodingStripeCount = 2;
        OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withIntegerDictionaryEncodingEnabled(true).withPreserveDirectEncodingStripeCount(preserveDirectEncodingStripeCount).build();
        ImmutableList values = builder.build();
        List<StripeFooter> stripeFooters = this.testDictionary((Type)BigintType.BIGINT, OrcEncoding.DWRF, orcWriterOptions, tester, (List<?>)values);
        Assert.assertEquals((int)TestDictionaryColumnWriter.getStripeSize(values.size()), (int)stripeFooters.size());
        for (i = 0; i <= preserveDirectEncodingStripeCount; ++i) {
            this.verifyDwrfDirectEncoding(stripeFooters, i);
        }
        for (i = preserveDirectEncodingStripeCount + 1; i < stripeFooters.size(); ++i) {
            this.verifyDictionaryEncoding(stripeFooters, OrcEncoding.DWRF, i, repeatInterval);
        }
    }

    @Test
    public void verifyIntegerInList() throws IOException {
        ArrayList values = new ArrayList();
        for (int i = 0; i < 50000; ++i) {
            int childSize = i % 5;
            if (childSize == 4) {
                values.add(null);
                continue;
            }
            ArrayList<Integer> childList = new ArrayList<Integer>();
            for (int j = 0; j < childSize; ++j) {
                childList.add(i + j);
            }
            values.add(childList);
        }
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ArrayType listType = new ArrayType((Type)IntegerType.INTEGER);
        this.testDictionary((Type)listType, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    @Test
    public void verifyChildElementEmptyOrMissingInList() throws IOException {
        ArrayList values = new ArrayList();
        ArrayList emptyChildList = new ArrayList();
        for (int i = 0; i < 50000; ++i) {
            int childSize = i % 2;
            values.add(childSize == 0 ? null : emptyChildList);
        }
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ArrayType listType = new ArrayType((Type)IntegerType.INTEGER);
        this.testDictionary((Type)listType, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    @Test
    public void verifyStringInList() throws IOException {
        ArrayList values = new ArrayList();
        for (int i = 0; i < 50000; ++i) {
            int childSize = i % 5;
            if (childSize == 4) {
                values.add(null);
                continue;
            }
            ArrayList<String> childList = new ArrayList<String>();
            for (int j = 0; j < childSize; ++j) {
                childList.add(Integer.toString(i + j));
            }
            values.add(childList);
        }
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ArrayType listType = new ArrayType((Type)VarcharType.VARCHAR);
        this.testDictionary((Type)listType, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    @Test
    public void verifyStringEmptyOrMissingInList() throws IOException {
        ArrayList values = new ArrayList();
        ArrayList emptyChildList = new ArrayList();
        for (int i = 0; i < 50000; ++i) {
            int childSize = i % 2;
            values.add(childSize == 0 ? null : emptyChildList);
        }
        DirectConversionTester directConversionTester = new DirectConversionTester();
        ArrayType listType = new ArrayType((Type)VarcharType.VARCHAR);
        this.testDictionary((Type)listType, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    private ColumnEncoding getColumnEncoding(List<StripeFooter> stripeFooters, int stripeId) {
        StripeFooter stripeFooter = stripeFooters.get(stripeId);
        return (ColumnEncoding)stripeFooter.getColumnEncodings().get(1);
    }

    private void verifyDwrfDirectEncoding(List<StripeFooter> stripeFooters, int stripeId) {
        Assert.assertEquals((Object)this.getColumnEncoding(stripeFooters, stripeId).getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT, (String)("StripeId " + stripeId));
    }

    private void verifyDirectEncoding(List<StripeFooter> stripeFooters, OrcEncoding encoding, int stripeId) {
        ColumnEncoding columnEncoding = this.getColumnEncoding(stripeFooters, stripeId);
        if (encoding.equals((Object)OrcEncoding.DWRF)) {
            Assert.assertEquals((Object)columnEncoding.getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DIRECT, (String)("Encoding " + encoding + " StripeId " + stripeId));
        } else {
            Assert.assertEquals((Object)encoding, (Object)OrcEncoding.ORC);
            Assert.assertEquals((Object)columnEncoding.getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DIRECT_V2, (String)("Encoding " + encoding + " StripeId " + stripeId));
        }
    }

    private void verifyDictionaryEncoding(List<StripeFooter> stripeFooters, OrcEncoding encoding, int stripeId, int dictionarySize) {
        ColumnEncoding columnEncoding = this.getColumnEncoding(stripeFooters, stripeId);
        if (encoding.equals((Object)OrcEncoding.DWRF)) {
            Assert.assertEquals((Object)columnEncoding.getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DICTIONARY, (String)("Encoding " + encoding + " StripeId " + stripeId));
        } else {
            Assert.assertEquals((Object)encoding, (Object)OrcEncoding.ORC);
            Assert.assertEquals((Object)columnEncoding.getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2, (String)("Encoding " + encoding + " StripeId " + stripeId));
        }
        Assert.assertEquals((int)columnEncoding.getDictionarySize(), (int)dictionarySize, (String)("Encoding " + encoding + " StripeId " + stripeId));
    }

    private void verifyDictionaryEncoding(int stripeCount, OrcEncoding encoding, List<StripeFooter> stripeFooters, List<Integer> dictionarySizes) {
        Assert.assertEquals((int)stripeFooters.size(), (int)stripeCount);
        for (int i = 0; i < stripeFooters.size(); ++i) {
            this.verifyDictionaryEncoding(stripeFooters, encoding, i, dictionarySizes.get(i));
        }
    }

    private void verifyDirectEncoding(int stripeCount, OrcEncoding encoding, List<StripeFooter> stripeFooters) {
        Assert.assertEquals((int)stripeFooters.size(), (int)stripeCount);
        for (int i = 0; i < stripeCount; ++i) {
            this.verifyDirectEncoding(stripeFooters, encoding, i);
        }
    }

    private void verifyDwrfDirectEncoding(int stripeCount, List<StripeFooter> stripeFooters) {
        Assert.assertEquals((int)stripeFooters.size(), (int)stripeCount);
        for (StripeFooter footer : stripeFooters) {
            ColumnEncoding encoding = (ColumnEncoding)footer.getColumnEncodings().get(1);
            Assert.assertEquals((Object)encoding.getColumnEncodingKind(), (Object)ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT);
        }
    }

    private List<StripeFooter> testLongDictionary(DirectConversionTester directConversionTester, List<?> values) throws IOException {
        return this.testDictionary((Type)BigintType.BIGINT, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    private List<StripeFooter> testIntegerDictionary(DirectConversionTester directConversionTester, List<?> values) throws IOException {
        return this.testDictionary((Type)IntegerType.INTEGER, OrcEncoding.DWRF, true, true, directConversionTester, values);
    }

    private List<StripeFooter> testStringDictionary(DirectConversionTester directConversionTester, StringDictionaryInput dictionaryInput, List<String> values) throws IOException {
        return this.testDictionary((Type)VarcharType.VARCHAR, dictionaryInput.getEncoding(), false, dictionaryInput.isSortStringDictionaryKeys(), directConversionTester, values);
    }

    private List<StripeFooter> testDictionary(Type type, OrcEncoding encoding, boolean enableIntDictionary, boolean sortStringDictionaryKeys, DirectConversionTester directConversionTester, List<?> values) throws IOException {
        OrcWriterOptions orcWriterOptions = OrcWriterOptions.builder().withFlushPolicy((OrcWriterFlushPolicy)DefaultOrcWriterFlushPolicy.builder().withStripeMaxRowCount(15000).build()).withIntegerDictionaryEncodingEnabled(enableIntDictionary).withStringDictionarySortingEnabled(sortStringDictionaryKeys).build();
        return this.testDictionary(type, encoding, orcWriterOptions, directConversionTester, values);
    }

    private static boolean isArrayType(Type type) {
        return type.getTypeSignature().getBase().equals("array");
    }

    private void appendListToBlock(Type type, List<?> values, BlockBuilder blockBuilder, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            Object value;
            if ((value = values.get(startIndex++)) == null) {
                blockBuilder.appendNull();
                continue;
            }
            if (TestDictionaryColumnWriter.isArrayType(type)) {
                List childList = (List)value;
                BlockBuilder childBlockBuilder = blockBuilder.beginBlockEntry();
                this.appendListToBlock((Type)type.getTypeParameters().get(0), childList, childBlockBuilder, 0, childList.size());
                blockBuilder.closeEntry();
                continue;
            }
            if (type.equals(VarcharType.VARCHAR)) {
                type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
                continue;
            }
            Number number = (Number)value;
            type.writeLong(blockBuilder, number.longValue());
        }
    }

    private List<StripeFooter> testDictionary(Type type, OrcEncoding encoding, OrcWriterOptions orcWriterOptions, DirectConversionTester directConversionTester, List<?> values) throws IOException {
        ImmutableList types = ImmutableList.of((Object)type);
        try (TempFile tempFile = new TempFile();){
            OrcWriter writer = OrcTester.createOrcWriter(tempFile.getFile(), encoding, CompressionKind.ZSTD, Optional.empty(), (List<Type>)types, orcWriterOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
            int index = 0;
            int batchId = 0;
            while (index < values.size()) {
                int end = Math.min(index + 1000, values.size());
                BlockBuilder blockBuilder = type.createBlockBuilder(null, end - index);
                this.appendListToBlock(type, values, blockBuilder, index, end);
                Block[] blocks = new Block[]{blockBuilder.build()};
                writer.write(new Page(blocks));
                directConversionTester.validate(batchId, writer);
                ++batchId;
                index = end;
            }
            writer.close();
            writer.validate((OrcDataSource)new FileOrcDataSource(tempFile.getFile(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true));
            index = 0;
            try (OrcSelectiveRecordReader reader = OrcTester.createCustomOrcSelectiveRecordReader(tempFile, encoding, OrcPredicate.TRUE, type, 1, true, false);){
                Page page;
                while (index < values.size() && (page = reader.getNextPage()) != null) {
                    Block block = page.getBlock(0).getLoadedBlock();
                    index = this.verifyBlock(type, values, index, block);
                }
                Assert.assertEquals((int)index, (int)values.size());
            }
            List<StripeFooter> list = OrcTester.getStripes(tempFile.getFile(), encoding);
            return list;
        }
    }

    private int verifyBlock(Type type, List<?> values, int index, Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            Object value = values.get(index++);
            Assert.assertEquals((boolean)block.isNull(i), (value == null ? 1 : 0) != 0);
            if (value == null) continue;
            if (type.equals(VarcharType.VARCHAR)) {
                Assert.assertEquals((Object)block.getSlice(i, 0, block.getSliceLength(i)), (Object)Slices.utf8Slice((String)((String)value)));
                continue;
            }
            if (TestDictionaryColumnWriter.isArrayType(type)) {
                List childList = (List)value;
                Block childBlock = block.getBlock(i);
                int childIndex = this.verifyBlock((Type)type.getTypeParameters().get(0), childList, 0, childBlock);
                Assert.assertEquals((int)childIndex, (int)childList.size());
                continue;
            }
            Number number = (Number)value;
            Assert.assertEquals((long)type.getLong(block, i), (long)number.longValue());
        }
        return index;
    }

    private static class DirectConversionTester {
        private final List<Integer> batchIds = new ArrayList<Integer>();
        private final List<Integer> maxDirectBytes = new ArrayList<Integer>();
        private final List<Boolean> expectedResults = new ArrayList<Boolean>();
        private int index;
        private int lastBatchId = -1;

        private DirectConversionTester() {
        }

        void add(int batchId, int maxBytes, boolean expectedResult) {
            this.batchIds.add(batchId);
            this.maxDirectBytes.add(maxBytes);
            this.expectedResults.add(expectedResult);
        }

        void validate(int batchId, OrcWriter writer) {
            Preconditions.checkState((batchId > this.lastBatchId ? 1 : 0) != 0);
            this.lastBatchId = batchId;
            while (this.index < this.batchIds.size() && this.batchIds.get(this.index) == batchId) {
                DictionaryColumnWriter columnWriter = (DictionaryColumnWriter)writer.getColumnWriters().get(0);
                Assert.assertFalse((boolean)columnWriter.isDirectEncoded(), (String)("BatchId " + batchId + "is Direct encoded"));
                int bufferedBytes = this.maxDirectBytes.get(this.index);
                if (!this.expectedResults.get(this.index).booleanValue()) {
                    Assert.assertFalse((boolean)columnWriter.tryConvertToDirect(bufferedBytes).isPresent(), (String)("BatchId " + batchId + " bytes " + bufferedBytes));
                } else {
                    List directConversionCandidates = writer.getDictionaryCompressionOptimizer().getDirectConversionCandidates();
                    boolean contains = directConversionCandidates.stream().anyMatch(x -> x.getDictionaryColumn() == columnWriter);
                    Assert.assertTrue((boolean)contains);
                    writer.getDictionaryCompressionOptimizer().convertLowCompressionStreams(true, bufferedBytes);
                    Assert.assertTrue((boolean)columnWriter.isDirectEncoded(), (String)("BatchId " + batchId + " bytes " + bufferedBytes));
                    contains = directConversionCandidates.stream().anyMatch(x -> x.getDictionaryColumn() == columnWriter);
                    Assert.assertFalse((boolean)contains);
                }
                ++this.index;
            }
            return;
        }
    }

    private static class StringDictionaryInput {
        private final OrcEncoding encoding;
        private final boolean sortStringDictionaryKeys;

        StringDictionaryInput(OrcEncoding encoding, boolean sortStringDictionaryKeys) {
            this.encoding = encoding;
            this.sortStringDictionaryKeys = sortStringDictionaryKeys;
        }

        public OrcEncoding getEncoding() {
            return this.encoding;
        }

        public boolean isSortStringDictionaryKeys() {
            return this.sortStringDictionaryKeys;
        }

        static List<StringDictionaryInput> values() {
            return ImmutableList.of((Object)new StringDictionaryInput(OrcEncoding.ORC, true), (Object)new StringDictionaryInput(OrcEncoding.DWRF, true), (Object)new StringDictionaryInput(OrcEncoding.DWRF, false));
        }
    }
}

