/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.IntMath;
import io.airlift.units.DataSize;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDictionaryCompressionOptimizer {
    private static final int DICTIONARY_ALMOST_FULL_MEMORY_RANGE = TestDictionaryCompressionOptimizer.megabytes(4);
    private static final int CHUNK_ROW_COUNT = 1024;

    @Test
    public void testNoDictionariesBytesLimit() {
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int bytesPerRow = 1024;
        int expectedMaxRowCount = stripeMaxBytes / bytesPerRow;
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, expectedMaxRowCount * 2, TestDictionaryCompressionOptimizer.megabytes(16), bytesPerRow, new TestDictionaryColumn[0]);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testSingleDictionaryColumnRowLimit() {
        int bytesPerEntry = 1024;
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.dictionaryColumn(bytesPerEntry, 1024);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(1000);
        int expectedMaxRowCount = 1000000;
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, expectedMaxRowCount, TestDictionaryCompressionOptimizer.megabytes(16), 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testSingleDictionaryColumnByteLimit() {
        int bytesPerEntry = 1024;
        int dictionaryEntries = 1024;
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.dictionaryColumn(bytesPerEntry, dictionaryEntries);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int bytesPerRow = DictionaryCompressionOptimizer.estimateIndexBytesPerValue((int)dictionaryEntries);
        int expectedMaxRowCount = stripeMaxBytes / bytesPerRow;
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, expectedMaxRowCount * 10, TestDictionaryCompressionOptimizer.megabytes(16), 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testSingleDictionaryColumnMemoryLimit() {
        int bytesPerEntry = 1024;
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(32);
        double uniquePercentage = 0.5;
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.directColumn(bytesPerEntry, uniquePercentage);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int dictionaryMaxMemoryBytesLow = dictionaryMaxMemoryBytes - DICTIONARY_ALMOST_FULL_MEMORY_RANGE;
        int expectedMaxRowCount = (int)((double)(dictionaryMaxMemoryBytesLow / bytesPerEntry) / uniquePercentage);
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, expectedMaxRowCount * 2, dictionaryMaxMemoryBytes, 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertTrue((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.finalOptimize();
            Assert.assertTrue((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testDirectConversionOnDictionaryFull() {
        int bytesPerEntry = 1024;
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(8);
        double uniquePercentage = 0.2;
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.directColumn(bytesPerEntry, uniquePercentage);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int expectedRowCountAtFlip = (int)((double)(dictionaryMaxMemoryBytes / bytesPerEntry) / uniquePercentage);
        int expectedMaxRowCountAtFull = stripeMaxBytes / bytesPerEntry;
        DataSimulator simulator = new DataSimulator(stripeMaxBytes / 2, stripeMaxBytes, expectedMaxRowCountAtFull * 2, dictionaryMaxMemoryBytes, 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedRowCountAtFlip));
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.reset();
        }
    }

    @Test
    public void testNotDirectConversionOnDictionaryFull() {
        int bytesPerEntry = 1024;
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(8);
        double uniquePercentage = 0.01;
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.directColumn(bytesPerEntry, uniquePercentage);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int expectedMaxRowCount = (int)((double)(dictionaryMaxMemoryBytes / bytesPerEntry) / uniquePercentage);
        DataSimulator simulator = new DataSimulator(stripeMaxBytes / 2, stripeMaxBytes, expectedMaxRowCount * 2, dictionaryMaxMemoryBytes, 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertTrue((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.finalOptimize();
            Assert.assertTrue((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testSingleDirectBytesLimit() {
        int bytesPerEntry = 1024;
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(16);
        TestDictionaryColumn column = TestDictionaryCompressionOptimizer.directColumn(bytesPerEntry, 1.0);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int expectedRowCountAtFlip = (dictionaryMaxMemoryBytes - DICTIONARY_ALMOST_FULL_MEMORY_RANGE) / bytesPerEntry;
        int expectedMaxRowCountAtFull = stripeMaxBytes / bytesPerEntry;
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, expectedMaxRowCountAtFull, dictionaryMaxMemoryBytes, 0, column);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)column.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedRowCountAtFlip));
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)column.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.reset();
        }
    }

    @Test
    public void testDictionaryAndDirectBytesLimit() {
        int bytesPerEntry = 1024;
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(8);
        double directUniquePercentage = 0.75;
        TestDictionaryColumn directColumn = TestDictionaryCompressionOptimizer.directColumn(bytesPerEntry, directUniquePercentage);
        TestDictionaryColumn dictionaryColumn = TestDictionaryCompressionOptimizer.dictionaryColumn(bytesPerEntry, 1024);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int expectedRowCountAtFlip = (int)((double)dictionaryMaxMemoryBytes / ((double)(bytesPerEntry * 2) * directUniquePercentage));
        int expectedMaxRowCountAtFull = stripeMaxBytes / (bytesPerEntry * 2);
        DataSimulator simulator = new DataSimulator(stripeMaxBytes / 2, stripeMaxBytes, expectedMaxRowCountAtFull * 2, dictionaryMaxMemoryBytes, 0, directColumn, dictionaryColumn);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedRowCountAtFlip));
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedMaxRowCountAtFull));
            simulator.reset();
        }
    }

    @Test
    public void testWideDictionaryAndNarrowDirectBytesLimit() {
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(32);
        int directBytesPerEntry = 100;
        double directUniquePercentage = 0.75;
        TestDictionaryColumn directColumn = TestDictionaryCompressionOptimizer.directColumn(directBytesPerEntry, directUniquePercentage);
        int dictionaryBytesPerEntry = 0x100000;
        int dictionaryEntries = 10;
        TestDictionaryColumn dictionaryColumn = TestDictionaryCompressionOptimizer.dictionaryColumn(dictionaryBytesPerEntry, dictionaryEntries);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(2000);
        int dictionaryMaxMemoryBytesLow = dictionaryMaxMemoryBytes - DICTIONARY_ALMOST_FULL_MEMORY_RANGE;
        int expectedRowCountAtFlip = (int)((double)(dictionaryMaxMemoryBytesLow - dictionaryEntries * dictionaryBytesPerEntry) / ((double)directBytesPerEntry * directUniquePercentage));
        int maxRowCount = 10000000;
        DataSimulator simulator = new DataSimulator(0, stripeMaxBytes, maxRowCount, dictionaryMaxMemoryBytes, 0, directColumn, dictionaryColumn);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(expectedRowCountAtFlip));
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(maxRowCount));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)directColumn.isDirectEncoded());
            Assert.assertFalse((boolean)dictionaryColumn.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(maxRowCount));
            simulator.reset();
        }
    }

    @Test
    public void testDictionaryUsefulCheck() {
        int largeBytesPerEntry = 768;
        TestDictionaryColumn largeDirectColumn = TestDictionaryCompressionOptimizer.directColumn(largeBytesPerEntry, 1.0);
        int smallBytePerEntry = 256;
        TestDictionaryColumn smallDirectColumn = TestDictionaryCompressionOptimizer.directColumn(smallBytePerEntry, 1.0);
        int dictionaryUsefulCheckPerChunkFrequency = 5;
        int dictionaryUsefulCheckColumnSizeBytes = TestDictionaryCompressionOptimizer.megabytes(10);
        int stripeMinBytes = TestDictionaryCompressionOptimizer.megabytes(275);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(300);
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(64);
        int maxRowCount = 10000000;
        int largeColumnAbandonRowCount = IntMath.divide((int)dictionaryUsefulCheckColumnSizeBytes, (int)largeBytesPerEntry, (RoundingMode)RoundingMode.CEILING);
        int largeColumnAbandonUpperBound = largeColumnAbandonRowCount + (dictionaryUsefulCheckPerChunkFrequency + 1) * 1024;
        int smallColumnAbandonRowCount = IntMath.divide((int)dictionaryUsefulCheckColumnSizeBytes, (int)smallBytePerEntry, (RoundingMode)RoundingMode.CEILING);
        int smallColumnAbandonUpperBound = smallColumnAbandonRowCount + (dictionaryUsefulCheckPerChunkFrequency + 1) * 1024;
        DataSimulator simulator = new DataSimulator(stripeMinBytes, stripeMaxBytes, maxRowCount, dictionaryMaxMemoryBytes, 0, DICTIONARY_ALMOST_FULL_MEMORY_RANGE, dictionaryUsefulCheckPerChunkFrequency, dictionaryUsefulCheckColumnSizeBytes, largeDirectColumn, smallDirectColumn);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertFalse((boolean)largeDirectColumn.isDirectEncoded());
            Assert.assertFalse((boolean)smallDirectColumn.isDirectEncoded());
            Assert.assertEquals((int)simulator.getRowCount(), (int)0);
            Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)largeDirectColumn.isDirectEncoded());
            Assert.assertFalse((boolean)smallDirectColumn.isDirectEncoded());
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(largeColumnAbandonRowCount));
            Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(largeColumnAbandonUpperBound));
            Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(smallColumnAbandonRowCount));
            simulator.advanceToNextStateChange();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            Assert.assertTrue((boolean)largeDirectColumn.isDirectEncoded());
            Assert.assertTrue((boolean)smallDirectColumn.isDirectEncoded());
            Assertions.assertLessThan((Comparable)Long.valueOf(simulator.getBufferedBytes()), (Comparable)Long.valueOf(stripeMaxBytes));
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(smallColumnAbandonRowCount));
            Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(smallColumnAbandonUpperBound));
            simulator.finalOptimize();
            Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
            simulator.reset();
        }
    }

    @Test
    public void testIsDictionaryUsefulCheckRequired() {
        TestDictionaryColumn directColumn = TestDictionaryCompressionOptimizer.directColumn(1024, 1.0);
        int dictionaryColumnSizeCheckBytes = TestDictionaryCompressionOptimizer.megabytes(1);
        int dictionaryUsefulCheckPerChunkFrequency = 3;
        DataSimulator simulator = new DataSimulator(TestDictionaryCompressionOptimizer.megabytes(100), TestDictionaryCompressionOptimizer.megabytes(200), 10000000, TestDictionaryCompressionOptimizer.megabytes(100), 0, DICTIONARY_ALMOST_FULL_MEMORY_RANGE, dictionaryUsefulCheckPerChunkFrequency, dictionaryColumnSizeCheckBytes, directColumn);
        for (int loop = 0; loop < 3; ++loop) {
            Assert.assertFalse((boolean)simulator.isUsefulCheckRequired(dictionaryColumnSizeCheckBytes + 1));
            Assert.assertFalse((boolean)simulator.isUsefulCheckRequired(dictionaryColumnSizeCheckBytes));
            Assert.assertFalse((boolean)simulator.isUsefulCheckRequired(dictionaryColumnSizeCheckBytes - 1));
            Assert.assertTrue((boolean)simulator.isUsefulCheckRequired(dictionaryColumnSizeCheckBytes));
        }
    }

    @Test
    public void testAllNullsColumnConvertToDirect() {
        double nullsRate = 1.0;
        TestDictionaryColumn column = new TestDictionaryColumn(10, 1.0, OptionalInt.empty(), 1.0, nullsRate);
        int stripeMaxBytes = TestDictionaryCompressionOptimizer.megabytes(100);
        int dictionaryMaxMemoryBytes = TestDictionaryCompressionOptimizer.megabytes(16);
        int dictionaryAlmostFullMemoryBytes = dictionaryMaxMemoryBytes - DICTIONARY_ALMOST_FULL_MEMORY_RANGE;
        DataSimulator simulator = new DataSimulator(stripeMaxBytes / 2, stripeMaxBytes, Integer.MAX_VALUE, dictionaryMaxMemoryBytes, 0, column);
        Assert.assertFalse((boolean)simulator.isDictionaryMemoryFull());
        Assert.assertFalse((boolean)column.isDirectEncoded());
        Assert.assertEquals((int)simulator.getRowCount(), (int)0);
        Assert.assertEquals((long)simulator.getBufferedBytes(), (long)0L);
        simulator.advanceToNextStateChange();
        int minDictionaryConversionRow = dictionaryAlmostFullMemoryBytes * 4;
        int maxDictionaryConversationRow = minDictionaryConversionRow + 1024 + 1;
        Assertions.assertLessThan((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(maxDictionaryConversationRow));
        Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(simulator.getRowCount()), (Comparable)Integer.valueOf(minDictionaryConversionRow));
        Assert.assertTrue((boolean)column.isDirectEncoded());
    }

    private static int megabytes(int size) {
        return Math.toIntExact(new DataSize((double)size, DataSize.Unit.MEGABYTE).toBytes());
    }

    private static TestDictionaryColumn directColumn(int bytesPerEntry, double uniquePercentage) {
        return new TestDictionaryColumn(bytesPerEntry, uniquePercentage, OptionalInt.empty(), 1.0, 0.0);
    }

    private static TestDictionaryColumn dictionaryColumn(int bytesPerEntry, int maxDictionaryEntries) {
        return TestDictionaryCompressionOptimizer.dictionaryColumn(bytesPerEntry, maxDictionaryEntries, 0.5);
    }

    private static TestDictionaryColumn dictionaryColumn(int bytesPerEntry, int maxDictionaryEntries, double uniquePercentage) {
        return new TestDictionaryColumn(bytesPerEntry, uniquePercentage, OptionalInt.of(maxDictionaryEntries), 1.0, 0.0);
    }

    private static class TestDictionaryColumn
    implements DictionaryCompressionOptimizer.DictionaryColumn {
        private final int bytesPerEntry;
        private final double uniquePercentage;
        private final OptionalInt maxDictionaryEntries;
        private final double valuesPerRow;
        private final double nullRate;
        private int rowCount;
        private boolean direct;

        private TestDictionaryColumn(int bytesPerEntry, double uniquePercentage, OptionalInt maxDictionaryEntries, double valuesPerRow, double nullRate) {
            Preconditions.checkArgument((bytesPerEntry >= 0 ? 1 : 0) != 0, (Object)"bytesPerEntry is negative");
            this.bytesPerEntry = bytesPerEntry;
            Preconditions.checkArgument((uniquePercentage >= 0.0 && uniquePercentage <= 1.0 ? 1 : 0) != 0, (Object)"bytesPerEntry must be between 0 and 1");
            this.uniquePercentage = uniquePercentage;
            this.maxDictionaryEntries = Objects.requireNonNull(maxDictionaryEntries, "maxDictionaryEntries is null");
            maxDictionaryEntries.ifPresent(value -> Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"maxDictionaryEntries is negative"));
            Preconditions.checkArgument((valuesPerRow >= 0.0 ? 1 : 0) != 0, (Object)"valuesPerRow is negative");
            this.valuesPerRow = valuesPerRow;
            Preconditions.checkArgument((nullRate >= 0.0 && nullRate <= 1.0 ? 1 : 0) != 0, (Object)"nullRate must be between 0 and 1");
            this.nullRate = nullRate;
        }

        public void reset() {
            this.rowCount = 0;
            this.direct = false;
        }

        public void advanceTo(int rowCount) {
            Assert.assertTrue((rowCount >= this.rowCount ? 1 : 0) != 0, (String)("rowCount: " + rowCount));
            this.rowCount = rowCount;
        }

        public long getBufferedBytes() {
            if (this.direct) {
                return (long)((double)this.rowCount * this.valuesPerRow * (double)this.bytesPerEntry);
            }
            int dictionaryEntries = this.getDictionaryEntries();
            int bytesPerValue = DictionaryCompressionOptimizer.estimateIndexBytesPerValue((int)dictionaryEntries);
            return (long)(dictionaryEntries * this.bytesPerEntry) + this.getNonNullValueCount() * (long)bytesPerValue + this.getNullValueCount() / 8L;
        }

        public long getValueCount() {
            return (long)((double)this.rowCount * this.valuesPerRow);
        }

        public long getNonNullValueCount() {
            return (long)((double)this.getValueCount() * (1.0 - this.nullRate));
        }

        public long getNullValueCount() {
            return (long)((double)this.getValueCount() * this.nullRate);
        }

        public long getRawBytesEstimate() {
            return (long)this.bytesPerEntry * this.getNonNullValueCount();
        }

        public int getDictionaryEntries() {
            int dictionaryEntries = (int)((double)this.getNonNullValueCount() * this.uniquePercentage);
            return Math.min(dictionaryEntries, this.maxDictionaryEntries.orElse(dictionaryEntries));
        }

        public int getDictionaryBytes() {
            return this.getDictionaryEntries() * this.bytesPerEntry;
        }

        public int getIndexBytes() {
            return Math.toIntExact((long)DictionaryCompressionOptimizer.estimateIndexBytesPerValue((int)this.getDictionaryEntries()) * this.getNonNullValueCount());
        }

        public OptionalInt tryConvertToDirect(int maxDirectBytes) {
            Assert.assertFalse((boolean)this.direct);
            long nonNullBytes = this.getNonNullValueCount() * (long)this.bytesPerEntry;
            long nullBytes = this.getNullValueCount() / 8L;
            long directBytes = nonNullBytes + nullBytes;
            if (directBytes <= (long)maxDirectBytes) {
                this.direct = true;
                return OptionalInt.of(Math.toIntExact(directBytes));
            }
            return OptionalInt.empty();
        }

        public boolean isDirectEncoded() {
            return this.direct;
        }
    }

    private static class DataSimulator {
        private final int stripeMaxBytes;
        private final int stripeMaxRowCount;
        private final int otherColumnsBytesPerRow;
        private final Set<TestDictionaryColumn> dictionaryColumns;
        private final DictionaryCompressionOptimizer optimizer;
        private int rowCount;

        public DataSimulator(int stripeMinBytes, int stripeMaxBytes, int stripeMaxRowCount, int dictionaryMemoryMaxBytes, int otherColumnsBytesPerRow, TestDictionaryColumn ... dictionaryColumns) {
            this(stripeMinBytes, stripeMaxBytes, stripeMaxRowCount, dictionaryMemoryMaxBytes, otherColumnsBytesPerRow, DICTIONARY_ALMOST_FULL_MEMORY_RANGE, dictionaryMemoryMaxBytes, 0, dictionaryColumns);
        }

        public DataSimulator(int stripeMinBytes, int stripeMaxBytes, int stripeMaxRowCount, int dictionaryMemoryMaxBytes, int otherColumnsBytesPerRow, int dictionaryAlmostFullRangeBytes, int dictionaryUsefulCheckPerChunkFrequency, int dictionaryUsefulCheckColumnSizeBytes, TestDictionaryColumn ... dictionaryColumns) {
            this.stripeMaxBytes = stripeMaxBytes;
            this.stripeMaxRowCount = stripeMaxRowCount;
            this.otherColumnsBytesPerRow = otherColumnsBytesPerRow;
            this.dictionaryColumns = ImmutableSet.copyOf((Object[])dictionaryColumns);
            this.optimizer = new DictionaryCompressionOptimizer(this.dictionaryColumns, stripeMinBytes, stripeMaxBytes, stripeMaxRowCount, dictionaryMemoryMaxBytes, dictionaryAlmostFullRangeBytes, dictionaryUsefulCheckColumnSizeBytes, dictionaryUsefulCheckPerChunkFrequency);
        }

        public void advanceToNextStateChange() {
            List<Boolean> directColumnFlags = this.getDirectColumnFlags();
            while (!this.optimizer.isFull(this.getBufferedBytes()) && this.getBufferedBytes() < (long)this.stripeMaxBytes && this.getRowCount() < this.stripeMaxRowCount && directColumnFlags.equals(this.getDirectColumnFlags())) {
                this.rowCount += 1024;
                for (TestDictionaryColumn dictionaryColumn : this.dictionaryColumns) {
                    dictionaryColumn.advanceTo(this.rowCount);
                }
                this.optimizer.optimize(Math.toIntExact(this.getBufferedBytes()), this.getRowCount());
            }
        }

        public boolean isDictionaryMemoryFull() {
            return this.optimizer.isFull(this.getBufferedBytes());
        }

        public void finalOptimize() {
            this.optimizer.finalOptimize(Math.toIntExact(this.getBufferedBytes()));
        }

        private List<Boolean> getDirectColumnFlags() {
            return this.dictionaryColumns.stream().map(TestDictionaryColumn::isDirectEncoded).collect(Collectors.toList());
        }

        public void reset() {
            this.rowCount = 0;
            this.optimizer.reset();
            for (TestDictionaryColumn dictionaryColumn : this.dictionaryColumns) {
                dictionaryColumn.reset();
            }
        }

        public long getBufferedBytes() {
            return (long)this.rowCount * (long)this.otherColumnsBytesPerRow + this.dictionaryColumns.stream().mapToLong(TestDictionaryColumn::getBufferedBytes).sum();
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public boolean isUsefulCheckRequired(int dictionaryMemoryBytes) {
            return this.optimizer.isUsefulCheckRequired(dictionaryMemoryBytes);
        }
    }
}

