/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFilterFunction {
    private static final long UNLUCKY = 13L;

    @Test
    public void testFilter() {
        TestingConnectorSession session = new TestingConnectorSession((List)ImmutableList.of());
        FilterFunction filter = new FilterFunction(session.getSqlFunctionProperties(), true, (Predicate)new IsOddPredicate());
        Block numbers = TestFilterFunction.makeNumbers(0, 1000);
        int[] allPositions = TestFilterFunction.makePositions(0, 1000, 1);
        TestFilterFunction.assertFilter(filter, numbers, allPositions, allPositions.length);
        DictionaryBlock dictionaryNumbers = new DictionaryBlock(numbers, allPositions);
        int[] sparsePositions = TestFilterFunction.makePositions(1, 300, 3);
        TestFilterFunction.assertFilter(filter, (Block)dictionaryNumbers, sparsePositions, sparsePositions.length);
        TestFilterFunction.assertFilter(filter, (Block)dictionaryNumbers, allPositions, allPositions.length);
        DictionaryBlock otherDictionary = new DictionaryBlock(numbers, TestFilterFunction.makePositions(1, 332, 3));
        int[] otherDictionaryPositions = TestFilterFunction.makePositions(0, 150, 2);
        TestFilterFunction.assertFilter(filter, (Block)otherDictionary, otherDictionaryPositions, otherDictionaryPositions.length);
        TestFilterFunction.assertFilter(filter, (Block)new DictionaryBlock(TestFilterFunction.makeNumbers(1, 1001), allPositions), allPositions, allPositions.length);
    }

    private static void assertFilter(FilterFunction filter, Block input, int[] inputPositions, int positionCount) {
        int[] positions = Arrays.copyOf(inputPositions, positionCount);
        RuntimeException[] errors = new RuntimeException[inputPositions[positionCount - 1] + 1];
        int numPreviousErrors = positionCount / 2;
        for (int i = 0; i < numPreviousErrors; ++i) {
            errors[i] = new RuntimeException("Pre-existent error at  " + positions[i]);
        }
        int lastErrorPosition = numPreviousErrors > 0 ? positions[numPreviousErrors - 1] : -1;
        int numHits = filter.filter(new Page(positionCount, new Block[]{input}), positions, positionCount, errors);
        int hitCounter = 0;
        for (int position : inputPositions) {
            long number = input.getLong(position);
            if (number == 13L) {
                Assert.assertEquals((int)positions[hitCounter], (int)position);
                Assert.assertTrue((boolean)(errors[hitCounter] instanceof UnluckyError));
                ++hitCounter;
                continue;
            }
            if ((number & 1L) != 1L) continue;
            Assert.assertEquals((int)positions[hitCounter], (int)position);
            if (position <= lastErrorPosition) {
                Assert.assertTrue((boolean)(errors[hitCounter] instanceof RuntimeException));
            } else {
                Assert.assertEquals((Object)errors[hitCounter], null);
            }
            ++hitCounter;
        }
        Assert.assertEquals((int)numHits, (int)hitCounter);
    }

    private static int[] makePositions(int from, int count, int step) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = from + step * i;
        }
        return array;
    }

    private static Block makeNumbers(int from, int to) {
        int count = to - from;
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = from + i;
        }
        return new LongArrayBlock(count, Optional.empty(), array);
    }

    private static class IsOddPredicate
    implements Predicate {
        private IsOddPredicate() {
        }

        public int[] getInputChannels() {
            return new int[]{0};
        }

        public boolean evaluate(SqlFunctionProperties properties, Page page, int position) {
            long number = page.getBlock(0).getLong(position);
            if (number == 13L) {
                throw new UnluckyError();
            }
            return (number & 1L) == 1L;
        }
    }

    private static class UnluckyError
    extends RuntimeException {
        private UnluckyError() {
        }
    }
}

