/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MapBlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.TempFile;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFlatMapWriter {
    private static final int ROWS = 50000;
    private static final Map<?, ?> EMPTY_MAP = ImmutableMap.of();

    @Test
    public void testMapValueType() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), 1, 2, 3, ImmutableMap.of((Object)10, (Object)"20"), ImmutableMap.of((Object)11, (Object)"22"), ImmutableMap.of((Object)12, (Object)"23"), ImmutableMap.of((Object)13, (Object)"24"), ImmutableMap.of((Object)14, (Object)"25"));
    }

    @Test
    public void testArrayValueType() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.arrayType((Type)IntegerType.INTEGER)), 1, 2, 3, ImmutableList.of((Object)1, (Object)2), ImmutableList.of((Object)3), ImmutableList.of((Object)4, (Object)5), ImmutableList.of((Object)6), ImmutableList.of((Object)9, (Object)10));
    }

    @Test
    public void testRowValueType() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.rowType(new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR})), 1, 2, 3, ImmutableList.of((Object)10, (Object)"20"), ImmutableList.of((Object)11, (Object)"22"), ImmutableList.of((Object)12, (Object)"23"), ImmutableList.of((Object)13, (Object)"24"), ImmutableList.of((Object)14, (Object)"25"));
    }

    @Test
    public void testDeeplyNestedValueType() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)IntegerType.INTEGER, OrcTester.arrayType(OrcTester.arrayType((Type)IntegerType.INTEGER))), 1, 2, 3, ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2)), ImmutableList.of((Object)ImmutableList.of((Object)3), (Object)ImmutableList.of((Object)33)), ImmutableList.of((Object)ImmutableList.of((Object)4, (Object)5), (Object)ImmutableList.of((Object)44, (Object)55)), ImmutableList.of((Object)ImmutableList.of((Object)6)), ImmutableList.of((Object)ImmutableList.of((Object)9, (Object)10)));
    }

    @Test
    public void testByteKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)TinyintType.TINYINT, (Type)IntegerType.INTEGER), (byte)1, (byte)2, (byte)3, 10, 11, 12, 13, 14);
    }

    @Test
    public void testShortKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)SmallintType.SMALLINT, (Type)IntegerType.INTEGER), (short)1, (short)2, (short)3, 10, 11, 12, 13, 14);
    }

    @Test
    public void testIntKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), 1, 2, 3, 10, 11, 12, 13, 14);
    }

    @Test
    public void testLongKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER), 1L, 2L, 3L, 10, 11, 12, 13, 14);
    }

    @Test
    public void testStringKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), "k1", "k2", "3", 10, 11, 12, 13, 14);
    }

    @Test
    public void testVarbinaryKey() throws Exception {
        TestFlatMapWriter.runTest(OrcTester.mapType((Type)VarbinaryType.VARBINARY, (Type)VarcharType.VARCHAR), new SqlVarbinary("k1".getBytes(StandardCharsets.UTF_8)), new SqlVarbinary("k2".getBytes(StandardCharsets.UTF_8)), new SqlVarbinary("k3".getBytes(StandardCharsets.UTF_8)), "10", "11", "12", "13", "14");
    }

    @Test
    public void testNullKeyUnsupported() {
        OrcTester tester = OrcTester.quickDwrfFlatMapTester();
        HashMap<Object, Object> nullKeyMap = new HashMap<Object, Object>();
        nullKeyMap.put(null, null);
        IllegalStateException ex = (IllegalStateException)Assert.expectThrows(IllegalStateException.class, () -> tester.testRoundTrip(OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Map[]{nullKeyMap})));
        Assert.assertEquals((String)ex.getMessage(), (String)"Map key is null at position: 0");
    }

    @Test
    public void testUnsupportedKeyType() {
        OrcTester tester = OrcTester.quickDwrfFlatMapTester();
        for (Type keyType : ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Object)OrcTester.arrayType((Type)IntegerType.INTEGER), (Object)OrcTester.rowType(new Type[]{IntegerType.INTEGER}))) {
            Assert.expectThrows(IllegalArgumentException.class, () -> tester.testRoundTrip(OrcTester.mapType(keyType, (Type)IntegerType.INTEGER), Lists.newArrayList((Object[])new Map[]{EMPTY_MAP})));
        }
    }

    @Test
    public void testMixedNullMapAndEmptyMap() throws Exception {
        Type mapType = OrcTester.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE);
        OrcTester tester = OrcTester.quickDwrfFlatMapTester();
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{null}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{null, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{EMPTY_MAP, null}), (int)50000)));
    }

    private static <K, V> void runTest(Type mapType, K key1, K key2, K key3, V value1, V value2, V value3, V value4, V value5) throws Exception {
        OrcTester tester = OrcTester.quickDwrfFlatMapTester();
        HashMap<K, Object> nullValue = new HashMap<K, Object>();
        nullValue.put(key1, null);
        ImmutableMap map1 = ImmutableMap.of(key1, value1);
        ImmutableMap map2 = ImmutableMap.of(key1, value2);
        ImmutableMap map3 = ImmutableMap.of(key2, value3);
        ImmutableMap map4 = ImmutableMap.of(key3, value4);
        ImmutableMap map5 = ImmutableMap.of(key1, value5, key2, value4, key3, value2);
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{nullValue}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{nullValue, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{EMPTY_MAP, nullValue}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map2}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map2, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map5, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map2, nullValue}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map2, nullValue, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map3, map4, map5}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map3, map4, map5, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map3, map4, map5, nullValue}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Map[]{map1, map3, map4, map5, nullValue, EMPTY_MAP}), (int)50000)));
        tester.testRoundTrip(mapType, Lists.newArrayList((Iterable)Iterables.limit(TestFlatMapWriter.random(map1, map2, map3, map4, map5, nullValue, EMPTY_MAP), (int)50000)));
    }

    @Test
    public void testMaxKeyLimit() throws Exception {
        MapType mapType = (MapType)OrcTester.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER);
        int maxFlattenedMapKeyCount = 3;
        OrcWriterOptions writerOptions = OrcWriterOptions.builder().withFlattenedColumns((Set)ImmutableSet.of((Object)0)).withMaxFlattenedMapKeyCount(maxFlattenedMapKeyCount).build();
        try (TempFile tempFile = new TempFile();
             OrcWriter orcWriter = OrcTester.createOrcWriter(tempFile.getFile(), OrcEncoding.DWRF, CompressionKind.ZLIB, Optional.empty(), (List<Type>)ImmutableList.of((Object)mapType), writerOptions, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);){
            orcWriter.write(TestFlatMapWriter.createMapPageForKeyLimitTest(mapType, maxFlattenedMapKeyCount - 1));
            Assert.expectThrows(IllegalStateException.class, () -> orcWriter.write(TestFlatMapWriter.createMapPageForKeyLimitTest(mapType, maxFlattenedMapKeyCount)));
        }
    }

    private static Page createMapPageForKeyLimitTest(MapType type, int keyCount) {
        Type keyType = type.getKeyType();
        Type valueType = type.getValueType();
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)type.createBlockBuilder(null, 10);
        BlockBuilder mapKeyBuilder = mapBlockBuilder.getKeyBlockBuilder();
        BlockBuilder mapValueBuilder = mapBlockBuilder.getValueBlockBuilder();
        mapBlockBuilder.beginDirectEntry();
        for (int k = 0; k < keyCount; ++k) {
            keyType.writeLong(mapKeyBuilder, (long)k);
            valueType.writeLong(mapValueBuilder, (long)k);
        }
        mapBlockBuilder.closeEntry();
        return new Page(new Block[]{mapBlockBuilder.build()});
    }

    private static <T> Iterable<T> random(final T ... elements) {
        final Random rnd = new Random(LocalDate.now().toEpochDay());
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return elements[rnd.nextInt(elements.length)];
            }
        };
        return () -> iterator;
    }
}

