/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.NoopOrcDataSource;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamDescriptorFactory;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.reader.ListFilter;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestListFilter {
    private static final int ROW_COUNT = 1000;
    private final Random random = new Random(0L);

    @Test
    public void testArray() {
        Integer[][] data = new Integer[1000][];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Integer[3 + this.random.nextInt(10)];
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = count++ % 11 == 0 ? null : Integer.valueOf(this.random.nextInt(100));
            }
        }
        this.assertPositionalFilter((Map<Integer, TupleDomainFilter>)ImmutableMap.of((Object)1, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)50L, (boolean)false)), data);
        this.assertPositionalFilter((Map<Integer, TupleDomainFilter>)ImmutableMap.of((Object)1, (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)50L, (boolean)false), (Object)2, (Object)TupleDomainFilter.BigintRange.of((long)25L, (long)50L, (boolean)false)), data);
        this.assertPositionalFilter((Map<Integer, TupleDomainFilter>)ImmutableMap.of((Object)2, (Object)TupleDomainFilter.BigintRange.of((long)25L, (long)50L, (boolean)false)), data);
    }

    @Test
    public void testArrayFilterCodeOverflowBug() {
        int j;
        Integer[][] data = new Integer[1000][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Integer[100];
            for (j = 0; j < data[i].length; ++j) {
                data[i][j] = j;
            }
        }
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (j = 1; j <= 64; ++j) {
            long value = j - 1;
            filters.put((Object)j, (Object)TupleDomainFilter.BigintRange.of((long)value, (long)value, (boolean)false));
        }
        this.assertPositionalFilter((Map<Integer, TupleDomainFilter>)filters.build(), data);
    }

    private void assertPositionalFilter(Map<Integer, TupleDomainFilter> filters, Integer[][] data) {
        ListFilter listFilter = TestListFilter.buildListFilter(filters, data);
        TestFilter1 testFilter = (i, value) -> Optional.ofNullable(filters.get(i + 1)).map(filter -> value == null ? filter.testNull() : filter.testLong((long)value.intValue())).orElse(true);
        TupleDomainFilter.PositionalFilter positionalFilter = listFilter.getPositionalFilter();
        block0: for (int i2 = 0; i2 < data.length; ++i2) {
            for (int j = 0; j < data[i2].length; ++j) {
                Integer value2 = data[i2][j];
                boolean expectedToPass = testFilter.test(j, value2);
                Assert.assertEquals((boolean)(value2 == null ? positionalFilter.testNull() : positionalFilter.testLong((long)value2.intValue())), (boolean)expectedToPass);
                if (expectedToPass) continue;
                Assert.assertEquals((int)positionalFilter.getPrecedingPositionsToFail(), (int)j);
                Assert.assertEquals((int)positionalFilter.getSucceedingPositionsToFail(), (int)(data[i2].length - j - 1));
                continue block0;
            }
        }
    }

    private static ListFilter buildListFilter(Map<Integer, TupleDomainFilter> filters, Integer[][] data) {
        Map subfieldFilters = (Map)filters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> TestListFilter.toSubfield((Integer)entry.getKey()), Map.Entry::getValue));
        ListFilter filter = new ListFilter(TestListFilter.makeStreamDescriptor(1), subfieldFilters);
        int[] lengths = Arrays.stream(data).mapToInt(v -> ((Integer[])v).length).toArray();
        filter.populateElementFilters(data.length, null, lengths, Arrays.stream(lengths).sum());
        return filter;
    }

    private static Subfield toSubfield(Integer index) {
        return new Subfield(String.format("c[%s]", index));
    }

    @Test
    public void testNestedArray() {
        Integer[][][] data = new Integer[1000][][];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            data[i] = new Integer[3 + this.random.nextInt(10)][];
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = new Integer[3 + this.random.nextInt(10)];
                for (int k = 0; k < data[i][j].length; ++k) {
                    data[i][j][k] = count++ % 11 == 0 ? null : Integer.valueOf(this.random.nextInt(100));
                }
            }
        }
        this.assertPositionalFilter((Map<RowAndColumn, TupleDomainFilter>)ImmutableMap.of((Object)RowAndColumn.of(1, 1), (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)50L, (boolean)false)), data);
        this.assertPositionalFilter((Map<RowAndColumn, TupleDomainFilter>)ImmutableMap.of((Object)RowAndColumn.of(1, 2), (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)50L, (boolean)false), (Object)RowAndColumn.of(3, 2), (Object)TupleDomainFilter.BigintRange.of((long)25L, (long)50L, (boolean)false)), data);
        this.assertPositionalFilter((Map<RowAndColumn, TupleDomainFilter>)ImmutableMap.of((Object)RowAndColumn.of(2, 1), (Object)TupleDomainFilter.BigintRange.of((long)0L, (long)50L, (boolean)false), (Object)RowAndColumn.of(2, 2), (Object)TupleDomainFilter.BigintRange.of((long)10L, (long)40L, (boolean)false), (Object)RowAndColumn.of(3, 3), (Object)TupleDomainFilter.BigintRange.of((long)20L, (long)30L, (boolean)false)), data);
    }

    private void assertPositionalFilter(Map<RowAndColumn, TupleDomainFilter> filters, Integer[][][] data) {
        ListFilter listFilter = TestListFilter.buildListFilter(filters, data);
        TestFilter2 testFilter = (i, j, value) -> Optional.ofNullable(filters.get(RowAndColumn.of(i + 1, j + 1))).map(filter -> value == null ? filter.testNull() : filter.testLong((long)value.intValue())).orElse(true);
        TupleDomainFilter.PositionalFilter positionalFilter = listFilter.getChild().getPositionalFilter();
        for (int i2 = 0; i2 < data.length; ++i2) {
            boolean expectedToPass = true;
            int passCount = 0;
            int failCount = 0;
            block1: for (int j2 = 0; j2 < data[i2].length; ++j2) {
                if (!expectedToPass) {
                    failCount += data[i2][j2].length;
                    continue;
                }
                for (int k = 0; k < data[i2][j2].length; ++k) {
                    Integer value2 = data[i2][j2][k];
                    expectedToPass = testFilter.test(j2, k, value2);
                    Assert.assertEquals((boolean)(value2 == null ? positionalFilter.testNull() : positionalFilter.testLong((long)value2.intValue())), (boolean)expectedToPass);
                    if (!expectedToPass) {
                        Assert.assertEquals((int)positionalFilter.getPrecedingPositionsToFail(), (int)passCount);
                        failCount = data[i2][j2].length - k - 1;
                        continue block1;
                    }
                    ++passCount;
                }
            }
            Assert.assertEquals((int)positionalFilter.getSucceedingPositionsToFail(), (int)failCount);
        }
    }

    private static ListFilter buildListFilter(Map<RowAndColumn, TupleDomainFilter> filters, Integer[][][] data) {
        Map subfieldFilters = (Map)filters.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> TestListFilter.toSubfield((RowAndColumn)entry.getKey()), Map.Entry::getValue));
        ListFilter filter = new ListFilter(TestListFilter.makeStreamDescriptor(2), subfieldFilters);
        int[] lengths = Arrays.stream(data).mapToInt(v -> ((Integer[][])v).length).toArray();
        filter.populateElementFilters(data.length, null, lengths, Arrays.stream(lengths).sum());
        int[] nestedLengths = Arrays.stream(data).flatMap(Arrays::stream).mapToInt(v -> ((Integer[])v).length).toArray();
        ((ListFilter)filter.getChild()).populateElementFilters(Arrays.stream(lengths).sum(), null, nestedLengths, Arrays.stream(nestedLengths).sum());
        return filter;
    }

    private static StreamDescriptor makeStreamDescriptor(int levels) {
        NoopOrcDataSource orcDataSource = NoopOrcDataSource.INSTANCE;
        IntegerType elementType = IntegerType.INTEGER;
        for (int i = 0; i < levels; ++i) {
            elementType = new ArrayType((Type)elementType);
        }
        List orcTypes = OrcType.toOrcType((int)0, (Type)elementType);
        return StreamDescriptorFactory.createStreamDescriptor((List)orcTypes, (OrcDataSource)orcDataSource);
    }

    private static Subfield toSubfield(RowAndColumn indices) {
        return new Subfield(String.format("c[%s][%s]", indices.getRow(), indices.getColumn()));
    }

    private static final class RowAndColumn {
        private final int row;
        private final int column;

        private RowAndColumn(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public static RowAndColumn of(int row, int column) {
            return new RowAndColumn(row, column);
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RowAndColumn that = (RowAndColumn)o;
            return this.row == that.row && this.column == that.column;
        }

        public int hashCode() {
            return Objects.hash(this.row, this.column);
        }
    }

    private static interface TestFilter2 {
        public boolean test(int var1, int var2, Integer var3);
    }

    private static interface TestFilter1 {
        public boolean test(int var1, Integer var2);
    }
}

