/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.NoopOrcDataSource;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcDecompressor;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamDescriptorFactory;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.checkpoint.Checkpoints;
import com.facebook.presto.orc.checkpoint.StreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.LongDictionaryProvider;
import com.facebook.presto.orc.stream.CheckpointInputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStreamDwrf;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.SharedBuffer;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLongDictionaryProvider {
    private static final OrcDataSourceId ORC_DATA_SOURCE_ID = new OrcDataSourceId("dict_provider_test");
    private static final DataSize COMPRESSION_BLOCK_SIZE = new DataSize(256.0, DataSize.Unit.KILOBYTE);
    private static final OrcType LONG_TYPE = new OrcType(OrcType.OrcTypeKind.LONG, (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final OrcDataSource DUMMY_ORC_DATA_SOURCE = new NoopOrcDataSource();

    @DataProvider(name="dataForDictionaryLoadingTest")
    public Object[][] dataForDictionaryLoadingTest() {
        return new Object[][]{{ImmutableMap.of((Object)new NodeId(1, 1), (Object)new long[]{1L, 2L, 3L, 4L}), ImmutableList.of((Object)new NodeId(0, 0), (Object)new NodeId(2, 1), (Object)new NodeId(1, 0), (Object)new NodeId(1, 3), (Object)new NodeId(42, 0))}, {ImmutableMap.of((Object)new NodeId(1, 1), (Object)new long[]{1L, 2L, 3L, 4L}, (Object)new NodeId(3, 1), (Object)new long[]{1L, 3L, 5L, 7L}), ImmutableList.of((Object)new NodeId(0, 0), (Object)new NodeId(2, 0), (Object)new NodeId(1, 0), (Object)new NodeId(1, 3), (Object)new NodeId(3, 0), (Object)new NodeId(42, 0))}, {ImmutableMap.of((Object)new NodeId(1, 0), (Object)new long[]{1L, 2L, 3L, 4L}, (Object)new NodeId(3, 0), (Object)new long[]{1L, 3L, 5L, 7L}, (Object)new NodeId(4, 1), (Object)new long[]{1L, 1L, 2L, 3L}, (Object)new NodeId(4, 2), (Object)new long[]{2L, 4L, 6L, 8L}, (Object)new NodeId(4, 4), (Object)new long[]{1L, 4L, 9L, 16L}), ImmutableList.of((Object)new NodeId(2, 0), (Object)new NodeId(4, 3), (Object)new NodeId(4, 42), (Object)new NodeId(42, 0))}};
    }

    @DataProvider(name="dataForBufferReuseTest")
    public Object[][] dataForBufferReuseTest() {
        return new Object[][]{{new long[0], 4, false}, {new long[4], 0, true}, {new long[4], 4, true}, {new long[4], 8, false}, {new long[8], 4, true}, {new long[16], 12, true}, {new long[16], 16, true}};
    }

    @DataProvider(name="dataForLongSharedDictionaryLoadingTest")
    private Object[][] dataForLongSharedDictionaryLoadingTest() {
        return new Object[][]{{ImmutableMap.of((Object)new NodeId(1, 0), (Object)new long[]{1L, 2L, 3L, 4L}), ImmutableList.of((Object)new SharedDictionaryTestInput(new NodeId(1, 0), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 1), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 3), false), (Object)new SharedDictionaryTestInput(new NodeId(1, 4), false), (Object)new SharedDictionaryTestInput(new NodeId(1, 9), false)), ImmutableList.of((Object)new NodeId(0, 0), (Object)new NodeId(2, 0), (Object)new NodeId(2, 1), (Object)new NodeId(42, 0))}, {ImmutableMap.of((Object)new NodeId(1, 0), (Object)new long[]{1L, 2L, 3L, 4L}, (Object)new NodeId(3, 0), (Object)new long[]{1L, 3L, 5L, 7L}), ImmutableList.of((Object)new SharedDictionaryTestInput(new NodeId(1, 0), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 4), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 1), false), (Object)new SharedDictionaryTestInput(new NodeId(1, 9), false), (Object)new SharedDictionaryTestInput(new NodeId(3, 0), true), (Object)new SharedDictionaryTestInput(new NodeId(3, 1), true), (Object)new SharedDictionaryTestInput(new NodeId(3, 3), false), (Object)new SharedDictionaryTestInput(new NodeId(3, 9), false)), ImmutableList.of((Object)new NodeId(0, 0), (Object)new NodeId(2, 0), (Object)new NodeId(2, 1), (Object)new NodeId(5, 1), (Object)new NodeId(42, 0))}, {ImmutableMap.of((Object)new NodeId(1, 0), (Object)new long[]{1L, 2L, 3L, 4L}, (Object)new NodeId(3, 0), (Object)new long[]{1L, 3L, 5L, 7L}, (Object)new NodeId(4, 1), (Object)new long[]{1L, 1L, 2L, 3L}, (Object)new NodeId(4, 2), (Object)new long[]{2L, 4L, 6L, 8L}, (Object)new NodeId(4, 4), (Object)new long[]{1L, 4L, 9L, 16L}), ImmutableList.of((Object)new SharedDictionaryTestInput(new NodeId(1, 0), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 1), true), (Object)new SharedDictionaryTestInput(new NodeId(1, 4), false), (Object)new SharedDictionaryTestInput(new NodeId(1, 9), false), (Object)new SharedDictionaryTestInput(new NodeId(3, 0), true), (Object)new SharedDictionaryTestInput(new NodeId(3, 1), true), (Object)new SharedDictionaryTestInput(new NodeId(3, 3), false), (Object)new SharedDictionaryTestInput(new NodeId(3, 9), false), (Object)new SharedDictionaryTestInput(new NodeId(4, 1), true), (Object)new SharedDictionaryTestInput(new NodeId(4, 2), true), (Object)new SharedDictionaryTestInput(new NodeId(4, 4), true)), ImmutableList.of((Object)new NodeId(2, 0), (Object)new NodeId(2, 1), (Object)new NodeId(4, 0), (Object)new NodeId(4, 3), (Object)new NodeId(4, 42), (Object)new NodeId(42, 0))}};
    }

    @Test(dataProvider="dataForDictionaryLoadingTest")
    public void testLongDictionaryLoading(Map<NodeId, long[]> dictionaryStreams, List<NodeId> missingNodes) throws Exception {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        LongDictionaryProvider dictionaryProvider = new LongDictionaryProvider(this.createLongDictionaryStreamSources(dictionaryStreams, aggregatedMemoryContext));
        for (Map.Entry<NodeId, long[]> entry : dictionaryStreams.entrySet()) {
            StreamId streamId = entry.getKey().toDictionaryDataStreamId();
            long[] data = entry.getValue();
            long[] dictionary = new long[]{};
            LongDictionaryProvider.DictionaryResult dictionaryResult = dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(streamId), dictionary, data.length);
            long[] newDictionary = dictionaryResult.dictionaryBuffer();
            Assert.assertTrue((boolean)dictionaryResult.isBufferOwner());
            Assert.assertEquals((long[])newDictionary, (long[])data);
        }
        for (NodeId missingNode : missingNodes) {
            long[] dictionary = new long[]{};
            Assert.expectThrows(OrcCorruptionException.class, () -> dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(missingNode.toDictionaryDataStreamId()), dictionary, 0));
        }
    }

    @Test(expectedExceptions={OrcCorruptionException.class}, expectedExceptionsMessageRegExp=".* Dictionary is not empty but data stream is not present.*")
    public void testDataCorruptionExceptionMessage() throws Exception {
        ImmutableMap dictionaryStreams = ImmutableMap.of((Object)new NodeId(1, 0), (Object)new long[]{1L, 2L, 3L, 4L});
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        LongDictionaryProvider dictionaryProvider = new LongDictionaryProvider(this.createLongDictionaryStreamSources((Map<NodeId, long[]>)dictionaryStreams, aggregatedMemoryContext));
        StreamId streamId = new NodeId(2, 0).toDictionaryDataStreamId();
        long[] dictionary = new long[]{};
        dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(streamId), dictionary, 0);
    }

    @Test(dataProvider="dataForBufferReuseTest")
    public void testBufferReuse(long[] buffer, int items, boolean reused) throws IOException {
        NodeId nodeId = new NodeId(1, 0);
        long[] data = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L};
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        LongDictionaryProvider dictionaryProvider = new LongDictionaryProvider(this.createLongDictionaryStreamSources((Map<NodeId, long[]>)ImmutableMap.of((Object)nodeId, (Object)data), aggregatedMemoryContext));
        StreamId streamId = nodeId.toDictionaryDataStreamId();
        LongDictionaryProvider.DictionaryResult dictionaryResult = dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(streamId), buffer, items);
        long[] newDictionary = dictionaryResult.dictionaryBuffer();
        Assert.assertTrue((boolean)dictionaryResult.isBufferOwner());
        Assert.assertEquals((newDictionary == buffer ? 1 : 0) != 0, (boolean)reused);
        Assert.assertTrue((newDictionary.length >= items ? 1 : 0) != 0);
    }

    @Test(dataProvider="dataForLongSharedDictionaryLoadingTest")
    public void testLongSharedDictionaryLoading(Map<NodeId, long[]> dictionaryStreams, List<SharedDictionaryTestInput> includedNodes, List<NodeId> excludedNodes) throws Exception {
        TestingHiveOrcAggregatedMemoryContext aggregatedMemoryContext = new TestingHiveOrcAggregatedMemoryContext();
        LongDictionaryProvider dictionaryProvider = new LongDictionaryProvider(this.createLongDictionaryStreamSources(dictionaryStreams, aggregatedMemoryContext));
        int dictionaryLength = 4;
        Set<Integer> sharedColumnIds = this.getSharedColumnIds(dictionaryStreams);
        for (SharedDictionaryTestInput testCase : includedNodes) {
            NodeId nodeId = testCase.nodeId();
            StreamId streamId = nodeId.toDictionaryDataStreamId();
            LongDictionaryProvider.DictionaryResult dictionaryResult = dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(streamId), null, 4);
            long[] dictionary = dictionaryResult.dictionaryBuffer();
            if (sharedColumnIds.contains(nodeId.node)) {
                NodeId sharedDictionaryNodeId = new NodeId(nodeId.node, 0);
                LongDictionaryProvider.DictionaryResult sharedDictionaryResult = dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(sharedDictionaryNodeId.toDictionaryDataStreamId()), new long[0], 4);
                Assert.assertEquals((boolean)testCase.isDictionaryOwner(), (boolean)dictionaryResult.isBufferOwner());
                Assert.assertEquals((long[])dictionary, (long[])sharedDictionaryResult.dictionaryBuffer());
                continue;
            }
            Assert.assertEquals((long[])dictionary, (long[])dictionaryStreams.get(nodeId));
        }
        for (NodeId nodeId : excludedNodes) {
            StreamId streamId = nodeId.toDictionaryDataStreamId();
            long[] dictionary = new long[4];
            Assert.assertThrows(OrcCorruptionException.class, () -> dictionaryProvider.getDictionary(this.createFlatStreamDescriptor(streamId), dictionary, 4));
        }
    }

    private Set<Integer> getSharedColumnIds(Map<NodeId, long[]> dictionaryStreams) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NodeId nodeId : dictionaryStreams.keySet()) {
            if (nodeId.sequence != 0) continue;
            builder.add((Object)nodeId.node);
        }
        return builder.build();
    }

    private StreamDescriptor createFlatStreamDescriptor(StreamId streamId) {
        ImmutableMap streamProperties = ImmutableMap.of((Object)streamId.getColumn(), (Object)new StreamDescriptorFactory.StreamProperty("test_dictionary_stream", LONG_TYPE, "field_" + streamId.getColumn(), (List)ImmutableList.of()));
        StreamDescriptorFactory.AllStreams allStreams = new StreamDescriptorFactory.AllStreams(DUMMY_ORC_DATA_SOURCE, (Map)streamProperties);
        return new StreamDescriptor(streamId.getColumn(), streamId.getSequence(), allStreams);
    }

    private InputStreamSources createLongDictionaryStreamSources(Map<NodeId, long[]> streams, OrcAggregatedMemoryContext aggregatedMemoryContext) {
        SharedBuffer decompressionBuffer = new SharedBuffer(aggregatedMemoryContext.newOrcLocalMemoryContext("sharedDecompressionBuffer"));
        ImmutableMap.Builder dictionaryStreamsBuilder = ImmutableMap.builder();
        for (Map.Entry<NodeId, long[]> entry : streams.entrySet()) {
            StreamId streamId = entry.getKey().toDictionaryDataStreamId();
            DynamicSliceOutput sliceOutput = this.createSliceOutput(streamId, entry.getValue());
            LongInputStreamDwrf valueStream = this.createValueStream(sliceOutput.slice(), aggregatedMemoryContext, decompressionBuffer);
            StreamCheckpoint streamCheckpoint = Checkpoints.getDictionaryStreamCheckpoint((StreamId)streamId, (OrcType.OrcTypeKind)OrcType.OrcTypeKind.LONG, (ColumnEncoding.ColumnEncodingKind)ColumnEncoding.ColumnEncodingKind.DICTIONARY);
            CheckpointInputStreamSource streamSource = CheckpointInputStreamSource.createCheckpointStreamSource((ValueInputStream)valueStream, (StreamCheckpoint)streamCheckpoint);
            dictionaryStreamsBuilder.put((Object)streamId, (Object)streamSource);
        }
        return new InputStreamSources((Map)dictionaryStreamsBuilder.build());
    }

    private DynamicSliceOutput createSliceOutput(StreamId streamId, long[] data) {
        LongOutputStreamDwrf outputStream = new LongOutputStreamDwrf(this.getColumnWriterOptions(), Optional.empty(), true, Stream.StreamKind.DICTIONARY_DATA);
        for (long val : data) {
            outputStream.writeLong(val);
        }
        outputStream.close();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1000);
        StreamDataOutput streamDataOutput = outputStream.getStreamDataOutput(streamId.getColumn(), 0);
        streamDataOutput.writeData((SliceOutput)sliceOutput);
        return sliceOutput;
    }

    private ColumnWriterOptions getColumnWriterOptions() {
        return ColumnWriterOptions.builder().setCompressionKind(CompressionKind.SNAPPY).setCompressionMaxBufferSize(COMPRESSION_BLOCK_SIZE).build();
    }

    private LongInputStreamDwrf createValueStream(Slice slice, OrcAggregatedMemoryContext aggregatedMemoryContext, SharedBuffer decompressionBuffer) throws OrcCorruptionException {
        OrcInputStream input = new OrcInputStream(ORC_DATA_SOURCE_ID, decompressionBuffer, (FixedLengthSliceInput)slice.getInput(), this.getOrcDecompressor(), Optional.empty(), aggregatedMemoryContext, slice.getRetainedSize());
        return new LongInputStreamDwrf(input, OrcType.OrcTypeKind.LONG, true, true);
    }

    private Optional<OrcDecompressor> getOrcDecompressor() {
        return OrcDecompressor.createOrcDecompressor((OrcDataSourceId)ORC_DATA_SOURCE_ID, (CompressionKind)CompressionKind.SNAPPY, (int)Math.toIntExact(COMPRESSION_BLOCK_SIZE.toBytes()));
    }

    private static class SharedDictionaryTestInput {
        private final NodeId nodeId;
        private final boolean isDictionaryOwner;

        SharedDictionaryTestInput(NodeId nodeId, boolean isDictionaryOwner) {
            this.nodeId = nodeId;
            this.isDictionaryOwner = isDictionaryOwner;
        }

        NodeId nodeId() {
            return this.nodeId;
        }

        boolean isDictionaryOwner() {
            return this.isDictionaryOwner;
        }
    }

    private static class NodeId {
        private final int node;
        private final int sequence;

        public NodeId(int node, int sequence) {
            this.node = node;
            this.sequence = sequence;
        }

        public int hashCode() {
            return Objects.hash(this.node, this.sequence);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeId)) {
                return false;
            }
            NodeId other = (NodeId)o;
            return other.node == this.node && other.sequence == this.sequence;
        }

        public StreamId toDictionaryDataStreamId() {
            return new StreamId(this.node, this.sequence, Stream.StreamKind.DICTIONARY_DATA);
        }
    }
}

