/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.FileOrcDataSource;
import com.facebook.presto.orc.NoopOrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderTestingUtils;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.TestingHiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.TestingOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapFlatBatchStreamReader {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = FunctionAndTypeManager.createTestFunctionAndTypeManager();
    private static final int NUM_ROWS = 31234;
    private static final Type LIST_TYPE = FUNCTION_AND_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)IntegerType.INTEGER.getTypeSignature())));
    private static final Type MAP_TYPE = FUNCTION_AND_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)RealType.REAL.getTypeSignature())));
    private static final Type STRUCT_TYPE = FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)ImmutableList.of((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value1", false)), IntegerType.INTEGER.getTypeSignature())), (Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value2", false)), IntegerType.INTEGER.getTypeSignature())), (Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value3", false)), IntegerType.INTEGER.getTypeSignature()))));

    @Test
    public void testByte() throws Exception {
        this.runTest("test_flat_map/flat_map_byte.dwrf", (Type)TinyintType.TINYINT, ExpectedValuesBuilder.get(Integer::byteValue));
    }

    @Test
    public void testByteWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_byte_with_null.dwrf", (Type)TinyintType.TINYINT, ExpectedValuesBuilder.get(Integer::byteValue).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testShort() throws Exception {
        this.runTest("test_flat_map/flat_map_short.dwrf", (Type)SmallintType.SMALLINT, ExpectedValuesBuilder.get(Integer::shortValue));
    }

    @Test
    public void testInteger() throws Exception {
        this.runTest("test_flat_map/flat_map_int.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()));
    }

    @Test
    public void testIntegerWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_int_with_null.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testIntegerWithSharedDictionary() throws Exception {
        this.runTest("test_flat_map/flat_map_dict_share_simple.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNumRows(2048));
    }

    @Test
    public void testLong() throws Exception {
        this.runTest("test_flat_map/flat_map_long.dwrf", (Type)BigintType.BIGINT, ExpectedValuesBuilder.get(Integer::longValue));
    }

    @Test
    public void testString() throws Exception {
        this.runTest("test_flat_map/flat_map_string.dwrf", (Type)VarcharType.VARCHAR, ExpectedValuesBuilder.get(i -> Integer.toString(i)));
    }

    @Test
    public void testStringWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_string_with_null.dwrf", (Type)VarcharType.VARCHAR, ExpectedValuesBuilder.get(i -> Integer.toString(i)).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testBinary() throws Exception {
        this.runTest("test_flat_map/flat_map_binary.dwrf", (Type)VarbinaryType.VARBINARY, ExpectedValuesBuilder.get(i -> new SqlVarbinary(Integer.toString(i).getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void testBoolean() throws Exception {
        this.runTest("test_flat_map/flat_map_boolean.dwrf", (Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToBoolean));
    }

    @Test
    public void testBooleanWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_boolean_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToBoolean).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testFloat() throws Exception {
        this.runTest("test_flat_map/flat_map_float.dwrf", (Type)IntegerType.INTEGER, (Type)RealType.REAL, ExpectedValuesBuilder.get(Function.identity(), Float::valueOf));
    }

    @Test
    public void testFloatWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_float_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)RealType.REAL, ExpectedValuesBuilder.get(Function.identity(), Float::valueOf).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testDouble() throws Exception {
        this.runTest("test_flat_map/flat_map_double.dwrf", (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE, ExpectedValuesBuilder.get(Function.identity(), Double::valueOf));
    }

    @Test
    public void testDoubleWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_double_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE, ExpectedValuesBuilder.get(Function.identity(), Double::valueOf).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testList() throws Exception {
        this.runTest("test_flat_map/flat_map_list.dwrf", (Type)IntegerType.INTEGER, LIST_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToList));
    }

    @Test
    public void testListWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_list_with_null.dwrf", (Type)IntegerType.INTEGER, LIST_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToList).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testMap() throws Exception {
        this.runTest("test_flat_map/flat_map_map.dwrf", (Type)IntegerType.INTEGER, MAP_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToMap));
    }

    @Test
    public void testMapWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_map_with_null.dwrf", (Type)IntegerType.INTEGER, MAP_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToMap).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testMapWithSharedDictionary() throws Exception {
        this.runTest("test_flat_map/flat_map_dict_share_nested.dwrf", (Type)BigintType.BIGINT, OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ExpectedValuesBuilder.get(x -> (long)x, TestMapFlatBatchStreamReader::intToIntMap).setNumRows(2048));
    }

    @Test
    public void testStruct() throws Exception {
        this.runTest("test_flat_map/flat_map_struct.dwrf", (Type)IntegerType.INTEGER, STRUCT_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToList));
    }

    @Test
    public void testStructWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_struct_with_null.dwrf", (Type)IntegerType.INTEGER, STRUCT_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatBatchStreamReader::intToList).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithNulls() throws Exception {
        this.runTest("test_flat_map/flat_map_some_null_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithAllNulls() throws Exception {
        this.runTest("test_flat_map/flat_map_all_null_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testWithAllNullsExceptFirst() throws Exception {
        this.runTest("test_flat_map/flat_map_all_null_maps_except_first.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.ALL_EXCEPT_FIRST));
    }

    @Test
    public void testWithEmptyMaps() throws Exception {
        this.runTest("test_flat_map/flat_map_some_empty_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithAllMaps() throws Exception {
        this.runTest("test_flat_map/flat_map_all_empty_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testWithAllEmptyMapsWithNoEncoding() throws Exception {
        this.runTest("test_flat_map/flat_map_all_empty_maps_no_encoding.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testMixedEncodings() throws Exception {
        this.runTest("test_flat_map/flat_map_mixed_encodings.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setMixedEncodings());
    }

    @Test
    public void testIntegerWithMissingSequences() throws Exception {
        this.runTest("test_flat_map/flat_map_int_missing_sequences.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setMissingSequences());
    }

    @Test
    public void testIntegerWithMissingSequence0() throws Exception {
        this.runTest("test_flat_map/flat_map_int_missing_sequence_0.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()));
    }

    private <K, V> void runTest(String testOrcFileName, Type type, ExpectedValuesBuilder<K, V> expectedValuesBuilder) throws Exception {
        this.runTest(testOrcFileName, type, type, expectedValuesBuilder);
    }

    private <K, V> void runTest(String testOrcFileName, Type keyType, Type valueType, ExpectedValuesBuilder<K, V> expectedValuesBuilder) throws Exception {
        List<Map<K, V>> expectedValues = expectedValuesBuilder.build();
        this.runTest(testOrcFileName, keyType, valueType, expectedValues, false, false);
        this.runTest(testOrcFileName, keyType, valueType, expectedValues, true, false);
        this.runTest(testOrcFileName, keyType, valueType, expectedValues, false, true);
    }

    private <K, V> void runTest(String testOrcFileName, Type keyType, Type valueType, List<Map<K, V>> expectedValues, boolean skipFirstBatch, boolean skipFirstStripe) throws Exception {
        FileOrcDataSource orcDataSource = new FileOrcDataSource(new File(Resources.getResource((String)testOrcFileName).getFile()), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), true);
        OrcReader orcReader = new OrcReader((OrcDataSource)orcDataSource, OrcEncoding.DWRF, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)NoopOrcAggregatedMemoryContext.NOOP_ORC_AGGREGATED_MEMORY_CONTEXT, OrcReaderTestingUtils.createDefaultTestConfig(), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
        Type mapType = FUNCTION_AND_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        try (OrcBatchRecordReader recordReader = orcReader.createBatchRecordReader((Map)ImmutableMap.of((Object)0, (Object)mapType), TestingOrcPredicate.createOrcPredicate(0, mapType, expectedValues, OrcTester.Format.DWRF, true), OrcTester.HIVE_STORAGE_TIME_ZONE, (OrcAggregatedMemoryContext)new TestingHiveOrcAggregatedMemoryContext(), 1024);){
            Iterator<Map<K, V>> expectedValuesIterator = expectedValues.iterator();
            boolean isFirst = true;
            int rowsProcessed = 0;
            int batchSize = Math.toIntExact(recordReader.nextBatch());
            while (batchSize >= 0) {
                if (skipFirstStripe && rowsProcessed < 10000) {
                    Assert.assertEquals((int)Iterators.advance(expectedValuesIterator, (int)batchSize), (int)batchSize);
                } else if (skipFirstBatch && isFirst) {
                    Assert.assertEquals((int)Iterators.advance(expectedValuesIterator, (int)batchSize), (int)batchSize);
                    isFirst = false;
                } else {
                    Block block = recordReader.readBlock(0);
                    for (int position = 0; position < block.getPositionCount(); ++position) {
                        Assert.assertEquals((Object)mapType.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position), expectedValuesIterator.next(), (String)String.format("row mismatch at processed rows %d, position %d", rowsProcessed, position));
                    }
                }
                Assert.assertEquals((long)recordReader.getReaderPosition(), (long)rowsProcessed);
                Assert.assertEquals((long)recordReader.getFilePosition(), (long)rowsProcessed);
                rowsProcessed += batchSize;
                batchSize = Math.toIntExact(recordReader.nextBatch());
            }
            Assert.assertFalse((boolean)expectedValuesIterator.hasNext());
            Assert.assertEquals((long)recordReader.getReaderPosition(), (long)rowsProcessed);
            Assert.assertEquals((long)recordReader.getFilePosition(), (long)rowsProcessed);
        }
    }

    private static boolean intToBoolean(int i) {
        return i % 2 == 0;
    }

    private static SqlTimestamp intToTimestamp(int i) {
        return new SqlTimestamp((long)i, TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS);
    }

    private static List<Integer> intToList(int i) {
        return ImmutableList.of((Object)(i * 3), (Object)(i * 3 + 1), (Object)(i * 3 + 2));
    }

    private static Map<String, Float> intToMap(int i) {
        return ImmutableMap.of((Object)Integer.toString(i * 3), (Object)Float.valueOf(i * 3), (Object)Integer.toString(i * 3 + 1), (Object)Float.valueOf(i * 3 + 1), (Object)Integer.toString(i * 3 + 2), (Object)Float.valueOf(i * 3 + 2));
    }

    private static Map<String, Integer> intToIntMap(int i) {
        return ImmutableMap.of((Object)Integer.toString(i * 3), (Object)(i * 3), (Object)Integer.toString(i * 3 + 1), (Object)(i * 3 + 1), (Object)Integer.toString(i * 3 + 2), (Object)(i * 3 + 2));
    }

    static class ExpectedValuesBuilder<K, V> {
        private final Function<Integer, K> keyConverter;
        private final Function<Integer, V> valueConverter;
        private Frequency nullValuesFrequency = Frequency.NONE;
        private Frequency nullRowsFrequency = Frequency.NONE;
        private Frequency emptyMapsFrequency = Frequency.NONE;
        private boolean mixedEncodings;
        private boolean missingSequences;
        private int numRows = 31234;

        private ExpectedValuesBuilder(Function<Integer, K> keyConverter, Function<Integer, V> valueConverter) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        public static <T> ExpectedValuesBuilder<T, T> get(Function<Integer, T> converter) {
            return new ExpectedValuesBuilder<T, T>(converter, converter);
        }

        public static <K, V> ExpectedValuesBuilder<K, V> get(Function<Integer, K> keyConverter, Function<Integer, V> valueConverter) {
            return new ExpectedValuesBuilder<K, V>(keyConverter, valueConverter);
        }

        public ExpectedValuesBuilder<K, V> setNullValuesFrequency(Frequency frequency) {
            this.nullValuesFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setNullRowsFrequency(Frequency frequency) {
            this.nullRowsFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setEmptyMapsFrequency(Frequency frequency) {
            this.emptyMapsFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setMixedEncodings() {
            this.mixedEncodings = true;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setMissingSequences() {
            this.missingSequences = true;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setNumRows(int numRows) {
            this.numRows = numRows;
            return this;
        }

        public List<Map<K, V>> build() {
            ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                if (this.passesFrequencyCheck(this.nullRowsFrequency, i)) {
                    result.add(null);
                    continue;
                }
                if (this.passesFrequencyCheck(this.emptyMapsFrequency, i)) {
                    result.add(Collections.emptyMap());
                    continue;
                }
                HashMap<K, Object> row = new HashMap<K, Object>();
                for (int j = 0; j < 3; ++j) {
                    int key = (i * 3 + j) % 32;
                    if (this.missingSequences && key % 2 == 1) continue;
                    Object value = j == 0 && this.passesFrequencyCheck(this.nullValuesFrequency, i) ? null : (this.mixedEncodings && (key == 1 || j == 2) ? (Object)this.valueConverter.apply(i * 3 + j) : (Object)this.valueConverter.apply((i * 3 + j) % 32));
                    row.put(this.keyConverter.apply(key), value);
                }
                result.add(row);
            }
            return result;
        }

        private boolean passesFrequencyCheck(Frequency frequency, int i) {
            switch (frequency) {
                case NONE: {
                    return false;
                }
                case ALL: {
                    return true;
                }
                case SOME: {
                    return i % 5 == 0;
                }
                case ALL_EXCEPT_FIRST: {
                    return i != 0;
                }
            }
            throw new IllegalArgumentException("Got unexpected Frequency: " + (Object)((Object)frequency));
        }

        static enum Frequency {
            NONE,
            SOME,
            ALL,
            ALL_EXCEPT_FIRST;

        }
    }
}

