/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.FilterFunction;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.predicate.TupleDomainFilterUtils;
import com.facebook.presto.common.relation.Predicate;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcTester;
import com.facebook.presto.orc.TestingOrcPredicate;
import com.facebook.presto.testing.TestingEnvironment;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.Test;

public class TestMapFlatSelectiveStreamReader {
    private static final Type STRUCT_TYPE = TestingEnvironment.FUNCTION_AND_TYPE_MANAGER.getParameterizedType("row", (List)ImmutableList.of((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value1", false)), IntegerType.INTEGER.getTypeSignature())), (Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value2", false)), IntegerType.INTEGER.getTypeSignature())), (Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName("value3", false)), IntegerType.INTEGER.getTypeSignature()))));
    private static final int NUM_ROWS = 31234;

    @Test
    public void testByte() throws Exception {
        this.runTest("test_flat_map/flat_map_byte.dwrf", (Type)TinyintType.TINYINT, ExpectedValuesBuilder.get(Integer::byteValue));
    }

    @Test
    public void testByteWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_byte_with_null.dwrf", (Type)TinyintType.TINYINT, ExpectedValuesBuilder.get(Integer::byteValue).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testShort() throws Exception {
        this.runTest("test_flat_map/flat_map_short.dwrf", (Type)SmallintType.SMALLINT, ExpectedValuesBuilder.get(Integer::shortValue));
    }

    @Test
    public void testInteger() throws Exception {
        this.runTest("test_flat_map/flat_map_int.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()));
    }

    @Test
    public void testIntegerWithSharedDictionary() throws Exception {
        this.runTest("test_flat_map/flat_map_dict_share_simple.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNumRows(2048));
    }

    @Test
    public void testIntegerWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_int_with_null.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testLong() throws Exception {
        this.runTest("test_flat_map/flat_map_long.dwrf", (Type)BigintType.BIGINT, ExpectedValuesBuilder.get(Integer::longValue));
    }

    @Test
    public void testString() throws Exception {
        this.runTest("test_flat_map/flat_map_string.dwrf", (Type)VarcharType.VARCHAR, ExpectedValuesBuilder.get(i -> Integer.toString(i)));
    }

    @Test
    public void testStringWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_string_with_null.dwrf", (Type)VarcharType.VARCHAR, ExpectedValuesBuilder.get(i -> Integer.toString(i)).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testBinary() throws Exception {
        this.runTest("test_flat_map/flat_map_binary.dwrf", (Type)VarbinaryType.VARBINARY, ExpectedValuesBuilder.get(i -> new SqlVarbinary(Integer.toString(i).getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void testBoolean() throws Exception {
        this.runTest("test_flat_map/flat_map_boolean.dwrf", (Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToBoolean));
    }

    @Test
    public void testBooleanWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_boolean_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)BooleanType.BOOLEAN, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToBoolean).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testFloat() throws Exception {
        this.runTest("test_flat_map/flat_map_float.dwrf", (Type)IntegerType.INTEGER, (Type)RealType.REAL, ExpectedValuesBuilder.get(Function.identity(), Float::valueOf));
    }

    @Test
    public void testFloatWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_float_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)RealType.REAL, ExpectedValuesBuilder.get(Function.identity(), Float::valueOf).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testDouble() throws Exception {
        this.runTest("test_flat_map/flat_map_double.dwrf", (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE, ExpectedValuesBuilder.get(Function.identity(), Double::valueOf));
    }

    @Test
    public void testDoubleWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_double_with_null.dwrf", (Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE, ExpectedValuesBuilder.get(Function.identity(), Double::valueOf).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testList() throws Exception {
        this.runTest("test_flat_map/flat_map_list.dwrf", (Type)IntegerType.INTEGER, OrcTester.arrayType((Type)IntegerType.INTEGER), ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToList));
    }

    @Test
    public void testListWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_list_with_null.dwrf", (Type)IntegerType.INTEGER, OrcTester.arrayType((Type)IntegerType.INTEGER), ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToList).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testMap() throws Exception {
        this.runTest("test_flat_map/flat_map_map.dwrf", (Type)IntegerType.INTEGER, OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)RealType.REAL), ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToMap));
    }

    @Test
    public void testMapWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_map_with_null.dwrf", (Type)IntegerType.INTEGER, OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)RealType.REAL), ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToMap).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testMapWithSharedDictionary() throws Exception {
        this.runTest("test_flat_map/flat_map_dict_share_nested.dwrf", (Type)BigintType.BIGINT, OrcTester.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), ExpectedValuesBuilder.get(x -> (long)x, TestMapFlatSelectiveStreamReader::intToIntMap).setNumRows(2048));
    }

    @Test
    public void testStruct() throws Exception {
        this.runTest("test_flat_map/flat_map_struct.dwrf", (Type)IntegerType.INTEGER, STRUCT_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToList));
    }

    @Test
    public void testStructWithNull() throws Exception {
        this.runTest("test_flat_map/flat_map_struct_with_null.dwrf", (Type)IntegerType.INTEGER, STRUCT_TYPE, ExpectedValuesBuilder.get(Function.identity(), TestMapFlatSelectiveStreamReader::intToList).setNullValuesFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithNulls() throws Exception {
        this.runTest("test_flat_map/flat_map_some_null_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithAllNulls() throws Exception {
        this.runTest("test_flat_map/flat_map_all_null_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testWithAllNullsExceptFirst() throws Exception {
        this.runTest("test_flat_map/flat_map_all_null_maps_except_first.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setNullRowsFrequency(ExpectedValuesBuilder.Frequency.ALL_EXCEPT_FIRST));
    }

    @Test
    public void testWithEmptyMaps() throws Exception {
        this.runTest("test_flat_map/flat_map_some_empty_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.SOME));
    }

    @Test
    public void testWithAllEmptyMaps() throws Exception {
        this.runTest("test_flat_map/flat_map_all_empty_maps.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testWithAllEmptyMapsWithNoEncoding() throws Exception {
        this.runTest("test_flat_map/flat_map_all_empty_maps_no_encoding.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setEmptyMapsFrequency(ExpectedValuesBuilder.Frequency.ALL));
    }

    @Test
    public void testMixedEncodings() throws Exception {
        this.runTest("test_flat_map/flat_map_mixed_encodings.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setMixedEncodings());
    }

    @Test
    public void testIntegerWithMissingSequences() throws Exception {
        this.runTest("test_flat_map/flat_map_int_missing_sequences.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()).setMissingSequences());
    }

    @Test
    public void testIntegerWithMissingSequence0() throws Exception {
        this.runTest("test_flat_map/flat_map_int_missing_sequence_0.dwrf", (Type)IntegerType.INTEGER, ExpectedValuesBuilder.get(Function.identity()));
    }

    private <K, V> void runTest(String testOrcFileName, Type type, ExpectedValuesBuilder<K, V> expectedValuesBuilder) throws Exception {
        this.runTest(testOrcFileName, type, type, expectedValuesBuilder);
    }

    private <K, V> void runTest(String testOrcFileName, Type keyType, Type valueType, ExpectedValuesBuilder<K, V> expectedValuesBuilder) throws Exception {
        List keys;
        List<Map<K, V>> expectedValues = expectedValuesBuilder.build();
        Type mapType = OrcTester.mapType(keyType, valueType);
        OrcPredicate orcPredicate = TestingOrcPredicate.createOrcPredicate(0, mapType, expectedValues, OrcTester.Format.DWRF, true);
        this.runTest(testOrcFileName, mapType, expectedValues, orcPredicate, Optional.empty(), (List<Subfield>)ImmutableList.of());
        this.runTest(testOrcFileName, mapType, expectedValues.stream().filter(Objects::isNull).collect(Collectors.toList()), orcPredicate, Optional.of(TupleDomainFilter.IS_NULL), (List<Subfield>)ImmutableList.of());
        this.runTest(testOrcFileName, mapType, expectedValues.stream().filter(Objects::nonNull).collect(Collectors.toList()), orcPredicate, Optional.of(TupleDomainFilter.IS_NOT_NULL), (List<Subfield>)ImmutableList.of());
        if (keyType != VarbinaryType.VARBINARY && !(keys = (List)expectedValues.stream().filter(Objects::nonNull).flatMap(v -> v.keySet().stream()).distinct().collect(ImmutableList.toImmutableList())).isEmpty()) {
            Object requiredKeys = ImmutableList.of(keys.get(0));
            this.runTest(testOrcFileName, mapType, TestMapFlatSelectiveStreamReader.pruneMaps(expectedValues, requiredKeys), orcPredicate, Optional.empty(), TestMapFlatSelectiveStreamReader.toSubfields(keyType, requiredKeys));
            ImmutableList keyIndices = ImmutableList.of((Object)1, (Object)3, (Object)7, (Object)11);
            requiredKeys = keyIndices.stream().filter(k -> k < keys.size()).map(keys::get).collect(Collectors.toList());
            this.runTest(testOrcFileName, mapType, TestMapFlatSelectiveStreamReader.pruneMaps(expectedValues, requiredKeys), orcPredicate, Optional.empty(), TestMapFlatSelectiveStreamReader.toSubfields(keyType, requiredKeys));
        }
        List ids = (List)IntStream.range(0, expectedValues.size()).map(i -> i % 10).boxed().collect(ImmutableList.toImmutableList());
        ImmutableList types = ImmutableList.of((Object)mapType, (Object)IntegerType.INTEGER);
        ImmutableMap filters = ImmutableMap.of((Object)1, (Object)ImmutableMap.of((Object)new Subfield("c"), (Object)TupleDomainFilterUtils.toBigintValues((long[])new long[]{1L, 5L, 6L}, (boolean)true)));
        OrcTester.assertFileContentsPresto((List<Type>)types, new File(Resources.getResource((String)testOrcFileName).getFile()), OrcTester.filterRows((List<Type>)types, ImmutableList.of(expectedValues, (Object)ids), (Map<Integer, Map<Subfield, TupleDomainFilter>>)filters), OrcEncoding.DWRF, OrcPredicate.TRUE, Optional.of(filters), (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), (Map<Integer, List<Subfield>>)ImmutableMap.of());
        TestingFilterFunction filterFunction = new TestingFilterFunction(mapType);
        OrcTester.assertFileContentsPresto((List<Type>)types, new File(Resources.getResource((String)testOrcFileName).getFile()), filterFunction.filterRows((List<List<?>>)ImmutableList.of(expectedValues, (Object)ids)), OrcEncoding.DWRF, OrcPredicate.TRUE, Optional.empty(), (List<FilterFunction>)ImmutableList.of((Object)((Object)filterFunction)), (Map<Integer, Integer>)ImmutableMap.of((Object)0, (Object)0), (Map<Integer, List<Subfield>>)ImmutableMap.of());
    }

    private static <K, V> List<Map<K, V>> pruneMaps(List<Map<K, V>> maps, List<K> keys) {
        return maps.stream().map(map -> map == null ? null : Maps.filterKeys((Map)map, keys::contains)).collect(Collectors.toList());
    }

    private static <K> List<Subfield> toSubfields(Type keyType, List<K> keys) {
        block5: {
            block4: {
                if (keyType == TinyintType.TINYINT || keyType == SmallintType.SMALLINT || keyType == IntegerType.INTEGER) break block4;
                if (keyType != BigintType.BIGINT) break block5;
            }
            return (List)keys.stream().map(Number.class::cast).mapToLong(Number::longValue).mapToObj(key -> new Subfield.LongSubscript(key)).map(subscript -> new Subfield("c", (List)ImmutableList.of((Object)subscript))).collect(ImmutableList.toImmutableList());
        }
        if (keyType == VarcharType.VARCHAR) {
            return (List)keys.stream().map(String.class::cast).map(key -> new Subfield.StringSubscript(key)).map(subscript -> new Subfield("c", (List)ImmutableList.of((Object)subscript))).collect(ImmutableList.toImmutableList());
        }
        throw new UnsupportedOperationException("Unsupported key type: " + keyType);
    }

    private <K, V> void runTest(String testOrcFileName, Type mapType, List<Map<K, V>> expectedValues, OrcPredicate orcPredicate, Optional<TupleDomainFilter> filter, List<Subfield> subfields) throws Exception {
        ImmutableList types = ImmutableList.of((Object)mapType);
        Optional<Map<Integer, Map<Subfield, TupleDomainFilter>>> filters = filter.map(f -> ImmutableMap.of((Object)new Subfield("c"), (Object)f)).map(f -> ImmutableMap.of((Object)0, (Object)f));
        OrcTester.assertFileContentsPresto((List<Type>)types, new File(Resources.getResource((String)testOrcFileName).getFile()), filters.map(arg_0 -> TestMapFlatSelectiveStreamReader.lambda$runTest$14((List)types, expectedValues, arg_0)).orElse((List)ImmutableList.of(expectedValues)), OrcEncoding.DWRF, orcPredicate, filters, (List<FilterFunction>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of(), (Map<Integer, List<Subfield>>)ImmutableMap.of((Object)0, subfields));
    }

    private static boolean intToBoolean(int i) {
        return i % 2 == 0;
    }

    private static SqlTimestamp intToTimestamp(int i) {
        return new SqlTimestamp((long)i, TimeZoneKey.UTC_KEY, TimeUnit.MILLISECONDS);
    }

    private static List<Integer> intToList(int i) {
        return ImmutableList.of((Object)(i * 3), (Object)(i * 3 + 1), (Object)(i * 3 + 2));
    }

    private static Map<String, Float> intToMap(int i) {
        return ImmutableMap.of((Object)Integer.toString(i * 3), (Object)Float.valueOf(i * 3), (Object)Integer.toString(i * 3 + 1), (Object)Float.valueOf(i * 3 + 1), (Object)Integer.toString(i * 3 + 2), (Object)Float.valueOf(i * 3 + 2));
    }

    private static Map<String, Integer> intToIntMap(int i) {
        return ImmutableMap.of((Object)Integer.toString(i * 3), (Object)(i * 3), (Object)Integer.toString(i * 3 + 1), (Object)(i * 3 + 1), (Object)Integer.toString(i * 3 + 2), (Object)(i * 3 + 2));
    }

    private static /* synthetic */ List lambda$runTest$14(List types, List expectedValues, Map f) {
        return OrcTester.filterRows(types, ImmutableList.of((Object)expectedValues), f);
    }

    static class TestingFilterFunction
    extends FilterFunction {
        private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        private final Type mapType;

        public TestingFilterFunction(final Type mapType) {
            super(TEST_SESSION.getSqlFunctionProperties(), true, new Predicate(){

                public int[] getInputChannels() {
                    return new int[]{0};
                }

                public boolean evaluate(SqlFunctionProperties properties, Page page, int position) {
                    Block mapBlock = page.getBlock(0);
                    if (mapBlock.isNull(position)) {
                        return false;
                    }
                    Map map = (Map)mapType.getObjectValue(TEST_SESSION.getSqlFunctionProperties(), mapBlock, position);
                    return map.containsKey(1);
                }
            });
            this.mapType = mapType;
        }

        public List<List<?>> filterRows(List<List<?>> values) {
            List passingRows = IntStream.range(0, values.get(0).size()).filter(row -> ((List)values.get(0)).get(row) != null).filter(row -> ((Map)((List)values.get(0)).get(row)).containsKey(1)).boxed().collect(Collectors.toList());
            return IntStream.range(0, values.size()).mapToObj(column -> passingRows.stream().map(((List)values.get(column))::get).collect(Collectors.toList())).collect(Collectors.toList());
        }
    }

    static class ExpectedValuesBuilder<K, V> {
        private final Function<Integer, K> keyConverter;
        private final Function<Integer, V> valueConverter;
        private Frequency nullValuesFrequency = Frequency.NONE;
        private Frequency nullRowsFrequency = Frequency.NONE;
        private Frequency emptyMapsFrequency = Frequency.NONE;
        private boolean mixedEncodings;
        private boolean missingSequences;
        private int numRows = 31234;

        private ExpectedValuesBuilder(Function<Integer, K> keyConverter, Function<Integer, V> valueConverter) {
            this.keyConverter = keyConverter;
            this.valueConverter = valueConverter;
        }

        public static <T> ExpectedValuesBuilder<T, T> get(Function<Integer, T> converter) {
            return new ExpectedValuesBuilder<T, T>(converter, converter);
        }

        public static <K, V> ExpectedValuesBuilder<K, V> get(Function<Integer, K> keyConverter, Function<Integer, V> valueConverter) {
            return new ExpectedValuesBuilder<K, V>(keyConverter, valueConverter);
        }

        public ExpectedValuesBuilder<K, V> setNullValuesFrequency(Frequency frequency) {
            this.nullValuesFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setNullRowsFrequency(Frequency frequency) {
            this.nullRowsFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setEmptyMapsFrequency(Frequency frequency) {
            this.emptyMapsFrequency = frequency;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setMixedEncodings() {
            this.mixedEncodings = true;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setMissingSequences() {
            this.missingSequences = true;
            return this;
        }

        public ExpectedValuesBuilder<K, V> setNumRows(int numRows) {
            this.numRows = numRows;
            return this;
        }

        public List<Map<K, V>> build() {
            ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>(this.numRows);
            for (int i = 0; i < this.numRows; ++i) {
                if (this.passesFrequencyCheck(this.nullRowsFrequency, i)) {
                    result.add(null);
                    continue;
                }
                if (this.passesFrequencyCheck(this.emptyMapsFrequency, i)) {
                    result.add(Collections.emptyMap());
                    continue;
                }
                HashMap<K, Object> row = new HashMap<K, Object>();
                for (int j = 0; j < 3; ++j) {
                    int key = (i * 3 + j) % 32;
                    if (this.missingSequences && key % 2 == 1) continue;
                    Object value = j == 0 && this.passesFrequencyCheck(this.nullValuesFrequency, i) ? null : (this.mixedEncodings && (key == 1 || j == 2) ? (Object)this.valueConverter.apply(i * 3 + j) : (Object)this.valueConverter.apply((i * 3 + j) % 32));
                    row.put(this.keyConverter.apply(key), value);
                }
                result.add(row);
            }
            return result;
        }

        private boolean passesFrequencyCheck(Frequency frequency, int i) {
            switch (frequency) {
                case NONE: {
                    return false;
                }
                case ALL: {
                    return true;
                }
                case SOME: {
                    return i % 5 == 0;
                }
                case ALL_EXCEPT_FIRST: {
                    return i != 0;
                }
            }
            throw new IllegalArgumentException("Got unexpected Frequency: " + (Object)((Object)frequency));
        }

        static enum Frequency {
            NONE,
            SOME,
            ALL,
            ALL_EXCEPT_FIRST;

        }
    }
}

